#include "uostr.h"

/* should use ssize_t here, but that's not portable, and requiring
 * "config.h" and autoconf for every application doesn't seem to
 * be appropriate.
 */
uostr_t *
uostr_cut(uostr_t *u,long new_len)
{	
	if (!u->data) {
		if (new_len!=0) return 0;
		u->len=0;
		return u;
	}
	if (new_len<0) { /* -x: cut by x */
		new_len=-new_len;
		if ((size_t)new_len>u->len) u->len=0;
		else u->len-=new_len;
		u->data[u->len]='Z'; /* clever idea stolen from djb */
		return u;
	}
	if ((size_t)new_len<=u->len) {
		u->len=new_len;
		u->data[u->len]='Z'; /* clever idea stolen from djb */
		return u;
	}
	return 0;
}
