/* reimplementation of qmail.c by djb */

#include "uocompiler.h"
#include <unistd.h>
#include <errno.h>
#include <stdlib.h> /* getenv */
#include <string.h>
#include <sys/wait.h>
#include "uostr.h"
#include "uoio.h"
#include "str_ulong.h"
#include "mtalib.h"

struct priv {
	char *from;
	char *to;
	int goterrs;
	uoio_t mess;
	uoio_t env;
	pid_t pid;
};
static mta_t * mta_qq_create P__((void));
static mta_ret_t mta_qq_write P__((mta_t *mta,const char *s, size_t len));
static mta_ret_t mta_qq_close P__ ((mta_t *mta));
static mta_ret_t mta_qq_abort P__ ((mta_t *mta));
static mta_ret_t mta_qq_open P__ ((mta_t **,const char *,const char *, const char *));

mta_t mta_qq={
	mta_qq_open,
	mta_qq_write,
	mta_qq_abort,
	mta_qq_close,
	0
};

static mta_t *
mta_qq_create(void)
{
	struct priv *pr;
	mta_t *m;
	pr=malloc(sizeof(struct priv));
	if (!pr) return 0;
	m=malloc(sizeof(mta_t));
	if (!m) {free(pr); return 0;}
	memcpy(m,&mta_qq,sizeof(mta_t));
	memset(pr,0,sizeof(*pr));
	m->priv=pr;
	return m;
}

#define DEFAULTQQ "/var/qmail/bin/qmail-queue"
static mta_ret_t
mta_qq_open(mta_t **m, const char *path,const char *from, const char *to)
{
	int pipe_env[2];
	int pipe_mess[2];
	int e;
	char *copy_from;
	char *copy_to;
	pid_t pid;
	mta_t *mta;

	mta=mta_qq_create(); if (!mta) {e=errno; goto cleanup_nothing; }
	if (pipe(pipe_env) == -1) { e=errno; goto cleanup0; }
	if (pipe(pipe_mess) == -1) { e=errno;goto cleanup1; }
	copy_from=malloc(strlen(from)+1);
	if (!copy_from) { e=ENOMEM; goto cleanup2; }
	strcpy(copy_from,from);
	copy_to=malloc(strlen(to)+1);
	if (!copy_to) { e=ENOMEM; goto cleanup3; }
	strcpy(copy_to,to);

	pid = vfork();
	if (pid==-1) { e=errno; goto cleanup4; }
	else if (pid==0) {
		union { char *c;const char *d;} disqualify;
		char *qq[2];
		const char *pc=getenv("QMAILQUEUE");
		if (!pc) pc = path;
		if (0==strcmp(pc,"DEFAULT")) pc=DEFAULTQQ;

		disqualify.d=pc;
		qq[0]=disqualify.c;qq[1]=0;
		close(pipe_env[1]);
		close(pipe_mess[1]);
		if (-1==dup2(pipe_env[0],1)) _exit(120);
		if (-1==dup2(pipe_mess[0],0)) _exit(120);
		execv(disqualify.d,qq);
		_exit(120);
	}
	close(pipe_env[0]);
	close(pipe_mess[0]);
	uoio_assign_w(&((struct priv *)mta->priv)->mess,pipe_mess[1],write,0);
	uoio_assign_w(&((struct priv *)mta->priv)->env,pipe_env[1],write,0);
	((struct priv *)mta->priv)->pid=pid;
	((struct priv *)mta->priv)->from=copy_from;
	((struct priv *)mta->priv)->to=copy_to;
	*m=mta;
	return MTA_SUCCESS;
  cleanup4: free(copy_to);
  cleanup3: free(copy_from);
  cleanup2: close(pipe_mess[0]); close(pipe_mess[1]); 
  cleanup1: close(pipe_env[0]); close(pipe_env[1]); 
  cleanup0: 
    free(mta->priv);
	free(mta);
  cleanup_nothing:
	errno=e; 
	mta_errtxt=strerror(errno);
	mta_hcmssc="(#4.3.0)";
	return MTA_DEFER;
}

static mta_ret_t
mta_qq_write(mta_t *mta,const char *s, size_t len)
{
	if (-1==uoio_write_mem(&((struct priv *)mta->priv)->mess,s,len)) 
		((struct priv *)mta->priv)->goterrs++;
	if (((struct priv *)mta->priv)->goterrs) {
		mta_errtxt=strerror(errno); mta_hcmssc="(#4.3.0)";
		return MTA_DEFER;
	}
	return MTA_SUCCESS;
}

static mta_ret_t
mta_qq_abort(mta_t *mta)
{
	struct priv *priv=mta->priv;
	close(priv->mess.fd);
	uoio_destroy(&priv->mess);
	close(priv->env.fd);
	uoio_destroy(&priv->env);
	free(priv->to);
	free(priv->from);
	free(priv);
	free(mta);
	return MTA_SUCCESS;
}

static mta_ret_t
mta_qq_close(mta_t *mta)
{
	int status;
	int exitcode;
	int goterrs;
	pid_t pid;
	struct priv *priv=mta->priv;

	if (priv->goterrs) { mta_errtxt="I/O error"; mta_hcmssc="(#4.3.0)"; }
	if (-1==uoio_flush(&priv->mess)) {priv->goterrs++;mta_errtxt=strerror(errno);mta_hcmssc="(#4.3.0)"; }
	close(priv->mess.fd);
	uoio_destroy(&priv->mess);

	if (!priv->goterrs) { /* write envelope now */
		int err;
		char *to;
		uoio_t *u=&priv->env;
		err=(-1==uoio_write_char(u,'F'));
		err|=(-1==uoio_write_cstr(u,priv->from));
		err|=(-1==uoio_write_char(u,0));
		to=priv->to;
		while (to && *to) {
			char *lf=strchr(to,'\n');
			if (lf) *lf=0;
			err=(-1==uoio_write_char(u,'T'));
			err|=(-1==uoio_write_cstr(u,to));
			err|=(-1==uoio_write_char(u,0));
			if (lf) to=lf+1; 
			else to=0;
		}
		/* final \0 */
		if (err || -1==uoio_write_char(u,0) || -1==uoio_flush(u))  {
			mta_errtxt=strerror(errno); mta_hcmssc="(#4.3.0)"; 
			priv->goterrs=1;
		}
	}
	close(priv->env.fd);
	uoio_destroy(&priv->env);

	pid=priv->pid;
	goterrs=priv->goterrs;
	free(priv->from);
	free(priv->to);
	free(priv);
	free(mta);

	if (waitpid(pid,&status,0)!=pid) { mta_errtxt="waitpid failed.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;}
	if (WIFSIGNALED(status)) {mta_errtxt="queue program crashed.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;};
	exitcode = WEXITSTATUS(status);

/* note: i'm using bernsteins hcmssc here for the same reason he uses them: DSN are almost useless,
 * and supporting them correctly ruins the code. I suppose djb thinks the same ...
 */
	switch (exitcode) {
	case 0: if (!goterrs) { 
				static char pidbuf[20]; 
				str_ulong(pidbuf,pid);
				mta_errtxt=pidbuf; /* magic: on MTA_SUCCESS the ..._close() puts an id into the errtxt */
				return MTA_SUCCESS;
			}
			return MTA_DEFER;
	case 115: /* compatibility, but for what? */
	case 11: mta_errtxt="Address too long.";mta_hcmssc="(#5.1.3)"; return MTA_FATAL;
	case 31: mta_errtxt="Mail server permanently refuses to send the message.";
	         mta_hcmssc="(#5.3.0)"; return MTA_FATAL;
	case 51: mta_errtxt="Out of memory.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 52: mta_errtxt="Timeout.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 53: mta_errtxt="Write/disk error.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 54: mta_errtxt="Unable to read the message or envelope.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 55: mta_errtxt="Unable to read a configuration file.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 56: mta_errtxt="Problem making a network connection from this host.";
	         mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 61: mta_errtxt="Problem with the qmail home directory.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 62: mta_errtxt="Problem with the queue directory.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 63: mta_errtxt="Problem with queue/pid.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 64: mta_errtxt="Problem with queue/mess.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 65: mta_errtxt="Problem with queue/intd.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 66: mta_errtxt="Problem with queue/todo.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 71: mta_errtxt="Mail server temporarily refuses to send the message.";
	         mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 72: mta_errtxt="Connection to mail server timed out.";mta_hcmssc="(#4.4.1)"; return MTA_DEFER;
	case 73: mta_errtxt="Connection to mail server rejected.";mta_hcmssc="(#4.4.1)"; return MTA_DEFER;
	case 74: mta_errtxt="Connection to mail server succeeded, but communication failed.";
	         mta_hcmssc="(#4.4.2)"; return MTA_DEFER;
	case 81: mta_errtxt="Internal bug; e.g., segmentation fault.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 91: mta_errtxt="Envelope format error == internal bug.";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	case 120:mta_errtxt="unable to execute queue program";mta_hcmssc="(#4.3.0)"; return MTA_DEFER;
	default:
		if ((exitcode >= 11) && (exitcode <= 40)) { 
			mta_errtxt="permanent problem";mta_hcmssc="(#5.3.0)"; return MTA_FATAL;
		}
		mta_errtxt= "temporary problem";mta_hcmssc="(#4.3.0)";
		return MTA_DEFER;
	}
}
