#include "config.h"

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/file.h>
#include <fcntl.h>
#include "uostr.h"
#include "uoio.h"
#include "smtp.h"
#include "smtptools.h"
#include "attribs.h"

static uoio_t u;
static int init_done;

static void 
logstartchar(int code)
{
	if (!init_done) uoio_assign_w(&u,logmsgfd,write,0);
	else if (u.fd!=logmsgfd) {uoio_destroy(&u); uoio_assign_w(&u,logmsgfd,write,0);}

	if (code==SMTP_SUCCESS) uoio_write_char(&u,'O');
	else if (code==SMTP_DEFER) uoio_write_char(&u,'D');
	else if (code==SMTP_FATAL) uoio_write_char(&u,'F');
	else if (code==SMTP_INFO) uoio_write_char(&u,'I');
	else uoio_write_char(&u,'?');
}

void
logmsguo(int code,uostr_t *s)
{
  	logstartchar(code);
	uoio_write_uostr(&u,s);
	uoio_write_char(&u,'\n');
	uoio_flush(&u); /* XXX possible loss of logging information */
}

void 
logmsg1(int code,const char *s)
{
  	logstartchar(code);
	uoio_write_cstr(&u,s);
	uoio_write_char(&u,'\n');
	uoio_flush(&u); /* XXX possible loss of logging information */
}

void 
logmsg2(int code,const char *s, const char *t)
{
  	logstartchar(code);
	uoio_write_cstr(&u,s);
	uoio_write_cstr(&u,t);
	uoio_write_char(&u,'\n');
	uoio_flush(&u); /* XXX possible loss of logging information */
}

void 
logmsg3(int code,const char *s, const char *t, const char *v)
{
  	logstartchar(code);
	uoio_write_cstr(&u,s);
	uoio_write_cstr(&u,t);
	uoio_write_cstr(&u,v);
	uoio_write_char(&u,'\n');
	uoio_flush(&u); /* XXX possible loss of logging information */
}

void 
logmsg4(int code,const char *s, const char *t, const char *v, const char *w)
{
  	logstartchar(code);
	uoio_write_cstr(&u,s);
	uoio_write_cstr(&u,t);
	uoio_write_cstr(&u,v);
	uoio_write_cstr(&u,w);
	uoio_write_char(&u,'\n');
	uoio_flush(&u); /* XXX possible loss of logging information */
}

void 
logmsg5(int code,const char *s, const char *t, const char *v, const char *w, const char *x)
{
  	logstartchar(code);
	uoio_write_cstr(&u,s);
	uoio_write_cstr(&u,t);
	uoio_write_cstr(&u,v);
	uoio_write_cstr(&u,w);
	uoio_write_cstr(&u,x);
	uoio_write_char(&u,'\n');
	uoio_flush(&u); /* XXX possible loss of logging information */
}
