# 0.81.1 release notes

**Release date:** 2024-05-12

## Summary

The main focus of this maintenance release is to fix a couple of regressions
introduced in 0.81.0, most of them related to game compatibility, and address
a few long-standing issues.

This release was made possible by everyone who tried 0.81.0, submitted bugs
and pull requests, and tested the updates. Thank you! :sunglasses:

### Regression fixes

The release fixes the following 0.81.0 regressions:

- Fix **Wing Commander 3** videos and cutscenes appearing height-doubled.

- Introduce `vga_render_per_scanline = off` workaround to fix the
  crash-at-startup regression in **Deus**, **Ishar 3**, **Robinson's
  Requiem**, and **Time Warriors**.

- Fix the Tandy version of **Impossible Mission II** crashing at startup.

- Fix regression in **Tyrian** where pressing the arrow keys get registered
  twice in menus.

- Fix starting **In Extremis** resulting in a black screen.

- Fix wrong colours in **Spell It Plus!** (needs `machine =
    svga_paradise`).

- Fix wrong colours and garbled graphics in **Spong** and **Exobius**.

- Fix squashed video output in the text mode game **Indenture**.

- Fix the DOSBox Staging window gaining focus on every emulated video mode change.

- Fix crash when exiting DOSBox Staging while in fullscreen mode on macOS and
  Linux.

- Fix not being able to disable OPL emulation with `oplmode = none`.


### Enhancements and fixes

We've also backported a number of enhancements and fixes for long-standing
issues:

- Introduce `vmem_delay = on` to help with flickering graphics and speed
  issues in Hercules, CGA, EGA, and early VGA games. This has proven to improve
  compatibility with **Future Wars**, **Operation Stealth**, **Quest
  for Glory II**, **Hostages**, **The Gold of the Aztecs**, **Crazy Brix**,
  **Corncob Deluxe**, and **Corncob 3-D** so far.

- Improve support for multiple joysticks/game controllers (the mapper
  could behave erratically if you had more than one controller connected).

- Emulate a memory-expanded PCjr machine more faithfully. This improves game
  compatibility; for{ example, **Space Quest** (v1.0x and v2.2) and **King's
  Quest** (1986 PCjr DOS version) now work instead of hanging the emulator.

- CD Audio is no longer muted in certain parts of **Time Warriors** and
  **Alpha Storm**.

- The batch file installer of **Alpha Storm** no longer fails.

- Forcing single scanning via `crt-auto-arcade` should now work
  with more programs.

- Fix various VGA double scanning related edge cases in demoscene
  productions.

- Detecting "repurposed" EGA video modes with 18-bit VGA DAC colours
  has been made more robust when using the `crt-auto` shader (should result in
  a double-scanned VGA shader being picked).

- Spanish and Brazilian Portuguese translations have been added, and
  most of the other translations have been updated.

Read on to learn about the details!


## How to upgrade

Start by downloading the latest version, then make sure to upgrade your
primary configuration as described below.

### Downloads

<div class="compact" markdown>

- [Windows](../windows.md)
- [macOS](../macos.md)
- [Linux](../linux.md)

</div>


### Upgrading your primary configuration

Since config settings might get renamed, altered, or deprecated between
releases, it's best to let DOSBox Staging write the new default primary config
on the first launch, then reapply your old settings manually.

Start by backing up your existing primary config. This is where to find
it on each platform:

<div class="compact" markdown>

| <!-- --> | <!-- -->
|----------|----------
| **Windows**  | `C:\Users\%USERNAME%\AppData\Local\DOSBox\dosbox-staging.conf`
| **macOS**    | `~/Library/Preferences/DOSBox/dosbox-staging.conf`
| **Linux**    | `~/.config/dosbox/dosbox-staging.conf`

</div>

You can also execute DOSBox Staging with the `--printconf` option to have the
location of the primary config printed to your console.

After backing up the existing primary config, simply start the new version---a
new `dosbox-staging.conf` will be written containing the new defaults and
updated setting descriptions.

!!! note "Portable mode notes"

    In portable mode, `dosbox-staging.conf` resides in the same folder as your
    DOSBox Staging executable. The migration steps for portable mode users are
    as follows:

      - Unpack the new version into a _new_ folder (this is important).
      - Create a new _empty_ `dosbox-staging.conf` file in the new folder to
        enable portable mode.
      - Launch the new version.

    DOSBox Staging will write the new defaults to the empty
    `dosbox-staging.conf` file. After this, you carry over your settings from
    the old primary config manually.

### After upgrading

Look for deprecation warnings in the logs (in yellow or orange colours) and
update your configs accordingly.


## Graphics

### VGA double scanning fixes & improvements

- The SVGA/VESA double scanning criteria has been refined, which fixes a
  **Wing Commander 3** regression where the videos and cutscenes appeared
  height-doubled.

- Some 320&times;
}
200, 320 & times;
240 and similar tweaked double - scanned VGA modes were incorrectly identified as 320 &
                times;
400, 320 & times;480, etc.,
  which was confusing in the logs and single scanning could not be forced on
  them (e.g., with `glshader = crt-auto-arcade`). Affected programs include
  **Pinball Dreams**, **Show by Majic 12**, and the **Copper demo** (see the
  [issue ticket](https://github.com/dosbox-staging/dosbox-staging/pull/3446)
  for the exact details).

- Support "unorthodox" scanline repeats on VGA in forced single scanning mode.
  This improves compatibility with demoscene productions; for example, [Show
  by Majic 12](https://www.pouet.net/prod.php?which=1158) sets up a custom
  320&times;40 mode and then uses scanline-quintupling to repeat every line 5
  times in the zoom-rotator part in the intro.

- Support for double-scanned text modes was removed by mistake, which
  we're now restoring. This resulted in the text mode game **Indenture**
  appearing squashed (half-height). The game sets up a custom 640&times;200
  text mode using the 8&times;8 pixel CGA font with double scanning enabled.

- Detecting "repurposed" EGA video modes with 18-bit VGA DAC colours on
  emulated VGA adapters has been made more robust. In these scenarios, the
  `crt-auto` shader should more reliably choose a double-scanned VGA shader
  instead of a single-scanned EGA shader.


### Option to emulate video memory access delays

We've added the new `vmem_delay` setting to the `[dosbox]` section to more
closely emulate the behaviour of old video cards. This approximates the
CPU-throttling effect of accessing slow video memory via the ISA bus. The
feature was adapted from [DOSBox-X](https://dosbox-x.com/) based on a tip by
**MX9000**. Thanks man! :sunglasses:

To enable the feature, just set `vmem_delay` to `on` in your config. This can
help reduce or eliminate flicker in Hercules, CGA, EGA, and early VGA games
and "even out" emulation speed in speed-sensitive titles.

We recommend enabling this only when necessary on a per-game basis, as it
slows down the emulation. You can also fine-tune the delay by specifying the
access delay in nanoseconds (`on` sets 3000 ns).

`vmem_delay = on` fixes the flashing graphics and various speed issues in at
least the following titles:

- **Corncob 3-D**
- **Corncob Deluxe**
- **Crazy Brix** (`vmem_delay = 2000` and `cycles = 70000` makes the game run
    smoothly)
- **Future Wars** (also needs `cycles = 1000`)
- **Gold of the Aztecs, The**
- **Hostages** (also needs `cycles = 1500`)
- **Operation Stealth** (when VGA or EGA is selected in the game's setup)
- **Quest for Glory II** (fixes the too-fast vertical scrolling in the intro)


### Option for legacy VGA rendering

In 0.81.0, we made accurate per-scanline VGA rendering the only rendering
option available (previously, you could only enable this via `machine =
vgaonly`). A minority of games, however, have regressed by this and would
crash at startup.

As a workaround, until we improve the accuracy of the VGA emulation, we're
introducing the `vga_render_per_scanline` setting in the `[dosbox]` section.
The setting is enabled by default, but you can disable it to restore the
legacy rendering behaviour on a per-game basis.

Disabling `vga_render_per_scanline` fixes the crash-at-startup regression in
the following Silmarils titles:

<div class="compact" markdown>

- **Deus**
- **Ishar 3**
- **Robinson's Requiem**
- **Time Warriors**

</div>

Note that these games are also CPU speed sensitive and would crash with high
cycles settings---see the [issue
ticket](https://github.com/dosbox-staging/dosbox-staging/pull/3507) for config
recommendations.


### Option for legacy palette behaviour

The `svga_paradise` machine type now uses the legacy non-`vgaonly` palette
behaviour. This fixes the wrong colours in some rare titles (e.g., **Spell It
Plus!**).


### Tandy graphics fixes

Fixed a regression where the Tandy version of **Impossible Mission
II** would crash when starting a new game. This fix should restore our general
compatibility with non-standard Tandy graphics modes as well.


### Other fixes

- Fixed the DOSBox Staging window gaining focus on emulated video mode
  changes.

- Fixed crash when exiting DOSBox Staging while in fullscreen mode on macOS
  and Linux.

- Fixed wrong colours and garbled graphics in **Spong** and **Exobius**.


??? note "Full PR list of graphics-related changes"

    - Add `vga_render_per_scanline` option (#3507)
    - Do not resize if Tandy vertical rows register is zero (#3448)
    - Fix crash when quitting while in fullscreen mode (#3545)
    - Fix double-scanning behavior for SVGA/VESA games (#3428)
    - Fix Impossible Mission II transition effect (#3454)
    - Fix the width of VGA text modes being incorrectly set sometimes (#3611)
    - Fix "unorthodox" scanline repeats on VGA (#3441)
    - Improve VGA double scanning criteria (#3446)
    - Log OpenGL vsync state (#3553)
    - Only raise window when it is newly created (#3440)
    - Port video memory I/O delay tweak from DOSBox-X (#3597)
    - Restore double scanning support for VGA text modes (#3568)
    - Revert to legacy non-`vgaonly` palette behaviour on `svga_paradise` (#3589)
    - Simplify "EGA mode with VGA palette" detection & make it more robust (#3639)


## Sound

### Implement seeking in MSCDEX

A few games use the seek function of the CD-ROM but this was not previously
implemented in our emulated MSCDEX driver. This resulted in CD Audio playing
only sometimes in a few games.

The new seek implementation fixes CD Audio music in at least these titles:

- **Time Warriors** --- CD Audio music is now playing during the main menu and
  gameplay.
- **Alpha Storm** --- CD Audio music is now playing in the opening movie.


### Fix not being able to disable OPL emulation

Fixed a regression where you could not disable OPL emulation with `oplmode =
none` anymore (`sbtype = none` still worked, but that disabled the Sound
Blaster as well).


### Other fixes

- Fixed crash when output filter cutoff frequencies are not below half the
  sample rate (e.g., by setting `rate = 11025` and `sbtype = sbpro1` which
  selects a 8 kHz low-pass filter by default).

- Fixed FluidSynth and MT-32 crashing the emulator when the host sample rate
  is set to 8000 Hz.


??? note "Full PR list of sound-related changes"

    - Fix not being able to set `oplmode = none` regression (#3565)
    - Fix various crashes when the host sample rate is set to low values (#3629)
    - Implement seeking in MSCDEX (#3516)
    - Use SB* and OPL logging prefixes consistely in all scenarios (#3587)


## Input

- Fixed a keyboard handling regression in **Tyrian** where pressing the arrow
  keys get registered twice, making the menus very hard to use.

- Fixed a keyboard handling regression in **In Extremis** where starting the
  game only resulted in a black screen.

- Fixed various problems in the mapper when using more than a single game
  controller (e.g., with two joysticks connected, mapping the controls of the
  first joystick could randomly target the mappings of the second one and vice
  versa).

- Fixed obscure regression where the `timed = on` joystick setting messed up
  the available free memory reported by the FreeDOS `MEM.EXE` command.

??? note "Full PR list of input-related changes"

    - Deactivate IRQ if byte is read from i8042 chip (#3647)
    - Fix handling multiple game controllers (#3404)
    - Fix the 'In Extremis' game intro getting stuck (#3549)
    - Set BIOS_Destroy not changeable at runtime (#3420)


## DOS integration

### Improved expanded PCjr emulation

Now we're emulating a memory-expanded PCjr machine more faithfully. This
improves game compatibility; for example, **Space Quest** (v1.0x and v2.2) and
**King's Quest** (1986 PCjr DOS version) now work fine---these games resulted
in the emulator hanging previously.

A new `pcjr_memory_config` setting has been introduced to the `[dosbox]`
section, defaulting to `expanded` (the new improved behaviour). Setting this
to `standard` restores the legacy memory model. You should only need this
for a handful of titles, such as the DOS conversions of the **Jumpman** and
**Troll** PC Booter games.


### DOS shell improvements

- Fixed a bug that caused the batch file installer of **Alpha Storm** to fail.

- The help text of the `IMGMOUNT` command now mentions the very handy wildcard
  mounting option. E.g., you can use the `IMGMOUNT A floppy*.img -t floppy`
  command to mount multiple floppy images, then cycle between them with
  ++ctrl+f4++ at runtime (++cmd+f4++ on macOS).

- The `LOADFIX` command's help text is more complete now (some options were
  not documented previously).

- When a batch file was being instantiated, the echo state from the parent was
  not being transferred correctly if the parent was another batch file.


??? note "Full PR list of DOS integration related changes"

    - Check the validity of leading path when checking device name (#3525)
    - Improve the IMGMOUNT command's help text (#3551)
    - Inherit batch file echo state from parent (#3578)
    - Improve the help text of the LOADFIX command (#3221) (#3427)
    - Make PCjr application memory contiguous (#3460)


## Localisation

- Spanish and Brazilian Portuguese translations have been added.
- Updates to the Dutch, German, and Polish translations.

??? note "Full PR list of localisation-related changes"

    - Fix incomplete integration of Brazilian translation (#3438)
    - New Spanish translation (#3317)
    - Portuguese (Brazilian) Translation (#3432)
    - Update br.lng (#3439)
    - Update br.lng (#3458)
    - Update de.lng (#3530)
    - Update de.lng (#3530)
    - Update Dutch (nl) translation (#3459)
    - Update English (en) translation for 0.81.1 (#3600)
    - Update German (de) translation (#3630)
    - Update Italian (it) translation (#3560)
    - Update Italian (it) translation (#3603)
    - Update Polish (pl) translation (#3463)
    - Update Polish (pl) translation (#3532)
    - Update Polish (pl) translation (#3633)
    - Update Portuguese (br) translation (#3469)


## General

- Attempting to change unchangeable settings via the `CONFIG` command at
  runtime is no longer silently accepted (without doing anything) but an
  error is raised instead.

- Unknown command-line switches starting with dashes are now ignored and a
  warning is logged---DOSBox Staging will not try to execute them anymore. As
  a side effect, the current working directory was mounted as the C drive,
  which led to very non-intuitive behaviour.

- The Windows installer now creates a Start Menu shortcut to launch DOSBox
  Staging without showing the console window (**DOSBox Staging (no console
  window)** menu item).

- The Windows installer no longer starts DOSBox Staging automatically when the
  installation is completed.

- Most config settings are now correctly reverted to their defaults when an
  invalid value is set, and their values are kept in sync with the active
  setting.

??? note "Full PR list of miscellaneous changes"

    - Add "no console" start menu item to the Windows installer (#3510)
    - Better build version handling at runtime (#3556)
    - Config setting defaulting/syncing improvements & fixes (#3626)
    - Do not treat illegal command line switches as commands (#3621)
    - Drop Debian 10 (#3557)
    - Fix IPX config help comment (#3403)
    - Improve 'keyboardlayout' option description (#3409)
    - LTO build fix (#3538)
    - Throw error if user attempts to change an unchangeable setting (#3470)


## 0.81.1 commit authors

Complete list of commit authors who have contributed code, documentation, or
translation changes:

<div class="compact" markdown>

  - altiereslima
  - bluddy
  - Burrito78
  - farsil
  - japsmits
  - FeralChild64
  - ftortoriello
  - johnnovak
  - kklobe
  - weirddan455

</div>


## Thank you

We are grateful for all the community contributions and the original DOSBox
project, on which DOSBox Staging is based.

