# 0.75.0 release notes

**Release date:** 2020-05-06

## Summary

This document contains the release notes for DOSBox Staging 0.75. It describes
recently added, changed, or deleted features of DOSBox Staging.

All users are encouraged to consult the [New features in detail](#new-features-in-detail)
and [Known issues](#known-issues) sections before using DOSBox Staging, as
these describe important interface changes as well as information discovered
late in the release cycle or after the release.

## Installation instructions

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

The **DOSBox Staging** project was created September 15, 2019 as a
[soft-fork][fork] of the SourceForge-based DOSBox project, which is a separate
project having its own schedule and development priorities.

[fork]: https://en.wikipedia.org/wiki/Fork_(software_development)


## New features in detail

New features originating from our upstream (DOSBox) are marked with **SVN**.

### Upgrade to SDL 2.0

SDL 2.0 is a major update to the SDL 1.2 codebase, which has been unmaintained
since 2013. SDL 2.0 supports more input devices; more output interfaces such as
Wayland, and OpenGLES 1 and 2; low-latency audio using OpenSL ES; and improves
cross-platform consistency.

The migration to SDL 2.0:

- Dropped 3,211 lines of SDL 1.2 code in place of 1,664 lines, for just
  under a 50% reduction in code-size.
- Eliminated several OS-specific branches and all SDL1-specific kludges.
- Eased support for modern graphic APIs, and opened the field for new features
  and improvements.

One example includes the new `texture` output mode, which uses SDL's 2D
hardware-accelerated API rendering to a platform-specific backend.

For example, Windows users can test:

``` ini
[sdl]
output           = texture
texture_renderer = direct3d11
```

macOS users can try Metal:

``` ini
[sdl]
output           = texture
texture_renderer = metal
```

And everyone can use OpenGL as texture backend:

``` ini
[sdl]
output           = texture
texture_renderer = opengl
```

Or just use `texture_renderer = auto` to let SDL pick the backend appropriate
for your operating system.


### Support FLAC, Opus, and MP3 CD-DA tracks

FLAC, Opus, and MP3 (as well as MP2 and MP1) encoded audio can be `imgmount`ed
as CD-DA tracks in DOSBox Staging, in addition to the usual WAV and Vorbis
tracks supported by DOSBox. WAV support has been expanded to include Sony's
Wave64 format.

DOSBox Staging also supports tracks having sample resolutions of 24 and 16-bit;
sampling rates of 96, 88.2, 48, 44.1, 22.05, and 11.025 kHz; and stereo or mono
channel counts (to the extent each codec supports these variations). You can
mix-and-match these properties and track types to best suit each track's
content.

The following sample CUE file depicts the use of every codec supported by
DOSBox Staging:

```
FILE "data.iso" BINARY
  TRACK 01 MODE1/2048
    INDEX 01 00:00:00

FILE "track02.opus" OPUS
  TRACK 02  AUDIO
    PREGAP 00:02:00
    INDEX 01 00:00:00

FILE "track03.flac" FLAC
  TRACK 03 AUDIO
    INDEX 01 00:00:00

FILE "track04.mp3" MP3
  TRACK 04 AUDIO
    INDEX 01 00:00:00

FILE "track05.w64" W64
  TRACK 05 AUDIO
    INDEX 01 00:00:00

FILE "track06.ogg" OGG
  TRACK 06 AUDIO
    INDEX 01 00:00:00

FILE "track07.wav" WAV
  TRACK 07 AUDIO
    INDEX 01 00:00:00
```

For devices with sufficient storage, we recommend ripping your CD-ROM audio to
(lossless) FLAC tracks and adding seek-points using:

```
flac -8 --output-name=trackXY.flac trackXY.wav
metaflac --add-seekpoint=1s trackXY.flac
```

FLAC typically achieves between 50% and 35% compression while producing
binary-identical output versus WAV files.

For limited-storage devices such as ARM single-board computers, Opus provides
state-of-the-art lossy compression that exceeds all other formats, including
Apple's AAC and AAC High-Efficiency formats. Opus allows even further space
savings over MP3 or Vorbis track while matching or exceeding them in output
quality.

For example, CD-DA tracks consisting of monaural speech can be encoded with:

```
opusenc --speech --bitrate 24 --downmix-mono trackXY.wav trackXY.opus
```

When applied to Sierra's **Jones in the Fast Lane** audio track, Opus compresses
it from 373 MB down to 6.4 MB (98.2% savings in disk space) with no discernible
loss in quality.

For CD-DA tracks consisting of sound effects and relatively simple music, Opus
does fine with a bitrate between 54 and 70, whereas more complex musical
tracks might need a bitrate of up to 84. Experiment and find your sweet spot!

```
opusenc --bitrate 70 trackXY.wav trackXY.opus
```

If your CD-DA tracks are encoded at 48 kHz (which is Opus's default internal
rate), then feel free to configure DOSBox Staging's mixer rate to match,
which ensures your CD-DA will not be resampled through your audio chain; as
your sound card, USB speakers, and HDMI interface all (likely) operate at a
native rate of 48 kHz.

``` ini
[mixer]
rate = 48000
```

### Pixel-perfect scaling mode

Pixel-perfect output scales the image by the largest integer multiplier that
fits within your monitor's native resolution. For example, given a
1920&times;1080 monitor and a 320&times;200 game requiring aspect-correction,
each of its pixels would be scaled by 4&times;5 to produce a 1280&times;1000
image. This preserves the original artwork without *any* edge blurring.

To enable pixel-perfect output, apply the following settings to the indicated
sections of your DOSBox Staging configuration file, as follows:

``` ini
[sdl]
fullscreen = true
output     = texturepp

[render]
scaler   = none
glshader = none
```

Pixel-perfect looks like this on a 1080p screen:

<figure markdown>
  ![Heroes of Might and Magic II (1996)](https://www.dosbox-staging.org/static/images/release-notes/0.75.0/heroes-of-might-and-magic-2-pixel-perfect.png)

  <figcaption markdown>
  [Heroes of Might and Magic II (1996)](https://en.wikipedia.org/wiki/Heroes_of_Might_and_Magic_II) --- 640&times;480
  with a [pixel aspect ratio (PAR)](https://en.wikipedia.org/wiki/Pixel_aspect_ratio)
  of 1:1, upscaled to 2&times;2
  </figcaption>
</figure>

<figure markdown>
  ![Wolf3D](https://www.dosbox-staging.org/static/images/release-notes/0.75.0/wolfenstein-3d-pixel-perfect.png)

  <figcaption markdown>
  [Wolfenstein 3D (1992)](https://en.wikipedia.org/wiki/Wolfenstein_3D) --- 320&times;200 with a PAR of 1:1.2 (non-square
  pixels), upscaled to 4&times;5 with a PAR of 1:1.25
  </figcaption>
</figure>


### Resizable window

Being able to click and drag to resize an application's window is not a
revolutionary feature by any measure; however it's a welcome addition for
DOSBox Staging!

<figure markdown>
  <iframe width="840" height="472" src="https://www.youtube-nocookie.com/embed/9J2U-qFxE1E" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

  <figcaption markdown>
  [Star Wars: Dark Forces (1995)](https://en.wikipedia.org/wiki/Star_Wars:_Dark_Forces) --- intro playing while the DOSBox window is being
  resized vigorously
  </figcaption>
</figure>

This feature is a work-in-progress: it's available on Linux by default, and can
be enabled for testing on Windows and macOS by setting the following (but note
that it does not yet work correctly on these systems):

``` ini
[sdl]
windowresolution = resizable
```

On all systems, the resizable window is only available for `output = opengl`
and `glshader = sharp`. Support will be expanded to more outputs and shaders in
the future versions.

### AUTOTYPE command

`AUTOTYPE` is a command-line tool provided by DOSBox Staging that performs
scripted keyboard entry into the running DOS program or game.

It can be used to reliably skip intros, provide input to answer initial startup
or configuration questions, or conduct a simple demo.

Simply run the command to learn more:

```
Z:> autotype
```

Some games that benefit from `AUTOTYPE` on startup are listed on the
[wiki page][autotype].

[autotype]: https://github.com/dosbox-staging/dosbox-staging/wiki/AUTOTYPE-Candidates


### Changed rendering defaults

The following default configuration settings were changed to improve the
out-of-the-box experience for the majority of games running on modern hardware.

The default video settings now use SDL's OpenGL rendering backend, apply a 4:3
aspect ratio correction, and scale the image using the `sharp` OpenGL shader to
provide relatively sharp pixels when in fullscreen mode.

<figure markdown>
  ![Battle Chess](https://www.dosbox-staging.org/static/images/release-notes/0.75.0/battle-chess.png)

  <figcaption markdown>
  [Battle Chess (1989)](https://en.wikipedia.org/wiki/Battle_Chess) --- at 1080p using the default settings
  </figcaption>
</figure>


### Expand mouse control methods

The prior "autolocking" mouse option used by DOSBox has been renamed in
DOSBox Staging to `capture_mouse`, which is configured using two values
defining how the mouse behaves.

The first value defines how the mouse is controlled:

- `onclick`: the mouse will be captured with a click inside the window
- `onstart`: the mouse is captured immediately on start (similar to real DOS)
- `seamless`: the mouse will move seamlessly in and out of the window and cannot be captured
- `nomouse`: the mouse is disabled and hidden without any input sent to the game

The second value defines how middle-clicks are handled:

- `middlegame`: middle-clicks are sent to the game (not used to uncapture the mouse)
- `middlerelease`: middle-click will uncapture the mouse when windowed (not sent to the game)

For example:


``` ini
[sdl]
capture_mouse = onclick middlerelease
```

This will capture the mouse on the first click inside DOSBox Staging's window, and a
middle-click will release the mouse. Note that the prior method to release the
mouse still works (pressing ++ctrl+f10++).

!!! note

    DOSBox Staging defaults to `seamless` mouse capture both to simplify
    multi-tasking in windowed-mode and provide a frustration-free experience for
    new users. However, some games and Windows 3.1 make their own adjustments to
    the mouse position and will cause an offset-effect. In these cases, we
    recommend switching to fullscreen (++alt+enter++) or configuring the mouse to capture
    `onclick` or `onstart`.

!!! important

    These options do not affect the mouse behavior in fullscreen (++alt+enter++), as the mouse is always captured.


### Nuked OPL v1.8

The cycle-accurate Nuked [OPL3][opl] emulator is now used by default;
this change improves AdLib and Sound Blaster FM music emulation accuracy.

This improved accuracy comes at the cost of a slightly higher CPU use, which
is insignificant for the vast majority of users on typical desktop or laptop
hardware.

However, those using DOSBox Staging on old or CPU-limited hardware (capable of
30,000 dosbox "cycles" or less, such as the Raspberry Pi 3) will be served best
using the `fast` OPL emulator (see the `oplemu` documentation provided in the
configuration file).

[opl]: https://en.wikipedia.org/wiki/Yamaha_YMF262


### Reload key bindings at runtime

The built-in `CONFIG` shell command is a bit old, but a little-known feature
allows users to reconfigure DOSBox Staging at runtime. This is a nifty way to
change configuration using batch scripts based on user input.


#### Reloading key bindings

You can now change key bindings at runtime by loading them from a file:

```{ . .dos-prompt }
Z:\> config -set "sdl mapperfile=<path-to-file>"
```

#### Other new options (SVN)

DOSBox added a number of features to the `CONFIG` command. To list them all,
run:

```{ . .dos-prompt }
Z:\> config /?
```

### Configuration file locations

#### Linux

DOSBox Staging's configuration file location has been updated to comply wit
the [XDG Base Directory Specification][xdg]. This means DOSBox Staging will no
longer create configuration directories directly in your home directory.

Configuration files are now located in:

```
~/.config/dosbox/
```

Users can customize the parent (`.config/`) location by setting the
`XDG_CONFIG_HOME` environment variable, according to the [XDG
Specification][xdg].

[xdg]: https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html


#### macOS

The path was slightly changed to avoid spaces in the default configuration
filename and to group all configuration files in a single directory:

```
~/Library/Preferences/DOSBox/
```

#### Windows

No changes; the configuration files are created in:

```
C:\Users\<username>\AppData\Local\DOSBox\
```

### Modem phonebook

You can map fake phone numbers to Internet addresses which is useful for programs
where limitations on phone number input field are too strict.
Create a text file with the name specified in `phonebookfile` entry in the `[serial]`
section in the DOSBox configuration file and add phone-address pairs per line,
for example:

```
5551234 towel.blinkenlights.nl:23
```

Now you can dial the specified phone number and the emulated modem will connect
to the address it's mapped to. Note that phone book does not allow any
characters in the phone number that are ignored or denied by a real Hayes
compatible modem.


### 64-bit dynamic recompilation (SVN)

DOSBox has had [dynamic recompilation][dynarec] support for a long time, but it
was limited to 32-bit builds.  Support for 64-bit dynarec improves CPU
emulation speed and quality across the board---this is especially visible to
Linux and macOS users[^1].


<figure markdown>
  <iframe width="840" height="472" src="https://www.youtube-nocookie.com/embed/9N-wXIamSh4" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

  <figcaption markdown>
  [Stargunner (1996, freeware)](https://en.wikipedia.org/wiki/Stargunner) --- running on Linux x86_64 via Boxtron
  </figcaption>
</figure>

Before 64-bit dynarec, this game had serious emulation problems resulting in
fluctuating emulation speed (sometimes too fast, sometimes too slow -
regardless of cycles settings). This game was designed to run with constant
70 FPS and now it runs with constant 70 FPS.

[dynarec]: https://en.wikipedia.org/wiki/Dynamic_recompilation

[^1]: DOSBox Staging 0.75.0 stable Windows build is still 32-bit; Linux and
macOS builds are 64-bits.


### CGA improvements

<figure markdown>
  ![Maniac Mansion -- CGA modes comparison](https://www.dosbox-staging.org/static/images/release-notes/0.75.0/maniac-mansion-cga.png)

  <figcaption markdown>
  [Maniac Mansion (1988)](https://en.wikipedia.org/wiki/Maniac_Mansion) --- with forced CGA mode:<br>
  top-left: CGA, default palette;<br>
  top-right: CGA mono, green tint;<br>
  bottom-left: CGA composite, early model, default hue;<br>
  bottom-right: CGA composite, late model, default hue.
  </figcaption>
</figure>


#### CGA monochrome mode

Many [CGA][cga] games from the 80's were designed to support monochromatic
cathode-ray tube (CRT) monitors that used either an amber, green, or
grayscale-shaded phosphor coating. As such, some games look much better when
rendered using a similar monochrome palette. This mode is designed to emulate
such displays.

Use `machine = cga_mono` to turn on the feature. You can switch between green,
amber, white, and paper-white palettes at runtime by pressing ++f11++.

[cga]: https://en.wikipedia.org/wiki/Color_Graphics_Adapter


#### CGA Composite mode (SVN)

Technical artifacts caused by the composite video format were cleverly used by
game developers to generate extra colors (versus non-composite CGA) by
manipulating pixel positions on the screen.  For example, adjacent pixels would be
partly "averaged" (through horizontal overlap), producing interposed solid
colors or generating rudimentary transparency effects.

[Composite][comp] mode was added to DOSBox's CGA emulator in 2012, but was
never back-ported to any of its stable releases. Most users are familiar this
mode as its commonly included in other DOSBox forks.

Once enabled, you can switch between color and composite modes, early and late
CGA models, and adjust the hue at runtime.

!!! note

    The default keybinding for manipulating CGA modes conflict with other
    essential bindings; it's advisable to change them if you plan to use this
    feature. The default key for turning on composite mode is ++f12++.

[comp]: https://en.wikipedia.org/wiki/Composite_artifact_colors


### GLSL shader support (SVN)

Shaders written in [OpenGL Shading Language (GLSL)][glsl] offload the task of
processing the emulated game's output to your GPU hardware.

This allows the image to be altered in many ways, such as emulating the analog
artifacts (scanlines, shadow masks, and phosphor glow) present in circa-1980s
and 90s CRT monitor on modern 1080p and greater LCD panels.

You can can select the shader to use by setting the `glshader` config param:

``` ini
[render]
glshader = sharp
```

It's also possible to provide your shader implementations by placing `.glsl`
files in the configuration directory:

<div class="compact" markdown>

| <!-- --> | <!-- --> |
|----------|----------|
| Linux    | `~/.config/dosbox/glshaders/` |
| macOS    | `~/Library/Preferences/DOSBox/glshaders/` |
| Windows  | `C:\Users\<USERNAME>\AppData\Local\DOSBox\glshaders\` |

</div>

E.g. if you put a shader file called `test.glsl` in your config directory, you
can select it as follows:

``` ini
glshader = test.glsl
```

!!! note

    When using a GLSL shader, we recommend setting the `scaler` type to `none` to
    ensure image post-processing is performed exclusively by the shader (and not a
    mix of the two).

<figure markdown>
  ![X-Wing Collector's Edition](https://www.dosbox-staging.org/static/images/release-notes/0.75.0/start-wars-x-wing-crt-shader.png)

  <figcaption markdown>
  [Star Wars(tm) --- X-Wing: Collector's CD-ROM Edition (1994)](https://en.wikipedia.org/wiki/Star_Wars:_X-Wing_(video_game_series)#Collector_Editions)<br>
  Using CRT-Lottes shader on a 1080p screen; click on the image to enlarge it to see
  the fine details. This shader is not bundled with DOSBox Staging (yet); you
  can download it from [here](https://github.com/tyrells/dosbox-svn-shaders).
  </figcaption>
</figure>

[glsl]: https://en.wikipedia.org/wiki/OpenGL_Shading_Language


### DATE and TIME commands (SVN)

The traditional `DATE` and `TIME` DOS commands have been added to DOSBox. This
allows the user to change the date seen by the software running inside the
emulated environment:

```{ . .dos-prompt }
Z:\> date
Current date: Fri 05/01/2020
Type 'date MM-DD-YYYY' to change.

Z:\> time
Current time: 11:08:23,34
```

Note that while the date can be changed, the time cannot.

This feature is useful for running old batch scripts and bypassing date checks
in some old software.


### Mount overlay support

This feature allows the user to redirect new and changed files to a different
location transparently. The files in the overlay and normal drives are merged
at startup and kept up to date when the game writes to the disk.

This feature is useful for redirecting save files or configuration files
to a different location (e.g. for backup or cloud saves).

Example usage:

```{ . .dos-prompt }
Z:\> mount C real
Drive C is mounted as local directory real/

Z:\> mount C backup -t overlay
Overlay backup/ on drive C mounted.

Z:\> C:
C:\> echo foo > test.txt

C:\> type TEST.TXT
foo
```

File `TEST.TXT` is written to the directory `backup`, and not to `real`.

## Overview of changes

### Removed features

- DOSBox Staging does not run on Operating System/2 (OS/2) or derivatives.
- DOSBox Staging does not run on Windows XP or earlier Windows versions.
- Removed support for old DirectDraw (`ddraw`) output.
  Use `output = texture`, `texture_renderer = directx11` instead.
- Removed support for old `overlay` output. Use any other output.
- Removed support for relative window size (`windowresolution = X%`).
- Removed support for 64-bit Zip Motion Blocks Video (ZMBV) codec (old 32-bit
  codec still works).
- Removed support for CD-DA playback from physical disks. It is
  still possible to install games distributed on CDs by mounting them as
  directories (#260)
- Removed CD-DA playback support for tracks using the Audio Interchange File
  Format [AIFF][aiff] audio codec.

[aiff]: https://en.wikipedia.org/wiki/Audio_Interchange_File_Format


### Development changes

- Migrated the DOSBox source from Apache's Subversion (SVN) software versioning
  and revision control system to the Git distributed version-control system
  using GitHub, while preserving all publicly available project history.

    - Active SVN branch paths were imported as Git branches (named`svn/<name>`).
    - SVN tag paths were imported as Git lightweight tags (named
      `svn/<tag-name>`).

- Ongoing upstream SVN development work is being imported in a timely manner to
  the Git branch named `svn/trunk`.

- C++11 language constructs are now allowed.

- Implemented a Continuous Integration (CI) system that builds on every code
  push to provide immediate feedback to developers regarding build-success and
  warning-counts on:

    - Windows x86_64 using GCC 32 and 64-bit, Clang 32 and 64-bit, and
      VisualStudio 64-bit compilers

    - macOS x86_64 using GCC and Clang compilers

    - Linux x86_64, ARMv6, ARMv7, IBM LinuxONE, and IBM POWER8 platforms using
      various versions of GCC and Clang

- Added static analysis checks performed by LLVM's Clang, Synopsys's Coverity,
  and VIVA64's Program Verification Systems (PVS) Studio.

- Added dynamic analysis checks performed by Clang's undefined-behavior (UB)
  sanitizer and GCC's UB and address sanitizers.

- The CI system includes gated checks that allow maintainers to focus on code
  functionality and correctness. These automated checks guarantee that new
  code:

    - builds cleanly on all supported platforms and compilers,
    - adds no new compiler warnings, and
    - adds no new static or dynamic analysis issues.

- Notable progress has been made in reducing the number of warnings and
  analysis issues flagged by these tools.

- Windows: the build-system was adjusted to allow easy compilation, without
  manual download or patching of dependencies. We use `vcpkg` to manage
  dependencies. The solution file was fixed to work with Visual Studio 2019.

- Linux and macOS: implemented a number of small build-system improvements.

- Automated the compilation of release-style builds against the latest main
  and feature branches. These not only save time for testers wanting to verify
  new features and bugfixes, but also ensures they're running builds compiled
  using would-be release settings.

- macOS: release binaries are compiled with optimizations supporting Intel
  Nehalem-based instructions (and newer), as this matches the minimum processor
  requirements set by macOS Catalina.

- Release packages are scanned using up-to-date Antivirus software: ClamAV for
  Linux and macOS, and Windows Defender for Windows.

- The project has published a
  [Code of Conduct](https://github.com/dosbox-staging/dosbox-staging/blob/main/CODE_OF_CONDUCT.md)
  along with clear
  [Contributor Guidelines](https://github.com/dosbox-staging/dosbox-staging/blob/main/CONTRIBUTING.md).


### Known issues

- Inconsistent minimum window size with `windowresolution = resizable` when
  leaving fullscreen.
- Windows, macOS: Window content is not refreshed when resizing.
- Windows, macOS: Emulation stops when moving or resizing window.
- Linux: Wayland crashes (Wayland support is "experimental" at the moment).
- Linux: Splash screen is sometimes transparent or corrupted on KDE.

Submit new issues or learn more about existing ones using our
[bug-tracker](https://github.com/dosbox-staging/dosbox-staging/issues).


### Contributors

During the **DOSBox Staging 0.75** development period:

- **11 DOSBox Staging contributors** submitted **208** pull requests comprised
  of **780** commits written by **18 authors**.
- **69 DOSBox Staging issues** were reported and addressed.
- **54 DOSBox Staging wiki updates** were made.
- **Three DOSBox (SVN) maintainers** committed **76** changes written by **5**
  authors. These changes have been incorporated into DOSBox Staging.


#### Maintainers

<div class="compact" markdown>

- Patryk Obara
- kcgen
- Anton Shepelev *(ant-222)*

</div>

#### Direct contributors

<div class="compact" markdown>

- Anton Shepelev *(ant-222)*
- Joshua Fern
- kcgen
- Marco Maccaferri
- NicknineTheEagle
- Nopey Nope
- numberZero
- Patrick McMorris
- Patryk Obara
- Troy Campbell
- Wouter Wijsman

</div>

#### Testers and wiki contributors

<div class="compact" markdown>

- GranMinigun
- kas1e
- nemo93
- rderooy

</div>

#### Indirect contributors

Library or patch authors, upstream SVN developers, etc.

<div class="compact" markdown>

- Alexey Khokholov *(nukeykt)*
- Arthur Ouellet
- David Reid
- jmarsh
- NY00123
- Peter Veenstra
- ripsaw8080
- Ryan C. Gordon
- Sean Barrett
- Sjoerd van der Berg
- VileRancour
- Yann Collet

</div>

#### Changelog

You can read detailed changelog via Git, e.g. using the following command:

```
git shortlog ^v0.75.0-pre v0.75.0 --no-merges
```

### Merged-in community patches and libraries

The following lists those merges performed by maintainers either on behalf of,
or making use of, patches or libraries authored by community members (in
alphabetic order).

**kcgen**

- Add built-in xxHash (v0.7.3) *(Yann Collet)*
- Add built-in Vorbis codec: (v1.17) *(Sean Barrett)*
- Add built-in SDL_sound r599 (LGPL) *(Ryan C. Gordon)*
- Add built-in C++ object serializer *(Arthur Cuellet)*
- Add built-in FLAC codec: dr_flac v0.12.11 *(David Reid)*
- Add built-in MP3 codec: dr_mp3 v0.6.4 *(David Reid)*
- Add built-in WAV codec: dr_wav v0.12.1 *(David Reid)*

**Patryk Obara**

- Replace SDL 1.2 with SDL 2.0 *(based on work of NY00123)*
- Add Nuked OPL3 emulator v1.8 *(Alexey Khokholov)*

**Peter Veenstra**

*Changes merged-in to SVN*

- Add OpenGL shader support *(ny00123 and refined by jmarsh)*
- Add several builtin shaders that mimic the scalers and some extra *(jmarsh)*

- Fix xcmpchg in dyn_x86 core. Allows Quickview to work in that core
  *(jmarsh)*

- Additional refinements and speed ups *(jmarsh)*
- Fix some issues with commit 4282 *(Patryk Obara and jmarsh)*
- Switch to a different way to calculate the table offsets *(jmarsh)*

- Fix boundary checks for word/dword memory access. Speeds up dynamic 32 bit
  core a bit *(jmarsh)*

- Add 64-bit support to dynamic_x86 core from vogons topic 67673 *(jmarsh)*

**Michael Zijlstra**

- Add cga_mono machine *(VileRancour)*


## Thank you

We are extremely grateful for all contributions, including the invaluable
improvements merged in from the DOSBox project.

