/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/fs_inet.h>
        #include <wx/filesys.h>
        #include <wx/filesys.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxInternetFSHandler : public ::wxInternetFSHandler
{
public:
    sipwxInternetFSHandler();
    virtual ~sipwxInternetFSHandler();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    static ::wxString sipProtect_GetAnchor(const ::wxString&);
    static ::wxString sipProtect_GetLeftLocation(const ::wxString&);
    static ::wxString sipProtect_GetProtocol(const ::wxString&);
    static ::wxString sipProtect_GetRightLocation(const ::wxString&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool CanOpen(const ::wxString&) SIP_OVERRIDE;
    ::wxString FindFirst(const ::wxString&, int) SIP_OVERRIDE;
    ::wxString FindNext() SIP_OVERRIDE;
    ::wxFSFile* OpenFile(::wxFileSystem&, const ::wxString&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxInternetFSHandler(const sipwxInternetFSHandler &);
    sipwxInternetFSHandler &operator = (const sipwxInternetFSHandler &);

    char sipPyMethods[4];
};

sipwxInternetFSHandler::sipwxInternetFSHandler(): ::wxInternetFSHandler(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxInternetFSHandler::~sipwxInternetFSHandler()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxInternetFSHandler::CanOpen(const ::wxString& location)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_CanOpen);

    if (!sipMeth)
        return ::wxInternetFSHandler::CanOpen(location);

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    return sipVH__core_9(sipGILState, 0, sipPySelf, sipMeth, location);
}

::wxString sipwxInternetFSHandler::FindFirst(const ::wxString& spec, int flags)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_FindFirst);

    if (!sipMeth)
        return ::wxInternetFSHandler::FindFirst(spec, flags);

    extern ::wxString sipVH__core_10(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&, int);

    return sipVH__core_10(sipGILState, 0, sipPySelf, sipMeth, spec, flags);
}

::wxString sipwxInternetFSHandler::FindNext()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_FindNext);

    if (!sipMeth)
        return ::wxInternetFSHandler::FindNext();

    extern ::wxString sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_11(sipGILState, 0, sipPySelf, sipMeth);
}

::wxFSFile* sipwxInternetFSHandler::OpenFile(::wxFileSystem& fs, const ::wxString& location)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_OpenFile);

    if (!sipMeth)
        return ::wxInternetFSHandler::OpenFile(fs, location);

    extern ::wxFSFile* sipVH__core_12(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxFileSystem&, const ::wxString&);

    return sipVH__core_12(sipGILState, 0, sipPySelf, sipMeth, fs, location);
}

::wxString sipwxInternetFSHandler::sipProtect_GetAnchor(const ::wxString& location)
{
    return ::wxFileSystemHandler::GetAnchor(location);
}

::wxString sipwxInternetFSHandler::sipProtect_GetLeftLocation(const ::wxString& location)
{
    return ::wxFileSystemHandler::GetLeftLocation(location);
}

::wxString sipwxInternetFSHandler::sipProtect_GetProtocol(const ::wxString& location)
{
    return ::wxFileSystemHandler::GetProtocol(location);
}

::wxString sipwxInternetFSHandler::sipProtect_GetRightLocation(const ::wxString& location)
{
    return ::wxFileSystemHandler::GetRightLocation(location);
}


PyDoc_STRVAR(doc_wxInternetFSHandler_GetAnchor, "GetAnchor(location) -> str\n"
"\n"
"Returns the anchor if present in the location.");

extern "C" {static PyObject *meth_wxInternetFSHandler_GetAnchor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_GetAnchor(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &location, &locationState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipwxInternetFSHandler::sipProtect_GetAnchor(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location), sipType_wxString, locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_GetAnchor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_GetLeftLocation, "GetLeftLocation(location) -> str\n"
"\n"
"Returns the left location string extracted from location.");

extern "C" {static PyObject *meth_wxInternetFSHandler_GetLeftLocation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_GetLeftLocation(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &location, &locationState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipwxInternetFSHandler::sipProtect_GetLeftLocation(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location), sipType_wxString, locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_GetLeftLocation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_GetProtocol, "GetProtocol(location) -> str\n"
"\n"
"Returns the protocol string extracted from location.");

extern "C" {static PyObject *meth_wxInternetFSHandler_GetProtocol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_GetProtocol(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &location, &locationState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipwxInternetFSHandler::sipProtect_GetProtocol(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location), sipType_wxString, locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_GetProtocol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_GetRightLocation, "GetRightLocation(location) -> str\n"
"\n"
"Returns the right location string extracted from location.");

extern "C" {static PyObject *meth_wxInternetFSHandler_GetRightLocation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_GetRightLocation(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* location;
        int locationState = 0;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &location, &locationState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipwxInternetFSHandler::sipProtect_GetRightLocation(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location), sipType_wxString, locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_GetRightLocation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_CanOpen, "CanOpen(self, location: Any) -> bool");

extern "C" {static PyObject *meth_wxInternetFSHandler_CanOpen(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_CanOpen(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxString* location;
        int locationState = 0;
        ::wxInternetFSHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxInternetFSHandler, &sipCpp, sipType_wxString, &location, &locationState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxInternetFSHandler::CanOpen(*location) : sipCpp->CanOpen(*location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location), sipType_wxString, locationState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_CanOpen, doc_wxInternetFSHandler_CanOpen);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_OpenFile, "OpenFile(self, fs: FileSystem, location: Any) -> FSFile|None");

extern "C" {static PyObject *meth_wxInternetFSHandler_OpenFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_OpenFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxFileSystem* fs;
        const ::wxString* location;
        int locationState = 0;
        ::wxInternetFSHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fs,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1", &sipSelf, sipType_wxInternetFSHandler, &sipCpp, sipType_wxFileSystem, &fs, sipType_wxString, &location, &locationState))
        {
            ::wxFSFile*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxInternetFSHandler::OpenFile(*fs, *location) : sipCpp->OpenFile(*fs, *location));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(location), sipType_wxString, locationState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxFSFile, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_OpenFile, doc_wxInternetFSHandler_OpenFile);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_FindFirst, "FindFirst(self, spec: Any, flags: int = 0) -> Any");

extern "C" {static PyObject *meth_wxInternetFSHandler_FindFirst(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_FindFirst(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxString* spec;
        int specState = 0;
        int flags = 0;
        ::wxInternetFSHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_spec,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_wxInternetFSHandler, &sipCpp, sipType_wxString, &spec, &specState, &flags))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString((sipSelfWasArg ? sipCpp->::wxInternetFSHandler::FindFirst(*spec, flags) : sipCpp->FindFirst(*spec, flags)));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(spec), sipType_wxString, specState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_FindFirst, doc_wxInternetFSHandler_FindFirst);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxInternetFSHandler_FindNext, "FindNext(self) -> Any");

extern "C" {static PyObject *meth_wxInternetFSHandler_FindNext(PyObject *, PyObject *);}
static PyObject *meth_wxInternetFSHandler_FindNext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxInternetFSHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxInternetFSHandler, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString((sipSelfWasArg ? sipCpp->::wxInternetFSHandler::FindNext() : sipCpp->FindNext()));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_InternetFSHandler, sipName_FindNext, doc_wxInternetFSHandler_FindNext);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxInternetFSHandler(void *, const sipTypeDef *);}
static void *cast_wxInternetFSHandler(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxInternetFSHandler *sipCpp = reinterpret_cast< ::wxInternetFSHandler *>(sipCppV);

    if (targetType == sipType_wxInternetFSHandler)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxFileSystemHandler)->ctd_cast(static_cast< ::wxFileSystemHandler *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxInternetFSHandler(void *, int);}
static void release_wxInternetFSHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxInternetFSHandler *>(sipCppV);
    else
        delete reinterpret_cast< ::wxInternetFSHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxInternetFSHandler(Py_ssize_t);}
static void *array_wxInternetFSHandler(Py_ssize_t sipNrElem)
{
    return new ::wxInternetFSHandler[sipNrElem];
}


extern "C" {static void array_delete_wxInternetFSHandler(void *);}
static void array_delete_wxInternetFSHandler(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxInternetFSHandler *>(sipCpp);
}


extern "C" {static void dealloc_wxInternetFSHandler(sipSimpleWrapper *);}
static void dealloc_wxInternetFSHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxInternetFSHandler *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxInternetFSHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxInternetFSHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxInternetFSHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxInternetFSHandler *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxInternetFSHandler();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxInternetFSHandler[] = {{186, 255, 1}};


static PyMethodDef methods_wxInternetFSHandler[] = {
    {sipName_CanOpen, SIP_MLMETH_CAST(meth_wxInternetFSHandler_CanOpen), METH_VARARGS|METH_KEYWORDS, doc_wxInternetFSHandler_CanOpen},
    {sipName_FindFirst, SIP_MLMETH_CAST(meth_wxInternetFSHandler_FindFirst), METH_VARARGS|METH_KEYWORDS, doc_wxInternetFSHandler_FindFirst},
    {sipName_FindNext, meth_wxInternetFSHandler_FindNext, METH_VARARGS, doc_wxInternetFSHandler_FindNext},
    {sipName_GetAnchor, SIP_MLMETH_CAST(meth_wxInternetFSHandler_GetAnchor), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_GetLeftLocation, SIP_MLMETH_CAST(meth_wxInternetFSHandler_GetLeftLocation), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_GetProtocol, SIP_MLMETH_CAST(meth_wxInternetFSHandler_GetProtocol), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_GetRightLocation, SIP_MLMETH_CAST(meth_wxInternetFSHandler_GetRightLocation), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_OpenFile, SIP_MLMETH_CAST(meth_wxInternetFSHandler_OpenFile), METH_VARARGS|METH_KEYWORDS, doc_wxInternetFSHandler_OpenFile}
};

PyDoc_STRVAR(doc_wxInternetFSHandler, "InternetFSHandler() -> None\n"
"\n"
"A file system handler for accessing files from internet servers.");


sipClassTypeDef sipTypeDef__core_wxInternetFSHandler = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxInternetFSHandler,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_InternetFSHandler,
        {0, 0, 1},
        8, methods_wxInternetFSHandler,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxInternetFSHandler,
    -1,
    -1,
    supers_wxInternetFSHandler,
    SIP_NULLPTR,
    init_type_wxInternetFSHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxInternetFSHandler,
    SIP_NULLPTR,
    array_wxInternetFSHandler,
    SIP_NULLPTR,
    release_wxInternetFSHandler,
    cast_wxInternetFSHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxInternetFSHandler,
    sizeof (::wxInternetFSHandler),
};
