/*
 * Copyright (C) 2002 Paul Martin <pm@debian.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "lcd.h"

void lcd_op(const int operation,
	                struct lcd_display *disp, const char *error);
void wait_for_select(void (*idle_task)(void));
unsigned long wait_for_button(void);
void wait_for_no_button(void);
void put_lcd(const char *line1, const char *line2);
void save_lcd(struct lcd_display *display);
void restore_lcd(struct lcd_display *display);
void set_cursor(int address);
void unset_cursor(void);
int ask_yes_no(const char *question);
