// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="what-is-rustc.html"><strong aria-hidden="true">1.</strong> What is rustc?</a></li><li class="chapter-item expanded "><a href="command-line-arguments.html"><strong aria-hidden="true">2.</strong> Command-line Arguments</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="command-line-arguments/print-options.html"><strong aria-hidden="true">2.1.</strong> Print Options</a></li><li class="chapter-item expanded "><a href="codegen-options/index.html"><strong aria-hidden="true">2.2.</strong> Codegen Options</a></li></ol></li><li class="chapter-item expanded "><a href="jobserver.html"><strong aria-hidden="true">3.</strong> Jobserver</a></li><li class="chapter-item expanded "><a href="lints/index.html"><strong aria-hidden="true">4.</strong> Lints</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="lints/levels.html"><strong aria-hidden="true">4.1.</strong> Lint Levels</a></li><li class="chapter-item expanded "><a href="lints/groups.html"><strong aria-hidden="true">4.2.</strong> Lint Groups</a></li><li class="chapter-item expanded "><a href="lints/listing/index.html"><strong aria-hidden="true">4.3.</strong> Lint Listing</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="lints/listing/allowed-by-default.html"><strong aria-hidden="true">4.3.1.</strong> Allowed-by-default Lints</a></li><li class="chapter-item expanded "><a href="lints/listing/warn-by-default.html"><strong aria-hidden="true">4.3.2.</strong> Warn-by-default Lints</a></li><li class="chapter-item expanded "><a href="lints/listing/deny-by-default.html"><strong aria-hidden="true">4.3.3.</strong> Deny-by-default Lints</a></li></ol></li></ol></li><li class="chapter-item expanded "><a href="json.html"><strong aria-hidden="true">5.</strong> JSON Output</a></li><li class="chapter-item expanded "><a href="tests/index.html"><strong aria-hidden="true">6.</strong> Tests</a></li><li class="chapter-item expanded "><a href="targets/index.html"><strong aria-hidden="true">7.</strong> Targets</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="targets/built-in.html"><strong aria-hidden="true">7.1.</strong> Built-in Targets</a></li><li class="chapter-item expanded "><a href="targets/custom.html"><strong aria-hidden="true">7.2.</strong> Custom Targets</a></li><li class="chapter-item expanded "><a href="targets/known-issues.html"><strong aria-hidden="true">7.3.</strong> Known Issues</a></li></ol></li><li class="chapter-item expanded "><a href="profile-guided-optimization.html"><strong aria-hidden="true">8.</strong> Profile-guided Optimization</a></li><li class="chapter-item expanded "><a href="instrument-coverage.html"><strong aria-hidden="true">9.</strong> Instrumentation-based Code Coverage</a></li><li class="chapter-item expanded "><a href="linker-plugin-lto.html"><strong aria-hidden="true">10.</strong> Linker-plugin-based LTO</a></li><li class="chapter-item expanded "><a href="check-cfg.html"><strong aria-hidden="true">11.</strong> Checking Conditional Configurations</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="check-cfg/cargo-specifics.html"><strong aria-hidden="true">11.1.</strong> Cargo Specifics</a></li></ol></li><li class="chapter-item expanded "><a href="exploit-mitigations.html"><strong aria-hidden="true">12.</strong> Exploit Mitigations</a></li><li class="chapter-item expanded "><a href="symbol-mangling/index.html"><strong aria-hidden="true">13.</strong> Symbol Mangling</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="symbol-mangling/v0.html"><strong aria-hidden="true">13.1.</strong> v0 Symbol Format</a></li></ol></li><li class="chapter-item expanded "><a href="contributing.html"><strong aria-hidden="true">14.</strong> Contributing to rustc</a></li><li class="chapter-item expanded affix "><li class="spacer"></li><li class="chapter-item expanded "><a href="platform-support.html"><strong aria-hidden="true">15.</strong> Platform Support</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="target-tier-policy.html"><strong aria-hidden="true">15.1.</strong> Target Tier Policy</a></li><li class="chapter-item expanded "><a href="platform-support/TEMPLATE.html"><strong aria-hidden="true">15.2.</strong> Template for Target-specific Documentation</a></li><li class="chapter-item expanded "><a href="platform-support/arm64ec-pc-windows-msvc.html"><strong aria-hidden="true">15.3.</strong> arm64ec-pc-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/apple-darwin.html"><strong aria-hidden="true">15.4.</strong> *-apple-darwin</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/i686-apple-darwin.html"><strong aria-hidden="true">15.4.1.</strong> i686-apple-darwin</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64h-apple-darwin.html"><strong aria-hidden="true">15.4.2.</strong> x86_64h-apple-darwin</a></li><li class="chapter-item expanded "><a href="platform-support/arm64e-apple-darwin.html"><strong aria-hidden="true">15.4.3.</strong> arm64e-apple-darwin</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/apple-ios.html"><strong aria-hidden="true">15.5.</strong> *-apple-ios</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/apple-ios-macabi.html"><strong aria-hidden="true">15.5.1.</strong> *-apple-ios-macabi</a></li><li class="chapter-item expanded "><a href="platform-support/arm64e-apple-ios.html"><strong aria-hidden="true">15.5.2.</strong> arm64e-apple-ios</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/apple-tvos.html"><strong aria-hidden="true">15.6.</strong> *-apple-tvos</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/arm64e-apple-tvos.html"><strong aria-hidden="true">15.6.1.</strong> arm64e-apple-tvos</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/apple-watchos.html"><strong aria-hidden="true">15.7.</strong> *-apple-watchos</a></li><li class="chapter-item expanded "><a href="platform-support/apple-visionos.html"><strong aria-hidden="true">15.8.</strong> *-apple-visionos</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-nintendo-switch-freestanding.html"><strong aria-hidden="true">15.9.</strong> aarch64-nintendo-switch-freestanding</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-unknown-linux-musl.html"><strong aria-hidden="true">15.10.</strong> aarch64-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/amdgcn-amd-amdhsa.html"><strong aria-hidden="true">15.11.</strong> amdgcn-amd-amdhsa</a></li><li class="chapter-item expanded "><a href="platform-support/armeb-unknown-linux-gnueabi.html"><strong aria-hidden="true">15.12.</strong> armeb-unknown-linux-gnueabi</a></li><li class="chapter-item expanded "><a href="platform-support/arm-none-eabi.html"><strong aria-hidden="true">15.13.</strong> arm-none-eabi</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="platform-support/armv4t-none-eabi.html"><strong aria-hidden="true">15.13.1.</strong> armv4t-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv5te-none-eabi.html"><strong aria-hidden="true">15.13.2.</strong> armv5te-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv7r-none-eabi.html"><strong aria-hidden="true">15.13.3.</strong> armv7r-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv8r-none-eabihf.html"><strong aria-hidden="true">15.13.4.</strong> armv8r-none-eabihf</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv6m-none-eabi.html"><strong aria-hidden="true">15.13.5.</strong> thumbv6m-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv7em-none-eabi.html"><strong aria-hidden="true">15.13.6.</strong> thumbv7em-none-eabi*</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv7m-none-eabi.html"><strong aria-hidden="true">15.13.7.</strong> thumbv7m-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv8m.base-none-eabi.html"><strong aria-hidden="true">15.13.8.</strong> thumbv8m.base-none-eabi</a></li><li class="chapter-item expanded "><a href="platform-support/thumbv8m.main-none-eabi.html"><strong aria-hidden="true">15.13.9.</strong> thumbv8m.main-none-eabi*</a></li></ol></li><li class="chapter-item expanded "><a href="platform-support/armv5te-unknown-linux-gnueabi.html"><strong aria-hidden="true">15.14.</strong> armv5te-unknown-linux-gnueabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv6k-nintendo-3ds.html"><strong aria-hidden="true">15.15.</strong> armv6k-nintendo-3ds</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-rtems-eabihf.html"><strong aria-hidden="true">15.16.</strong> armv7-rtems-eabihf</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-sony-vita-newlibeabihf.html"><strong aria-hidden="true">15.17.</strong> armv7-sony-vita-newlibeabihf</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-unknown-linux-uclibceabi.html"><strong aria-hidden="true">15.18.</strong> armv7-unknown-linux-uclibceabi</a></li><li class="chapter-item expanded "><a href="platform-support/armv7-unknown-linux-uclibceabihf.html"><strong aria-hidden="true">15.19.</strong> armv7-unknown-linux-uclibceabihf</a></li><li class="chapter-item expanded "><a href="platform-support/android.html"><strong aria-hidden="true">15.20.</strong> *-android and *-androideabi</a></li><li class="chapter-item expanded "><a href="platform-support/openharmony.html"><strong aria-hidden="true">15.21.</strong> *-linux-ohos</a></li><li class="chapter-item expanded "><a href="platform-support/hurd.html"><strong aria-hidden="true">15.22.</strong> *-hurd-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/aarch64-unknown-teeos.html"><strong aria-hidden="true">15.23.</strong> aarch64-unknown-teeos</a></li><li class="chapter-item expanded "><a href="platform-support/avr-none.html"><strong aria-hidden="true">15.24.</strong> avr-none</a></li><li class="chapter-item expanded "><a href="platform-support/esp-idf.html"><strong aria-hidden="true">15.25.</strong> *-espidf</a></li><li class="chapter-item expanded "><a href="platform-support/fuchsia.html"><strong aria-hidden="true">15.26.</strong> *-unknown-fuchsia</a></li><li class="chapter-item expanded "><a href="platform-support/trusty.html"><strong aria-hidden="true">15.27.</strong> *-unknown-trusty</a></li><li class="chapter-item expanded "><a href="platform-support/kmc-solid.html"><strong aria-hidden="true">15.28.</strong> *-kmc-solid_*</a></li><li class="chapter-item expanded "><a href="platform-support/csky-unknown-linux-gnuabiv2.html"><strong aria-hidden="true">15.29.</strong> csky-unknown-linux-gnuabiv2*</a></li><li class="chapter-item expanded "><a href="platform-support/hexagon-unknown-linux-musl.html"><strong aria-hidden="true">15.30.</strong> hexagon-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/hexagon-unknown-none-elf.html"><strong aria-hidden="true">15.31.</strong> hexagon-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/illumos.html"><strong aria-hidden="true">15.32.</strong> illumos</a></li><li class="chapter-item expanded "><a href="platform-support/loongarch-linux.html"><strong aria-hidden="true">15.33.</strong> loongarch*-unknown-linux-*</a></li><li class="chapter-item expanded "><a href="platform-support/loongarch-none.html"><strong aria-hidden="true">15.34.</strong> loongarch*-unknown-none*</a></li><li class="chapter-item expanded "><a href="platform-support/lynxos178.html"><strong aria-hidden="true">15.35.</strong> *-lynxos178-*</a></li><li class="chapter-item expanded "><a href="platform-support/m68k-unknown-linux-gnu.html"><strong aria-hidden="true">15.36.</strong> m68k-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/m68k-unknown-none-elf.html"><strong aria-hidden="true">15.37.</strong> m68k-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/mips64-openwrt-linux-musl.html"><strong aria-hidden="true">15.38.</strong> mips64-openwrt-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/mips64-unknown-linux-muslabi64.html"><strong aria-hidden="true">15.39.</strong> mips64-unknown-linux-muslabi64</a></li><li class="chapter-item expanded "><a href="platform-support/mipsel-sony-psx.html"><strong aria-hidden="true">15.40.</strong> mipsel-sony-psx</a></li><li class="chapter-item expanded "><a href="platform-support/mipsel-unknown-linux-gnu.html"><strong aria-hidden="true">15.41.</strong> mipsel-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/mips-mti-none-elf.html"><strong aria-hidden="true">15.42.</strong> mips*-mti-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/mips-release-6.html"><strong aria-hidden="true">15.43.</strong> mipsisa*r6*-unknown-linux-gnu*</a></li><li class="chapter-item expanded "><a href="platform-support/nvptx64-nvidia-cuda.html"><strong aria-hidden="true">15.44.</strong> nvptx64-nvidia-cuda</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc-unknown-openbsd.html"><strong aria-hidden="true">15.45.</strong> powerpc-unknown-openbsd</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc-unknown-linux-gnuspe.html"><strong aria-hidden="true">15.46.</strong> powerpc-unknown-linux-gnuspe</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc-unknown-linux-muslspe.html"><strong aria-hidden="true">15.47.</strong> powerpc-unknown-linux-muslspe</a></li><li class="chapter-item expanded "><a href="platform-support/aix.html"><strong aria-hidden="true">15.48.</strong> powerpc64-ibm-aix</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc64-unknown-linux-musl.html"><strong aria-hidden="true">15.49.</strong> powerpc64-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc64le-unknown-linux-gnu.html"><strong aria-hidden="true">15.50.</strong> powerpc64le-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/powerpc64le-unknown-linux-musl.html"><strong aria-hidden="true">15.51.</strong> powerpc64le-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32e-unknown-none-elf.html"><strong aria-hidden="true">15.52.</strong> riscv32e*-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32-unknown-none-elf.html"><strong aria-hidden="true">15.53.</strong> riscv32i*-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32im-risc0-zkvm-elf.html"><strong aria-hidden="true">15.54.</strong> riscv32im-risc0-zkvm-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv32imac-unknown-xous-elf.html"><strong aria-hidden="true">15.55.</strong> riscv32imac-unknown-xous-elf</a></li><li class="chapter-item expanded "><a href="platform-support/riscv64gc-unknown-linux-gnu.html"><strong aria-hidden="true">15.56.</strong> riscv64gc-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/riscv64gc-unknown-linux-musl.html"><strong aria-hidden="true">15.57.</strong> riscv64gc-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/s390x-unknown-linux-gnu.html"><strong aria-hidden="true">15.58.</strong> s390x-unknown-linux-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/s390x-unknown-linux-musl.html"><strong aria-hidden="true">15.59.</strong> s390x-unknown-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/sparc-unknown-none-elf.html"><strong aria-hidden="true">15.60.</strong> sparc-unknown-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/solaris.html"><strong aria-hidden="true">15.61.</strong> solaris</a></li><li class="chapter-item expanded "><a href="platform-support/nto-qnx.html"><strong aria-hidden="true">15.62.</strong> *-nto-qnx-*</a></li><li class="chapter-item expanded "><a href="platform-support/unikraft-linux-musl.html"><strong aria-hidden="true">15.63.</strong> *-unikraft-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/hermit.html"><strong aria-hidden="true">15.64.</strong> *-unknown-hermit</a></li><li class="chapter-item expanded "><a href="platform-support/freebsd.html"><strong aria-hidden="true">15.65.</strong> *-unknown-freebsd</a></li><li class="chapter-item expanded "><a href="platform-support/netbsd.html"><strong aria-hidden="true">15.66.</strong> *-unknown-netbsd*</a></li><li class="chapter-item expanded "><a href="platform-support/openbsd.html"><strong aria-hidden="true">15.67.</strong> *-unknown-openbsd</a></li><li class="chapter-item expanded "><a href="platform-support/redox.html"><strong aria-hidden="true">15.68.</strong> *-unknown-redox</a></li><li class="chapter-item expanded "><a href="platform-support/unknown-uefi.html"><strong aria-hidden="true">15.69.</strong> *-unknown-uefi</a></li><li class="chapter-item expanded "><a href="platform-support/windows-msvc.html"><strong aria-hidden="true">15.70.</strong> *-unknown-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/uwp-windows-msvc.html"><strong aria-hidden="true">15.71.</strong> *-uwp-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/vxworks.html"><strong aria-hidden="true">15.72.</strong> *-wrs-vxworks</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip1.html"><strong aria-hidden="true">15.73.</strong> wasm32-wasip1</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip1-threads.html"><strong aria-hidden="true">15.74.</strong> wasm32-wasip1-threads</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wasip2.html"><strong aria-hidden="true">15.75.</strong> wasm32-wasip2</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-wali-linux.html"><strong aria-hidden="true">15.76.</strong> wasm32-wali-linux-musl</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-unknown-emscripten.html"><strong aria-hidden="true">15.77.</strong> wasm32-unknown-emscripten</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32-unknown-unknown.html"><strong aria-hidden="true">15.78.</strong> wasm32-unknown-unknown</a></li><li class="chapter-item expanded "><a href="platform-support/wasm32v1-none.html"><strong aria-hidden="true">15.79.</strong> wasm32v1-none</a></li><li class="chapter-item expanded "><a href="platform-support/wasm64-unknown-unknown.html"><strong aria-hidden="true">15.80.</strong> wasm64-unknown-unknown</a></li><li class="chapter-item expanded "><a href="platform-support/windows-gnu.html"><strong aria-hidden="true">15.81.</strong> windows-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/windows-gnullvm.html"><strong aria-hidden="true">15.82.</strong> windows-gnullvm</a></li><li class="chapter-item expanded "><a href="platform-support/win7-windows-gnu.html"><strong aria-hidden="true">15.83.</strong> *-win7-windows-gnu</a></li><li class="chapter-item expanded "><a href="platform-support/win7-windows-msvc.html"><strong aria-hidden="true">15.84.</strong> *-win7-windows-msvc</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-fortanix-unknown-sgx.html"><strong aria-hidden="true">15.85.</strong> x86_64-fortanix-unknown-sgx</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-pc-cygwin.html"><strong aria-hidden="true">15.86.</strong> x86_64-pc-cygwin</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-unknown-linux-none.html"><strong aria-hidden="true">15.87.</strong> x86_64-unknown-linux-none</a></li><li class="chapter-item expanded "><a href="platform-support/x86_64-unknown-none.html"><strong aria-hidden="true">15.88.</strong> x86_64-unknown-none</a></li><li class="chapter-item expanded "><a href="platform-support/xtensa.html"><strong aria-hidden="true">15.89.</strong> xtensa-*-none-elf</a></li><li class="chapter-item expanded "><a href="platform-support/nuttx.html"><strong aria-hidden="true">15.90.</strong> *-nuttx-*</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
