/*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of Optional Class Library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*/

#include "optclass_abi.hpp"
#include "optclass_interfaces.hpp"
#include "optclass_interfaceexception.hpp"
#include "optclass_interfacejournal.hpp"

#include <map>

using namespace OptClass::Impl;

POptClassInterfaceJournal m_GlobalJournal;

OptClassResult handleOptClassException(IBase * pIBaseClass, EOptClassInterfaceException & Exception, COptClassInterfaceJournalEntry * pJournalEntry = nullptr)
{
	OptClassResult errorCode = Exception.getErrorCode();

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

OptClassResult handleStdException(IBase * pIBaseClass, std::exception & Exception, COptClassInterfaceJournalEntry * pJournalEntry = nullptr)
{
	OptClassResult errorCode = OPTCLASS_ERROR_GENERICEXCEPTION;

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

OptClassResult handleUnhandledException(IBase * pIBaseClass, COptClassInterfaceJournalEntry * pJournalEntry = nullptr)
{
	OptClassResult errorCode = OPTCLASS_ERROR_GENERICEXCEPTION;

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage("Unhandled Exception");

	return errorCode;
}



/*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************/


/*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************/

OptClassResult _optclass_getprocaddress_internal(const char * pProcName, void ** ppProcAddress)
{
	static bool sbProcAddressMapHasBeenInitialized = false;
	static std::map<std::string, void*> sProcAddressMap;
	if (!sbProcAddressMapHasBeenInitialized) {
		sProcAddressMap["optclass_acquireinstance"] = (void*)&optclass_acquireinstance;
		sProcAddressMap["optclass_releaseinstance"] = (void*)&optclass_releaseinstance;
		sProcAddressMap["optclass_getversion"] = (void*)&optclass_getversion;
		sProcAddressMap["optclass_getlasterror"] = (void*)&optclass_getlasterror;
		sProcAddressMap["optclass_setjournal"] = (void*)&optclass_setjournal;
		sProcAddressMap["optclass_createinstancewithname"] = (void*)&optclass_createinstancewithname;
		sProcAddressMap["optclass_findinstancea"] = (void*)&optclass_findinstancea;
		sProcAddressMap["optclass_findinstanceb"] = (void*)&optclass_findinstanceb;
		sProcAddressMap["optclass_useinstancemaybe"] = (void*)&optclass_useinstancemaybe;
		
		sbProcAddressMapHasBeenInitialized = true;
	}
	if (pProcName == nullptr)
		return OPTCLASS_ERROR_INVALIDPARAM;
	if (ppProcAddress == nullptr)
		return OPTCLASS_ERROR_INVALIDPARAM;
	*ppProcAddress = nullptr;
	std::string sProcName (pProcName);
	
	auto procPair = sProcAddressMap.find(sProcName);
	if (procPair == sProcAddressMap.end()) {
		return OPTCLASS_ERROR_COULDNOTFINDLIBRARYEXPORT;
	}
	else {
		*ppProcAddress = procPair->second;
		return OPTCLASS_SUCCESS;
	}
	
}

/*************************************************************************************************************************
 Global functions implementation
**************************************************************************************************************************/
OptClassResult optclass_acquireinstance(OptClass_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("AcquireInstance");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDCAST);
		
		CWrapper::AcquireInstance(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_releaseinstance(OptClass_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("ReleaseInstance");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDCAST);
		
		CWrapper::ReleaseInstance(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_getversion(OptClass_uint32 * pMajor, OptClass_uint32 * pMinor, OptClass_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetVersion");
		}
		if (!pMajor)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		CWrapper::GetVersion(*pMajor, *pMinor, *pMicro);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Major", *pMajor);
			pJournalEntry->addUInt32Result("Minor", *pMinor);
			pJournalEntry->addUInt32Result("Micro", *pMicro);
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_getlasterror(OptClass_Base pInstance, const OptClass_uint32 nErrorMessageBufferSize, OptClass_uint32* pErrorMessageNeededChars, char * pErrorMessageBuffer, bool * pHasError)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetLastError");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		if ( (!pErrorMessageBuffer) && !(pErrorMessageNeededChars) )
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		if (pHasError == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDCAST);
		
		std::string sErrorMessage("");
		*pHasError = CWrapper::GetLastError(pIInstance, sErrorMessage);

		if (pErrorMessageNeededChars)
			*pErrorMessageNeededChars = (OptClass_uint32) (sErrorMessage.size()+1);
		if (pErrorMessageBuffer) {
			if (sErrorMessage.size() >= nErrorMessageBufferSize)
				throw EOptClassInterfaceException (OPTCLASS_ERROR_BUFFERTOOSMALL);
			for (size_t iErrorMessage = 0; iErrorMessage < sErrorMessage.size(); iErrorMessage++)
				pErrorMessageBuffer[iErrorMessage] = sErrorMessage[iErrorMessage];
			pErrorMessageBuffer[sErrorMessage.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ErrorMessage", sErrorMessage.c_str());
			pJournalEntry->addBooleanResult("HasError", *pHasError);
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_setjournal(const char * pFileName)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pFileName == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		std::string sFileName(pFileName);
		m_GlobalJournal = nullptr;
		if (sFileName != "") {
			m_GlobalJournal = std::make_shared<COptClassInterfaceJournal> (sFileName);
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

OptClassResult optclass_createinstancewithname(const char * pIdentifier)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("CreateInstanceWithName");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		CWrapper::CreateInstanceWithName(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_findinstancea(const char * pIdentifier, OptClass_Base * pInstance)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("FindInstanceA");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		if (pInstance == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseInstance(nullptr);
		pBaseInstance = CWrapper::FindInstanceA(sIdentifier);

		*pInstance = (IBase*)(pBaseInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Instance", *pInstance);
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_findinstanceb(const char * pIdentifier, OptClass_Base * pInstance)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("FindInstanceB");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		if (pInstance == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBase* pBaseInstance(nullptr);
		CWrapper::FindInstanceB(sIdentifier, pBaseInstance);

		*pInstance = (IBase*)(pBaseInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Instance", *pInstance);
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

OptClassResult optclass_useinstancemaybe(OptClass_Base pInstance, bool * pIsUsed)
{
	IBase* pIBaseClass = nullptr;

	POptClassInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("UseInstanceMaybe");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		if (pIsUsed == nullptr)
			throw EOptClassInterfaceException (OPTCLASS_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		*pIsUsed = CWrapper::UseInstanceMaybe(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsUsed", *pIsUsed);
			pJournalEntry->writeSuccess();
		}
		return OPTCLASS_SUCCESS;
	}
	catch (EOptClassInterfaceException & Exception) {
		return handleOptClassException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


