/*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++-Header file in order to allow an easy
 use of Optional Class Library

Interface version: 1.0.0

*/

#ifndef __OPTCLASS_CPPHEADER_IMPLICIT_CPP
#define __OPTCLASS_CPPHEADER_IMPLICIT_CPP

#include "optclass_types.hpp"
#include "optclass_abi.hpp"


#ifdef _WIN32
#include <windows.h>
#else // _WIN32
#include <dlfcn.h>
#endif // _WIN32
#include <string>
#include <memory>
#include <vector>
#include <exception>

namespace OptClass {

/*************************************************************************************************************************
 Forward Declaration of all classes
**************************************************************************************************************************/
class CWrapper;
class CBase;

/*************************************************************************************************************************
 Declaration of deprecated class types
**************************************************************************************************************************/
typedef CWrapper COptClassWrapper;
typedef CBase COptClassBase;

/*************************************************************************************************************************
 Declaration of shared pointer types
**************************************************************************************************************************/
typedef std::shared_ptr<CWrapper> PWrapper;
typedef std::shared_ptr<CBase> PBase;

/*************************************************************************************************************************
 Declaration of deprecated shared pointer types
**************************************************************************************************************************/
typedef PWrapper POptClassWrapper;
typedef PBase POptClassBase;


/*************************************************************************************************************************
 Class EOptClassException 
**************************************************************************************************************************/
class EOptClassException : public std::exception {
protected:
	/**
	* Error code for the Exception.
	*/
	OptClassResult m_errorCode;
	/**
	* Error message for the Exception.
	*/
	std::string m_errorMessage;

public:
	/**
	* Exception Constructor.
	*/
	EOptClassException(OptClassResult errorCode, const std::string & sErrorMessage)
		: m_errorMessage("OptClass Error " + std::to_string(errorCode) + " (" + sErrorMessage + ")")
	{
		m_errorCode = errorCode;
	}

	/**
	* Returns error code
	*/
	OptClassResult getErrorCode() const noexcept
	{
		return m_errorCode;
	}

	/**
	* Returns error message
	*/
	const char* what() const noexcept
	{
		return m_errorMessage.c_str();
	}

};

/*************************************************************************************************************************
 Class CInputVector
**************************************************************************************************************************/
template <typename T>
class CInputVector {
private:
	
	const T* m_data;
	size_t m_size;
	
public:
	
	CInputVector( const std::vector<T>& vec)
		: m_data( vec.data() ), m_size( vec.size() )
	{
	}
	
	CInputVector( const T* in_data, size_t in_size)
		: m_data( in_data ), m_size(in_size )
	{
	}
	
	const T* data() const
	{
		return m_data;
	}
	
	size_t size() const
	{
		return m_size;
	}
	
};

// declare deprecated class name
template<typename T>
using COptClassInputVector = CInputVector<T>;

/*************************************************************************************************************************
 Class CWrapper 
**************************************************************************************************************************/
class CWrapper {
public:
	
	CWrapper()
	{
	}
	
	~CWrapper()
	{
	}
	static inline PWrapper loadLibrary()
	{
		return std::make_shared<CWrapper>();
	}
	
	inline void CheckError(CBase * pBaseClass, OptClassResult nResult);

	inline void AcquireInstance(CBase * pInstance);
	inline void ReleaseInstance(CBase * pInstance);
	inline void GetVersion(OptClass_uint32 & nMajor, OptClass_uint32 & nMinor, OptClass_uint32 & nMicro);
	inline bool GetLastError(CBase * pInstance, std::string & sErrorMessage);
	inline void SetJournal(const std::string & sFileName);
	inline void CreateInstanceWithName(const std::string & sIdentifier);
	inline PBase FindInstanceA(const std::string & sIdentifier);
	inline void FindInstanceB(const std::string & sIdentifier, PBase & pInstance);
	inline bool UseInstanceMaybe(CBase * pInstance);

private:
	
	OptClassResult checkBinaryVersion()
	{
		OptClass_uint32 nMajor, nMinor, nMicro;
		GetVersion(nMajor, nMinor, nMicro);
		if ( (nMajor != OPTCLASS_VERSION_MAJOR) || (nMinor < OPTCLASS_VERSION_MINOR) ) {
			return OPTCLASS_ERROR_INCOMPATIBLEBINARYVERSION;
		}
		return OPTCLASS_SUCCESS;
	}

	friend class CBase;

};

	
/*************************************************************************************************************************
 Class CBase 
**************************************************************************************************************************/
class CBase {
public:
	
protected:
	/* Wrapper Object that created the class. */
	CWrapper * m_pWrapper;
	/* Handle to Instance in library*/
	OptClassHandle m_pHandle;

	/* Checks for an Error code and raises Exceptions */
	void CheckError(OptClassResult nResult)
	{
		if (m_pWrapper != nullptr)
			m_pWrapper->CheckError(this, nResult);
	}
public:
	/**
	* CBase::CBase - Constructor for Base class.
	*/
	CBase(CWrapper * pWrapper, OptClassHandle pHandle)
		: m_pWrapper(pWrapper), m_pHandle(pHandle)
	{
	}

	/**
	* CBase::~CBase - Destructor for Base class.
	*/
	virtual ~CBase()
	{
		if (m_pWrapper != nullptr)
			m_pWrapper->ReleaseInstance(this);
		m_pWrapper = nullptr;
	}

	/**
	* CBase::GetHandle - Returns handle to instance.
	*/
	OptClassHandle GetHandle()
	{
		return m_pHandle;
	}
	
	friend class CWrapper;
};
	
	/**
	* CWrapper::AcquireInstance - Acquire shared ownership of an Instance
	* @param[in] pInstance - Instance Handle
	*/
	inline void CWrapper::AcquireInstance(CBase * pInstance)
	{
		OptClassHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		CheckError(nullptr,optclass_acquireinstance(hInstance));
	}
	
	/**
	* CWrapper::ReleaseInstance - Releases shared ownership of an Instance
	* @param[in] pInstance - Instance Handle
	*/
	inline void CWrapper::ReleaseInstance(CBase * pInstance)
	{
		OptClassHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		CheckError(nullptr,optclass_releaseinstance(hInstance));
	}
	
	/**
	* CWrapper::GetVersion - retrieves the binary version of this library.
	* @param[out] nMajor - returns the major version of this library
	* @param[out] nMinor - returns the minor version of this library
	* @param[out] nMicro - returns the micro version of this library
	*/
	inline void CWrapper::GetVersion(OptClass_uint32 & nMajor, OptClass_uint32 & nMinor, OptClass_uint32 & nMicro)
	{
		CheckError(nullptr,optclass_getversion(&nMajor, &nMinor, &nMicro));
	}
	
	/**
	* CWrapper::GetLastError - Returns the last error recorded on this object
	* @param[in] pInstance - Instance Handle
	* @param[out] sErrorMessage - Message of the last error
	* @return Is there a last error to query
	*/
	inline bool CWrapper::GetLastError(CBase * pInstance, std::string & sErrorMessage)
	{
		OptClassHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		OptClass_uint32 bytesNeededErrorMessage = 0;
		OptClass_uint32 bytesWrittenErrorMessage = 0;
		bool resultHasError = 0;
		CheckError(nullptr,optclass_getlasterror(hInstance, 0, &bytesNeededErrorMessage, nullptr, &resultHasError));
		std::vector<char> bufferErrorMessage(bytesNeededErrorMessage);
		CheckError(nullptr,optclass_getlasterror(hInstance, bytesNeededErrorMessage, &bytesWrittenErrorMessage, &bufferErrorMessage[0], &resultHasError));
		sErrorMessage = std::string(&bufferErrorMessage[0]);
		
		return resultHasError;
	}
	
	/**
	* CWrapper::SetJournal - Handles Library Journaling
	* @param[in] sFileName - Journal FileName
	*/
	inline void CWrapper::SetJournal(const std::string & sFileName)
	{
		CheckError(nullptr,optclass_setjournal(sFileName.c_str()));
	}
	
	/**
	* CWrapper::CreateInstanceWithName - Creates an instance of Base class with a given identifier (but does not return it)
	* @param[in] sIdentifier - Identifier of the new instance
	*/
	inline void CWrapper::CreateInstanceWithName(const std::string & sIdentifier)
	{
		CheckError(nullptr,optclass_createinstancewithname(sIdentifier.c_str()));
	}
	
	/**
	* CWrapper::FindInstanceA - Finds a Base class instance by Identifier
	* @param[in] sIdentifier - Identifier of the tnstance to query
	* @return Base class instance
	*/
	inline PBase CWrapper::FindInstanceA(const std::string & sIdentifier)
	{
		OptClassHandle hInstance = nullptr;
		CheckError(nullptr,optclass_findinstancea(sIdentifier.c_str(), &hInstance));
		
		if (hInstance) {
			return std::make_shared<CBase>(this, hInstance);
		} else {
			return nullptr;
		}
	}
	
	/**
	* CWrapper::FindInstanceB - Finds a Base class instance by Identifier
	* @param[in] sIdentifier - Identifier of the tnstance to query
	* @param[out] pInstance - Base class instance
	*/
	inline void CWrapper::FindInstanceB(const std::string & sIdentifier, PBase & pInstance)
	{
		OptClassHandle hInstance = nullptr;
		CheckError(nullptr,optclass_findinstanceb(sIdentifier.c_str(), &hInstance));
		if (hInstance) {
			pInstance = std::make_shared<CBase>(this, hInstance);
		} else {
			pInstance = nullptr;
		}
	}
	
	/**
	* CWrapper::UseInstanceMaybe - Uses a Base class instance
	* @param[in] pInstance - Base class instance
	* @return Was the Instance used?
	*/
	inline bool CWrapper::UseInstanceMaybe(CBase * pInstance)
	{
		OptClassHandle hInstance = nullptr;
		if (pInstance != nullptr) {
			hInstance = pInstance->GetHandle();
		};
		bool resultIsUsed = 0;
		CheckError(nullptr,optclass_useinstancemaybe(hInstance, &resultIsUsed));
		
		return resultIsUsed;
	}
	
	inline void CWrapper::CheckError(CBase * pBaseClass, OptClassResult nResult)
	{
		if (nResult != 0) {
			std::string sErrorMessage;
			if (pBaseClass != nullptr) {
				GetLastError(pBaseClass, sErrorMessage);
			}
			throw EOptClassException(nResult, sErrorMessage);
		}
	}
	

	
	/**
	 * Method definitions for class CBase
	 */

} // namespace OptClass

#endif // __OPTCLASS_CPPHEADER_IMPLICIT_CPP

