'''++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Python application that demonstrates the
 usage of the Python bindings of Calculation library

Interface version: 1.0.0

'''


import os
import sys
sys.path.append(os.path.join(os.path.dirname(os.path.realpath(__file__)), "..", "..", "Bindings", "Python"))
import Calculation


def main():
	libpath = '' # TODO add the location of the shared library binary here
	wrapper = Calculation.Wrapper(libraryName = os.path.join(libpath, "calculation"))
	
	major, minor, micro = wrapper.GetVersion()
	print("Calculation version: {:d}.{:d}.{:d}".format(major, minor, micro), end="")
	print("")

	libpath = '' # TODO add the location of the shared library binary here
	numbers = Calculation.Numbers.Wrapper(os.path.join(libpath, "numbers"))
	major, minor, micro = numbers.GetVersion()
	print("Numbers version: {:d}.{:d}.{:d}".format(major, minor, micro), end="")
	print("")

	wrapper.InjectComponent("Numbers", numbers.GetSymbolLookupMethod())

	calculator = wrapper.CreateCalculator()
	calculator.EnlistVariable(numbers.CreateVariable(10.0))
	calculator.EnlistVariable(numbers.CreateVariable(5.0))
	print("   sum="+str(calculator.Add().GetValue()))
	calculator.GetEnlistedVariable(1).SetValue(15.0)
	print("newSum="+str(calculator.Add().GetValue()))

if __name__ == "__main__":
	try:
		main()
	except Calculation.ECalculationException as e:
		print(e)
