(*++

Copyright (C) 2019 Calculator developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal implementation file in order to allow easy
development of Calculator library. It needs to be generated only once.

Interface version: 1.0.0

*)

{$MODE DELPHI}
Unit calculator_impl;

interface

uses
  calculator_types,
  calculator_exception,
  calculator_interfaces,
  calculator_impl_variable,
  calculator_impl_calculator,
  Classes,
  sysutils;

type
  TCalculatorWrapper = class (TObject)
    public
      class procedure GetVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
      class function GetLastError(AInstance: TObject; out AErrorMessage: String): Boolean;
      class procedure ReleaseInstance(AInstance: TObject);
      class procedure AcquireInstance(AInstance: TObject);
      class function CreateVariable(const AInitialValue: Double): TObject;
      class function CreateCalculator(): TObject;
  end;


implementation

class procedure TCalculatorWrapper.GetVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
begin
  AMajor := CALCULATOR_VERSION_MAJOR;
  AMinor := CALCULATOR_VERSION_MINOR;
  AMicro := CALCULATOR_VERSION_MICRO;
end;

class function TCalculatorWrapper.GetLastError(AInstance: TObject; out AErrorMessage: String): Boolean;
begin
  result := (AInstance as ICalculatorBase).GetLastErrorMessage(AErrorMessage);
end;

class procedure TCalculatorWrapper.ReleaseInstance(AInstance: TObject);
begin
  (AInstance as ICalculatorBase).DecRefCount();
end;

class procedure TCalculatorWrapper.AcquireInstance(AInstance: TObject);
begin
  (AInstance as ICalculatorBase).IncRefCount();
end;

class function TCalculatorWrapper.CreateVariable(const AInitialValue: Double): TObject;
begin
  result := TCalculatorVariable.Create();
  (result as TCalculatorVariable).SetValue(AInitialValue);
end;

class function TCalculatorWrapper.CreateCalculator(): TObject;
begin
  result := TCalculatorCalculator.Create();
end;


end.
