package testdata

import "time"

var RaftV055 = []SerializeTest{
	{"AppendEntriesRequest", "89a441646472a7636172746d616ea7456e74726965739186aa417070656e6465644174af01000000000000000000000000ffffa444617461c0aa457874656e73696f6e73c0a5496e64657865a45465726d04a45479706501a24944c0a64c6561646572c0b14c6561646572436f6d6d6974496e6465785aac507265764c6f67456e74727964ab507265764c6f675465726d04af50726f746f636f6c56657273696f6e00a45465726d0a", AppendEntriesRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}}, Term: 0xa, Leader: []uint8(nil), PrevLogEntry: 0x64, PrevLogTerm: 0x4, Entries: []*Log{{Index: 0x65, Term: 0x4, Type: 0x1, Data: []uint8(nil), Extensions: []uint8(nil), AppendedAt: time.Date(1, time.January, 1, 0, 0, 0, 0, time.UTC)}}, LeaderCommitIndex: 0x5a}},
	{"AppendEntriesRequest", "89a441646472a7636172746d616ea7456e7472696573c0a24944c0a64c6561646572a7636172746d616eb14c6561646572436f6d6d6974496e64657800ac507265764c6f67456e74727900ab507265764c6f675465726d00af50726f746f636f6c56657273696f6e03a45465726d0a", AppendEntriesRequest{RPCHeader: RPCHeader{ProtocolVersion: 3, ID: []uint8(nil), Addr: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}}, Term: 0xa, Leader: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}, PrevLogEntry: 0x0, PrevLogTerm: 0x0, Entries: []*Log(nil), LeaderCommitIndex: 0x0}},
	{"AppendEntriesResponse", "87a441646472c0a24944c0a74c6173744c6f675aae4e6f52657472794261636b6f6666c2af50726f746f636f6c56657273696f6e00a753756363657373c3a45465726d04", AppendEntriesResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0x4, LastLog: 0x5a, Success: true, NoRetryBackoff: false}},
	{"InstallSnapshotRequest", "8ca441646472a46b796c65ad436f6e66696775726174696f6ec0b2436f6e66696775726174696f6e496e64657800a24944c0ac4c6173744c6f67496e64657864ab4c6173744c6f675465726d09a64c6561646572c0a55065657273a9626c616820626c6168af50726f746f636f6c56657273696f6e00a453697a650aaf536e617073686f7456657273696f6e00a45465726d0a", InstallSnapshotRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x6b, 0x79, 0x6c, 0x65}}, SnapshotVersion: 0, Term: 0xa, Leader: []uint8(nil), LastLogIndex: 0x64, LastLogTerm: 0x9, Peers: []uint8{0x62, 0x6c, 0x61, 0x68, 0x20, 0x62, 0x6c, 0x61, 0x68}, Configuration: []uint8(nil), ConfigurationIndex: 0x0, Size: 10}},
	{"InstallSnapshotResponse", "85a441646472c0a24944c0af50726f746f636f6c56657273696f6e00a753756363657373c3a45465726d0a", InstallSnapshotResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0xa, Success: true}},
	{"RequestVoteRequest", "88a441646472a762757474657273a943616e646964617465c0a24944c0ac4c6173744c6f67496e64657864ab4c6173744c6f675465726d13b24c6561646572736869705472616e73666572c2af50726f746f636f6c56657273696f6e00a45465726d14", RequestVoteRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x62, 0x75, 0x74, 0x74, 0x65, 0x72, 0x73}}, Term: 0x14, Candidate: []uint8(nil), LastLogIndex: 0x64, LastLogTerm: 0x13, LeadershipTransfer: false}},
	{"RequestVoteResponse", "86a441646472c0a74772616e746564c2a24944c0a55065657273c0af50726f746f636f6c56657273696f6e00a45465726d64", RequestVoteResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0x64, Peers: []uint8(nil), Granted: false}},
	{"[][]uint8", "91a96f7665722068657265", [][]uint8{{0x6f, 0x76, 0x65, 0x72, 0x20, 0x68, 0x65, 0x72, 0x65}}},
	{"[][]uint8", "91da002430383530383039372d366262642d643738652d323636362d353238363631336630623963", [][]uint8{{0x30, 0x38, 0x35, 0x30, 0x38, 0x30, 0x39, 0x37, 0x2d, 0x36, 0x62, 0x62, 0x64, 0x2d, 0x64, 0x37, 0x38, 0x65, 0x2d, 0x32, 0x36, 0x36, 0x36, 0x2d, 0x35, 0x32, 0x38, 0x36, 0x36, 0x31, 0x33, 0x66, 0x30, 0x62, 0x39, 0x63}}},
	{"[][]uint8", "91da002435633965303837302d663434302d626536352d646135632d346630306663353332353436", [][]uint8{{0x35, 0x63, 0x39, 0x65, 0x30, 0x38, 0x37, 0x30, 0x2d, 0x66, 0x34, 0x34, 0x30, 0x2d, 0x62, 0x65, 0x36, 0x35, 0x2d, 0x64, 0x61, 0x35, 0x63, 0x2d, 0x34, 0x66, 0x30, 0x30, 0x66, 0x63, 0x35, 0x33, 0x32, 0x35, 0x34, 0x36}}},
	{"[][]uint8", "91da002439303965343361612d666531302d653361622d353330342d343961396364643437653637", [][]uint8{{0x39, 0x30, 0x39, 0x65, 0x34, 0x33, 0x61, 0x61, 0x2d, 0x66, 0x65, 0x31, 0x30, 0x2d, 0x65, 0x33, 0x61, 0x62, 0x2d, 0x35, 0x33, 0x30, 0x34, 0x2d, 0x34, 0x39, 0x61, 0x39, 0x63, 0x64, 0x64, 0x34, 0x37, 0x65, 0x36, 0x37}}},
	{"[][]uint8", "91da002461356630613931342d313738322d303833332d333061382d383463376237313463363135", [][]uint8{{0x61, 0x35, 0x66, 0x30, 0x61, 0x39, 0x31, 0x34, 0x2d, 0x31, 0x37, 0x38, 0x32, 0x2d, 0x30, 0x38, 0x33, 0x33, 0x2d, 0x33, 0x30, 0x61, 0x38, 0x2d, 0x38, 0x34, 0x63, 0x37, 0x62, 0x37, 0x31, 0x34, 0x63, 0x36, 0x31, 0x35}}},
	{"[][]uint8", "91da002464643933303433322d653065302d336338342d666666392d366662613136303337376464", [][]uint8{{0x64, 0x64, 0x39, 0x33, 0x30, 0x34, 0x33, 0x32, 0x2d, 0x65, 0x30, 0x65, 0x30, 0x2d, 0x33, 0x63, 0x38, 0x34, 0x2d, 0x66, 0x66, 0x66, 0x39, 0x2d, 0x36, 0x66, 0x62, 0x61, 0x31, 0x36, 0x30, 0x33, 0x37, 0x37, 0x64, 0x64}}},
	{"[][]uint8", "92da002439323032343438612d303839362d613536322d326537332d396535633063336464373536da002461386361396133642d396562372d663264312d306162662d363635346630336264663534", [][]uint8{{0x39, 0x32, 0x30, 0x32, 0x34, 0x34, 0x38, 0x61, 0x2d, 0x30, 0x38, 0x39, 0x36, 0x2d, 0x61, 0x35, 0x36, 0x32, 0x2d, 0x32, 0x65, 0x37, 0x33, 0x2d, 0x39, 0x65, 0x35, 0x63, 0x30, 0x63, 0x33, 0x64, 0x64, 0x37, 0x35, 0x36}, {0x61, 0x38, 0x63, 0x61, 0x39, 0x61, 0x33, 0x64, 0x2d, 0x39, 0x65, 0x62, 0x37, 0x2d, 0x66, 0x32, 0x64, 0x31, 0x2d, 0x30, 0x61, 0x62, 0x66, 0x2d, 0x36, 0x36, 0x35, 0x34, 0x66, 0x30, 0x33, 0x62, 0x64, 0x66, 0x35, 0x34}}},
	{"[][]uint8", "92da002465626237363962332d386561392d313733322d653531332d653166313636303639663736da002437663666303034622d613162322d636536632d333030382d343935326432663565343930", [][]uint8{{0x65, 0x62, 0x62, 0x37, 0x36, 0x39, 0x62, 0x33, 0x2d, 0x38, 0x65, 0x61, 0x39, 0x2d, 0x31, 0x37, 0x33, 0x32, 0x2d, 0x65, 0x35, 0x31, 0x33, 0x2d, 0x65, 0x31, 0x66, 0x31, 0x36, 0x36, 0x30, 0x36, 0x39, 0x66, 0x37, 0x36}, {0x37, 0x66, 0x36, 0x66, 0x30, 0x30, 0x34, 0x62, 0x2d, 0x61, 0x31, 0x62, 0x32, 0x2d, 0x63, 0x65, 0x36, 0x63, 0x2d, 0x33, 0x30, 0x30, 0x38, 0x2d, 0x34, 0x39, 0x35, 0x32, 0x64, 0x32, 0x66, 0x35, 0x65, 0x34, 0x39, 0x30}}},
	{"[][]uint8", "93da002433616432323363332d613939612d623864372d313961362d643565376339346162636639da002464353239633464612d663839362d363663362d663566612d666335656563323336366465da002436626338373062362d363061662d393161642d336331392d373964323364363462323331", [][]uint8{{0x33, 0x61, 0x64, 0x32, 0x32, 0x33, 0x63, 0x33, 0x2d, 0x61, 0x39, 0x39, 0x61, 0x2d, 0x62, 0x38, 0x64, 0x37, 0x2d, 0x31, 0x39, 0x61, 0x36, 0x2d, 0x64, 0x35, 0x65, 0x37, 0x63, 0x39, 0x34, 0x61, 0x62, 0x63, 0x66, 0x39}, {0x64, 0x35, 0x32, 0x39, 0x63, 0x34, 0x64, 0x61, 0x2d, 0x66, 0x38, 0x39, 0x36, 0x2d, 0x36, 0x36, 0x63, 0x36, 0x2d, 0x66, 0x35, 0x66, 0x61, 0x2d, 0x66, 0x63, 0x35, 0x65, 0x65, 0x63, 0x32, 0x33, 0x36, 0x36, 0x64, 0x65}, {0x36, 0x62, 0x63, 0x38, 0x37, 0x30, 0x62, 0x36, 0x2d, 0x36, 0x30, 0x61, 0x66, 0x2d, 0x39, 0x31, 0x61, 0x64, 0x2d, 0x33, 0x63, 0x31, 0x39, 0x2d, 0x37, 0x39, 0x64, 0x32, 0x33, 0x64, 0x36, 0x34, 0x62, 0x32, 0x33, 0x31}}},
	{"[][]uint8", "93da002434373238313866322d656430392d316431652d323435342d323865333036343061383732da002464623337313138392d366235312d306563612d333432332d646233353538623039323466da002433633835373330302d646162332d306133322d653664662d386364343033653535383737", [][]uint8{{0x34, 0x37, 0x32, 0x38, 0x31, 0x38, 0x66, 0x32, 0x2d, 0x65, 0x64, 0x30, 0x39, 0x2d, 0x31, 0x64, 0x31, 0x65, 0x2d, 0x32, 0x34, 0x35, 0x34, 0x2d, 0x32, 0x38, 0x65, 0x33, 0x30, 0x36, 0x34, 0x30, 0x61, 0x38, 0x37, 0x32}, {0x64, 0x62, 0x33, 0x37, 0x31, 0x31, 0x38, 0x39, 0x2d, 0x36, 0x62, 0x35, 0x31, 0x2d, 0x30, 0x65, 0x63, 0x61, 0x2d, 0x33, 0x34, 0x32, 0x33, 0x2d, 0x64, 0x62, 0x33, 0x35, 0x35, 0x38, 0x62, 0x30, 0x39, 0x32, 0x34, 0x66}, {0x33, 0x63, 0x38, 0x35, 0x37, 0x33, 0x30, 0x30, 0x2d, 0x64, 0x61, 0x62, 0x33, 0x2d, 0x30, 0x61, 0x33, 0x32, 0x2d, 0x65, 0x36, 0x64, 0x66, 0x2d, 0x38, 0x63, 0x64, 0x34, 0x30, 0x33, 0x65, 0x35, 0x35, 0x38, 0x37, 0x37}}},
	{"[][]uint8", "93da002436316536386662332d366437362d333264612d386364382d316530376238653334383733da002431346463383131342d333039632d346366642d643961312d323166366538653066643561da002462663966333364652d333163322d343763622d636633332d663831656539623532393434", [][]uint8{{0x36, 0x31, 0x65, 0x36, 0x38, 0x66, 0x62, 0x33, 0x2d, 0x36, 0x64, 0x37, 0x36, 0x2d, 0x33, 0x32, 0x64, 0x61, 0x2d, 0x38, 0x63, 0x64, 0x38, 0x2d, 0x31, 0x65, 0x30, 0x37, 0x62, 0x38, 0x65, 0x33, 0x34, 0x38, 0x37, 0x33}, {0x31, 0x34, 0x64, 0x63, 0x38, 0x31, 0x31, 0x34, 0x2d, 0x33, 0x30, 0x39, 0x63, 0x2d, 0x34, 0x63, 0x66, 0x64, 0x2d, 0x64, 0x39, 0x61, 0x31, 0x2d, 0x32, 0x31, 0x66, 0x36, 0x65, 0x38, 0x65, 0x30, 0x66, 0x64, 0x35, 0x61}, {0x62, 0x66, 0x39, 0x66, 0x33, 0x33, 0x64, 0x65, 0x2d, 0x33, 0x31, 0x63, 0x32, 0x2d, 0x34, 0x37, 0x63, 0x62, 0x2d, 0x63, 0x66, 0x33, 0x33, 0x2d, 0x66, 0x38, 0x31, 0x65, 0x65, 0x39, 0x62, 0x35, 0x32, 0x39, 0x34, 0x34}}},
	{"[][]uint8", "93da002436326131666466642d303136342d363062372d373035612d666134656462383364653731da002465363764306361332d333265612d383933312d633431302d663932356630646362323163da002462393332623038382d326462312d653561632d663137622d323762623561623934623236", [][]uint8{{0x36, 0x32, 0x61, 0x31, 0x66, 0x64, 0x66, 0x64, 0x2d, 0x30, 0x31, 0x36, 0x34, 0x2d, 0x36, 0x30, 0x62, 0x37, 0x2d, 0x37, 0x30, 0x35, 0x61, 0x2d, 0x66, 0x61, 0x34, 0x65, 0x64, 0x62, 0x38, 0x33, 0x64, 0x65, 0x37, 0x31}, {0x65, 0x36, 0x37, 0x64, 0x30, 0x63, 0x61, 0x33, 0x2d, 0x33, 0x32, 0x65, 0x61, 0x2d, 0x38, 0x39, 0x33, 0x31, 0x2d, 0x63, 0x34, 0x31, 0x30, 0x2d, 0x66, 0x39, 0x32, 0x35, 0x66, 0x30, 0x64, 0x63, 0x62, 0x32, 0x31, 0x63}, {0x62, 0x39, 0x33, 0x32, 0x62, 0x30, 0x38, 0x38, 0x2d, 0x32, 0x64, 0x62, 0x31, 0x2d, 0x65, 0x35, 0x61, 0x63, 0x2d, 0x66, 0x31, 0x37, 0x62, 0x2d, 0x32, 0x37, 0x62, 0x62, 0x35, 0x61, 0x62, 0x39, 0x34, 0x62, 0x32, 0x36}}},
	{"[][]uint8", "93da002436393238393739632d353635662d393439302d356562622d376664396461393763393931da002432616365343833632d626363662d376364302d346338632d653961666666326236333237da002435623638646239372d393534612d373061392d333732382d613464343132353937343132", [][]uint8{{0x36, 0x39, 0x32, 0x38, 0x39, 0x37, 0x39, 0x63, 0x2d, 0x35, 0x36, 0x35, 0x66, 0x2d, 0x39, 0x34, 0x39, 0x30, 0x2d, 0x35, 0x65, 0x62, 0x62, 0x2d, 0x37, 0x66, 0x64, 0x39, 0x64, 0x61, 0x39, 0x37, 0x63, 0x39, 0x39, 0x31}, {0x32, 0x61, 0x63, 0x65, 0x34, 0x38, 0x33, 0x63, 0x2d, 0x62, 0x63, 0x63, 0x66, 0x2d, 0x37, 0x63, 0x64, 0x30, 0x2d, 0x34, 0x63, 0x38, 0x63, 0x2d, 0x65, 0x39, 0x61, 0x66, 0x66, 0x66, 0x32, 0x62, 0x36, 0x33, 0x32, 0x37}, {0x35, 0x62, 0x36, 0x38, 0x64, 0x62, 0x39, 0x37, 0x2d, 0x39, 0x35, 0x34, 0x61, 0x2d, 0x37, 0x30, 0x61, 0x39, 0x2d, 0x33, 0x37, 0x32, 0x38, 0x2d, 0x61, 0x34, 0x64, 0x34, 0x31, 0x32, 0x35, 0x39, 0x37, 0x34, 0x31, 0x32}}},
	{"[][]uint8", "93da002437326432383133662d343562622d326462342d323439302d336566353762656462633034da002461653338306639352d373034612d616564382d323762652d323530396231643261373762da002435643034303663612d343130342d653938332d366437332d333732313364396263326362", [][]uint8{{0x37, 0x32, 0x64, 0x32, 0x38, 0x31, 0x33, 0x66, 0x2d, 0x34, 0x35, 0x62, 0x62, 0x2d, 0x32, 0x64, 0x62, 0x34, 0x2d, 0x32, 0x34, 0x39, 0x30, 0x2d, 0x33, 0x65, 0x66, 0x35, 0x37, 0x62, 0x65, 0x64, 0x62, 0x63, 0x30, 0x34}, {0x61, 0x65, 0x33, 0x38, 0x30, 0x66, 0x39, 0x35, 0x2d, 0x37, 0x30, 0x34, 0x61, 0x2d, 0x61, 0x65, 0x64, 0x38, 0x2d, 0x32, 0x37, 0x62, 0x65, 0x2d, 0x32, 0x35, 0x30, 0x39, 0x62, 0x31, 0x64, 0x32, 0x61, 0x37, 0x37, 0x62}, {0x35, 0x64, 0x30, 0x34, 0x30, 0x36, 0x63, 0x61, 0x2d, 0x34, 0x31, 0x30, 0x34, 0x2d, 0x65, 0x39, 0x38, 0x33, 0x2d, 0x36, 0x64, 0x37, 0x33, 0x2d, 0x33, 0x37, 0x32, 0x31, 0x33, 0x64, 0x39, 0x62, 0x63, 0x32, 0x63, 0x62}}},
	{"[][]uint8", "93da002437373235333334382d613338362d313231362d326664622d303834663330313934623364da002430636135663565622d613137352d613735382d383266392d613163656439326339646137da002463376664623833302d323837362d653230382d303031332d633364303635646333643635", [][]uint8{{0x37, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x38, 0x2d, 0x61, 0x33, 0x38, 0x36, 0x2d, 0x31, 0x32, 0x31, 0x36, 0x2d, 0x32, 0x66, 0x64, 0x62, 0x2d, 0x30, 0x38, 0x34, 0x66, 0x33, 0x30, 0x31, 0x39, 0x34, 0x62, 0x33, 0x64}, {0x30, 0x63, 0x61, 0x35, 0x66, 0x35, 0x65, 0x62, 0x2d, 0x61, 0x31, 0x37, 0x35, 0x2d, 0x61, 0x37, 0x35, 0x38, 0x2d, 0x38, 0x32, 0x66, 0x39, 0x2d, 0x61, 0x31, 0x63, 0x65, 0x64, 0x39, 0x32, 0x63, 0x39, 0x64, 0x61, 0x37}, {0x63, 0x37, 0x66, 0x64, 0x62, 0x38, 0x33, 0x30, 0x2d, 0x32, 0x38, 0x37, 0x36, 0x2d, 0x65, 0x32, 0x30, 0x38, 0x2d, 0x30, 0x30, 0x31, 0x33, 0x2d, 0x63, 0x33, 0x64, 0x30, 0x36, 0x35, 0x64, 0x63, 0x33, 0x64, 0x36, 0x35}}},
	{"[][]uint8", "93da002437383138346662302d343937372d613163382d646637302d363634313663333564343662da002432623531323730622d653066632d616337312d303163302d313837323264356137396639da002434646537616438372d633235332d663036342d303535642d373466303330396531353663", [][]uint8{{0x37, 0x38, 0x31, 0x38, 0x34, 0x66, 0x62, 0x30, 0x2d, 0x34, 0x39, 0x37, 0x37, 0x2d, 0x61, 0x31, 0x63, 0x38, 0x2d, 0x64, 0x66, 0x37, 0x30, 0x2d, 0x36, 0x36, 0x34, 0x31, 0x36, 0x63, 0x33, 0x35, 0x64, 0x34, 0x36, 0x62}, {0x32, 0x62, 0x35, 0x31, 0x32, 0x37, 0x30, 0x62, 0x2d, 0x65, 0x30, 0x66, 0x63, 0x2d, 0x61, 0x63, 0x37, 0x31, 0x2d, 0x30, 0x31, 0x63, 0x30, 0x2d, 0x31, 0x38, 0x37, 0x32, 0x32, 0x64, 0x35, 0x61, 0x37, 0x39, 0x66, 0x39}, {0x34, 0x64, 0x65, 0x37, 0x61, 0x64, 0x38, 0x37, 0x2d, 0x63, 0x32, 0x35, 0x33, 0x2d, 0x66, 0x30, 0x36, 0x34, 0x2d, 0x30, 0x35, 0x35, 0x64, 0x2d, 0x37, 0x34, 0x66, 0x30, 0x33, 0x30, 0x39, 0x65, 0x31, 0x35, 0x36, 0x63}}},
	{"[][]uint8", "93da002437613939636563632d633135642d623039612d396263322d643565643839613836626137da002465363861303139632d346461322d353465302d396662662d373530373239383864663864da002462303431306230612d373137632d333863652d626534352d336630353432333236356436", [][]uint8{{0x37, 0x61, 0x39, 0x39, 0x63, 0x65, 0x63, 0x63, 0x2d, 0x63, 0x31, 0x35, 0x64, 0x2d, 0x62, 0x30, 0x39, 0x61, 0x2d, 0x39, 0x62, 0x63, 0x32, 0x2d, 0x64, 0x35, 0x65, 0x64, 0x38, 0x39, 0x61, 0x38, 0x36, 0x62, 0x61, 0x37}, {0x65, 0x36, 0x38, 0x61, 0x30, 0x31, 0x39, 0x63, 0x2d, 0x34, 0x64, 0x61, 0x32, 0x2d, 0x35, 0x34, 0x65, 0x30, 0x2d, 0x39, 0x66, 0x62, 0x66, 0x2d, 0x37, 0x35, 0x30, 0x37, 0x32, 0x39, 0x38, 0x38, 0x64, 0x66, 0x38, 0x64}, {0x62, 0x30, 0x34, 0x31, 0x30, 0x62, 0x30, 0x61, 0x2d, 0x37, 0x31, 0x37, 0x63, 0x2d, 0x33, 0x38, 0x63, 0x65, 0x2d, 0x62, 0x65, 0x34, 0x35, 0x2d, 0x33, 0x66, 0x30, 0x35, 0x34, 0x32, 0x33, 0x32, 0x36, 0x35, 0x64, 0x36}}},
	{"[][]uint8", "93da002438336337643332392d643964612d326235362d396638622d626330636164663733616135da002433613662656333322d326236372d396636632d333234302d316162376231656464636366da002430333937646531622d396433302d303164312d613738322d316665363132306232333766", [][]uint8{{0x38, 0x33, 0x63, 0x37, 0x64, 0x33, 0x32, 0x39, 0x2d, 0x64, 0x39, 0x64, 0x61, 0x2d, 0x32, 0x62, 0x35, 0x36, 0x2d, 0x39, 0x66, 0x38, 0x62, 0x2d, 0x62, 0x63, 0x30, 0x63, 0x61, 0x64, 0x66, 0x37, 0x33, 0x61, 0x61, 0x35}, {0x33, 0x61, 0x36, 0x62, 0x65, 0x63, 0x33, 0x32, 0x2d, 0x32, 0x62, 0x36, 0x37, 0x2d, 0x39, 0x66, 0x36, 0x63, 0x2d, 0x33, 0x32, 0x34, 0x30, 0x2d, 0x31, 0x61, 0x62, 0x37, 0x62, 0x31, 0x65, 0x64, 0x64, 0x63, 0x63, 0x66}, {0x30, 0x33, 0x39, 0x37, 0x64, 0x65, 0x31, 0x62, 0x2d, 0x39, 0x64, 0x33, 0x30, 0x2d, 0x30, 0x31, 0x64, 0x31, 0x2d, 0x61, 0x37, 0x38, 0x32, 0x2d, 0x31, 0x66, 0x65, 0x36, 0x31, 0x32, 0x30, 0x62, 0x32, 0x33, 0x37, 0x66}}},
	{"[][]uint8", "93da002439323032343438612d303839362d613536322d326537332d396535633063336464373536da002461386361396133642d396562372d663264312d306162662d363635346630336264663534da002462616562633337332d626564312d326265352d656363302d643135666533636336343037", [][]uint8{{0x39, 0x32, 0x30, 0x32, 0x34, 0x34, 0x38, 0x61, 0x2d, 0x30, 0x38, 0x39, 0x36, 0x2d, 0x61, 0x35, 0x36, 0x32, 0x2d, 0x32, 0x65, 0x37, 0x33, 0x2d, 0x39, 0x65, 0x35, 0x63, 0x30, 0x63, 0x33, 0x64, 0x64, 0x37, 0x35, 0x36}, {0x61, 0x38, 0x63, 0x61, 0x39, 0x61, 0x33, 0x64, 0x2d, 0x39, 0x65, 0x62, 0x37, 0x2d, 0x66, 0x32, 0x64, 0x31, 0x2d, 0x30, 0x61, 0x62, 0x66, 0x2d, 0x36, 0x36, 0x35, 0x34, 0x66, 0x30, 0x33, 0x62, 0x64, 0x66, 0x35, 0x34}, {0x62, 0x61, 0x65, 0x62, 0x63, 0x33, 0x37, 0x33, 0x2d, 0x62, 0x65, 0x64, 0x31, 0x2d, 0x32, 0x62, 0x65, 0x35, 0x2d, 0x65, 0x63, 0x63, 0x30, 0x2d, 0x64, 0x31, 0x35, 0x66, 0x65, 0x33, 0x63, 0x63, 0x36, 0x34, 0x30, 0x37}}},
	{"[][]uint8", "93da002464323336653730382d666366652d363133322d613639662d363938663032633039373364da002431396133303538642d636336662d303434332d353832302d323764356136376630393134da002430306430656634332d326333322d363135352d643061362d383262343861393461353233", [][]uint8{{0x64, 0x32, 0x33, 0x36, 0x65, 0x37, 0x30, 0x38, 0x2d, 0x66, 0x63, 0x66, 0x65, 0x2d, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x61, 0x36, 0x39, 0x66, 0x2d, 0x36, 0x39, 0x38, 0x66, 0x30, 0x32, 0x63, 0x30, 0x39, 0x37, 0x33, 0x64}, {0x31, 0x39, 0x61, 0x33, 0x30, 0x35, 0x38, 0x64, 0x2d, 0x63, 0x63, 0x36, 0x66, 0x2d, 0x30, 0x34, 0x34, 0x33, 0x2d, 0x35, 0x38, 0x32, 0x30, 0x2d, 0x32, 0x37, 0x64, 0x35, 0x61, 0x36, 0x37, 0x66, 0x30, 0x39, 0x31, 0x34}, {0x30, 0x30, 0x64, 0x30, 0x65, 0x66, 0x34, 0x33, 0x2d, 0x32, 0x63, 0x33, 0x32, 0x2d, 0x36, 0x31, 0x35, 0x35, 0x2d, 0x64, 0x30, 0x61, 0x36, 0x2d, 0x38, 0x32, 0x62, 0x34, 0x38, 0x61, 0x39, 0x34, 0x61, 0x35, 0x32, 0x33}}},
	{"[][]uint8", "93da002465356434323461392d373564302d613732312d623461332d343833333364616361626362da002435636138613738342d633261362d383663302d656335322d366137616233383437376135da002430656265393063312d333866612d356432392d666532352d353631396630653166346665", [][]uint8{{0x65, 0x35, 0x64, 0x34, 0x32, 0x34, 0x61, 0x39, 0x2d, 0x37, 0x35, 0x64, 0x30, 0x2d, 0x61, 0x37, 0x32, 0x31, 0x2d, 0x62, 0x34, 0x61, 0x33, 0x2d, 0x34, 0x38, 0x33, 0x33, 0x33, 0x64, 0x61, 0x63, 0x61, 0x62, 0x63, 0x62}, {0x35, 0x63, 0x61, 0x38, 0x61, 0x37, 0x38, 0x34, 0x2d, 0x63, 0x32, 0x61, 0x36, 0x2d, 0x38, 0x36, 0x63, 0x30, 0x2d, 0x65, 0x63, 0x35, 0x32, 0x2d, 0x36, 0x61, 0x37, 0x61, 0x62, 0x33, 0x38, 0x34, 0x37, 0x37, 0x61, 0x35}, {0x30, 0x65, 0x62, 0x65, 0x39, 0x30, 0x63, 0x31, 0x2d, 0x33, 0x38, 0x66, 0x61, 0x2d, 0x35, 0x64, 0x32, 0x39, 0x2d, 0x66, 0x65, 0x32, 0x35, 0x2d, 0x35, 0x36, 0x31, 0x39, 0x66, 0x30, 0x65, 0x31, 0x66, 0x34, 0x66, 0x65}}},
	{"[][]uint8", "93da002465356434323461392d373564302d613732312d623461332d343833333364616361626362da002464653066366332332d633337342d316131622d366564312d643330336563303563616337da002464326139336434662d376164312d643236622d333231632d323134393532396332363661", [][]uint8{{0x65, 0x35, 0x64, 0x34, 0x32, 0x34, 0x61, 0x39, 0x2d, 0x37, 0x35, 0x64, 0x30, 0x2d, 0x61, 0x37, 0x32, 0x31, 0x2d, 0x62, 0x34, 0x61, 0x33, 0x2d, 0x34, 0x38, 0x33, 0x33, 0x33, 0x64, 0x61, 0x63, 0x61, 0x62, 0x63, 0x62}, {0x64, 0x65, 0x30, 0x66, 0x36, 0x63, 0x32, 0x33, 0x2d, 0x63, 0x33, 0x37, 0x34, 0x2d, 0x31, 0x61, 0x31, 0x62, 0x2d, 0x36, 0x65, 0x64, 0x31, 0x2d, 0x64, 0x33, 0x30, 0x33, 0x65, 0x63, 0x30, 0x35, 0x63, 0x61, 0x63, 0x37}, {0x64, 0x32, 0x61, 0x39, 0x33, 0x64, 0x34, 0x66, 0x2d, 0x37, 0x61, 0x64, 0x31, 0x2d, 0x64, 0x32, 0x36, 0x62, 0x2d, 0x33, 0x32, 0x31, 0x63, 0x2d, 0x32, 0x31, 0x34, 0x39, 0x35, 0x32, 0x39, 0x63, 0x32, 0x36, 0x36, 0x61}}},
	{"[][]uint8", "93da002466333333613135392d653934352d653131372d613762662d333462393163613232643437da002463303531653363642d393531352d333162642d666630662d656632353032346131373537da002432653434613239642d653431632d336332362d393638362d343632623532626465396238", [][]uint8{{0x66, 0x33, 0x33, 0x33, 0x61, 0x31, 0x35, 0x39, 0x2d, 0x65, 0x39, 0x34, 0x35, 0x2d, 0x65, 0x31, 0x31, 0x37, 0x2d, 0x61, 0x37, 0x62, 0x66, 0x2d, 0x33, 0x34, 0x62, 0x39, 0x31, 0x63, 0x61, 0x32, 0x32, 0x64, 0x34, 0x37}, {0x63, 0x30, 0x35, 0x31, 0x65, 0x33, 0x63, 0x64, 0x2d, 0x39, 0x35, 0x31, 0x35, 0x2d, 0x33, 0x31, 0x62, 0x64, 0x2d, 0x66, 0x66, 0x30, 0x66, 0x2d, 0x65, 0x66, 0x32, 0x35, 0x30, 0x32, 0x34, 0x61, 0x31, 0x37, 0x35, 0x37}, {0x32, 0x65, 0x34, 0x34, 0x61, 0x32, 0x39, 0x64, 0x2d, 0x65, 0x34, 0x31, 0x63, 0x2d, 0x33, 0x63, 0x32, 0x36, 0x2d, 0x39, 0x36, 0x38, 0x36, 0x2d, 0x34, 0x36, 0x32, 0x62, 0x35, 0x32, 0x62, 0x64, 0x65, 0x39, 0x62, 0x38}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002430383530383039372d366262642d643738652d323636362d353238363631336630623963a24944da002b7365727665722d30383530383039372d366262642d643738652d323636362d353238363631336630623963a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-08508097-6bbd-d78e-2666-5286613f0b9c", Address: "08508097-6bbd-d78e-2666-5286613f0b9c"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002430616531663439332d653431392d653938302d616335392d326239333730316432626430a24944da002b7365727665722d30616531663439332d653431392d653938302d616335392d326239333730316432626430a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0ae1f493-e419-e980-ac59-2b93701d2bd0", Address: "0ae1f493-e419-e980-ac59-2b93701d2bd0"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002433343962313136632d663535372d623035312d643330312d303431343462306265373661a24944da002b7365727665722d33343962313136632d663535372d623035312d643330312d303431343462306265373661a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-349b116c-f557-b051-d301-04144b0be76a", Address: "349b116c-f557-b051-d301-04144b0be76a"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002434343762386430332d336239332d356434362d396335612d313730346334353631623933a24944da002b7365727665722d34343762386430332d336239332d356434362d396335612d313730346334353631623933a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-447b8d03-3b93-5d46-9c5a-1704c4561b93", Address: "447b8d03-3b93-5d46-9c5a-1704c4561b93"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002434613033626666342d663433382d363765632d623835612d616630363331343961653566a24944da002b7365727665722d34613033626666342d663433382d363765632d623835612d616630363331343961653566a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-4a03bff4-f438-67ec-b85a-af063149ae5f", Address: "4a03bff4-f438-67ec-b85a-af063149ae5f"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002435633965303837302d663434302d626536352d646135632d346630306663353332353436a24944da002b7365727665722d35633965303837302d663434302d626536352d646135632d346630306663353332353436a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-5c9e0870-f440-be65-da5c-4f00fc532546", Address: "5c9e0870-f440-be65-da5c-4f00fc532546"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002437623236616332642d376166612d313331372d346239302d356662323337623233376533a24944da002b7365727665722d37623236616332642d376166612d313331372d346239302d356662323337623233376533a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-7b26ac2d-7afa-1317-4b90-5fb237b237e3", Address: "7b26ac2d-7afa-1317-4b90-5fb237b237e3"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002438633638366339662d613238652d386338662d623565372d396561383661626239303030a24944da002b7365727665722d38633638366339662d613238652d386338662d623565372d396561383661626239303030a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8c686c9f-a28e-8c8f-b5e7-9ea86abb9000", Address: "8c686c9f-a28e-8c8f-b5e7-9ea86abb9000"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002438653739636637362d653138322d333438652d396138382d383236623634346132396162a24944da002b7365727665722d38653739636637362d653138322d333438652d396138382d383236623634346132396162a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8e79cf76-e182-348e-9a88-826b644a29ab", Address: "8e79cf76-e182-348e-9a88-826b644a29ab"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002439303965343361612d666531302d653361622d353330342d343961396364643437653637a24944da002b7365727665722d39303965343361612d666531302d653361622d353330342d343961396364643437653637a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-909e43aa-fe10-e3ab-5304-49a9cdd47e67", Address: "909e43aa-fe10-e3ab-5304-49a9cdd47e67"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002461323538323963612d613466302d323162362d386632362d663030613835623765303132a24944da002b7365727665722d61323538323963612d613466302d323162362d386632362d663030613835623765303132a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a25829ca-a4f0-21b6-8f26-f00a85b7e012", Address: "a25829ca-a4f0-21b6-8f26-f00a85b7e012"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002461356630613931342d313738322d303833332d333061382d383463376237313463363135a24944da002b7365727665722d61356630613931342d313738322d303833332d333061382d383463376237313463363135a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a5f0a914-1782-0833-30a8-84c7b714c615", Address: "a5f0a914-1782-0833-30a8-84c7b714c615"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002462363964306230652d353666322d356261322d386633632d393537353361636236616361a24944da002b7365727665722d62363964306230652d353666322d356261322d386633632d393537353361636236616361a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b69d0b0e-56f2-5ba2-8f3c-95753acb6aca", Address: "b69d0b0e-56f2-5ba2-8f3c-95753acb6aca"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002464643933303433322d653065302d336338342d666666392d366662613136303337376464a24944da002b7365727665722d64643933303433322d653065302d336338342d666666392d366662613136303337376464a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-dd930432-e0e0-3c84-fff9-6fba160377dd", Address: "dd930432-e0e0-3c84-fff9-6fba160377dd"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002465353538323135612d363739392d366664382d376231332d613837396363333538303735a24944da002b7365727665722d65353538323135612d363739392d366664382d376231332d613837396363333538303735a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e558215a-6799-6fd8-7b13-a879cc358075", Address: "e558215a-6799-6fd8-7b13-a879cc358075"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002431343662623961312d666463622d653261312d306664312d353738303263643933376534a24944da002b7365727665722d31343662623961312d666463622d653261312d306664312d353738303263643933376534a853756666726167650083a741646472657373da002436363838343133372d613930662d306663312d316139612d366135633738333438613133a24944da002b7365727665722d36363838343133372d613930662d306663312d316139612d366135633738333438613133a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-146bb9a1-fdcb-e2a1-0fd1-57802cd937e4", Address: "146bb9a1-fdcb-e2a1-0fd1-57802cd937e4"}, {Suffrage: 0, ID: "server-66884137-a90f-0fc1-1a9a-6a5c78348a13", Address: "66884137-a90f-0fc1-1a9a-6a5c78348a13"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002433346238306239322d323261642d336362372d323931312d643838336533396363353232a24944da002b7365727665722d33346238306239322d323261642d336362372d323931312d643838336533396363353232a853756666726167650083a741646472657373da002435636431313736302d323433362d333466392d633166632d346466313238616636373165a24944da002b7365727665722d35636431313736302d323433362d333466392d633166632d346466313238616636373165a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-34b80b92-22ad-3cb7-2911-d883e39cc522", Address: "34b80b92-22ad-3cb7-2911-d883e39cc522"}, {Suffrage: 0, ID: "server-5cd11760-2436-34f9-c1fc-4df128af671e", Address: "5cd11760-2436-34f9-c1fc-4df128af671e"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002433376636386638662d616566622d306363392d613962632d343435623136353166313164a24944da002b7365727665722d33376636386638662d616566622d306363392d613962632d343435623136353166313164a853756666726167650083a741646472657373da002436656564343663312d306339622d643165342d323166352d636339656538643031373236a24944da002b7365727665722d36656564343663312d306339622d643165342d323166352d636339656538643031373236a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-37f68f8f-aefb-0cc9-a9bc-445b1651f11d", Address: "37f68f8f-aefb-0cc9-a9bc-445b1651f11d"}, {Suffrage: 0, ID: "server-6eed46c1-0c9b-d1e4-21f5-cc9ee8d01726", Address: "6eed46c1-0c9b-d1e4-21f5-cc9ee8d01726"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002433376636386638662d616566622d306363392d613962632d343435623136353166313164a24944da002b7365727665722d33376636386638662d616566622d306363392d613962632d343435623136353166313164a853756666726167650183a741646472657373da002436656564343663312d306339622d643165342d323166352d636339656538643031373236a24944da002b7365727665722d36656564343663312d306339622d643165342d323166352d636339656538643031373236a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 1, ID: "server-37f68f8f-aefb-0cc9-a9bc-445b1651f11d", Address: "37f68f8f-aefb-0cc9-a9bc-445b1651f11d"}, {Suffrage: 0, ID: "server-6eed46c1-0c9b-d1e4-21f5-cc9ee8d01726", Address: "6eed46c1-0c9b-d1e4-21f5-cc9ee8d01726"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002435366663303135372d303236332d303438372d303034382d666437613334356135666262a24944da002b7365727665722d35366663303135372d303236332d303438372d303034382d666437613334356135666262a853756666726167650083a741646472657373da002439313265366335352d663935622d616262332d376363652d373139316538636438666438a24944da002b7365727665722d39313265366335352d663935622d616262332d376363652d373139316538636438666438a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-56fc0157-0263-0487-0048-fd7a345a5fbb", Address: "56fc0157-0263-0487-0048-fd7a345a5fbb"}, {Suffrage: 0, ID: "server-912e6c55-f95b-abb3-7cce-7191e8cd8fd8", Address: "912e6c55-f95b-abb3-7cce-7191e8cd8fd8"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002436303436353837612d623961652d623835382d656566372d343331653263383932306138a24944da002b7365727665722d36303436353837612d623961652d623835382d656566372d343331653263383932306138a853756666726167650083a741646472657373da002433303036303833362d383663632d313363622d646130312d633130656238393938373163a24944da002b7365727665722d33303036303833362d383663632d313363622d646130312d633130656238393938373163a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6046587a-b9ae-b858-eef7-431e2c8920a8", Address: "6046587a-b9ae-b858-eef7-431e2c8920a8"}, {Suffrage: 0, ID: "server-30060836-86cc-13cb-da01-c10eb899871c", Address: "30060836-86cc-13cb-da01-c10eb899871c"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002437376363616134372d643466632d653234382d643061652d353931643538396237633964a24944da002b7365727665722d37376363616134372d643466632d653234382d643061652d353931643538396237633964a853756666726167650083a741646472657373da002432313637656632652d363861662d353166382d333266372d643162633337373962343231a24944da002b7365727665722d32313637656632652d363861662d353166382d333266372d643162633337373962343231a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-77ccaa47-d4fc-e248-d0ae-591d589b7c9d", Address: "77ccaa47-d4fc-e248-d0ae-591d589b7c9d"}, {Suffrage: 0, ID: "server-2167ef2e-68af-51f8-32f7-d1bc3779b421", Address: "2167ef2e-68af-51f8-32f7-d1bc3779b421"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002438323535663433622d363332632d383663342d386138382d646264653836376539386461a24944da002b7365727665722d38323535663433622d363332632d383663342d386138382d646264653836376539386461a853756666726167650083a741646472657373da002436646163356565612d333663312d313965342d643837342d373434393064363830626137a24944da002b7365727665722d36646163356565612d333663312d313965342d643837342d373434393064363830626137a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8255f43b-632c-86c4-8a88-dbde867e98da", Address: "8255f43b-632c-86c4-8a88-dbde867e98da"}, {Suffrage: 0, ID: "server-6dac5eea-36c1-19e4-d874-74490d680ba7", Address: "6dac5eea-36c1-19e4-d874-74490d680ba7"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002438653739636637362d653138322d333438652d396138382d383236623634346132396162a24944da002b7365727665722d38653739636637362d653138322d333438652d396138382d383236623634346132396162a853756666726167650083a741646472657373da002466343663383134362d323866662d613732392d663762392d353264313434303235663638a24944da002b7365727665722d66343663383134362d323866662d613732392d663762392d353264313434303235663638a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8e79cf76-e182-348e-9a88-826b644a29ab", Address: "8e79cf76-e182-348e-9a88-826b644a29ab"}, {Suffrage: 0, ID: "server-f46c8146-28ff-a729-f7b9-52d144025f68", Address: "f46c8146-28ff-a729-f7b9-52d144025f68"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002439646532626534392d386437662d646664372d613064322d383934363038656138633531a24944da002b7365727665722d39646532626534392d386437662d646664372d613064322d383934363038656138633531a853756666726167650083a741646472657373da002462646230383161332d613031662d343238392d383365622d653933333263646530373862a24944da002b7365727665722d62646230383161332d613031662d343238392d383365622d653933333263646530373862a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9de2be49-8d7f-dfd7-a0d2-894608ea8c51", Address: "9de2be49-8d7f-dfd7-a0d2-894608ea8c51"}, {Suffrage: 0, ID: "server-bdb081a3-a01f-4289-83eb-e9332cde078b", Address: "bdb081a3-a01f-4289-83eb-e9332cde078b"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002439653438646333362d346663382d663464392d393562302d666237393734303538326265a24944da002b7365727665722d39653438646333362d346663382d663464392d393562302d666237393734303538326265a853756666726167650083a741646472657373da002464316262313230302d323335362d633539372d336363312d306430323836303361316562a24944da002b7365727665722d64316262313230302d323335362d633539372d336363312d306430323836303361316562a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9e48dc36-4fc8-f4d9-95b0-fb79740582be", Address: "9e48dc36-4fc8-f4d9-95b0-fb79740582be"}, {Suffrage: 0, ID: "server-d1bb1200-2356-c597-3cc1-0d028603a1eb", Address: "d1bb1200-2356-c597-3cc1-0d028603a1eb"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002462393634313365612d306664362d366232322d333436622d386265653035323864656235a24944da002b7365727665722d62393634313365612d306664362d366232322d333436622d386265653035323864656235a853756666726167650083a741646472657373da002466346533373334332d633231372d386561372d393062302d323635356161333766663938a24944da002b7365727665722d66346533373334332d633231372d386561372d393062302d323635356161333766663938a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b96413ea-0fd6-6b22-346b-8bee0528deb5", Address: "b96413ea-0fd6-6b22-346b-8bee0528deb5"}, {Suffrage: 0, ID: "server-f4e37343-c217-8ea7-90b0-2655aa37ff98", Address: "f4e37343-c217-8ea7-90b0-2655aa37ff98"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002464343139653731352d663261632d666534612d303530332d356466336334393031636363a24944da002b7365727665722d64343139653731352d663261632d666534612d303530332d356466336334393031636363a853756666726167650083a741646472657373da002433653434383833382d353638622d346134362d396235632d643161343633346638303233a24944da002b7365727665722d33653434383833382d353638622d346134362d396235632d643161343633346638303233a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d419e715-f2ac-fe4a-0503-5df3c4901ccc", Address: "d419e715-f2ac-fe4a-0503-5df3c4901ccc"}, {Suffrage: 0, ID: "server-3e448838-568b-4a46-9b5c-d1a4634f8023", Address: "3e448838-568b-4a46-9b5c-d1a4634f8023"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002465626237363962332d386561392d313733322d653531332d653166313636303639663736a24944da002465626237363962332d386561392d313733322d653531332d653166313636303639663736a853756666726167650083a741646472657373da002433383661393863352d323432652d653638612d343365662d623865383438393932653536a24944da002b7365727665722d33383661393863352d323432652d653638612d343365662d623865383438393932653536a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "ebb769b3-8ea9-1732-e513-e1f166069f76", Address: "ebb769b3-8ea9-1732-e513-e1f166069f76"}, {Suffrage: 0, ID: "server-386a98c5-242e-e68a-43ef-b8e848992e56", Address: "386a98c5-242e-e68a-43ef-b8e848992e56"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002466343732363761372d613835622d353165362d623536352d323361666335323531373735a24944da002b7365727665722d66343732363761372d613835622d353165362d623536352d323361666335323531373735a853756666726167650083a741646472657373da002430623565333566642d616336662d363234622d343932342d353139306536363562663539a24944da002b7365727665722d30623565333566642d616336662d363234622d343932342d353139306536363562663539a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f47267a7-a85b-51e6-b565-23afc5251775", Address: "f47267a7-a85b-51e6-b565-23afc5251775"}, {Suffrage: 0, ID: "server-0b5e35fd-ac6f-624b-4924-5190e665bf59", Address: "0b5e35fd-ac6f-624b-4924-5190e665bf59"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373a56164647230a24944a3696430a853756666726167650183a741646472657373a56164647231a24944a3696431a853756666726167650083a741646472657373a56164647232a24944a3696432a8537566667261676502", Configuration{Servers: []Server{{Suffrage: 1, ID: "id0", Address: "addr0"}, {Suffrage: 0, ID: "id1", Address: "addr1"}, {Suffrage: 2, ID: "id2", Address: "addr2"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002430373434336232302d643762332d313030652d306264662d333931313263656530643838a24944da002b7365727665722d30373434336232302d643762332d313030652d306264662d333931313263656530643838a853756666726167650083a741646472657373da002438376338366235332d323639662d636661382d333031342d393635383130323136383063a24944da002b7365727665722d38376338366235332d323639662d636661382d333031342d393635383130323136383063a853756666726167650083a741646472657373da002438633333356339362d333539312d316535332d343962372d633839383737656363383236a24944da002b7365727665722d38633333356339362d333539312d316535332d343962372d633839383737656363383236a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-07443b20-d7b3-100e-0bdf-39112cee0d88", Address: "07443b20-d7b3-100e-0bdf-39112cee0d88"}, {Suffrage: 0, ID: "server-87c86b53-269f-cfa8-3014-96581021680c", Address: "87c86b53-269f-cfa8-3014-96581021680c"}, {Suffrage: 0, ID: "server-8c335c96-3591-1e53-49b7-c89877ecc826", Address: "8c335c96-3591-1e53-49b7-c89877ecc826"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002430663564376338352d313535392d326464322d646231302d316632353238353466666565a24944da002b7365727665722d30663564376338352d313535392d326464322d646231302d316632353238353466666565a853756666726167650083a741646472657373da002430633961666464382d376437312d646536372d656432632d313432306132373030346636a24944da002b7365727665722d30633961666464382d376437312d646536372d656432632d313432306132373030346636a853756666726167650083a741646472657373da002435666465623266372d653363612d316663322d346330302d393762323765373337343762a24944da002b7365727665722d35666465623266372d653363612d316663322d346330302d393762323765373337343762a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0f5d7c85-1559-2dd2-db10-1f252854ffee", Address: "0f5d7c85-1559-2dd2-db10-1f252854ffee"}, {Suffrage: 0, ID: "server-0c9afdd8-7d71-de67-ed2c-1420a27004f6", Address: "0c9afdd8-7d71-de67-ed2c-1420a27004f6"}, {Suffrage: 0, ID: "server-5fdeb2f7-e3ca-1fc2-4c00-97b27e73747b", Address: "5fdeb2f7-e3ca-1fc2-4c00-97b27e73747b"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431353765663736322d303138342d356234392d643830612d666661376636626162356530a24944da002b7365727665722d31353765663736322d303138342d356234392d643830612d666661376636626162356530a853756666726167650083a741646472657373da002432373838653738322d626535622d313766612d343331302d663636366634353763336136a24944da002b7365727665722d32373838653738322d626535622d313766612d343331302d663636366634353763336136a853756666726167650083a741646472657373da002435633638396662342d396166302d373031342d356362612d323639396235396630386239a24944da002b7365727665722d35633638396662342d396166302d373031342d356362612d323639396235396630386239a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-157ef762-0184-5b49-d80a-ffa7f6bab5e0", Address: "157ef762-0184-5b49-d80a-ffa7f6bab5e0"}, {Suffrage: 0, ID: "server-2788e782-be5b-17fa-4310-f666f457c3a6", Address: "2788e782-be5b-17fa-4310-f666f457c3a6"}, {Suffrage: 0, ID: "server-5c689fb4-9af0-7014-5cba-2699b59f08b9", Address: "5c689fb4-9af0-7014-5cba-2699b59f08b9"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431616530643831612d633733312d373034372d323762662d363232333333643365353363a24944da002b7365727665722d31616530643831612d633733312d373034372d323762662d363232333333643365353363a853756666726167650083a741646472657373da002431336439383534612d333232652d393330312d366136662d386339363964366361633930a24944da002b7365727665722d31336439383534612d333232652d393330312d366136662d386339363964366361633930a853756666726167650083a741646472657373da002438383766656562302d333164322d333565662d623461322d366338343239356636363766a24944da002b7365727665722d38383766656562302d333164322d333565662d623461322d366338343239356636363766a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-1ae0d81a-c731-7047-27bf-622333d3e53c", Address: "1ae0d81a-c731-7047-27bf-622333d3e53c"}, {Suffrage: 0, ID: "server-13d9854a-322e-9301-6a6f-8c969d6cac90", Address: "13d9854a-322e-9301-6a6f-8c969d6cac90"}, {Suffrage: 0, ID: "server-887feeb0-31d2-35ef-b4a2-6c84295f667f", Address: "887feeb0-31d2-35ef-b4a2-6c84295f667f"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433346238306239322d323261642d336362372d323931312d643838336533396363353232a24944da002b7365727665722d33346238306239322d323261642d336362372d323931312d643838336533396363353232a853756666726167650083a741646472657373da002465663236376637652d343432652d386139652d373631352d313463613934646535346264a24944da002b7365727665722d65663236376637652d343432652d386139652d373631352d313463613934646535346264a853756666726167650083a741646472657373da002435636431313736302d323433362d333466392d633166632d346466313238616636373165a24944da002b7365727665722d35636431313736302d323433362d333466392d633166632d346466313238616636373165a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-34b80b92-22ad-3cb7-2911-d883e39cc522", Address: "34b80b92-22ad-3cb7-2911-d883e39cc522"}, {Suffrage: 0, ID: "server-ef267f7e-442e-8a9e-7615-14ca94de54bd", Address: "ef267f7e-442e-8a9e-7615-14ca94de54bd"}, {Suffrage: 0, ID: "server-5cd11760-2436-34f9-c1fc-4df128af671e", Address: "5cd11760-2436-34f9-c1fc-4df128af671e"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433366565656336632d363462342d373063642d653933392d646433343738616536353331a24944da002b7365727665722d33366565656336632d363462342d373063642d653933392d646433343738616536353331a853756666726167650083a741646472657373da002466343732363761372d613835622d353165362d623536352d323361666335323531373735a24944da002b7365727665722d66343732363761372d613835622d353165362d623536352d323361666335323531373735a853756666726167650083a741646472657373da002430623565333566642d616336662d363234622d343932342d353139306536363562663539a24944da002b7365727665722d30623565333566642d616336662d363234622d343932342d353139306536363562663539a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-36eeec6c-64b4-70cd-e939-dd3478ae6531", Address: "36eeec6c-64b4-70cd-e939-dd3478ae6531"}, {Suffrage: 0, ID: "server-f47267a7-a85b-51e6-b565-23afc5251775", Address: "f47267a7-a85b-51e6-b565-23afc5251775"}, {Suffrage: 0, ID: "server-0b5e35fd-ac6f-624b-4924-5190e665bf59", Address: "0b5e35fd-ac6f-624b-4924-5190e665bf59"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433376239383163332d343861322d373938392d303466612d323364353835333932653137a24944da002b7365727665722d33376239383163332d343861322d373938392d303466612d323364353835333932653137a853756666726167650083a741646472657373da002431653939613433342d656461302d616139642d336362312d363562396335313630323430a24944da002b7365727665722d31653939613433342d656461302d616139642d336362312d363562396335313630323430a853756666726167650083a741646472657373da002432303736623861362d383961612d646137342d613839622d333433313031306164353139a24944da002b7365727665722d32303736623861362d383961612d646137342d613839622d333433313031306164353139a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-37b981c3-48a2-7989-04fa-23d585392e17", Address: "37b981c3-48a2-7989-04fa-23d585392e17"}, {Suffrage: 0, ID: "server-1e99a434-eda0-aa9d-3cb1-65b9c5160240", Address: "1e99a434-eda0-aa9d-3cb1-65b9c5160240"}, {Suffrage: 0, ID: "server-2076b8a6-89aa-da74-a89b-3431010ad519", Address: "2076b8a6-89aa-da74-a89b-3431010ad519"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433616432323363332d613939612d623864372d313961362d643565376339346162636639a24944da002b7365727665722d33616432323363332d613939612d623864372d313961362d643565376339346162636639a853756666726167650083a741646472657373da002464353239633464612d663839362d363663362d663566612d666335656563323336366465a24944da002b7365727665722d64353239633464612d663839362d363663362d663566612d666335656563323336366465a853756666726167650083a741646472657373da002436626338373062362d363061662d393161642d336331392d373964323364363462323331a24944da002b7365727665722d36626338373062362d363061662d393161642d336331392d373964323364363462323331a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3ad223c3-a99a-b8d7-19a6-d5e7c94abcf9", Address: "3ad223c3-a99a-b8d7-19a6-d5e7c94abcf9"}, {Suffrage: 0, ID: "server-d529c4da-f896-66c6-f5fa-fc5eec2366de", Address: "d529c4da-f896-66c6-f5fa-fc5eec2366de"}, {Suffrage: 0, ID: "server-6bc870b6-60af-91ad-3c19-79d23d64b231", Address: "6bc870b6-60af-91ad-3c19-79d23d64b231"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434393263623436632d343132392d373331372d323764312d363130626438613136356266a24944da002b7365727665722d34393263623436632d343132392d373331372d323764312d363130626438613136356266a853756666726167650083a741646472657373da002431343662623961312d666463622d653261312d306664312d353738303263643933376534a24944da002b7365727665722d31343662623961312d666463622d653261312d306664312d353738303263643933376534a853756666726167650083a741646472657373da002436363838343133372d613930662d306663312d316139612d366135633738333438613133a24944da002b7365727665722d36363838343133372d613930662d306663312d316139612d366135633738333438613133a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-492cb46c-4129-7317-27d1-610bd8a165bf", Address: "492cb46c-4129-7317-27d1-610bd8a165bf"}, {Suffrage: 0, ID: "server-146bb9a1-fdcb-e2a1-0fd1-57802cd937e4", Address: "146bb9a1-fdcb-e2a1-0fd1-57802cd937e4"}, {Suffrage: 0, ID: "server-66884137-a90f-0fc1-1a9a-6a5c78348a13", Address: "66884137-a90f-0fc1-1a9a-6a5c78348a13"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436303436353837612d623961652d623835382d656566372d343331653263383932306138a24944da002b7365727665722d36303436353837612d623961652d623835382d656566372d343331653263383932306138a853756666726167650083a741646472657373da002436323265646465652d656137612d306334312d623639302d636336323134643934303038a24944da002b7365727665722d36323265646465652d656137612d306334312d623639302d636336323134643934303038a853756666726167650083a741646472657373da002433303036303833362d383663632d313363622d646130312d633130656238393938373163a24944da002b7365727665722d33303036303833362d383663632d313363622d646130312d633130656238393938373163a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6046587a-b9ae-b858-eef7-431e2c8920a8", Address: "6046587a-b9ae-b858-eef7-431e2c8920a8"}, {Suffrage: 0, ID: "server-622eddee-ea7a-0c41-b690-cc6214d94008", Address: "622eddee-ea7a-0c41-b690-cc6214d94008"}, {Suffrage: 0, ID: "server-30060836-86cc-13cb-da01-c10eb899871c", Address: "30060836-86cc-13cb-da01-c10eb899871c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436316536386662332d366437362d333264612d386364382d316530376238653334383733a24944da002b7365727665722d36316536386662332d366437362d333264612d386364382d316530376238653334383733a853756666726167650083a741646472657373da002431346463383131342d333039632d346366642d643961312d323166366538653066643561a24944da002b7365727665722d31346463383131342d333039632d346366642d643961312d323166366538653066643561a853756666726167650083a741646472657373da002462663966333364652d333163322d343763622d636633332d663831656539623532393434a24944da002b7365727665722d62663966333364652d333163322d343763622d636633332d663831656539623532393434a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-61e68fb3-6d76-32da-8cd8-1e07b8e34873", Address: "61e68fb3-6d76-32da-8cd8-1e07b8e34873"}, {Suffrage: 0, ID: "server-14dc8114-309c-4cfd-d9a1-21f6e8e0fd5a", Address: "14dc8114-309c-4cfd-d9a1-21f6e8e0fd5a"}, {Suffrage: 0, ID: "server-bf9f33de-31c2-47cb-cf33-f81ee9b52944", Address: "bf9f33de-31c2-47cb-cf33-f81ee9b52944"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436326131666466642d303136342d363062372d373035612d666134656462383364653731a24944da002b7365727665722d36326131666466642d303136342d363062372d373035612d666134656462383364653731a853756666726167650083a741646472657373da002465363764306361332d333265612d383933312d633431302d663932356630646362323163a24944da002b7365727665722d65363764306361332d333265612d383933312d633431302d663932356630646362323163a853756666726167650083a741646472657373da002462393332623038382d326462312d653561632d663137622d323762623561623934623236a24944da002b7365727665722d62393332623038382d326462312d653561632d663137622d323762623561623934623236a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-62a1fdfd-0164-60b7-705a-fa4edb83de71", Address: "62a1fdfd-0164-60b7-705a-fa4edb83de71"}, {Suffrage: 0, ID: "server-e67d0ca3-32ea-8931-c410-f925f0dcb21c", Address: "e67d0ca3-32ea-8931-c410-f925f0dcb21c"}, {Suffrage: 0, ID: "server-b932b088-2db1-e5ac-f17b-27bb5ab94b26", Address: "b932b088-2db1-e5ac-f17b-27bb5ab94b26"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436353939313366322d656137322d353438342d666131352d646138613231613030373832a24944da002b7365727665722d36353939313366322d656137322d353438342d666131352d646138613231613030373832a853756666726167650083a741646472657373da002461316237633132312d396532622d323963652d626561372d636362663338666662353763a24944da002b7365727665722d61316237633132312d396532622d323963652d626561372d636362663338666662353763a853756666726167650083a741646472657373da002430613535343762302d656535342d656662632d366231632d366536663633366438643438a24944da002b7365727665722d30613535343762302d656535342d656662632d366231632d366536663633366438643438a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-659913f2-ea72-5484-fa15-da8a21a00782", Address: "659913f2-ea72-5484-fa15-da8a21a00782"}, {Suffrage: 0, ID: "server-a1b7c121-9e2b-29ce-bea7-ccbf38ffb57c", Address: "a1b7c121-9e2b-29ce-bea7-ccbf38ffb57c"}, {Suffrage: 0, ID: "server-0a5547b0-ee54-efbc-6b1c-6e6f636d8d48", Address: "0a5547b0-ee54-efbc-6b1c-6e6f636d8d48"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436386231336264322d363232342d393737332d393038332d333732396139333038653663a24944da002b7365727665722d36386231336264322d363232342d393737332d393038332d333732396139333038653663a853756666726167650083a741646472657373da002439653939663834312d643531372d383830612d393362632d663564336366336662313834a24944da002b7365727665722d39653939663834312d643531372d383830612d393362632d663564336366336662313834a853756666726167650083a741646472657373da002436636262303839372d663535312d383736612d366463632d353238323430353337306135a24944da002b7365727665722d36636262303839372d663535312d383736612d366463632d353238323430353337306135a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-68b13bd2-6224-9773-9083-3729a9308e6c", Address: "68b13bd2-6224-9773-9083-3729a9308e6c"}, {Suffrage: 0, ID: "server-9e99f841-d517-880a-93bc-f5d3cf3fb184", Address: "9e99f841-d517-880a-93bc-f5d3cf3fb184"}, {Suffrage: 0, ID: "server-6cbb0897-f551-876a-6dcc-5282405370a5", Address: "6cbb0897-f551-876a-6dcc-5282405370a5"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436393238393739632d353635662d393439302d356562622d376664396461393763393931a24944da002b7365727665722d36393238393739632d353635662d393439302d356562622d376664396461393763393931a853756666726167650083a741646472657373da002432616365343833632d626363662d376364302d346338632d653961666666326236333237a24944da002b7365727665722d32616365343833632d626363662d376364302d346338632d653961666666326236333237a853756666726167650083a741646472657373da002435623638646239372d393534612d373061392d333732382d613464343132353937343132a24944da002b7365727665722d35623638646239372d393534612d373061392d333732382d613464343132353937343132a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6928979c-565f-9490-5ebb-7fd9da97c991", Address: "6928979c-565f-9490-5ebb-7fd9da97c991"}, {Suffrage: 0, ID: "server-2ace483c-bccf-7cd0-4c8c-e9afff2b6327", Address: "2ace483c-bccf-7cd0-4c8c-e9afff2b6327"}, {Suffrage: 0, ID: "server-5b68db97-954a-70a9-3728-a4d412597412", Address: "5b68db97-954a-70a9-3728-a4d412597412"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437326432383133662d343562622d326462342d323439302d336566353762656462633034a24944da002b7365727665722d37326432383133662d343562622d326462342d323439302d336566353762656462633034a853756666726167650083a741646472657373da002461653338306639352d373034612d616564382d323762652d323530396231643261373762a24944da002b7365727665722d61653338306639352d373034612d616564382d323762652d323530396231643261373762a853756666726167650083a741646472657373da002435643034303663612d343130342d653938332d366437332d333732313364396263326362a24944da002b7365727665722d35643034303663612d343130342d653938332d366437332d333732313364396263326362a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-72d2813f-45bb-2db4-2490-3ef57bedbc04", Address: "72d2813f-45bb-2db4-2490-3ef57bedbc04"}, {Suffrage: 0, ID: "server-ae380f95-704a-aed8-27be-2509b1d2a77b", Address: "ae380f95-704a-aed8-27be-2509b1d2a77b"}, {Suffrage: 0, ID: "server-5d0406ca-4104-e983-6d73-37213d9bc2cb", Address: "5d0406ca-4104-e983-6d73-37213d9bc2cb"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437333765363361662d666130362d636163372d316434332d346635373731353966623965a24944da002b7365727665722d37333765363361662d666130362d636163372d316434332d346635373731353966623965a853756666726167650083a741646472657373da002436666266326362352d653838332d396637332d366166662d633231373764363764333339a24944da002b7365727665722d36666266326362352d653838332d396637332d366166662d633231373764363764333339a853756666726167650083a741646472657373da002437633965623462302d313063652d353861362d303735652d623562333966613364633432a24944da002b7365727665722d37633965623462302d313063652d353861362d303735652d623562333966613364633432a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-737e63af-fa06-cac7-1d43-4f577159fb9e", Address: "737e63af-fa06-cac7-1d43-4f577159fb9e"}, {Suffrage: 0, ID: "server-6fbf2cb5-e883-9f73-6aff-c2177d67d339", Address: "6fbf2cb5-e883-9f73-6aff-c2177d67d339"}, {Suffrage: 0, ID: "server-7c9eb4b0-10ce-58a6-075e-b5b39fa3dc42", Address: "7c9eb4b0-10ce-58a6-075e-b5b39fa3dc42"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437373235333334382d613338362d313231362d326664622d303834663330313934623364a24944da002b7365727665722d37373235333334382d613338362d313231362d326664622d303834663330313934623364a853756666726167650083a741646472657373da002430636135663565622d613137352d613735382d383266392d613163656439326339646137a24944da002b7365727665722d30636135663565622d613137352d613735382d383266392d613163656439326339646137a853756666726167650083a741646472657373da002463376664623833302d323837362d653230382d303031332d633364303635646333643635a24944da002b7365727665722d63376664623833302d323837362d653230382d303031332d633364303635646333643635a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-77253348-a386-1216-2fdb-084f30194b3d", Address: "77253348-a386-1216-2fdb-084f30194b3d"}, {Suffrage: 0, ID: "server-0ca5f5eb-a175-a758-82f9-a1ced92c9da7", Address: "0ca5f5eb-a175-a758-82f9-a1ced92c9da7"}, {Suffrage: 0, ID: "server-c7fdb830-2876-e208-0013-c3d065dc3d65", Address: "c7fdb830-2876-e208-0013-c3d065dc3d65"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437376363616134372d643466632d653234382d643061652d353931643538396237633964a24944da002b7365727665722d37376363616134372d643466632d653234382d643061652d353931643538396237633964a853756666726167650083a741646472657373da002432313637656632652d363861662d353166382d333266372d643162633337373962343231a24944da002b7365727665722d32313637656632652d363861662d353166382d333266372d643162633337373962343231a853756666726167650083a741646472657373da002430653162663564322d346132352d653737362d343832352d346236343037383465306461a24944da002b7365727665722d30653162663564322d346132352d653737362d343832352d346236343037383465306461a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-77ccaa47-d4fc-e248-d0ae-591d589b7c9d", Address: "77ccaa47-d4fc-e248-d0ae-591d589b7c9d"}, {Suffrage: 0, ID: "server-2167ef2e-68af-51f8-32f7-d1bc3779b421", Address: "2167ef2e-68af-51f8-32f7-d1bc3779b421"}, {Suffrage: 0, ID: "server-0e1bf5d2-4a25-e776-4825-4b640784e0da", Address: "0e1bf5d2-4a25-e776-4825-4b640784e0da"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437383138346662302d343937372d613163382d646637302d363634313663333564343662a24944da002b7365727665722d37383138346662302d343937372d613163382d646637302d363634313663333564343662a853756666726167650083a741646472657373da002432623531323730622d653066632d616337312d303163302d313837323264356137396639a24944da002b7365727665722d32623531323730622d653066632d616337312d303163302d313837323264356137396639a853756666726167650083a741646472657373da002434646537616438372d633235332d663036342d303535642d373466303330396531353663a24944da002b7365727665722d34646537616438372d633235332d663036342d303535642d373466303330396531353663a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-78184fb0-4977-a1c8-df70-66416c35d46b", Address: "78184fb0-4977-a1c8-df70-66416c35d46b"}, {Suffrage: 0, ID: "server-2b51270b-e0fc-ac71-01c0-18722d5a79f9", Address: "2b51270b-e0fc-ac71-01c0-18722d5a79f9"}, {Suffrage: 0, ID: "server-4de7ad87-c253-f064-055d-74f0309e156c", Address: "4de7ad87-c253-f064-055d-74f0309e156c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437613939636563632d633135642d623039612d396263322d643565643839613836626137a24944da002b7365727665722d37613939636563632d633135642d623039612d396263322d643565643839613836626137a853756666726167650083a741646472657373da002465363861303139632d346461322d353465302d396662662d373530373239383864663864a24944da002b7365727665722d65363861303139632d346461322d353465302d396662662d373530373239383864663864a853756666726167650083a741646472657373da002462303431306230612d373137632d333863652d626534352d336630353432333236356436a24944da002b7365727665722d62303431306230612d373137632d333863652d626534352d336630353432333236356436a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-7a99cecc-c15d-b09a-9bc2-d5ed89a86ba7", Address: "7a99cecc-c15d-b09a-9bc2-d5ed89a86ba7"}, {Suffrage: 0, ID: "server-e68a019c-4da2-54e0-9fbf-75072988df8d", Address: "e68a019c-4da2-54e0-9fbf-75072988df8d"}, {Suffrage: 0, ID: "server-b0410b0a-717c-38ce-be45-3f05423265d6", Address: "b0410b0a-717c-38ce-be45-3f05423265d6"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438336337643332392d643964612d326235362d396638622d626330636164663733616135a24944da002b7365727665722d38336337643332392d643964612d326235362d396638622d626330636164663733616135a853756666726167650083a741646472657373da002433613662656333322d326236372d396636632d333234302d316162376231656464636366a24944da002b7365727665722d33613662656333322d326236372d396636632d333234302d316162376231656464636366a853756666726167650083a741646472657373da002430333937646531622d396433302d303164312d613738322d316665363132306232333766a24944da002b7365727665722d30333937646531622d396433302d303164312d613738322d316665363132306232333766a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-83c7d329-d9da-2b56-9f8b-bc0cadf73aa5", Address: "83c7d329-d9da-2b56-9f8b-bc0cadf73aa5"}, {Suffrage: 0, ID: "server-3a6bec32-2b67-9f6c-3240-1ab7b1eddccf", Address: "3a6bec32-2b67-9f6c-3240-1ab7b1eddccf"}, {Suffrage: 0, ID: "server-0397de1b-9d30-01d1-a782-1fe6120b237f", Address: "0397de1b-9d30-01d1-a782-1fe6120b237f"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438396238616166322d366231632d383634312d376631322d313834623739326239646664a24944da002b7365727665722d38396238616166322d366231632d383634312d376631322d313834623739326239646664a853756666726167650083a741646472657373da002465666633313663632d376335642d666633322d333138312d346137356234393639353862a24944da002b7365727665722d65666633313663632d376335642d666633322d333138312d346137356234393639353862a853756666726167650083a741646472657373da002436313738373065312d396661392d643134332d346238622d643364666434623636343564a24944da002b7365727665722d36313738373065312d396661392d643134332d346238622d643364666434623636343564a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-89b8aaf2-6b1c-8641-7f12-184b792b9dfd", Address: "89b8aaf2-6b1c-8641-7f12-184b792b9dfd"}, {Suffrage: 0, ID: "server-eff316cc-7c5d-ff32-3181-4a75b496958b", Address: "eff316cc-7c5d-ff32-3181-4a75b496958b"}, {Suffrage: 0, ID: "server-617870e1-9fa9-d143-4b8b-d3dfd4b6645d", Address: "617870e1-9fa9-d143-4b8b-d3dfd4b6645d"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438633534383864642d323965312d653432632d323136392d323638656662633138313936a24944da002b7365727665722d38633534383864642d323965312d653432632d323136392d323638656662633138313936a853756666726167650083a741646472657373da002430376664613535322d626265342d373637642d313532372d383262383363306162366130a24944da002b7365727665722d30376664613535322d626265342d373637642d313532372d383262383363306162366130a853756666726167650083a741646472657373da002463646633653230622d626137652d633262372d623932392d316238363230316333323463a24944da002b7365727665722d63646633653230622d626137652d633262372d623932392d316238363230316333323463a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8c5488dd-29e1-e42c-2169-268efbc18196", Address: "8c5488dd-29e1-e42c-2169-268efbc18196"}, {Suffrage: 0, ID: "server-07fda552-bbe4-767d-1527-82b83c0ab6a0", Address: "07fda552-bbe4-767d-1527-82b83c0ab6a0"}, {Suffrage: 0, ID: "server-cdf3e20b-ba7e-c2b7-b929-1b86201c324c", Address: "cdf3e20b-ba7e-c2b7-b929-1b86201c324c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438633639396133362d323135352d386566362d646137612d613137346433656437316238a24944da002b7365727665722d38633639396133362d323135352d386566362d646137612d613137346433656437316238a853756666726167650083a741646472657373da002433386263626566332d643530362d333538312d316532372d656431383535623937356132a24944da002b7365727665722d33386263626566332d643530362d333538312d316532372d656431383535623937356132a853756666726167650083a741646472657373da002434303462666337312d336462332d306633662d346535392d666663623332383836633936a24944da002b7365727665722d34303462666337312d336462332d306633662d346535392d666663623332383836633936a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8c699a36-2155-8ef6-da7a-a174d3ed71b8", Address: "8c699a36-2155-8ef6-da7a-a174d3ed71b8"}, {Suffrage: 0, ID: "server-38bcbef3-d506-3581-1e27-ed1855b975a2", Address: "38bcbef3-d506-3581-1e27-ed1855b975a2"}, {Suffrage: 0, ID: "server-404bfc71-3db3-0f3f-4e59-ffcb32886c96", Address: "404bfc71-3db3-0f3f-4e59-ffcb32886c96"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438653739636637362d653138322d333438652d396138382d383236623634346132396162a24944da002b7365727665722d38653739636637362d653138322d333438652d396138382d383236623634346132396162a853756666726167650083a741646472657373da002466343663383134362d323866662d613732392d663762392d353264313434303235663638a24944da002b7365727665722d66343663383134362d323866662d613732392d663762392d353264313434303235663638a853756666726167650083a741646472657373da002430616664386131632d656639302d623639362d326538632d366637333065653430383731a24944da002b7365727665722d30616664386131632d656639302d623639362d326538632d366637333065653430383731a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8e79cf76-e182-348e-9a88-826b644a29ab", Address: "8e79cf76-e182-348e-9a88-826b644a29ab"}, {Suffrage: 0, ID: "server-f46c8146-28ff-a729-f7b9-52d144025f68", Address: "f46c8146-28ff-a729-f7b9-52d144025f68"}, {Suffrage: 0, ID: "server-0afd8a1c-ef90-b696-2e8c-6f730ee40871", Address: "0afd8a1c-ef90-b696-2e8c-6f730ee40871"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439363134633432322d393430322d303066642d363832632d616166633366343632373838a24944da002b7365727665722d39363134633432322d393430322d303066642d363832632d616166633366343632373838a853756666726167650083a741646472657373da002438383262613063632d653537382d376362652d653630652d663163336430623363633063a24944da002b7365727665722d38383262613063632d653537382d376362652d653630652d663163336430623363633063a853756666726167650083a741646472657373da002439383766356466302d626566352d623262662d663461642d353836356137656337376338a24944da002b7365727665722d39383766356466302d626566352d623262662d663461642d353836356137656337376338a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9614c422-9402-00fd-682c-aafc3f462788", Address: "9614c422-9402-00fd-682c-aafc3f462788"}, {Suffrage: 0, ID: "server-882ba0cc-e578-7cbe-e60e-f1c3d0b3cc0c", Address: "882ba0cc-e578-7cbe-e60e-f1c3d0b3cc0c"}, {Suffrage: 0, ID: "server-987f5df0-bef5-b2bf-f4ad-5865a7ec77c8", Address: "987f5df0-bef5-b2bf-f4ad-5865a7ec77c8"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439366136373566622d626263312d313536622d633065662d623434613263326361303265a24944da002b7365727665722d39366136373566622d626263312d313536622d633065662d623434613263326361303265a853756666726167650083a741646472657373da002464316235643966322d363232342d643963352d636164302d373366316239633434626438a24944da002b7365727665722d64316235643966322d363232342d643963352d636164302d373366316239633434626438a853756666726167650083a741646472657373da002438303539343361642d393562362d653563392d336630642d323736616262656364363539a24944da002b7365727665722d38303539343361642d393562362d653563392d336630642d323736616262656364363539a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-96a675fb-bbc1-156b-c0ef-b44a2c2ca02e", Address: "96a675fb-bbc1-156b-c0ef-b44a2c2ca02e"}, {Suffrage: 0, ID: "server-d1b5d9f2-6224-d9c5-cad0-73f1b9c44bd8", Address: "d1b5d9f2-6224-d9c5-cad0-73f1b9c44bd8"}, {Suffrage: 0, ID: "server-805943ad-95b6-e5c9-3f0d-276abbecd659", Address: "805943ad-95b6-e5c9-3f0d-276abbecd659"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439653438646333362d346663382d663464392d393562302d666237393734303538326265a24944da002b7365727665722d39653438646333362d346663382d663464392d393562302d666237393734303538326265a853756666726167650083a741646472657373da002464316262313230302d323335362d633539372d336363312d306430323836303361316562a24944da002b7365727665722d64316262313230302d323335362d633539372d336363312d306430323836303361316562a853756666726167650083a741646472657373da002466333939613138342d356334372d323636382d646133362d636663643137386465623631a24944da002b7365727665722d66333939613138342d356334372d323636382d646133362d636663643137386465623631a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9e48dc36-4fc8-f4d9-95b0-fb79740582be", Address: "9e48dc36-4fc8-f4d9-95b0-fb79740582be"}, {Suffrage: 0, ID: "server-d1bb1200-2356-c597-3cc1-0d028603a1eb", Address: "d1bb1200-2356-c597-3cc1-0d028603a1eb"}, {Suffrage: 0, ID: "server-f399a184-5c47-2668-da36-cfcd178deb61", Address: "f399a184-5c47-2668-da36-cfcd178deb61"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002461373233356633662d363830392d343435352d386330342d393138626565326136306137a24944da002b7365727665722d61373233356633662d363830392d343435352d386330342d393138626565326136306137a853756666726167650083a741646472657373da002431383638663839312d336334392d663563302d363062322d653937373631383863323332a24944da002b7365727665722d31383638663839312d336334392d663563302d363062322d653937373631383863323332a853756666726167650083a741646472657373da002436303235633939332d303835352d346136622d656239622d346265653232626666666465a24944da002b7365727665722d36303235633939332d303835352d346136622d656239622d346265653232626666666465a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a7235f3f-6809-4455-8c04-918bee2a60a7", Address: "a7235f3f-6809-4455-8c04-918bee2a60a7"}, {Suffrage: 0, ID: "server-1868f891-3c49-f5c0-60b2-e9776188c232", Address: "1868f891-3c49-f5c0-60b2-e9776188c232"}, {Suffrage: 0, ID: "server-6025c993-0855-4a6b-eb9b-4bee22bfffde", Address: "6025c993-0855-4a6b-eb9b-4bee22bfffde"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462353337333339372d373261662d303066392d633335652d303664396432316661393235a24944da002b7365727665722d62353337333339372d373261662d303066392d633335652d303664396432316661393235a853756666726167650083a741646472657373da002430353635633233612d303636332d353862612d616336362d303639343238393166323862a24944da002b7365727665722d30353635633233612d303636332d353862612d616336362d303639343238393166323862a853756666726167650083a741646472657373da002437303532636365612d396462382d663662622d656132382d306635373330343636613535a24944da002b7365727665722d37303532636365612d396462382d663662622d656132382d306635373330343636613535a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b5373397-72af-00f9-c35e-06d9d21fa925", Address: "b5373397-72af-00f9-c35e-06d9d21fa925"}, {Suffrage: 0, ID: "server-0565c23a-0663-58ba-ac66-06942891f28b", Address: "0565c23a-0663-58ba-ac66-06942891f28b"}, {Suffrage: 0, ID: "server-7052ccea-9db8-f6bb-ea28-0f5730466a55", Address: "7052ccea-9db8-f6bb-ea28-0f5730466a55"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462616431656237632d616639352d373234342d613265622d643962653365646532303937a24944da002b7365727665722d62616431656237632d616639352d373234342d613265622d643962653365646532303937a853756666726167650083a741646472657373da002464343139653731352d663261632d666534612d303530332d356466336334393031636363a24944da002b7365727665722d64343139653731352d663261632d666534612d303530332d356466336334393031636363a853756666726167650083a741646472657373da002433653434383833382d353638622d346134362d396235632d643161343633346638303233a24944da002b7365727665722d33653434383833382d353638622d346134362d396235632d643161343633346638303233a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-bad1eb7c-af95-7244-a2eb-d9be3ede2097", Address: "bad1eb7c-af95-7244-a2eb-d9be3ede2097"}, {Suffrage: 0, ID: "server-d419e715-f2ac-fe4a-0503-5df3c4901ccc", Address: "d419e715-f2ac-fe4a-0503-5df3c4901ccc"}, {Suffrage: 0, ID: "server-3e448838-568b-4a46-9b5c-d1a4634f8023", Address: "3e448838-568b-4a46-9b5c-d1a4634f8023"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463313763636665382d326163632d666539352d373333352d363538356665343861383761a24944da002b7365727665722d63313763636665382d326163632d666539352d373333352d363538356665343861383761a853756666726167650083a741646472657373da002463316631346262342d363338362d653939362d336535362d653563353664366337376534a24944da002b7365727665722d63316631346262342d363338362d653939362d336535362d653563353664366337376534a853756666726167650083a741646472657373da002434393338366536392d646666352d653161302d306432342d393961346238663236366666a24944da002b7365727665722d34393338366536392d646666352d653161302d306432342d393961346238663236366666a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c17ccfe8-2acc-fe95-7335-6585fe48a87a", Address: "c17ccfe8-2acc-fe95-7335-6585fe48a87a"}, {Suffrage: 0, ID: "server-c1f14bb4-6386-e996-3e56-e5c56d6c77e4", Address: "c1f14bb4-6386-e996-3e56-e5c56d6c77e4"}, {Suffrage: 0, ID: "server-49386e69-dff5-e1a0-0d24-99a4b8f266ff", Address: "49386e69-dff5-e1a0-0d24-99a4b8f266ff"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463313837323732302d383133632d633564642d333131342d623730326136376138373830a24944da002b7365727665722d63313837323732302d383133632d633564642d333131342d623730326136376138373830a853756666726167650083a741646472657373da002465343137393433632d386565342d656663302d333534392d666564313635346231633130a24944da002b7365727665722d65343137393433632d386565342d656663302d333534392d666564313635346231633130a853756666726167650083a741646472657373da002463613364333164362d623166382d613337612d396335342d386337306263323635343264a24944da002b7365727665722d63613364333164362d623166382d613337612d396335342d386337306263323635343264a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c1872720-813c-c5dd-3114-b702a67a8780", Address: "c1872720-813c-c5dd-3114-b702a67a8780"}, {Suffrage: 0, ID: "server-e417943c-8ee4-efc0-3549-fed1654b1c10", Address: "e417943c-8ee4-efc0-3549-fed1654b1c10"}, {Suffrage: 0, ID: "server-ca3d31d6-b1f8-a37a-9c54-8c70bc26542d", Address: "ca3d31d6-b1f8-a37a-9c54-8c70bc26542d"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463326338373964382d333931352d313633342d386265322d353537346531393338373137a24944da002b7365727665722d63326338373964382d333931352d313633342d386265322d353537346531393338373137a853756666726167650083a741646472657373da002463333164323037642d386334382d303066632d353563382d316631613862623730376466a24944da002b7365727665722d63333164323037642d386334382d303066632d353563382d316631613862623730376466a853756666726167650083a741646472657373da002439386462653963322d363462652d626639392d353564362d356130336531303136633432a24944da002b7365727665722d39386462653963322d363462652d626639392d353564362d356130336531303136633432a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c2c879d8-3915-1634-8be2-5574e1938717", Address: "c2c879d8-3915-1634-8be2-5574e1938717"}, {Suffrage: 0, ID: "server-c31d207d-8c48-00fc-55c8-1f1a8bb707df", Address: "c31d207d-8c48-00fc-55c8-1f1a8bb707df"}, {Suffrage: 0, ID: "server-98dbe9c2-64be-bf99-55d6-5a03e1016c42", Address: "98dbe9c2-64be-bf99-55d6-5a03e1016c42"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463623463353932362d346331382d333033342d383566622d316534373839353164363234a24944da002b7365727665722d63623463353932362d346331382d333033342d383566622d316534373839353164363234a853756666726167650083a741646472657373da002434383836366535612d383561652d356430622d366662352d613565313666626634613762a24944da002b7365727665722d34383836366535612d383561652d356430622d366662352d613565313666626634613762a853756666726167650083a741646472657373da002462623037393134352d306536622d306632302d346136642d303661653530363530353332a24944da002b7365727665722d62623037393134352d306536622d306632302d346136642d303661653530363530353332a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-cb4c5926-4c18-3034-85fb-1e478951d624", Address: "cb4c5926-4c18-3034-85fb-1e478951d624"}, {Suffrage: 0, ID: "server-48866e5a-85ae-5d0b-6fb5-a5e16fbf4a7b", Address: "48866e5a-85ae-5d0b-6fb5-a5e16fbf4a7b"}, {Suffrage: 0, ID: "server-bb079145-0e6b-0f20-4a6d-06ae50650532", Address: "bb079145-0e6b-0f20-4a6d-06ae50650532"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463643164366635612d663465622d393337302d633239392d656436313666343038386263a24944da002b7365727665722d63643164366635612d663465622d393337302d633239392d656436313666343038386263a853756666726167650083a741646472657373da002430643164643635642d383538662d666262332d316236322d323433663039653964653134a24944da002b7365727665722d30643164643635642d383538662d666262332d316236322d323433663039653964653134a853756666726167650083a741646472657373da002465343832353964312d663838312d653464662d613862322d303663366663316134303965a24944da002b7365727665722d65343832353964312d663838312d653464662d613862322d303663366663316134303965a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-cd1d6f5a-f4eb-9370-c299-ed616f4088bc", Address: "cd1d6f5a-f4eb-9370-c299-ed616f4088bc"}, {Suffrage: 0, ID: "server-0d1dd65d-858f-fbb3-1b62-243f09e9de14", Address: "0d1dd65d-858f-fbb3-1b62-243f09e9de14"}, {Suffrage: 0, ID: "server-e48259d1-f881-e4df-a8b2-06c6fc1a409e", Address: "e48259d1-f881-e4df-a8b2-06c6fc1a409e"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464323336653730382d666366652d363133322d613639662d363938663032633039373364a24944da002b7365727665722d64323336653730382d666366652d363133322d613639662d363938663032633039373364a853756666726167650083a741646472657373da002431396133303538642d636336662d303434332d353832302d323764356136376630393134a24944da002b7365727665722d31396133303538642d636336662d303434332d353832302d323764356136376630393134a853756666726167650083a741646472657373da002430306430656634332d326333322d363135352d643061362d383262343861393461353233a24944da002b7365727665722d30306430656634332d326333322d363135352d643061362d383262343861393461353233a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d236e708-fcfe-6132-a69f-698f02c0973d", Address: "d236e708-fcfe-6132-a69f-698f02c0973d"}, {Suffrage: 0, ID: "server-19a3058d-cc6f-0443-5820-27d5a67f0914", Address: "19a3058d-cc6f-0443-5820-27d5a67f0914"}, {Suffrage: 0, ID: "server-00d0ef43-2c32-6155-d0a6-82b48a94a523", Address: "00d0ef43-2c32-6155-d0a6-82b48a94a523"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464323834653864632d656163372d326431302d323861622d666163666664643937316336a24944da002b7365727665722d64323834653864632d656163372d326431302d323861622d666163666664643937316336a853756666726167650083a741646472657373da002439623534386462312d353133632d333762622d393562632d313836656532323631623062a24944da002b7365727665722d39623534386462312d353133632d333762622d393562632d313836656532323631623062a853756666726167650083a741646472657373da002435303237653835612d326566312d336236332d303532612d633637343335386262306163a24944da002b7365727665722d35303237653835612d326566312d336236332d303532612d633637343335386262306163a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d284e8dc-eac7-2d10-28ab-facffdd971c6", Address: "d284e8dc-eac7-2d10-28ab-facffdd971c6"}, {Suffrage: 0, ID: "server-9b548db1-513c-37bb-95bc-186ee2261b0b", Address: "9b548db1-513c-37bb-95bc-186ee2261b0b"}, {Suffrage: 0, ID: "server-5027e85a-2ef1-3b63-052a-c674358bb0ac", Address: "5027e85a-2ef1-3b63-052a-c674358bb0ac"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464343139653731352d663261632d666534612d303530332d356466336334393031636363a24944da002b7365727665722d64343139653731352d663261632d666534612d303530332d356466336334393031636363a853756666726167650083a741646472657373da002433653434383833382d353638622d346134362d396235632d643161343633346638303233a24944da002b7365727665722d33653434383833382d353638622d346134362d396235632d643161343633346638303233a853756666726167650083a741646472657373da002462616431656237632d616639352d373234342d613265622d643962653365646532303937a24944da002b7365727665722d62616431656237632d616639352d373234342d613265622d643962653365646532303937a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d419e715-f2ac-fe4a-0503-5df3c4901ccc", Address: "d419e715-f2ac-fe4a-0503-5df3c4901ccc"}, {Suffrage: 0, ID: "server-3e448838-568b-4a46-9b5c-d1a4634f8023", Address: "3e448838-568b-4a46-9b5c-d1a4634f8023"}, {Suffrage: 0, ID: "server-bad1eb7c-af95-7244-a2eb-d9be3ede2097", Address: "bad1eb7c-af95-7244-a2eb-d9be3ede2097"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465356434323461392d373564302d613732312d623461332d343833333364616361626362a24944da002465356434323461392d373564302d613732312d623461332d343833333364616361626362a853756666726167650083a741646472657373da002464653066366332332d633337342d316131622d366564312d643330336563303563616337a24944da002464653066366332332d633337342d316131622d366564312d643330336563303563616337a853756666726167650083a741646472657373da002464326139336434662d376164312d643236622d333231632d323134393532396332363661a24944da002464326139336434662d376164312d643236622d333231632d323134393532396332363661a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "e5d424a9-75d0-a721-b4a3-48333dacabcb", Address: "e5d424a9-75d0-a721-b4a3-48333dacabcb"}, {Suffrage: 0, ID: "de0f6c23-c374-1a1b-6ed1-d303ec05cac7", Address: "de0f6c23-c374-1a1b-6ed1-d303ec05cac7"}, {Suffrage: 0, ID: "d2a93d4f-7ad1-d26b-321c-2149529c266a", Address: "d2a93d4f-7ad1-d26b-321c-2149529c266a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465376537396462362d653039352d643462612d316566302d623061306234363237313164a24944da002b7365727665722d65376537396462362d653039352d643462612d316566302d623061306234363237313164a853756666726167650083a741646472657373da002463353162643133382d636334622d333332312d396630352d316566313437323735383065a24944da002b7365727665722d63353162643133382d636334622d333332312d396630352d316566313437323735383065a853756666726167650083a741646472657373da002431326461323134322d383037362d323135312d653339662d336339323062643163373761a24944da002b7365727665722d31326461323134322d383037362d323135312d653339662d336339323062643163373761a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e7e79db6-e095-d4ba-1ef0-b0a0b462711d", Address: "e7e79db6-e095-d4ba-1ef0-b0a0b462711d"}, {Suffrage: 0, ID: "server-c51bd138-cc4b-3321-9f05-1ef14727580e", Address: "c51bd138-cc4b-3321-9f05-1ef14727580e"}, {Suffrage: 0, ID: "server-12da2142-8076-2151-e39f-3c920bd1c77a", Address: "12da2142-8076-2151-e39f-3c920bd1c77a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465393531626433362d386339342d386263612d623461632d366634663536636530316630a24944da002b7365727665722d65393531626433362d386339342d386263612d623461632d366634663536636530316630a853756666726167650083a741646472657373da002436356539393435662d336230622d663036302d613266362d313830643064613337373766a24944da002b7365727665722d36356539393435662d336230622d663036302d613266362d313830643064613337373766a853756666726167650083a741646472657373da002465613833393563312d346130642d613330642d633163662d326135663836666462333133a24944da002b7365727665722d65613833393563312d346130642d613330642d633163662d326135663836666462333133a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e951bd36-8c94-8bca-b4ac-6f4f56ce01f0", Address: "e951bd36-8c94-8bca-b4ac-6f4f56ce01f0"}, {Suffrage: 0, ID: "server-65e9945f-3b0b-f060-a2f6-180d0da3777f", Address: "65e9945f-3b0b-f060-a2f6-180d0da3777f"}, {Suffrage: 0, ID: "server-ea8395c1-4a0d-a30d-c1cf-2a5f86fdb313", Address: "ea8395c1-4a0d-a30d-c1cf-2a5f86fdb313"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465613461396665642d343662622d313939372d393665642d373263656338333761643331a24944da002b7365727665722d65613461396665642d343662622d313939372d393665642d373263656338333761643331a853756666726167650083a741646472657373da002466383938326538642d663839392d313138322d376264352d353361633331626661356633a24944da002b7365727665722d66383938326538642d663839392d313138322d376264352d353361633331626661356633a853756666726167650083a741646472657373da002463626534663739652d333834342d643439372d303336632d353532313330393532633037a24944da002b7365727665722d63626534663739652d333834342d643439372d303336632d353532313330393532633037a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-ea4a9fed-46bb-1997-96ed-72cec837ad31", Address: "ea4a9fed-46bb-1997-96ed-72cec837ad31"}, {Suffrage: 0, ID: "server-f8982e8d-f899-1182-7bd5-53ac31bfa5f3", Address: "f8982e8d-f899-1182-7bd5-53ac31bfa5f3"}, {Suffrage: 0, ID: "server-cbe4f79e-3844-d497-036c-552130952c07", Address: "cbe4f79e-3844-d497-036c-552130952c07"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465626237363962332d386561392d313733322d653531332d653166313636303639663736a24944da002465626237363962332d386561392d313733322d653531332d653166313636303639663736a853756666726167650083a741646472657373da002437663666303034622d613162322d636536632d333030382d343935326432663565343930a24944da002437663666303034622d613162322d636536632d333030382d343935326432663565343930a853756666726167650083a741646472657373da002433383661393863352d323432652d653638612d343365662d623865383438393932653536a24944da002b7365727665722d33383661393863352d323432652d653638612d343365662d623865383438393932653536a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "ebb769b3-8ea9-1732-e513-e1f166069f76", Address: "ebb769b3-8ea9-1732-e513-e1f166069f76"}, {Suffrage: 0, ID: "7f6f004b-a1b2-ce6c-3008-4952d2f5e490", Address: "7f6f004b-a1b2-ce6c-3008-4952d2f5e490"}, {Suffrage: 0, ID: "server-386a98c5-242e-e68a-43ef-b8e848992e56", Address: "386a98c5-242e-e68a-43ef-b8e848992e56"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466313362663738322d646366652d653632352d376166372d653530393866636462623338a24944da002b7365727665722d66313362663738322d646366652d653632352d376166372d653530393866636462623338a853756666726167650083a741646472657373da002434353364653361392d393838302d636662652d376237392d646663353238623864666334a24944da002b7365727665722d34353364653361392d393838302d636662652d376237392d646663353238623864666334a853756666726167650083a741646472657373da002464366634666665322d363338372d316132362d363961312d316232656530653837393565a24944da002b7365727665722d64366634666665322d363338372d316132362d363961312d316232656530653837393565a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f13bf782-dcfe-e625-7af7-e5098fcdbb38", Address: "f13bf782-dcfe-e625-7af7-e5098fcdbb38"}, {Suffrage: 0, ID: "server-453de3a9-9880-cfbe-7b79-dfc528b8dfc4", Address: "453de3a9-9880-cfbe-7b79-dfc528b8dfc4"}, {Suffrage: 0, ID: "server-d6f4ffe2-6387-1a26-69a1-1b2ee0e8795e", Address: "d6f4ffe2-6387-1a26-69a1-1b2ee0e8795e"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466333333613135392d653934352d653131372d613762662d333462393163613232643437a24944da002b7365727665722d66333333613135392d653934352d653131372d613762662d333462393163613232643437a853756666726167650083a741646472657373da002463303531653363642d393531352d333162642d666630662d656632353032346131373537a24944da002b7365727665722d63303531653363642d393531352d333162642d666630662d656632353032346131373537a853756666726167650083a741646472657373da002432653434613239642d653431632d336332362d393638362d343632623532626465396238a24944da002b7365727665722d32653434613239642d653431632d336332362d393638362d343632623532626465396238a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f333a159-e945-e117-a7bf-34b91ca22d47", Address: "f333a159-e945-e117-a7bf-34b91ca22d47"}, {Suffrage: 0, ID: "server-c051e3cd-9515-31bd-ff0f-ef25024a1757", Address: "c051e3cd-9515-31bd-ff0f-ef25024a1757"}, {Suffrage: 0, ID: "server-2e44a29d-e41c-3c26-9686-462b52bde9b8", Address: "2e44a29d-e41c-3c26-9686-462b52bde9b8"}}}},
	{"Configuration", "81a7536572766572739483a741646472657373da002433376239383163332d343861322d373938392d303466612d323364353835333932653137a24944da002b7365727665722d33376239383163332d343861322d373938392d303466612d323364353835333932653137a853756666726167650083a741646472657373da002431653939613433342d656461302d616139642d336362312d363562396335313630323430a24944da002b7365727665722d31653939613433342d656461302d616139642d336362312d363562396335313630323430a853756666726167650083a741646472657373da002432303736623861362d383961612d646137342d613839622d333433313031306164353139a24944da002b7365727665722d32303736623861362d383961612d646137342d613839622d333433313031306164353139a853756666726167650083a741646472657373da002436633062653330372d393864632d626564342d363734302d323937656666376335366334a24944da002b7365727665722d36633062653330372d393864632d626564342d363734302d323937656666376335366334a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-37b981c3-48a2-7989-04fa-23d585392e17", Address: "37b981c3-48a2-7989-04fa-23d585392e17"}, {Suffrage: 0, ID: "server-1e99a434-eda0-aa9d-3cb1-65b9c5160240", Address: "1e99a434-eda0-aa9d-3cb1-65b9c5160240"}, {Suffrage: 0, ID: "server-2076b8a6-89aa-da74-a89b-3431010ad519", Address: "2076b8a6-89aa-da74-a89b-3431010ad519"}, {Suffrage: 0, ID: "server-6c0be307-98dc-bed4-6740-297eff7c56c4", Address: "6c0be307-98dc-bed4-6740-297eff7c56c4"}}}},
	{"Configuration", "81a7536572766572739783a741646472657373da002430643266663134342d636264312d633431312d323632652d393138636466373038373539a24944da002b7365727665722d30643266663134342d636264312d633431312d323632652d393138636466373038373539a853756666726167650083a741646472657373da002466666432656536322d636565632d336166362d356665612d346666626637313166353430a24944da002b7365727665722d66666432656536322d636565632d336166362d356665612d346666626637313166353430a853756666726167650083a741646472657373da002464386132633834642d383338322d613132342d383834382d613831343934396661386536a24944da002b7365727665722d64386132633834642d383338322d613132342d383834382d613831343934396661386536a853756666726167650083a741646472657373da002465663036653661392d643335372d626635312d386363312d663061646165373535613239a24944da002b7365727665722d65663036653661392d643335372d626635312d386363312d663061646165373535613239a853756666726167650083a741646472657373da002439623333616162662d653565652d613061302d623130392d376563373037316162343534a24944da002b7365727665722d39623333616162662d653565652d613061302d623130392d376563373037316162343534a853756666726167650083a741646472657373da002465623438653838332d613135322d333565612d326135662d643232663365613837633733a24944da002b7365727665722d65623438653838332d613135322d333565612d326135662d643232663365613837633733a853756666726167650083a741646472657373da002434343436663833662d623433352d666131392d316136342d633238633233363239633761a24944da002b7365727665722d34343436663833662d623433352d666131392d316136342d633238633233363239633761a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0d2ff144-cbd1-c411-262e-918cdf708759", Address: "0d2ff144-cbd1-c411-262e-918cdf708759"}, {Suffrage: 0, ID: "server-ffd2ee62-ceec-3af6-5fea-4ffbf711f540", Address: "ffd2ee62-ceec-3af6-5fea-4ffbf711f540"}, {Suffrage: 0, ID: "server-d8a2c84d-8382-a124-8848-a814949fa8e6", Address: "d8a2c84d-8382-a124-8848-a814949fa8e6"}, {Suffrage: 0, ID: "server-ef06e6a9-d357-bf51-8cc1-f0adae755a29", Address: "ef06e6a9-d357-bf51-8cc1-f0adae755a29"}, {Suffrage: 0, ID: "server-9b33aabf-e5ee-a0a0-b109-7ec7071ab454", Address: "9b33aabf-e5ee-a0a0-b109-7ec7071ab454"}, {Suffrage: 0, ID: "server-eb48e883-a152-35ea-2a5f-d22f3ea87c73", Address: "eb48e883-a152-35ea-2a5f-d22f3ea87c73"}, {Suffrage: 0, ID: "server-4446f83f-b435-fa19-1a64-c28c23629c7a", Address: "4446f83f-b435-fa19-1a64-c28c23629c7a"}}}},
}
