
from numpy import nan

xpoints  = [0.55, 0.65, 0.75, 0.85, 0.95, 1.05, 1.15, 1.25, 1.35, 1.45, 1.55, 1.65, 1.75, 1.85, 1.9500000000000002, 2.05, 2.1500000000000004, 2.25, 2.3500000000000005, 2.45, 2.625, 2.875, 3.125, 3.375, 3.75, 4.25, 4.75, 5.5, 6.5, 7.5, 8.5, 9.5, 12.5, 17.5, 25.0, 40.0]
xedges   = [0.5, 0.6, 0.7, 0.7999999999999999, 0.8999999999999999, 1.0, 1.0999999999999999, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7000000000000002, 1.8, 1.9000000000000001, 2.0, 2.1, 2.2, 2.3000000000000003, 2.4, 2.5, 2.75, 3.0, 3.25, 3.5, 4.0, 4.5, 5.0, 6.0, 7.0, 7.999999999999999, 9.0, 10.0, 15.000000000000002, 20.0, 30.0, 50.0]
xmins    = [0.5, 0.6, 0.7, 0.7999999999999999, 0.8999999999999999, 1.0, 1.0999999999999999, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7000000000000002, 1.8, 1.9000000000000001, 2.0, 2.1, 2.2, 2.3000000000000003, 2.4, 2.5, 2.75, 3.0, 3.25, 3.5, 4.0, 4.5, 5.0, 6.0, 7.0, 7.999999999999999, 9.0, 10.0, 15.000000000000002, 20.0, 30.0]
xmaxs    = [0.6000000000000001, 0.7000000000000001, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4000000000000001, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.1, 2.2, 2.3000000000000003, 2.4000000000000004, 2.5, 2.75, 3.0, 3.25, 3.5, 4.0, 4.5, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 15.0, 20.0, 30.0, 50.0]
xerrs = [
  [abs(xpoints[i] - xmins[i])   for i in range(len(xpoints))],
  [abs(xmaxs[i]   - xpoints[i]) for i in range(len(xpoints))]
]

ref_yvals = [2.128, 1.391, 0.939, 0.6502, 0.4597, 0.3309, 0.2422, 0.1792, 0.1346, 0.102, 0.07812, 0.06025, 0.047, 0.03694, 0.02915, 0.02319, 0.01857, 0.01493, 0.01211, 0.009884, 0.007001, 0.004375, 0.002804, 0.001833, 0.001035, 0.0005015, 0.0002612, 0.0001131, 4.077e-05, 1.722e-05, 8.044e-06, 4.128e-06, 1.003e-06, 1.123e-07, 1.554e-08, 1.08e-09]
ref_errminus = [0.052, 0.033, 0.0223009, 0.01510033, 0.01060047, 0.007500667, 0.005400926, 0.00400125, 0.003, 0.0022, 0.001690266, 0.001300154, 0.001010198, 0.0007902531, 0.0006200806, 0.000490102, 0.0003901282, 0.0003101612, 0.0002501999, 0.0002080865, 0.0001440555, 9.004999e-05, 5.703508e-05, 3.80526e-05, 2.10238e-05, 1.021225e-05, 5.408327e-06, 2.308679e-06, 7.851751e-07, 3.535534e-07, 4.518683e-07, 2.167487e-07, 1.390575e-07, 1.522104e-08, 3.556206e-09, 3.351612e-10]
ref_errplus = [0.052, 0.033, 0.0223009, 0.01510033, 0.01060047, 0.007500667, 0.005400926, 0.00400125, 0.003, 0.0022, 0.001690266, 0.001300154, 0.001010198, 0.0007902531, 0.0006200806, 0.000490102, 0.0003901282, 0.0003101612, 0.0002501999, 0.0002080865, 0.0001440555, 9.004999e-05, 5.703508e-05, 3.80526e-05, 2.10238e-05, 1.021225e-05, 5.408327e-06, 2.308679e-06, 7.851751e-07, 3.535534e-07, 4.518683e-07, 2.167487e-07, 1.0008e-07, 1.082959e-08, 1.901631e-09, 1.144902e-10]
ref_errs = [ref_errminus, ref_errplus]

yvals = {
  'curve1' : [2.4987840000000006, 1.6047310000000004, 1.045598999999999, 0.6942176000000001, 0.4756194000000001, 0.33397249999999973, 0.24195890000000034, 0.17788629999999983, 0.13381310000000018, 0.10181409999999991, 0.07818242999999994, 0.06042755000000009, 0.04729140999999996, 0.03696175000000005, 0.029260549999999972, 0.023346259999999976, 0.018830219999999984, 0.015227150000000054, 0.01218044999999999, 0.00987369299999999, 0.007059432, 0.004358312, 0.0027604248, 0.0018101416, 0.0010040978, 0.0004862838, 0.0002430424, 0.0001097214, 3.942202e-05, 1.663047e-05, 7.543211e-06, 3.691567e-06, 9.755506e-07, 1.1596506e-07, 1.466538e-08, 5.509615e-10],
  'curve2' : [3.446330000000001, 2.2509150000000004, 1.4990129999999986, 1.0229190000000004, 0.7178138000000002, 0.5181237999999995, 0.3825823000000005, 0.28874719999999976, 0.22128960000000028, 0.17118959999999983, 0.13432919999999987, 0.10594670000000014, 0.08423273999999992, 0.06734046000000009, 0.05419723999999995, 0.043470079999999967, 0.035075319999999965, 0.0286625500000001, 0.02320761999999998, 0.018990119999999985, 0.013569064, 0.0084655, 0.005301244, 0.0033925056, 0.001856305, 0.0008546022, 0.00041577, 0.0001671095, 5.619946e-05, 2.165944e-05, 9.753354e-06, 5.273537e-06, 1.1525032e-06, 1.2706868e-07, 1.408594e-08, 7.865785e-10],
}
yedges = {
  'curve1' : [2.4987840000000006, 2.4987840000000006, 1.6047310000000004, 1.045598999999999, 0.6942176000000001, 0.4756194000000001, 0.33397249999999973, 0.24195890000000034, 0.17788629999999983, 0.13381310000000018, 0.10181409999999991, 0.07818242999999994, 0.06042755000000009, 0.04729140999999996, 0.03696175000000005, 0.029260549999999972, 0.023346259999999976, 0.018830219999999984, 0.015227150000000054, 0.01218044999999999, 0.00987369299999999, 0.007059432, 0.004358312, 0.0027604248, 0.0018101416, 0.0010040978, 0.0004862838, 0.0002430424, 0.0001097214, 3.942202e-05, 1.663047e-05, 7.543211e-06, 3.691567e-06, 9.755506e-07, 1.1596506e-07, 1.466538e-08, 5.509615e-10],
  'curve2' : [3.446330000000001, 3.446330000000001, 2.2509150000000004, 1.4990129999999986, 1.0229190000000004, 0.7178138000000002, 0.5181237999999995, 0.3825823000000005, 0.28874719999999976, 0.22128960000000028, 0.17118959999999983, 0.13432919999999987, 0.10594670000000014, 0.08423273999999992, 0.06734046000000009, 0.05419723999999995, 0.043470079999999967, 0.035075319999999965, 0.0286625500000001, 0.02320761999999998, 0.018990119999999985, 0.013569064, 0.0084655, 0.005301244, 0.0033925056, 0.001856305, 0.0008546022, 0.00041577, 0.0001671095, 5.619946e-05, 2.165944e-05, 9.753354e-06, 5.273537e-06, 1.1525032e-06, 1.2706868e-07, 1.408594e-08, 7.865785e-10],
}
yups = {
  'curve1' : [0.0018507187792854971, 0.0013629042519560943, 0.0010234480934566237, 0.0007829315423458172, 0.0006127014770669319, 0.0004881975010177742, 0.00039694483243896806, 0.0003263979166600176, 0.000272363195017242, 0.0002292046465497589, 0.00019424288918773818, 0.0001655057098712914, 0.00014215734240622242, 0.00012222479290225876, 0.00010592176358048417, 9.226811475260553e-05, 8.09132065858225e-05, 7.112273194977844e-05, 6.223983451134807e-05, 5.488136295683622e-05, 2.841136392361338e-05, 2.1321384570426002e-05, 1.627221927089234e-05, 1.2676422208178458e-05, 6.356241027525624e-06, 4.151059623758734e-06, 2.7733661857028544e-06, 1.2325100405270538e-06, 6.777284116812575e-07, 4.086037200026451e-07, 2.5857579159697067e-07, 1.707199168228476e-07, 3.559231939618434e-08, 1.0163302612832111e-08, 2.177303607676247e-09, 2.4918552325526455e-10],
  'curve2' : [0.002100770572908903, 0.0015601781949508206, 0.0011844606367456866, 0.0009185477124243468, 0.0007275521974401564, 0.0005877552211592844, 0.00048246906636591804, 0.0004019659189533358, 0.00033856520789945366, 0.00028728689493257405, 0.00024611584670638316, 0.000211827146513378, 0.00018339108484329312, 0.00015947761598418777, 0.0001393462234866807, 0.00012170780583019305, 0.0001067507845404425, 9.43291842432662e-05, 8.304964780178172e-05, 7.357208709830102e-05, 3.807276822086883e-05, 2.8728224449137122e-05, 2.1798172400455965e-05, 1.6775582255170756e-05, 8.35548682004825e-06, 5.320043232907041e-06, 3.50761400384934e-06, 1.4715114678452218e-06, 7.824924280783808e-07, 4.51367256233768e-07, 2.842169593813853e-07, 1.9758590536776652e-07, 3.76232321843831e-08, 1.0304303955144181e-08, 2.0694385712071765e-09, 2.804917111074764e-10],
}
ydowns = {
  'curve1' : [0.0018507187792854971, 0.0013629042519560943, 0.0010234480934566237, 0.0007829315423458172, 0.0006127014770669319, 0.0004881975010177742, 0.00039694483243896806, 0.0003263979166600176, 0.000272363195017242, 0.0002292046465497589, 0.00019424288918773818, 0.0001655057098712914, 0.00014215734240622242, 0.00012222479290225876, 0.00010592176358048417, 9.226811475260553e-05, 8.09132065858225e-05, 7.112273194977844e-05, 6.223983451134807e-05, 5.488136295683622e-05, 2.841136392361338e-05, 2.1321384570426002e-05, 1.627221927089234e-05, 1.2676422208178458e-05, 6.356241027525624e-06, 4.151059623758734e-06, 2.7733661857028544e-06, 1.2325100405270538e-06, 6.777284116812575e-07, 4.086037200026451e-07, 2.5857579159697067e-07, 1.707199168228476e-07, 3.559231939618434e-08, 1.0163302612832111e-08, 2.177303607676247e-09, 2.4918552325526455e-10],
  'curve2' : [0.002100770572908903, 0.0015601781949508206, 0.0011844606367456866, 0.0009185477124243468, 0.0007275521974401564, 0.0005877552211592844, 0.00048246906636591804, 0.0004019659189533358, 0.00033856520789945366, 0.00028728689493257405, 0.00024611584670638316, 0.000211827146513378, 0.00018339108484329312, 0.00015947761598418777, 0.0001393462234866807, 0.00012170780583019305, 0.0001067507845404425, 9.43291842432662e-05, 8.304964780178172e-05, 7.357208709830102e-05, 3.807276822086883e-05, 2.8728224449137122e-05, 2.1798172400455965e-05, 1.6775582255170756e-05, 8.35548682004825e-06, 5.320043232907041e-06, 3.50761400384934e-06, 1.4715114678452218e-06, 7.824924280783808e-07, 4.51367256233768e-07, 2.842169593813853e-07, 1.9758590536776652e-07, 3.76232321843831e-08, 1.0304303955144181e-08, 2.0694385712071765e-09, 2.804917111074764e-10],
}
variation_yvals = {
}


# lists for ratio plot
ratio0_ref_errminus = [0.02443609022556391, 0.02372393961179008, 0.023749627263045792, 0.02322413103660412, 0.023059538829671527, 0.02266747355696585, 0.022299446738232868, 0.022328404017857142, 0.022288261515601784, 0.021568627450980395, 0.02163678955453149, 0.02157931950207469, 0.021493574468085103, 0.021392883053600435, 0.02127206174957118, 0.021134195774040535, 0.021008519116855143, 0.02077436034829203, 0.020660602807597028, 0.021052863213273976, 0.02057641765462077, 0.020582854857142858, 0.02034061340941512, 0.020759738134206222, 0.020312850241545895, 0.020363409770687936, 0.020705692955589588, 0.020412723253757738, 0.019258648516065735, 0.020531556329849012, 0.05617457732471408, 0.05250695251937984, 0.13864157527417748, 0.13553909171861087, 0.22884208494208497, 0.3103344444444444]
ratio0_ref_errplus  = [0.02443609022556391, 0.02372393961179008, 0.023749627263045792, 0.02322413103660412, 0.023059538829671527, 0.02266747355696585, 0.022299446738232868, 0.022328404017857142, 0.022288261515601784, 0.021568627450980395, 0.02163678955453149, 0.02157931950207469, 0.021493574468085103, 0.021392883053600435, 0.02127206174957118, 0.021134195774040535, 0.021008519116855143, 0.02077436034829203, 0.020660602807597028, 0.021052863213273976, 0.02057641765462077, 0.020582854857142858, 0.02034061340941512, 0.020759738134206222, 0.020312850241545895, 0.020363409770687936, 0.020705692955589588, 0.020412723253757738, 0.019258648516065735, 0.020531556329849012, 0.05617457732471408, 0.05250695251937984, 0.09978065802592223, 0.09643446126447017, 0.12237007722007723, 0.10600944444444445]
ratio0_ref_errs     = [ratio0_ref_errminus, ratio0_ref_errplus]

ratio0_yvals = {
  'curve1' : [1.1742406015037596, 1.1742406015037596, 1.153652767792955, 1.1135239616613408, 1.0676985542909876, 1.034629976071351, 1.0092852825627068, 0.9990045417010749, 0.9926690848214277, 0.994153789004459, 0.9981774509803913, 1.0007991551459288, 1.0029468879668064, 1.0062002127659566, 1.0005887926367094, 1.0037924528301878, 1.0067382492453634, 1.0140129240710816, 1.0199028801071703, 1.005817506193228, 0.9989572035613102, 1.008346236251964, 0.9961855999999998, 0.9844596291012838, 0.987529514457174, 0.9701428019323673, 0.9696586241276172, 0.9304839203675345, 0.9701273209549072, 0.9669369634535198, 0.9657648083623693, 0.9377437841869717, 0.8942749515503876, 0.972632701894317, 1.0326363312555653, 0.9437181467181468, 0.510149537037037],
  'curve2' : [1.6195159774436094, 1.6195159774436094, 1.6181991373112872, 1.596392971246005, 1.5732374653952634, 1.5614831411790302, 1.5658017527954047, 1.5796131296449236, 1.6113124999999986, 1.6440534918276395, 1.6783294117647043, 1.719523809523808, 1.7584514522821602, 1.7921859574468066, 1.8229685977260446, 1.8592535162950241, 1.8745183268650267, 1.8888163704900358, 1.9197957133288746, 1.916401321222129, 1.9212990692027503, 1.9381608341665477, 1.9349714285714286, 1.8906005706134095, 1.85079410801964, 1.7935314009661838, 1.7040921236291127, 1.5917687595712098, 1.4775375773651638, 1.3784513122393918, 1.257807200929152, 1.2125004972650424, 1.2775041182170541, 1.149056031904287, 1.1315109528049865, 0.9064311454311456, 0.728313425925926],
}
ratio0_yups = {
  'curve1' : [1.175110300178236, 1.154632569555684, 1.1146138957331797, 1.0689026938516546, 1.0359628050403895, 1.010760645213108, 1.0006434551298071, 0.994490501767075, 0.9961772897103821, 1.0004245553583302, 1.003285623261491, 1.0056938707032594, 1.009224837072472, 1.0038975309394238, 1.0074261325413536, 1.0107170381523323, 1.018370124210329, 1.024666626386459, 1.0109570466153046, 1.0045097493885904, 1.0124044227858324, 1.001059059330383, 0.9902628456743552, 0.9944451839651819, 0.976284097611136, 0.9779359115129787, 0.9411017082147889, 0.9810248456280023, 0.9835601768869576, 0.9894932473869132, 0.9698889596714285, 0.9356315205481703, 1.0081185637050691, 1.1231376902300276, 1.0838277739817406, 0.7408768733845043],
  'curve2' : [1.620503181660202, 1.6193207607440339, 1.5976543776749141, 1.5746501810403333, 1.563065808565239, 1.5675779849536378, 1.5816051571691427, 1.6135556133870153, 1.6465688351255554, 1.6811459499503179, 1.7226742939926558, 1.761967255543793, 1.796087895422196, 1.827285804439206, 1.8640338327096615, 1.8797666151716326, 1.8945649318546263, 1.9261138100631858, 1.9232592607598484, 1.928742623138232, 1.9435990241709569, 1.9415378798740883, 1.898374526533686, 1.8599460896100222, 1.8016043350918343, 1.7147003853098843, 1.605197603383803, 1.4905482888403645, 1.397644160610213, 1.284019004427048, 1.2478332868450255, 1.3253689208739745, 1.1865667319884177, 1.2232678891820494, 1.0395996506568326, 0.9880279732476633],
}
ratio0_ydowns = {
  'curve1' : [1.1733709028292834, 1.152672966030226, 1.1124340275895022, 1.0664944147303204, 1.0332971471023127, 1.0078099199123056, 0.9973656282723427, 0.9908476678757803, 0.9921302882985359, 0.9959303466024525, 0.9983126870303662, 1.0001999052303534, 1.003175588459441, 0.9972800543339954, 1.0001587731190218, 1.0027594603383947, 1.0096557239318342, 1.0151391338278817, 1.0006779657711513, 0.9934046577340302, 1.0042880497180955, 0.9913121406696167, 0.9786564125282124, 0.9806138449491661, 0.9640015062535987, 0.9613813367422558, 0.91986613252028, 0.9592297962818122, 0.9503137500200819, 0.9420363693378254, 0.905598608702515, 0.8529183825526047, 0.937146840083565, 0.9421349722811031, 0.803608519454553, 0.27942220068956986],
  'curve2' : [1.6185287732270168, 1.6170775138785403, 1.5951315648170958, 1.5718247497501938, 1.5599004737928215, 1.5640255206371718, 1.5776211021207043, 1.6090693866129822, 1.6415381485297238, 1.675512873579091, 1.7163733250549602, 1.7549356490205272, 1.7882840194714176, 1.8186513910128832, 1.8544731998803867, 1.8692700385584207, 1.8830678091254456, 1.9134776165945633, 1.9095433816844096, 1.9138555152672685, 1.9327226441621383, 1.9284049772687688, 1.8828266146931327, 1.8416421264292575, 1.785458466840533, 1.6934838619483408, 1.5783399157586167, 1.4645268658899628, 1.3592584638685705, 1.2315953974312561, 1.177167707685059, 1.229639315560134, 1.1115453318201565, 1.0397540164279235, 0.7732626402054585, 0.4685988786041886],
}
ratio0_variation_vals = {
}