// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {

  /// @brief Measurement of beauty and charm production iat 5 TeV
  class ALICE_2021_I1848990 : public Analysis {
  public:

    RIVET_DEFAULT_ANALYSIS_CTOR(ALICE_2021_I1848990);

    void init() {

      const UnstableParticles fs(Cuts::absrap < 0.5);
      declare(fs, "fs");

      book(_h_D0_npm,1,1,1);                                                                // non-prompt D0 production cross section
      book(_h_Dplus_npm,2,1,1);                                                             // non-prompt D+ production cross section
      book(_h_DS_npm,3,1,1);                                                                // non-prompt DS+ production cross section
      book(_h_D0_pm,4,1,1);                                                                 // prompt D0 production cross section
      book(_h_Dplus_pm,5,1,1);                                                              // prompt D+ production cross section
      book(_h_DS_pm,6,1,1);                                                                 // prompt DS+ production cross section


      book(_h_ratioD0,7,1,1);                                                               // ratio of production cross-section between non-prompt D0 and prompt D0
      book(_h_D0_pm_dummy,"TMP/_h_D0_pm_dummy",refData(7,1,1));                             // prompt D0 production cross section

      book(_h_ratioDplus,8,1,1);                                                            // ratio of production cross-section between non-prompt D+ and prompt D+
      book(_h_Dplus_pm_dummy,"TMP/_h_Dplus_pm_dummy",refData(8,1,1));                       // prompt D+ production cross section

      book(_h_ratioDS,9,1,1);                                                               // ratio of production cross-section between non-prompt DS+ and prompt DS+
      book(_h_DS_pm_dummy,"TMP/_h_DS_pm_dummy",refData(9,1,1));                             // prompt DS+ production cross section

      book(_h_ratio_pm_DplusD0,10,1,1);                                                     // ratio of production cross-section between prompt D+ and prompt D0
      book(_h_D0_pm_dummy2,"TMP/_h_D0_pm_dummy2",refData(10,1,1));                          // prompt D0 production cross section

      book(_h_ratio_npm_DplusD0,11,1,1);                                                    // ratio of production cross-section between non-prompt D+ and non-prompt D0
      book(_h_D0_npm_dummy,"TMP/_h_D0_npm_dummy",refData(11,1,1));                          // non-prompt D0 production cross section

      book(_h_ratio_pm_DS_DplusD0,12,1,1);                                                  // ratio of production cross-section between prompt DS+ and sum of prompt D0 and prompt D+
      book(_h_DplusD0_pm_sum_dummy,"TMP/_h_RatioDplusD0_pm_sum_dummy",refData(12,1,1));     // sum of prompt D0 and prompt D+ production cross section

      book(_h_ratio_npm_DS_DplusD0,13,1,1);                                                 // ratio of production cross-section between non-prompt DS+ and sum of non-prompt D0 and non-prompt D+
      book(_h_DplusD0_npm_sum_dummy,"TMP/_h_RatioDplusD0_npm_sum_dummy",refData(13,1,1));   // sum of non-prompt D0 and non-prompt D+ production cross section

      book(_h_Charmfrag, 14,1,1);                                                           // Charm-quark fragmentation-fraction ratio
      book(_h_DS_fpm_dummy,"TMP/_h_DS_fpm_dummy",refData(14,1,1));                          // prompt DS+ pt-integrated production
      book(_h_DpD0_fpm_dummy,"TMP/_h_DpD0_fpm_dummy",refData(14,1,1));                      // sum of prompt D0 and prompt D+ pt-integrated production

      book(_h_Beautyfrag, 15,1,1);                                                          // Beauty-quark fragmentation-fraction ratio
      book(_h_DS_fnpm_dummy,"TMP/_h_DS_fnpm_dummy",refData(15,1,1));                        // non-prompt DS+ pt-integrated production
      book(_h_DpD0_fnpm_dummy,"TMP/_h_DpD0_fbpm_dummy",refData(15,1,1));                    // sum of non-prompt D0 and non-prompt D+ pt-integrated production

    }

    void analyze(const Event& event) {

      const UnstableParticles& fs = apply<UnstableParticles>(event, "fs");

      for (const Particle& p : fs.particles()) {
        if (p.fromBottom()){
          if(p.abspid()== 421){
            _h_D0_npm->fill(p.pT()/GeV);
            _h_D0_npm_dummy->fill(p.pT()/GeV);
            _h_DplusD0_npm_sum_dummy->fill(p.pT()/GeV);

            if(p.pT() >= 2){
              _h_DpD0_fnpm_dummy->fill(1);
            }
          }

          else if(p.abspid()== 411){
            _h_Dplus_npm->fill(p.pT()/GeV);
            _h_DplusD0_npm_sum_dummy->fill(p.pT()/GeV);

            if(p.pT() >= 2){
              _h_DpD0_fnpm_dummy->fill(1);
            }
          }

          else if(p.abspid()== 431){
            _h_DS_npm->fill(p.pT()/GeV);

            if(p.pT() >= 2){
              _h_DS_fnpm_dummy->fill(1);
            }
          }
        }

        else{
          if(p.abspid()== 421){
            _h_D0_pm->fill(p.pT()/GeV);
            _h_D0_pm_dummy->fill(p.pT()/GeV);
            _h_D0_pm_dummy2->fill(p.pT()/GeV);
            _h_DplusD0_pm_sum_dummy->fill(p.pT()/GeV);

            if(p.pT() >= 1){
              _h_DpD0_fpm_dummy->fill(1);
            }
          }

          else if(p.abspid()== 411){
            _h_Dplus_pm->fill(p.pT()/GeV);
            _h_Dplus_pm_dummy->fill(p.pT()/GeV);
            _h_DplusD0_pm_sum_dummy->fill(p.pT()/GeV);

            if(p.pT() >= 1){
              _h_DpD0_fpm_dummy->fill(1);
            }
          }

          else if(p.abspid()== 431){
            _h_DS_pm->fill(p.pT()/GeV);
            _h_DS_pm_dummy->fill(p.pT()/GeV);

            if(p.pT() >= 1){
              _h_DS_fpm_dummy->fill(1);
            }
          }
        }
      }
    }

    void finalize() {

      scale(_h_D0_npm,                 crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_Dplus_npm,              crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_DS_npm,                 crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_D0_pm,                  crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_Dplus_pm,               crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_DS_pm,                  crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_D0_pm_dummy,            crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_D0_pm_dummy2,           crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_D0_npm_dummy,           crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_Dplus_pm_dummy,         crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_DS_pm_dummy,            crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_DplusD0_pm_sum_dummy,   crossSection()/(microbarn*2*sumOfWeights()));
      scale(_h_DplusD0_npm_sum_dummy,  crossSection()/(microbarn*2*sumOfWeights()));

      scale(_h_DS_fpm_dummy,            0.5);
      scale(_h_DpD0_fpm_dummy,          0.5);
      scale(_h_DS_fnpm_dummy,           0.5);
      scale(_h_DpD0_fnpm_dummy,         0.5);

      divide(_h_D0_npm,     _h_D0_pm_dummy,            _h_ratioD0);
      divide(_h_Dplus_npm,  _h_Dplus_pm_dummy,         _h_ratioDplus);
      divide(_h_DS_npm,     _h_DS_pm_dummy,            _h_ratioDS);
      divide(_h_Dplus_pm,   _h_D0_pm_dummy2,           _h_ratio_pm_DplusD0);
      divide(_h_Dplus_npm,  _h_D0_npm_dummy,           _h_ratio_npm_DplusD0);
      divide(_h_DS_pm,      _h_DplusD0_pm_sum_dummy,   _h_ratio_pm_DS_DplusD0);
      divide(_h_DS_npm,     _h_DplusD0_npm_sum_dummy,  _h_ratio_npm_DS_DplusD0);

      divide(_h_DS_fpm_dummy,   _h_DpD0_fpm_dummy,      _h_Charmfrag);
      divide(_h_DS_fnpm_dummy,  _h_DpD0_fnpm_dummy,     _h_Beautyfrag);

    }

    Histo1DPtr _h_D0_npm, _h_D0_npm_dummy, _h_Dplus_npm, _h_DS_npm, _h_D0_pm,
    _h_D0_pm_dummy, _h_D0_pm_dummy2, _h_Dplus_pm, _h_Dplus_pm_dummy, _h_DS_pm,
    _h_DS_pm_dummy, _h_DplusD0_pm_sum_dummy, _h_DplusD0_npm_sum_dummy,
    _h_DS_fpm_dummy, _h_DpD0_fpm_dummy, _h_DS_fnpm_dummy,  _h_DpD0_fnpm_dummy;

    Scatter2DPtr _h_ratioD0, _h_ratioDplus, _h_ratioDS, _h_ratio_pm_DplusD0,
    _h_ratio_npm_DplusD0, _h_ratio_pm_DS_DplusD0, _h_ratio_npm_DS_DplusD0,
    _h_Charmfrag,  _h_Beautyfrag;

  };

  RIVET_DECLARE_PLUGIN(ALICE_2021_I1848990);

}
