// swift-tools-version:5.3

import Foundation
import PackageDescription

var sources = ["src/parser.c"]
if FileManager.default.fileExists(atPath: "src/scanner.c") {
    sources.append("src/scanner.c")
}

let package = Package(
    name: "TreeSitterOdin",
    products: [
        .library(name: "TreeSitterOdin", targets: ["TreeSitterOdin"]),
    ],
    dependencies: [
        .package(name: "SwiftTreeSitter", url: "https://github.com/tree-sitter/swift-tree-sitter", from: "0.8.0"),
    ],
    targets: [
        .target(
            name: "TreeSitterOdin",
            dependencies: [],
            path: ".",
            sources: sources,
            resources: [
                .copy("queries")
            ],
            publicHeadersPath: "bindings/swift",
            cSettings: [.headerSearchPath("src")]
        ),
        .testTarget(
            name: "TreeSitterOdinTests",
            dependencies: [
                "SwiftTreeSitter",
                "TreeSitterOdin",
            ],
            path: "bindings/swift/TreeSitterOdinTests"
        )
    ],
    cLanguageStandard: .c11
)
