/*
*  qm_streamloader.h
*  QUIMUP class to download streams
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_SFETCHER_H
#define QM_SFETCHER_H

#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QStringList>
#include <QTextStream>
#include <QElapsedTimer>
#include <QUrl>


class qm_streamFetcher: public QObject
{
    Q_OBJECT

public:
    qm_streamFetcher();
    virtual ~qm_streamFetcher();

public slots:
    void download_this(QString input);

private slots:
    void on_download_finished(QNetworkReply *reply);
    void on_download_progress(qint64,qint64);

private:

    QNetworkAccessManager nwm_manager;
    QNetworkReply *thedownload;
    QElapsedTimer download_time;

signals:
    void streamdownload_done(QStringList);


};


#endif // QM_SFETCHER_H
