###########################################################################################
##
##	Author    : Johan Spee
##	Project   : Quimup
##	FileName  : Quimup.pro
##	Date      : 2024-01-01T10:10:10
##	License   : GPL
##	Comment   : Quimup is a client for MPD
##	Home Page :
##
##	This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
##	WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
##
###########################################################################################

 # disable all APIs deprecated in Qt 6.6.0 and earlier:
DEFINES += QT_DISABLE_DEPRECATED_UP_TO=0x060600

greaterThan(QT_MAJOR_VERSION, 5): {
    QT += core gui network widgets
 }

TARGET = quimup
TEMPLATE = app

CONFIG += link_pkgconfig
PKGCONFIG = libmpdclient

BUILD_PATH = ./build

CONFIG(debug, debug|release) {
    #Debug
    CONFIG += console
    unix:TARGET = $$join(TARGET,,,_debug)
    else:TARGET = $$join(TARGET,,,d)
    unix:OBJECTS_DIR = $${BUILD_PATH}/debug/.obj/unix
    win32:OBJECTS_DIR = $${BUILD_PATH}/debug/.obj/win32
    mac:OBJECTS_DIR = $${BUILD_PATH}/debug/.obj/mac
    UI_DIR = $${BUILD_PATH}/debug/.ui
    MOC_DIR = $${BUILD_PATH}/debug/.moc
    RCC_DIR = $${BUILD_PATH}/debug/.rcc
} else {
    #Release
    unix:OBJECTS_DIR = $${BUILD_PATH}/release/.obj/unix
    win32:OBJECTS_DIR = $${BUILD_PATH}/release/.obj/win32
    mac:OBJECTS_DIR = $${BUILD_PATH}/release/.obj/mac
    UI_DIR = $${BUILD_PATH}/release/.ui
    MOC_DIR = $${BUILD_PATH}/release/.moc
    RCC_DIR = $${BUILD_PATH}/release/.rcc
}

SOURCES += source/main.cpp \
    source/QtSingleApplication/qtsingleapplication.cpp \
    source/QtSingleApplication/qtlockedfile.cpp \
    source/QtSingleApplication/qtlockedfile_unix.cpp \
    source/QtSingleApplication/qtlocalpeer.cpp \
    source/qm_clicklabel.cpp \
    source/qm_clickprogressbar.cpp \
    source/qm_config.cpp \
    source/qm_core.cpp \
    source/qm_mpdcom.cpp \
    source/qm_player.cpp \
    source/qm_scroller.cpp \
    source/qm_streamfetcher.cpp \
    source/qm_task.cpp \
    source/qm_trayicon.cpp \
    source/qm_settings.cpp \
    source/qm_browser.cpp \
    source/qm_playlistview.cpp \
    source/qm_libraryview.cpp \
    source/qm_itemlist.cpp \
    source/qm_songinfo.cpp \
    source/qm_colorpicker.cpp

HEADERS += source/qm_clicklabel.h \
    source/QtSingleApplication/qtsingleapplication.h \
    source/QtSingleApplication/qtlockedfile.h \
    source/QtSingleApplication/qtlocalpeer.h \
    source/qm_clickprogressbar.h \
    source/qm_config.h \
    source/qm_core.h \
    source/qm_modes_ids.h \
    source/qm_mpdcom.h \
    source/qm_player.h \
    source/qm_scroller.h \
    source/qm_songinfo.h \
    source/qm_streamfetcher.h \
    source/qm_task.h \
    source/qm_trayicon.h \
    source/qm_widget_ids.h \
    source/qm_settings.h \
    source/qm_browser.h \
    source/qm_playlistview.h \
    source/qm_libraryview.h \
    source/qm_commandlist.h \
    source/qm_itemlist.h \
    source/qm_colorpicker.h

RESOURCES += source/quimup.qrc

##TRANSLATIONS += quimup_nl.ts \
##    quimup_fr.ts

TRANSLATIONS +=


DISTFILES += \
    FAQ.txt \
    README \
    changelog \


