package AmphetaDesk::OS::MacOS;
###############################################################################
# This package handles all the GUI routines for the Mac operating system.     #
# It requires various modules to be compiled into the runtime wrapper script  #
# - these modules are assumed to be there. If not, oopsy, we got problems.    #
#                                                                             #
# LIST OF ROUTINES BELOW:                                                     #
#   gui_init - start the gui and display the window.                          #
#   gui_listen - listen for window events for our gui.                        #
#   gui_note - send a note to our gui window.                                 #
#   open_url - open a url in the system's default browser.                    #
#   _things - various routines that control the gui and should be private.    #
###############################################################################

use strict;
use AmphetaDesk::Settings;
use AmphetaDesk::Utilities;
use Mac::Events;
require Exporter;
use vars qw( @ISA @EXPORT );
@ISA = qw( Exporter );
@EXPORT = qw( gui_init gui_listen gui_note open_url );

###############################################################################
# gui_init - start the gui and display the window.                            #
###############################################################################
# USAGE:                                                                      #
#   gui_init;                                                                 #
#                                                                             #
# NOTES:                                                                      #
#   This routine loads specific libraries specific to the OS and attempts to  #
#   do everything necessary to start up a GUI window and start listening for  #
#   events. Further down in this file, you should see supplementary GUI       #
#   routines (starting with _) that are part of the GUI happenings this       #
#   routine inits.                                                            #
#                                                                             #
# RETURNS:                                                                    #
#   1; this routine always returns happily.                                   #
###############################################################################

sub gui_init {

   return 1;

}

###############################################################################
# gui_listen - listen for window events for our gui.                          #
###############################################################################
# USAGE:                                                                      #
#   gui_listen;                                                               #
#                                                                             #
# NOTES:                                                                      #
#   This routine checks the event queue and sees if there is anything that    #
#   needs to be done. It's called from the main loop of our program.          #
#                                                                             #
# RETURNS:                                                                    #
#   1; this routine always returns happily.                                   #
###############################################################################

sub gui_listen {

    my $start = time; WaitNextEvent until time > ($start + 1); return 1;

}

###############################################################################
# gui_note - send a note to our gui window.                                   #
###############################################################################
# USAGE:                                                                      #
#   gui_note("This is a gui window line. Yup.");                              #
#                                                                             #
# NOTES:                                                                      #
#   Much like note(), only we send our message to our os specific gui window. #
#                                                                             #
# RETURNS:                                                                    #
#   1; this routine always returns happily.                                   #
###############################################################################

sub gui_note {

   # eventually, this will do something a bit more meaningful.
   my ($message) = @_; print STDOUT $message . "\n"; return 1;

}

###############################################################################
# open_url - open a url in the system's default browser.                      #
###############################################################################
# USAGE:                                                                      #
#    open_url( );                                                             #
#                                                                             #
# OS SPECIFIC NOTES:                                                          #
#    This routine loads the Mac::InternetConfig module to find the default    #
#    browser as defined in the Internet control panel. It will then load the  #
#    URL within the program specified.                                        #
#                                                                             #
# RETURNS:                                                                    #
#    1; we instruct the user to open their browser if we can't.               #
###############################################################################

sub open_url {

   # construct our url.
   my $url = "http://127.0.0.1:" . get_setting("urls_port") . "/index.html";

   # we spit out our suggestion just to catch all instances.
   note("If your browser doesn't load, go to <$url>.", 1);

   # open url based on the default browser entry.
   use Mac::InternetConfig qw(:DEFAULT $ICInstance);
   ICGeneralFindConfigFile($ICInstance);
   ICLaunchURL($ICInstance, 0, $url);

   return 1;

}

###############################################################################
# _things - various routines that control the gui and should be private.      #
###############################################################################
# USAGE:                                                                      #
#    These are internally called by the GUI and shouldn't be publically       #
#    used. So stop poking around here. Sheesh. Flippin' nosy people. Sigh.    #
###############################################################################

1;
