/*
 * Decompiled with CFR 0.152.
 */
package net.pms.xmlwise;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.pms.xmlwise.XmlElement;
import net.pms.xmlwise.XmlParseException;
import net.pms.xmlwise.Xmlwise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class Plist {
    private static final Logger logger = LoggerFactory.getLogger(Plist.class);
    private static final Plist PLIST = new Plist();
    private static final String BASE64_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private final DateFormat m_dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Map<Class<?>, ElementType> m_simpleTypes;

    public static String toXml(Map<String, Object> data) {
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">");
        builder.append(PLIST.objectToXml(data).toXml());
        return builder.append("</plist>").toString();
    }

    public static void store(Map<String, Object> data, String filename) throws IOException {
        Plist.store(data, new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Map<String, Object> data, File file) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(Plist.toXml(data).getBytes());
        }
        catch (Throwable throwable) {
            Plist.silentlyClose(stream);
            throw throwable;
        }
        Plist.silentlyClose(stream);
    }

    static void silentlyClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.debug("Caught exception", e);
        }
    }

    public static Map<String, Object> fromXml(String xml) throws XmlParseException {
        return PLIST.parse(Xmlwise.createXml(xml));
    }

    public static Map<String, Object> load(File file) throws XmlParseException, IOException {
        return PLIST.parse(Xmlwise.loadXml(file));
    }

    public static Map<String, Object> load(String filename) throws XmlParseException, IOException {
        return Plist.load(new File(filename));
    }

    Plist() {
        this.m_dateFormat.setTimeZone(TimeZone.getTimeZone("Z"));
        this.m_simpleTypes = new HashMap();
        this.m_simpleTypes.put(Integer.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Byte.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Short.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Short.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Long.class, ElementType.INTEGER);
        this.m_simpleTypes.put(String.class, ElementType.STRING);
        this.m_simpleTypes.put(Float.class, ElementType.REAL);
        this.m_simpleTypes.put(Double.class, ElementType.REAL);
        this.m_simpleTypes.put(byte[].class, ElementType.DATA);
        this.m_simpleTypes.put(Boolean.class, ElementType.TRUE);
        this.m_simpleTypes.put(Date.class, ElementType.DATE);
    }

    XmlElement objectToXml(Object o) {
        ElementType type = this.m_simpleTypes.get(o.getClass());
        if (type != null) {
            switch (type) {
                case REAL: {
                    return new XmlElement("real", o.toString());
                }
                case INTEGER: {
                    return new XmlElement("integer", o.toString());
                }
                case TRUE: {
                    return new XmlElement((Boolean)o != false ? "true" : "false");
                }
                case DATE: {
                    return new XmlElement("date", this.m_dateFormat.format((Date)o));
                }
                case STRING: {
                    return new XmlElement("string", (String)o);
                }
                case DATA: {
                    return new XmlElement("data", Plist.base64encode((byte[])o));
                }
            }
        }
        if (o instanceof Map) {
            return this.toXmlDict((Map)o);
        }
        if (o instanceof List) {
            return this.toXmlArray((List)o);
        }
        throw new RuntimeException("Cannot use " + o.getClass() + " in plist.");
    }

    private XmlElement toXmlArray(List<?> list) {
        XmlElement array = new XmlElement("array");
        for (Object o : list) {
            array.add(this.objectToXml(o));
        }
        return array;
    }

    private XmlElement toXmlDict(Map<String, Object> map) {
        XmlElement dict = new XmlElement("dict");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            dict.add(new XmlElement("key", entry.getKey()));
            dict.add(this.objectToXml(entry.getValue()));
        }
        return dict;
    }

    Map<String, Object> parse(XmlElement element) throws XmlParseException {
        if (!"plist".equalsIgnoreCase(element.getName())) {
            throw new XmlParseException("Expected plist top element, was: " + element.getName());
        }
        if (element.size() != 1) {
            throw new XmlParseException("Expected single 'dict' child element.");
        }
        element.getUnique("dict");
        return (Map)this.parseElement(element.getUnique("dict"));
    }

    private Object parseElement(XmlElement element) throws XmlParseException {
        try {
            return this.parseElementRaw(element);
        }
        catch (Exception e) {
            throw new XmlParseException("Failed to parse: " + element.toXml(), e);
        }
    }

    private Object parseElementRaw(XmlElement element) throws Exception {
        ElementType type = ElementType.valueOf(element.getName().toUpperCase());
        switch (type) {
            case INTEGER: {
                return this.parseInt(element.getValue());
            }
            case REAL: {
                return this.parseDouble(element.getValue());
            }
            case STRING: {
                return element.getValue();
            }
            case DATE: {
                return this.m_dateFormat.parse(element.getValue());
            }
            case DATA: {
                return Plist.base64decode(element.getValue());
            }
            case ARRAY: {
                return this.parseArray(element);
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case DICT: {
                return this.parseDict(element);
            }
        }
        throw new RuntimeException("Unexpected type: " + element.getName());
    }

    private Number parseInt(String value) {
        Long l = Long.valueOf(value);
        if ((long)l.intValue() == l) {
            return l.intValue();
        }
        return l;
    }

    private Number parseDouble(String value) {
        if (value.equals("NaN")) {
            return Double.NaN;
        }
        if (value.equals("-inf")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (value.equals("inf")) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.valueOf(value);
    }

    private Map<String, Object> parseDict(List<XmlElement> elements) throws Exception {
        Iterator<XmlElement> element = elements.iterator();
        HashMap<String, Object> dict = new HashMap<String, Object>();
        while (element.hasNext()) {
            XmlElement key = element.next();
            if (!"key".equals(key.getName())) {
                throw new Exception("Expected key but was " + key.getName());
            }
            Object o = this.parseElementRaw(element.next());
            dict.put(key.getValue(), o);
        }
        return dict;
    }

    private List<Object> parseArray(List<XmlElement> elements) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(elements.size());
        for (XmlElement element : elements) {
            list.add(this.parseElementRaw(element));
        }
        return list;
    }

    static String base64encode(byte[] bytes) {
        StringBuilder builder = new StringBuilder((bytes.length + 2) / 3 * 4);
        for (int i = 0; i < bytes.length; i += 3) {
            byte b0 = bytes[i];
            byte b1 = i < bytes.length - 1 ? bytes[i + 1] : (byte)0;
            byte b2 = i < bytes.length - 2 ? bytes[i + 2] : (byte)0;
            builder.append(BASE64_CHARS[(b0 & 0xFF) >> 2]);
            builder.append(BASE64_CHARS[(b0 & 3) << 4 | (b1 & 0xF0) >> 4]);
            builder.append(i < bytes.length - 1 ? Character.valueOf(BASE64_CHARS[(b1 & 0xF) << 2 | (b2 & 0xC0) >> 6]) : "=");
            builder.append(i < bytes.length - 2 ? Character.valueOf(BASE64_CHARS[b2 & 0x3F]) : "=");
        }
        return builder.toString();
    }

    static byte[] base64decode(String base64) {
        int endTrim = (base64 = base64.trim()).endsWith("==") ? 2 : (base64.endsWith("=") ? 1 : 0);
        int length = base64.length() / 4 * 3 - endTrim;
        base64 = base64.replace('=', 'A');
        byte[] result = new byte[length];
        int stringLength = base64.length();
        int index = 0;
        for (int i = 0; i < stringLength; i += 4) {
            int i0 = BASE64_STRING.indexOf(base64.charAt(i));
            int i1 = BASE64_STRING.indexOf(base64.charAt(i + 1));
            int i2 = BASE64_STRING.indexOf(base64.charAt(i + 2));
            int i3 = BASE64_STRING.indexOf(base64.charAt(i + 3));
            byte b0 = (byte)(i0 << 2 | i1 >> 4);
            byte b1 = (byte)(i1 << 4 | i2 >> 2);
            byte b2 = (byte)(i2 << 6 | i3);
            result[index++] = b0;
            if (index >= length) continue;
            result[index++] = b1;
            if (index >= length) continue;
            result[index++] = b2;
        }
        return result;
    }

    private static enum ElementType {
        INTEGER,
        STRING,
        REAL,
        DATA,
        DATE,
        DICT,
        ARRAY,
        TRUE,
        FALSE;

    }
}

