/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import org.apache.commons.lang3.text.WordUtils;

public class StringUtil {
    public static void openTag(StringBuilder sb, String tag) {
        sb.append("&lt;");
        sb.append(tag);
    }

    public static void endTag(StringBuilder sb) {
        sb.append("&gt;");
    }

    public static void closeTag(StringBuilder sb, String tag) {
        sb.append("&lt;/");
        sb.append(tag);
        sb.append("&gt;");
    }

    public static void addAttribute(StringBuilder sb, String attribute, Object value) {
        sb.append(" ");
        sb.append(attribute);
        sb.append("=\"");
        sb.append(value);
        sb.append("\"");
    }

    public static void addXMLTagAndAttribute(StringBuilder sb, String tag, Object value) {
        sb.append("&lt;");
        sb.append(tag);
        sb.append("&gt;");
        sb.append(value);
        sb.append("&lt;/");
        sb.append(tag);
        sb.append("&gt;");
    }

    public static String encodeXML(String s) {
        s = s.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = s.replace("\"", "&quot;");
        s = s.replace("'", "&apos;");
        s = s.replace("&", "&amp;");
        return s;
    }

    public static String convertURLToFileName(String url) {
        url = url.replace('/', '\u00b5');
        url = url.replace('\\', '\u00b5');
        url = url.replace(':', '\u00b5');
        url = url.replace('?', '\u00b5');
        url = url.replace('*', '\u00b5');
        url = url.replace('|', '\u00b5');
        url = url.replace('<', '\u00b5');
        url = url.replace('>', '\u00b5');
        return url;
    }

    public static String abbreviate(String str) {
        if (str == null) {
            return null;
        }
        return WordUtils.capitalize(str).replaceAll("[^A-Z]", "");
    }
}

