/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import net.pms.dlna.DLNAResource;
import net.pms.formats.Format;

public class PlayerUtil {
    private PlayerUtil() {
    }

    private static boolean isType(DLNAResource resource, int matchType, Format.Identifier matchIdentifier) {
        Format format;
        boolean match = false;
        if (resource != null && (format = resource.getFormat()) != null && (format.getType() & matchType) == matchType) {
            if (matchIdentifier == null) {
                match = true;
            } else {
                Format.Identifier identifier = format.getIdentifier();
                match = identifier.equals((Object)matchIdentifier);
            }
        }
        return match;
    }

    public static boolean isImage(DLNAResource resource) {
        return PlayerUtil.isType(resource, 2, null);
    }

    public static boolean isImage(DLNAResource resource, Format.Identifier identifier) {
        return PlayerUtil.isType(resource, 2, identifier);
    }

    public static boolean isAudio(DLNAResource resource) {
        return PlayerUtil.isType(resource, 1, null);
    }

    public static boolean isAudio(DLNAResource resource, Format.Identifier identifier) {
        return PlayerUtil.isType(resource, 1, identifier);
    }

    public static boolean isVideo(DLNAResource resource) {
        return PlayerUtil.isType(resource, 4, null);
    }

    public static boolean isVideo(DLNAResource resource, Format.Identifier identifier) {
        return PlayerUtil.isType(resource, 4, identifier);
    }

    public static boolean isWebAudio(DLNAResource resource) {
        return PlayerUtil.isType(resource, 1, Format.Identifier.WEB);
    }

    public static boolean isWebVideo(DLNAResource resource) {
        return PlayerUtil.isType(resource, 4, Format.Identifier.WEB);
    }
}

