/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.Range;
import net.pms.external.StartStopListenerDelegate;
import net.pms.network.HTMLConsole;
import net.pms.network.HTTPResource;
import net.pms.network.HTTPXMLHelper;
import org.apache.commons.lang3.StringUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.stream.ChunkedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestV2
extends HTTPResource {
    private static final Logger logger = LoggerFactory.getLogger(RequestV2.class);
    private static final String CRLF = "\r\n";
    private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
    private static int BUFFER_SIZE = 8192;
    private static final int[] MULTIPLIER = new int[]{1, 60, 3600, 86400};
    private final String method;
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private String argument;
    private String soapaction;
    private String content;
    private String objectID;
    private int startingIndex;
    private int requestCount;
    private String browseFlag;
    private long lowRange;
    private InputStream inputStream;
    private RendererConfiguration mediaRenderer;
    private String transferMode;
    private String contentFeatures;
    private final Range.Time range = new Range.Time();
    private long highRange;
    private boolean http10;

    public RendererConfiguration getMediaRenderer() {
        return this.mediaRenderer;
    }

    public void setMediaRenderer(RendererConfiguration mediaRenderer) {
        this.mediaRenderer = mediaRenderer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getLowRange() {
        return this.lowRange;
    }

    public void setLowRange(long lowRange) {
        this.lowRange = lowRange;
    }

    public String getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(String transferMode) {
        this.transferMode = transferMode;
    }

    public String getContentFeatures() {
        return this.contentFeatures;
    }

    public void setContentFeatures(String contentFeatures) {
        this.contentFeatures = contentFeatures;
    }

    public void setTimeRangeStart(Double timeseek) {
        this.range.setStart(timeseek);
    }

    public void setTimeRangeStartString(String str) {
        this.setTimeRangeStart(this.convertTime(str));
    }

    public void setTimeRangeEnd(Double rangeEnd) {
        this.range.setEnd(rangeEnd);
    }

    public void setTimeRangeEndString(String str) {
        this.setTimeRangeEnd(this.convertTime(str));
    }

    public long getHighRange() {
        return this.highRange;
    }

    public void setHighRange(long highRange) {
        this.highRange = highRange;
    }

    public boolean isHttp10() {
        return this.http10;
    }

    public void setHttp10(boolean http10) {
        this.http10 = http10;
    }

    public RequestV2(String method, String argument) {
        this.method = method;
        this.argument = argument;
    }

    public String getSoapaction() {
        return this.soapaction;
    }

    public void setSoapaction(String soapaction) {
        this.soapaction = soapaction;
    }

    public String getTextContent() {
        return this.content;
    }

    public void setTextContent(String content) {
        this.content = content;
    }

    public String getMethod() {
        return this.method;
    }

    public String getArgument() {
        return this.argument;
    }

    public ChannelFuture answer(HttpResponse output, MessageEvent e, boolean close, final StartStopListenerDelegate startStopListenerDelegate) throws IOException {
        ChannelFuture future = null;
        long CLoverride = -2L;
        StringBuilder response = new StringBuilder();
        DLNAResource dlna = null;
        boolean xbox = this.mediaRenderer.isXBOX();
        if (this.argument.startsWith("/")) {
            logger.trace("Stripping preceding slash from: " + this.argument);
            this.argument = this.argument.substring(1);
        }
        if ((this.method.equals("GET") || this.method.equals("HEAD")) && this.argument.startsWith("console/")) {
            output.setHeader("Content-Type", "text/html");
            response.append(HTMLConsole.servePage(this.argument.substring(8)));
        } else if ((this.method.equals("GET") || this.method.equals("HEAD")) && this.argument.startsWith("get/")) {
            String id = StringUtils.substringBetween(this.argument, "get/", "/");
            id = id.replace("%24", "$");
            List<DLNAResource> files = PMS.get().getRootFolder(this.mediaRenderer).getDLNAResources(id, false, 0, 0, this.mediaRenderer);
            if (this.transferMode != null) {
                output.setHeader("TransferMode.DLNA.ORG", this.transferMode);
            }
            if (files.size() == 1) {
                dlna = files.get(0);
                String fileName = this.argument.substring(this.argument.lastIndexOf("/") + 1);
                if (fileName.startsWith("thumbnail0000")) {
                    output.setHeader("Content-Type", dlna.getThumbnailContentType());
                    output.setHeader("Accept-Ranges", "bytes");
                    output.setHeader("Expires", this.getFUTUREDATE() + " GMT");
                    output.setHeader("Connection", "keep-alive");
                    if (this.mediaRenderer.isMediaParserV2()) {
                        dlna.checkThumbnail();
                    }
                    this.inputStream = dlna.getThumbnailInputStream();
                } else if (fileName.indexOf("subtitle0000") > -1) {
                    DLNAMediaSubtitle sub;
                    output.setHeader("Content-Type", "text/plain");
                    output.setHeader("Expires", this.getFUTUREDATE() + " GMT");
                    List<DLNAMediaSubtitle> subs = dlna.getMedia().getSubtitleTracksList();
                    if (subs != null && !subs.isEmpty() && (sub = subs.get(0)).isExternal()) {
                        this.inputStream = new FileInputStream(sub.getExternalFile());
                    }
                } else {
                    List<DLNAMediaSubtitle> subs;
                    String subtitleHttpHeader;
                    Range.Time splitRange = dlna.getSplitRange();
                    if (this.range.getStart() == null && splitRange.getStart() != null) {
                        this.range.setStart(splitRange.getStart());
                    }
                    if (this.range.getEnd() == null && splitRange.getEnd() != null) {
                        this.range.setEnd(splitRange.getEnd());
                    }
                    this.inputStream = dlna.getInputStream(Range.create(this.lowRange, this.highRange, this.range.getStart(), this.range.getEnd()), this.mediaRenderer);
                    if (!(configuration.isDisableSubtitles() || (subtitleHttpHeader = this.mediaRenderer.getSubtitleHttpHeader()) == null || "".equals(subtitleHttpHeader) || (subs = dlna.getMedia().getSubtitleTracksList()) == null || subs.isEmpty())) {
                        DLNAMediaSubtitle sub = subs.get(0);
                        String subExtension = sub.getType().getExtension();
                        String subtitleUrl = StringUtils.isNotBlank(subExtension) ? "http://" + PMS.get().getServer().getHost() + ':' + PMS.get().getServer().getPort() + "/get/" + id + "/subtitle0000." + subExtension : "http://" + PMS.get().getServer().getHost() + ':' + PMS.get().getServer().getPort() + "/get/" + id + "/subtitle0000";
                        output.setHeader(subtitleHttpHeader, subtitleUrl);
                    }
                    String name = dlna.getDisplayName(this.mediaRenderer);
                    if (this.inputStream == null) {
                        logger.error("There is no inputstream to return for " + name);
                    } else {
                        DLNAMediaInfo media;
                        startStopListenerDelegate.start(dlna);
                        String rendererMimeType = this.getRendererMimeType(dlna.mimeType(), this.mediaRenderer);
                        if (rendererMimeType != null && !"".equals(rendererMimeType)) {
                            output.setHeader("Content-Type", rendererMimeType);
                        }
                        if ((media = dlna.getMedia()) != null) {
                            if (StringUtils.isNotBlank(media.getContainer())) {
                                name = name + " [container: " + media.getContainer() + "]";
                            }
                            if (StringUtils.isNotBlank(media.getCodecV())) {
                                name = name + " [video: " + media.getCodecV() + "]";
                            }
                        }
                        PMS.get().getFrame().setStatusLine("Serving " + name);
                        boolean chunked = this.mediaRenderer.isChunkedTransfer();
                        long totalsize = dlna.length(this.mediaRenderer);
                        if (chunked && totalsize == 0x7FFFFFFF7FFFFFFFL) {
                            totalsize = -1L;
                        }
                        long remaining = totalsize - this.lowRange;
                        long requested = this.highRange - this.lowRange;
                        if (requested != 0L) {
                            long bytes;
                            long l = bytes = remaining > -1L ? remaining : (long)this.inputStream.available();
                            if (requested > 0L && bytes > requested) {
                                bytes = requested + 1L;
                            }
                            this.highRange = this.lowRange + bytes - (long)(bytes > 0L ? 1 : 0);
                            logger.trace((chunked ? "Using chunked response. " : "") + "Sending " + bytes + " bytes.");
                            output.setHeader("Content-Range", "bytes " + this.lowRange + "-" + (this.highRange > -1L ? Long.valueOf(this.highRange) : "*") + "/" + (totalsize > -1L ? Long.valueOf(totalsize) : "*"));
                            CLoverride = chunked && requested < 0L && totalsize < 0L ? -1L : bytes;
                        } else {
                            CLoverride = remaining;
                        }
                        this.highRange = this.lowRange + CLoverride - (long)(CLoverride > 0L ? 1 : 0);
                        if (this.contentFeatures != null) {
                            output.setHeader("ContentFeatures.DLNA.ORG", dlna.getDlnaContentFeatures());
                        }
                        output.setHeader("Accept-Ranges", "bytes");
                        output.setHeader("Connection", "keep-alive");
                    }
                }
            }
        } else if ((this.method.equals("GET") || this.method.equals("HEAD")) && (this.argument.toLowerCase().endsWith(".png") || this.argument.toLowerCase().endsWith(".jpg") || this.argument.toLowerCase().endsWith(".jpeg"))) {
            if (this.argument.toLowerCase().endsWith(".png")) {
                output.setHeader("Content-Type", "image/png");
            } else {
                output.setHeader("Content-Type", "image/jpeg");
            }
            output.setHeader("Accept-Ranges", "bytes");
            output.setHeader("Connection", "keep-alive");
            output.setHeader("Expires", this.getFUTUREDATE() + " GMT");
            this.inputStream = this.getResourceInputStream(this.argument);
        } else if ((this.method.equals("GET") || this.method.equals("HEAD")) && (this.argument.equals("description/fetch") || this.argument.endsWith("1.0.xml"))) {
            output.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            output.setHeader("Cache-Control", "no-cache");
            output.setHeader("Expires", "0");
            output.setHeader("Accept-Ranges", "bytes");
            output.setHeader("Connection", "keep-alive");
            this.inputStream = this.getResourceInputStream(this.argument.equals("description/fetch") ? "PMS.xml" : this.argument);
            if (this.argument.equals("description/fetch")) {
                byte[] b = new byte[this.inputStream.available()];
                this.inputStream.read(b);
                String s = new String(b);
                s = s.replace("[uuid]", PMS.get().usn());
                String profileName = configuration.getProfileName();
                if (PMS.get().getServer().getHost() != null) {
                    s = s.replace("[host]", PMS.get().getServer().getHost());
                    s = s.replace("[port]", "" + PMS.get().getServer().getPort());
                }
                if (xbox) {
                    logger.debug("DLNA changes for Xbox 360");
                    s = s.replace("PS3 Media Server", "PS3 Media Server [" + profileName + "] : Windows Media Connect");
                    s = s.replace("<modelName>PMS</modelName>", "<modelName>Windows Media Connect</modelName>");
                    s = s.replace("<serviceList>", "<serviceList>\r\n<service>\r\n<serviceType>urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1</serviceType>\r\n<serviceId>urn:microsoft.com:serviceId:X_MS_MediaReceiverRegistrar</serviceId>\r\n<SCPDURL>/upnp/mrr/scpd</SCPDURL>\r\n<controlURL>/upnp/mrr/control</controlURL>\r\n</service>\r\n");
                } else {
                    s = s.replace("PS3 Media Server", "PS3 Media Server [" + profileName + "]");
                }
                if (!this.mediaRenderer.isPS3()) {
                    s = s.replace("<mimetype>image/png</mimetype>", "<mimetype>image/jpeg</mimetype>");
                    s = s.replace("/images/thumbnail-video-256.png", "/images/thumbnail-video-120.jpg");
                    s = s.replace(">256<", ">120<");
                }
                response.append(s);
                this.inputStream = null;
            }
        } else if (this.method.equals("POST") && (this.argument.contains("MS_MediaReceiverRegistrar_control") || this.argument.contains("mrr/control"))) {
            output.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            response.append(CRLF);
            response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
            response.append(CRLF);
            if (this.soapaction != null && this.soapaction.contains("IsAuthorized")) {
                response.append("<u:IsAuthorizedResponse xmlns:u=\"urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1\">\r\n<Result>1</Result>\r\n</u:IsAuthorizedResponse>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.contains("IsValidated")) {
                response.append("<u:IsValidatedResponse xmlns:u=\"urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1\">\r\n<Result>1</Result>\r\n</u:IsValidatedResponse>");
                response.append(CRLF);
            }
            response.append("</u:BrowseResponse>");
            response.append(CRLF);
            response.append("</s:Body>\r\n</s:Envelope>");
            response.append(CRLF);
        } else if (this.method.equals("POST") && this.argument.endsWith("upnp/control/connection_manager")) {
            output.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            if (this.soapaction != null && this.soapaction.indexOf("ConnectionManager:1#GetProtocolInfo") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetProtocolInfoResponse xmlns:u=\"urn:schemas-upnp-org:service:ConnectionManager:1\"><Source>http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_SM,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_MED,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_LRG,http-get:*:audio/mpeg:DLNA.ORG_PN=MP3,http-get:*:audio/L16:DLNA.ORG_PN=LPCM,http-get:*:video/mpeg:DLNA.ORG_PN=AVC_TS_HD_24_AC3_ISO;SONY.COM_PN=AVC_TS_HD_24_AC3_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_24_AC3;SONY.COM_PN=AVC_TS_HD_24_AC3,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_24_AC3_T;SONY.COM_PN=AVC_TS_HD_24_AC3_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_PS_PAL,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_PS_NTSC,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_50_L2_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_60_L2_T,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_SD_EU_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_50_AC3_T,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_50_L2_ISO;SONY.COM_PN=HD2_50_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_60_AC3_T,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_60_L2_ISO;SONY.COM_PN=HD2_60_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_50_L2_T;SONY.COM_PN=HD2_50_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_60_L2_T;SONY.COM_PN=HD2_60_T,http-get:*:video/mpeg:DLNA.ORG_PN=AVC_TS_HD_50_AC3_ISO;SONY.COM_PN=AVC_TS_HD_50_AC3_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_50_AC3;SONY.COM_PN=AVC_TS_HD_50_AC3,http-get:*:video/mpeg:DLNA.ORG_PN=AVC_TS_HD_60_AC3_ISO;SONY.COM_PN=AVC_TS_HD_60_AC3_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_60_AC3;SONY.COM_PN=AVC_TS_HD_60_AC3,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_50_AC3_T;SONY.COM_PN=AVC_TS_HD_50_AC3_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_60_AC3_T;SONY.COM_PN=AVC_TS_HD_60_AC3_T,http-get:*:video/x-mp2t-mphl-188:*,http-get:*:*:*,http-get:*:video/*:*,http-get:*:audio/*:*,http-get:*:image/*:*</Source><Sink></Sink></u:GetProtocolInfoResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            }
        } else if (this.method.equals("POST") && this.argument.endsWith("upnp/control/content_directory")) {
            output.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
            if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#GetSystemUpdateID") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetSystemUpdateIDResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
                response.append(CRLF);
                response.append("<Id>").append(DLNAResource.getSystemUpdateId()).append("</Id>");
                response.append(CRLF);
                response.append("</u:GetSystemUpdateIDResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#X_GetFeatureList") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<s:Fault><faultCode>s:Client</faultCode><faultString>UPnPError</faultString><detail><UPnPError xmlns=\"urn:schemas-upnp-org:control-1-0\"><errorCode>401</errorCode><errorDescription>Invalid Action</errorDescription></UPnPError></detail></s:Fault>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#GetSortCapabilities") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetSortCapabilitiesResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\"><SortCaps></SortCaps></u:GetSortCapabilitiesResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#GetSearchCapabilities") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetSearchCapabilitiesResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\"><SearchCaps></SearchCaps></u:GetSearchCapabilitiesResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && (this.soapaction.contains("ContentDirectory:1#Browse") || this.soapaction.contains("ContentDirectory:1#Search"))) {
                this.objectID = this.getEnclosingValue(this.content, "<ObjectID>", "</ObjectID>");
                String containerID = null;
                if (StringUtils.isEmpty(this.objectID) && xbox) {
                    containerID = this.getEnclosingValue(this.content, "<ContainerID>", "</ContainerID>");
                    if (containerID == null || !containerID.contains("$")) {
                        this.objectID = "0";
                    } else {
                        this.objectID = containerID;
                        containerID = null;
                    }
                }
                String sI = this.getEnclosingValue(this.content, "<StartingIndex>", "</StartingIndex>");
                String rC = this.getEnclosingValue(this.content, "<RequestedCount>", "</RequestedCount>");
                this.browseFlag = this.getEnclosingValue(this.content, "<BrowseFlag>", "</BrowseFlag>");
                if (sI != null) {
                    this.startingIndex = Integer.parseInt(sI.toString());
                }
                if (rC != null) {
                    this.requestCount = Integer.parseInt(rC.toString());
                }
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                if (this.soapaction != null && this.soapaction.contains("ContentDirectory:1#Search")) {
                    response.append("<u:SearchResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
                } else {
                    response.append("<u:BrowseResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
                }
                response.append(CRLF);
                response.append("<Result>");
                response.append("&lt;DIDL-Lite xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\"&gt;");
                if (this.soapaction != null && this.soapaction.contains("ContentDirectory:1#Search")) {
                    this.browseFlag = "BrowseDirectChildren";
                }
                String searchCriteria = null;
                if (xbox && configuration.getUseCache() && PMS.get().getLibrary() != null && containerID != null) {
                    String artist;
                    if (containerID.equals("7") && PMS.get().getLibrary().getAlbumFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getAlbumFolder().getResourceId();
                    } else if (containerID.equals("6") && PMS.get().getLibrary().getArtistFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getArtistFolder().getResourceId();
                    } else if (containerID.equals("5") && PMS.get().getLibrary().getGenreFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getGenreFolder().getResourceId();
                    } else if (containerID.equals("F") && PMS.get().getLibrary().getPlaylistFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getPlaylistFolder().getResourceId();
                    } else if (containerID.equals("4") && PMS.get().getLibrary().getAllFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getAllFolder().getResourceId();
                    } else if (containerID.equals("1") && (artist = this.getEnclosingValue(this.content, "upnp:artist = &quot;", "&quot;)")) != null) {
                        this.objectID = PMS.get().getLibrary().getArtistFolder().getResourceId();
                        searchCriteria = artist;
                    }
                }
                List<DLNAResource> files = PMS.get().getRootFolder(this.mediaRenderer).getDLNAResources(this.objectID, this.browseFlag != null && this.browseFlag.equals("BrowseDirectChildren"), this.startingIndex, this.requestCount, this.mediaRenderer);
                if (searchCriteria != null && files != null) {
                    for (int i = files.size() - 1; i >= 0; --i) {
                        if (files.get(i).getName().equals(searchCriteria)) continue;
                        files.remove(i);
                    }
                    if (files.size() > 0) {
                        files = files.get(0).getChildren();
                    }
                }
                int minus = 0;
                if (files != null) {
                    for (DLNAResource uf : files) {
                        if (xbox && containerID != null) {
                            uf.setFakeParentId(containerID);
                        }
                        if (uf.isCompatible(this.mediaRenderer) && (uf.getPlayer() == null || uf.getPlayer().isPlayerCompatible(this.mediaRenderer))) {
                            response.append(uf.toString(this.mediaRenderer));
                            continue;
                        }
                        ++minus;
                    }
                }
                response.append("&lt;/DIDL-Lite&gt;");
                response.append("</Result>");
                response.append(CRLF);
                int filessize = 0;
                if (files != null) {
                    filessize = files.size();
                }
                response.append("<NumberReturned>").append(filessize - minus).append("</NumberReturned>");
                response.append(CRLF);
                DLNAResource parentFolder = null;
                if (files != null && filessize > 0) {
                    parentFolder = files.get(0).getParent();
                }
                if (this.browseFlag != null && this.browseFlag.equals("BrowseDirectChildren") && this.mediaRenderer.isMediaParserV2() && this.mediaRenderer.isDLNATreeHack()) {
                    int totalCount = this.startingIndex + this.requestCount + 1;
                    if (filessize - minus <= 0) {
                        totalCount = this.startingIndex;
                    }
                    response.append("<TotalMatches>").append(totalCount).append("</TotalMatches>");
                } else if (this.browseFlag != null && this.browseFlag.equals("BrowseDirectChildren")) {
                    response.append("<TotalMatches>").append((parentFolder != null ? parentFolder.childrenNumber() : filessize) - minus).append("</TotalMatches>");
                } else {
                    response.append("<TotalMatches>1</TotalMatches>");
                }
                response.append(CRLF);
                response.append("<UpdateID>");
                if (parentFolder != null) {
                    response.append(parentFolder.getUpdateId());
                } else {
                    response.append("1");
                }
                response.append("</UpdateID>");
                response.append(CRLF);
                if (this.soapaction != null && this.soapaction.contains("ContentDirectory:1#Search")) {
                    response.append("</u:SearchResponse>");
                } else {
                    response.append("</u:BrowseResponse>");
                }
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            }
        } else if (this.method.equals("SUBSCRIBE")) {
            output.setHeader("SID", PMS.get().usn());
            output.setHeader("TIMEOUT", "Second-1800");
            if (this.soapaction != null) {
                String cb = this.soapaction.replace("<", "").replace(">", "");
                try {
                    URL soapActionUrl = new URL(cb);
                    String addr = soapActionUrl.getHost();
                    int port = soapActionUrl.getPort();
                    Socket sock = new Socket(addr, port);
                    OutputStream out = sock.getOutputStream();
                    out.write(("NOTIFY /" + this.argument + " HTTP/1.1").getBytes());
                    out.write(CRLF.getBytes());
                    out.write(("SID: " + PMS.get().usn()).getBytes());
                    out.write(CRLF.getBytes());
                    out.write("SEQ: 0".getBytes());
                    out.write(CRLF.getBytes());
                    out.write("NT: upnp:event".getBytes());
                    out.write(CRLF.getBytes());
                    out.write("NTS: upnp:propchange".getBytes());
                    out.write(CRLF.getBytes());
                    out.write(("HOST: " + addr + ":" + port).getBytes());
                    out.write(CRLF.getBytes());
                    out.flush();
                    out.close();
                    sock.close();
                }
                catch (MalformedURLException ex) {
                    logger.debug("Cannot parse address and port from soap action \"" + this.soapaction + "\"", ex);
                }
            } else {
                logger.debug("Expected soap action in request");
            }
            if (this.argument.contains("connection_manager")) {
                response.append(HTTPXMLHelper.eventHeader("urn:schemas-upnp-org:service:ConnectionManager:1"));
                response.append(HTTPXMLHelper.eventProp("SinkProtocolInfo"));
                response.append(HTTPXMLHelper.eventProp("SourceProtocolInfo"));
                response.append(HTTPXMLHelper.eventProp("CurrentConnectionIDs"));
                response.append("</e:propertyset>");
            } else if (this.argument.contains("content_directory")) {
                response.append(HTTPXMLHelper.eventHeader("urn:schemas-upnp-org:service:ContentDirectory:1"));
                response.append(HTTPXMLHelper.eventProp("TransferIDs"));
                response.append(HTTPXMLHelper.eventProp("ContainerUpdateIDs"));
                response.append(HTTPXMLHelper.eventProp("SystemUpdateID", "" + DLNAResource.getSystemUpdateId()));
                response.append("</e:propertyset>");
            }
        } else if (this.method.equals("NOTIFY")) {
            output.setHeader("Content-Type", "text/xml");
            output.setHeader("NT", "upnp:event");
            output.setHeader("NTS", "upnp:propchange");
            output.setHeader("SID", PMS.get().usn());
            output.setHeader("SEQ", "0");
            response.append("<e:propertyset xmlns:e=\"urn:schemas-upnp-org:event-1-0\">");
            response.append("<e:property>");
            response.append("<TransferIDs></TransferIDs>");
            response.append("</e:property>");
            response.append("<e:property>");
            response.append("<ContainerUpdateIDs></ContainerUpdateIDs>");
            response.append("</e:property>");
            response.append("<e:property>");
            response.append("<SystemUpdateID>").append(DLNAResource.getSystemUpdateId()).append("</SystemUpdateID>");
            response.append("</e:property>");
            response.append("</e:propertyset>");
        }
        output.setHeader("Server", PMS.get().getServerName());
        if (response.length() > 0) {
            byte[] responseData = response.toString().getBytes("UTF-8");
            output.setHeader("Content-Length", "" + responseData.length);
            if (!this.method.equals("HEAD")) {
                ChannelBuffer buf = ChannelBuffers.copiedBuffer(responseData);
                output.setContent(buf);
            }
            future = e.getChannel().write(output);
            if (close) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        } else if (this.inputStream != null) {
            if (CLoverride > -2L) {
                if (CLoverride > -1L && CLoverride != 0x7FFFFFFF7FFFFFFFL) {
                    output.setHeader("Content-Length", "" + CLoverride);
                }
            } else {
                int cl = this.inputStream.available();
                logger.trace("Available Content-Length: " + cl);
                output.setHeader("Content-Length", "" + cl);
            }
            if (this.range.isStartOffsetAvailable() && dlna != null) {
                String timeseekValue = DLNAMediaInfo.getDurationString(this.range.getStartOrZero());
                String timetotalValue = dlna.getMedia().getDurationString();
                String timeEndValue = this.range.isEndLimitAvailable() ? DLNAMediaInfo.getDurationString(this.range.getEnd()) : timetotalValue;
                output.setHeader("TimeSeekRange.dlna.org", "npt=" + timeseekValue + "-" + timeEndValue + "/" + timetotalValue);
                output.setHeader("X-Seek-Range", "npt=" + timeseekValue + "-" + timeEndValue + "/" + timetotalValue);
            }
            future = e.getChannel().write(output);
            if (this.lowRange != 99999475712L && !this.method.equals("HEAD")) {
                ChannelFuture chunkWriteFuture = e.getChannel().write(new ChunkedStream(this.inputStream, BUFFER_SIZE));
                chunkWriteFuture.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) {
                        try {
                            PMS.get().getRegistry().reenableGoToSleep();
                            RequestV2.this.inputStream.close();
                        }
                        catch (IOException e) {
                            logger.debug("Caught exception", e);
                        }
                        future.getChannel().close();
                        startStopListenerDelegate.stop();
                    }
                });
            } else {
                try {
                    PMS.get().getRegistry().reenableGoToSleep();
                    this.inputStream.close();
                }
                catch (IOException ioe) {
                    logger.debug("Caught exception", ioe);
                }
                if (close) {
                    future.addListener(ChannelFutureListener.CLOSE);
                }
                startStopListenerDelegate.stop();
            }
        } else {
            if (this.lowRange > 0L && this.highRange > 0L) {
                output.setHeader("Content-Length", "" + (this.highRange - this.lowRange + 1L));
            } else {
                output.setHeader("Content-Length", "0");
            }
            future = e.getChannel().write(output);
            if (close) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
        for (String headerName : output.getHeaderNames()) {
            logger.trace("Sent to socket: " + headerName + ": " + output.getHeader(headerName));
        }
        return future;
    }

    private String getFUTUREDATE() {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(new Date(10000000000L + System.currentTimeMillis()));
    }

    private String getEnclosingValue(String content, String leftTag, String rightTag) {
        String result = null;
        int leftTagPos = content.indexOf(leftTag);
        int rightTagPos = content.indexOf(rightTag, leftTagPos + 1);
        if (leftTagPos > -1 && rightTagPos > leftTagPos) {
            result = content.substring(leftTagPos + leftTag.length(), rightTagPos);
        }
        return result;
    }

    private double convertTime(String time) {
        try {
            return Double.parseDouble(time);
        }
        catch (NumberFormatException e) {
            String[] arrs = time.split(":");
            double sum = 0.0;
            for (int i = 0; i < arrs.length; ++i) {
                double value = Double.parseDouble(arrs[arrs.length - i - 1]);
                sum += value * (double)MULTIPLIER[i];
            }
            return sum;
        }
    }
}

