/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.Range;
import net.pms.external.StartStopListenerDelegate;
import net.pms.network.HTMLConsole;
import net.pms.network.HTTPResource;
import net.pms.network.HTTPXMLHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Request
extends HTTPResource {
    private static final Logger logger = LoggerFactory.getLogger(Request.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private static final String CRLF = "\r\n";
    private static final String HTTP_200_OK = "HTTP/1.1 200 OK";
    private static final String HTTP_500 = "HTTP/1.1 500 Internal Server Error";
    private static final String HTTP_206_OK = "HTTP/1.1 206 Partial Content";
    private static final String HTTP_200_OK_10 = "HTTP/1.0 200 OK";
    private static final String HTTP_206_OK_10 = "HTTP/1.0 206 Partial Content";
    private static final String CONTENT_TYPE_UTF8 = "CONTENT-TYPE: text/xml; charset=\"utf-8\"";
    private static final String CONTENT_TYPE = "Content-Type: text/xml; charset=\"utf-8\"";
    private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
    private final String method;
    private String argument;
    private String soapaction;
    private String content;
    private OutputStream output;
    private String objectID;
    private int startingIndex;
    private int requestCount;
    private String browseFlag;
    private long lowRange;
    private InputStream inputStream;
    private RendererConfiguration mediaRenderer;
    private String transferMode;
    private String contentFeatures;
    private double timeseek;
    private double timeRangeEnd;
    private long highRange;
    private boolean http10;

    public RendererConfiguration getMediaRenderer() {
        return this.mediaRenderer;
    }

    public void setMediaRenderer(RendererConfiguration mediaRenderer) {
        this.mediaRenderer = mediaRenderer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getLowRange() {
        return this.lowRange;
    }

    public void setLowRange(long lowRange) {
        this.lowRange = lowRange;
    }

    public String getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(String transferMode) {
        this.transferMode = transferMode;
    }

    public String getContentFeatures() {
        return this.contentFeatures;
    }

    public void setContentFeatures(String contentFeatures) {
        this.contentFeatures = contentFeatures;
    }

    public double getTimeseek() {
        return this.timeseek;
    }

    public void setTimeseek(double timeseek) {
        this.timeseek = timeseek;
    }

    public void setTimeRangeEnd(double timeRangeEnd) {
        this.timeRangeEnd = timeRangeEnd;
    }

    public long getHighRange() {
        return this.highRange;
    }

    public void setHighRange(long highRange) {
        this.highRange = highRange;
    }

    public boolean isHttp10() {
        return this.http10;
    }

    public void setHttp10(boolean http10) {
        this.http10 = http10;
    }

    public Request(String method, String argument) {
        this.method = method;
        this.argument = argument;
    }

    public String getSoapaction() {
        return this.soapaction;
    }

    public void setSoapaction(String soapaction) {
        this.soapaction = soapaction;
    }

    public String getTextContent() {
        return this.content;
    }

    public void setTextContent(String content) {
        this.content = content;
    }

    public String getMethod() {
        return this.method;
    }

    public String getArgument() {
        return this.argument;
    }

    public void answer(OutputStream output, StartStopListenerDelegate startStopListenerDelegate) throws IOException {
        this.output = output;
        long CLoverride = -2L;
        if (this.lowRange != 0L || this.highRange != 0L) {
            this.output(output, this.http10 ? HTTP_206_OK_10 : HTTP_206_OK);
        } else if (this.soapaction != null && this.soapaction.contains("X_GetFeatureList")) {
            this.output(output, HTTP_500);
        } else {
            this.output(output, this.http10 ? HTTP_200_OK_10 : HTTP_200_OK);
        }
        StringBuilder response = new StringBuilder();
        DLNAResource dlna = null;
        boolean xbox = this.mediaRenderer.isXBOX();
        if (this.argument.startsWith("/")) {
            logger.trace("Stripping preceding slash from: " + this.argument);
            this.argument = this.argument.substring(1);
        }
        if ((this.method.equals("GET") || this.method.equals("HEAD")) && this.argument.startsWith("console/")) {
            this.output(output, "Content-Type: text/html");
            response.append(HTMLConsole.servePage(this.argument.substring(8)));
        } else if ((this.method.equals("GET") || this.method.equals("HEAD")) && this.argument.startsWith("get/")) {
            String id = this.argument.substring(this.argument.indexOf("get/") + 4, this.argument.lastIndexOf("/"));
            id = id.replace("%24", "$");
            List<DLNAResource> files = PMS.get().getRootFolder(this.mediaRenderer).getDLNAResources(id, false, 0, 0, this.mediaRenderer);
            if (this.transferMode != null) {
                this.output(output, "TransferMode.DLNA.ORG: " + this.transferMode);
            }
            if (files.size() == 1) {
                dlna = files.get(0);
                String fileName = this.argument.substring(this.argument.lastIndexOf("/") + 1);
                if (fileName.startsWith("thumbnail0000")) {
                    this.output(output, "Content-Type: " + dlna.getThumbnailContentType());
                    this.output(output, "Accept-Ranges: bytes");
                    this.output(output, "Expires: " + this.getFUTUREDATE() + " GMT");
                    this.output(output, "Connection: keep-alive");
                    if (this.mediaRenderer.isMediaParserV2()) {
                        dlna.checkThumbnail();
                    }
                    this.inputStream = dlna.getThumbnailInputStream();
                } else if (fileName.indexOf("subtitle0000") > -1) {
                    DLNAMediaSubtitle sub;
                    this.output(output, "Content-Type: text/plain");
                    this.output(output, "Expires: " + this.getFUTUREDATE() + " GMT");
                    List<DLNAMediaSubtitle> subs = dlna.getMedia().getSubtitleTracksList();
                    if (subs != null && !subs.isEmpty() && (sub = subs.get(0)).isExternal()) {
                        this.inputStream = new FileInputStream(sub.getExternalFile());
                    }
                } else {
                    String name = dlna.getDisplayName(this.mediaRenderer);
                    this.inputStream = dlna.getInputStream(Range.create(this.lowRange, this.highRange, this.timeseek, this.timeRangeEnd), this.mediaRenderer);
                    if (this.inputStream == null) {
                        logger.error("There is no inputstream to return for " + name);
                    } else {
                        DLNAMediaInfo media;
                        List<DLNAMediaSubtitle> subs;
                        String subtitleHttpHeader;
                        startStopListenerDelegate.start(dlna);
                        this.output(output, "Content-Type: " + this.getRendererMimeType(dlna.mimeType(), this.mediaRenderer));
                        if (!(configuration.isDisableSubtitles() || (subtitleHttpHeader = this.mediaRenderer.getSubtitleHttpHeader()) == null || "".equals(subtitleHttpHeader) || (subs = dlna.getMedia().getSubtitleTracksList()) == null || subs.isEmpty())) {
                            DLNAMediaSubtitle sub = subs.get(0);
                            String subExtension = sub.getType().getExtension();
                            String subtitleUrl = StringUtils.isNotBlank(subExtension) ? "http://" + PMS.get().getServer().getHost() + ':' + PMS.get().getServer().getPort() + "/get/" + id + "/subtitle0000." + subExtension : "http://" + PMS.get().getServer().getHost() + ':' + PMS.get().getServer().getPort() + "/get/" + id + "/subtitle0000";
                            this.output(output, subtitleHttpHeader + ": " + subtitleUrl);
                        }
                        if ((media = dlna.getMedia()) != null) {
                            if (StringUtils.isNotBlank(media.getContainer())) {
                                name = name + " [container: " + media.getContainer() + "]";
                            }
                            if (StringUtils.isNotBlank(media.getCodecV())) {
                                name = name + " [video: " + media.getCodecV() + "]";
                            }
                        }
                        PMS.get().getFrame().setStatusLine("Serving " + name);
                        boolean chunked = this.mediaRenderer.isChunkedTransfer();
                        long totalsize = dlna.length(this.mediaRenderer);
                        if (chunked && totalsize == 0x7FFFFFFF7FFFFFFFL) {
                            totalsize = -1L;
                        }
                        long remaining = totalsize - this.lowRange;
                        long requested = this.highRange - this.lowRange;
                        if (requested != 0L) {
                            long bytes;
                            long l = bytes = remaining > -1L ? remaining : (long)this.inputStream.available();
                            if (requested > 0L && bytes > requested) {
                                bytes = requested + 1L;
                            }
                            this.highRange = this.lowRange + bytes - (long)(bytes > 0L ? 1 : 0);
                            logger.trace((chunked ? "Using chunked response. " : "") + "Sending " + bytes + " bytes.");
                            this.output(output, "Content-Range: bytes " + this.lowRange + "-" + (this.highRange > -1L ? Long.valueOf(this.highRange) : "*") + "/" + (totalsize > -1L ? Long.valueOf(totalsize) : "*"));
                            CLoverride = chunked && requested < 0L && totalsize < 0L ? -1L : bytes;
                        } else {
                            CLoverride = remaining;
                        }
                        if (this.contentFeatures != null) {
                            this.output(output, "ContentFeatures.DLNA.ORG: " + dlna.getDlnaContentFeatures());
                        }
                        if (dlna.getPlayer() == null || xbox) {
                            this.output(output, "Accept-Ranges: bytes");
                        }
                        this.output(output, "Connection: keep-alive");
                    }
                }
            }
        } else if ((this.method.equals("GET") || this.method.equals("HEAD")) && (this.argument.toLowerCase().endsWith(".png") || this.argument.toLowerCase().endsWith(".jpg") || this.argument.toLowerCase().endsWith(".jpeg"))) {
            if (this.argument.toLowerCase().endsWith(".png")) {
                this.output(output, "Content-Type: image/png");
            } else {
                this.output(output, "Content-Type: image/jpeg");
            }
            this.output(output, "Accept-Ranges: bytes");
            this.output(output, "Connection: keep-alive");
            this.output(output, "Expires: " + this.getFUTUREDATE() + " GMT");
            this.inputStream = this.getResourceInputStream(this.argument);
        } else if ((this.method.equals("GET") || this.method.equals("HEAD")) && (this.argument.equals("description/fetch") || this.argument.endsWith("1.0.xml"))) {
            String profileName = configuration.getProfileName();
            this.output(output, CONTENT_TYPE);
            this.output(output, "Cache-Control: no-cache");
            this.output(output, "Expires: 0");
            this.output(output, "Accept-Ranges: bytes");
            this.output(output, "Connection: keep-alive");
            this.inputStream = this.getResourceInputStream(this.argument.equals("description/fetch") ? "PMS.xml" : this.argument);
            if (this.argument.equals("description/fetch")) {
                byte[] b = new byte[this.inputStream.available()];
                this.inputStream.read(b);
                String s = new String(b);
                s = s.replace("[uuid]", PMS.get().usn());
                s = s.replace("[host]", PMS.get().getServer().getHost());
                s = s.replace("[port]", "" + PMS.get().getServer().getPort());
                if (xbox) {
                    logger.debug("DLNA changes for Xbox 360");
                    s = s.replace("PS3 Media Server", "PS3 Media Server [" + profileName + "] : Windows Media Connect");
                    s = s.replace("<modelName>PMS</modelName>", "<modelName>Windows Media Connect</modelName>");
                    s = s.replace("<serviceList>", "<serviceList>\r\n<service>\r\n<serviceType>urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1</serviceType>\r\n<serviceId>urn:microsoft.com:serviceId:X_MS_MediaReceiverRegistrar</serviceId>\r\n<SCPDURL>/upnp/mrr/scpd</SCPDURL>\r\n<controlURL>/upnp/mrr/control</controlURL>\r\n</service>\r\n");
                } else {
                    s = s.replace("PS3 Media Server", "PS3 Media Server [" + profileName + "]");
                }
                this.inputStream = new ByteArrayInputStream(s.getBytes());
            }
        } else if (this.method.equals("POST") && (this.argument.contains("MS_MediaReceiverRegistrar_control") || this.argument.contains("mrr/control"))) {
            this.output(output, CONTENT_TYPE_UTF8);
            response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            response.append(CRLF);
            response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
            response.append(CRLF);
            if (this.soapaction != null && this.soapaction.contains("IsAuthorized")) {
                response.append("<u:IsAuthorizedResponse xmlns:u=\"urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1\">\r\n<Result>1</Result>\r\n</u:IsAuthorizedResponse>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.contains("IsValidated")) {
                response.append("<u:IsValidatedResponse xmlns:u=\"urn:microsoft.com:service:X_MS_MediaReceiverRegistrar:1\">\r\n<Result>1</Result>\r\n</u:IsValidatedResponse>");
                response.append(CRLF);
            }
            response.append("</s:Body>\r\n</s:Envelope>");
            response.append(CRLF);
        } else if (this.method.equals("POST") && this.argument.endsWith("upnp/control/connection_manager")) {
            this.output(output, CONTENT_TYPE_UTF8);
            if (this.soapaction != null && this.soapaction.indexOf("ConnectionManager:1#GetProtocolInfo") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetProtocolInfoResponse xmlns:u=\"urn:schemas-upnp-org:service:ConnectionManager:1\"><Source>http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_SM,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_MED,http-get:*:image/jpeg:DLNA.ORG_PN=JPEG_LRG,http-get:*:audio/mpeg:DLNA.ORG_PN=MP3,http-get:*:audio/L16:DLNA.ORG_PN=LPCM,http-get:*:video/mpeg:DLNA.ORG_PN=AVC_TS_HD_24_AC3_ISO;SONY.COM_PN=AVC_TS_HD_24_AC3_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_24_AC3;SONY.COM_PN=AVC_TS_HD_24_AC3,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_24_AC3_T;SONY.COM_PN=AVC_TS_HD_24_AC3_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_PS_PAL,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_PS_NTSC,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_50_L2_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_60_L2_T,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_SD_EU_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_EU_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_50_AC3_T,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_50_L2_ISO;SONY.COM_PN=HD2_50_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_SD_60_AC3_T,http-get:*:video/mpeg:DLNA.ORG_PN=MPEG_TS_HD_60_L2_ISO;SONY.COM_PN=HD2_60_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_50_L2_T;SONY.COM_PN=HD2_50_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=MPEG_TS_HD_60_L2_T;SONY.COM_PN=HD2_60_T,http-get:*:video/mpeg:DLNA.ORG_PN=AVC_TS_HD_50_AC3_ISO;SONY.COM_PN=AVC_TS_HD_50_AC3_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_50_AC3;SONY.COM_PN=AVC_TS_HD_50_AC3,http-get:*:video/mpeg:DLNA.ORG_PN=AVC_TS_HD_60_AC3_ISO;SONY.COM_PN=AVC_TS_HD_60_AC3_ISO,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_60_AC3;SONY.COM_PN=AVC_TS_HD_60_AC3,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_50_AC3_T;SONY.COM_PN=AVC_TS_HD_50_AC3_T,http-get:*:video/vnd.dlna.mpeg-tts:DLNA.ORG_PN=AVC_TS_HD_60_AC3_T;SONY.COM_PN=AVC_TS_HD_60_AC3_T,http-get:*:video/x-mp2t-mphl-188:*,http-get:*:*:*,http-get:*:video/*:*,http-get:*:audio/*:*,http-get:*:image/*:*</Source><Sink></Sink></u:GetProtocolInfoResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            }
        } else if (this.method.equals("SUBSCRIBE")) {
            if (this.soapaction == null) {
                return;
            }
            this.output(output, CONTENT_TYPE_UTF8);
            this.output(output, "Content-Length: 0");
            this.output(output, "Connection: close");
            this.output(output, "SID: " + PMS.get().usn());
            this.output(output, "Server: " + PMS.get().getServerName());
            this.output(output, "Timeout: Second-1800");
            this.output(output, "");
            output.flush();
            String cb = this.soapaction.replace("<", "").replace(">", "");
            try {
                URL soapActionUrl = new URL(cb);
                String addr = soapActionUrl.getHost();
                int port = soapActionUrl.getPort();
                Socket sock = new Socket(addr, port);
                OutputStream out = sock.getOutputStream();
                this.output(out, "NOTIFY /" + this.argument + " HTTP/1.1");
                this.output(out, "SID: " + PMS.get().usn());
                this.output(out, "SEQ: 0");
                this.output(out, "NT: upnp:event");
                this.output(out, "NTS: upnp:propchange");
                this.output(out, "HOST: " + addr + ":" + port);
                this.output(out, CONTENT_TYPE_UTF8);
                sock.close();
            }
            catch (MalformedURLException ex) {
                logger.debug("Cannot parse address and port from soap action \"" + this.soapaction + "\"", ex);
            }
            if (this.argument.contains("connection_manager")) {
                response.append(HTTPXMLHelper.eventHeader("urn:schemas-upnp-org:service:ConnectionManager:1"));
                response.append(HTTPXMLHelper.eventProp("SinkProtocolInfo"));
                response.append(HTTPXMLHelper.eventProp("SourceProtocolInfo"));
                response.append(HTTPXMLHelper.eventProp("CurrentConnectionIDs"));
                response.append("</e:propertyset>");
            } else if (this.argument.contains("content_directory")) {
                response.append(HTTPXMLHelper.eventHeader("urn:schemas-upnp-org:service:ContentDirectory:1"));
                response.append(HTTPXMLHelper.eventProp("TransferIDs"));
                response.append(HTTPXMLHelper.eventProp("ContainerUpdateIDs"));
                response.append(HTTPXMLHelper.eventProp("SystemUpdateID", "" + DLNAResource.getSystemUpdateId()));
                response.append("</e:propertyset>");
            }
        } else if (this.method.equals("POST") && this.argument.endsWith("upnp/control/content_directory")) {
            this.output(output, CONTENT_TYPE_UTF8);
            if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#GetSystemUpdateID") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetSystemUpdateIDResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
                response.append(CRLF);
                response.append("<Id>").append(DLNAResource.getSystemUpdateId()).append("</Id>");
                response.append(CRLF);
                response.append("</u:GetSystemUpdateIDResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#GetSortCapabilities") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetSortCapabilitiesResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\"><SortCaps></SortCaps></u:GetSortCapabilitiesResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#X_GetFeatureList") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<s:Fault><faultCode>s:Client</faultCode><faultString>UPnPError</faultString><detail><UPnPError xmlns=\"urn:schemas-upnp-org:control-1-0\"><errorCode>401</errorCode><errorDescription>Invalid Action</errorDescription></UPnPError></detail></s:Fault>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && this.soapaction.indexOf("ContentDirectory:1#GetSearchCapabilities") > -1) {
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                response.append("<u:GetSearchCapabilitiesResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\"><SearchCaps></SearchCaps></u:GetSearchCapabilitiesResponse>");
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            } else if (this.soapaction != null && (this.soapaction.contains("ContentDirectory:1#Browse") || this.soapaction.contains("ContentDirectory:1#Search"))) {
                this.objectID = this.getEnclosingValue(this.content, "<ObjectID>", "</ObjectID>");
                String containerID = null;
                if (StringUtils.isEmpty(this.objectID) && xbox) {
                    containerID = this.getEnclosingValue(this.content, "<ContainerID>", "</ContainerID>");
                    if (containerID == null || !containerID.contains("$")) {
                        this.objectID = "0";
                    } else {
                        this.objectID = containerID;
                        containerID = null;
                    }
                }
                String sI = this.getEnclosingValue(this.content, "<StartingIndex>", "</StartingIndex>");
                String rC = this.getEnclosingValue(this.content, "<RequestedCount>", "</RequestedCount>");
                this.browseFlag = this.getEnclosingValue(this.content, "<BrowseFlag>", "</BrowseFlag>");
                if (sI != null) {
                    this.startingIndex = Integer.parseInt(sI.toString());
                }
                if (rC != null) {
                    this.requestCount = Integer.parseInt(rC.toString());
                }
                response.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                response.append(CRLF);
                response.append("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<s:Body>");
                response.append(CRLF);
                if (this.soapaction != null && this.soapaction.contains("ContentDirectory:1#Search")) {
                    response.append("<u:SearchResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
                } else {
                    response.append("<u:BrowseResponse xmlns:u=\"urn:schemas-upnp-org:service:ContentDirectory:1\">");
                }
                response.append(CRLF);
                response.append("<Result>");
                response.append("&lt;DIDL-Lite xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\"&gt;");
                if (this.soapaction != null && this.soapaction.contains("ContentDirectory:1#Search")) {
                    this.browseFlag = "BrowseDirectChildren";
                }
                String searchCriteria = null;
                if (xbox && configuration.getUseCache() && PMS.get().getLibrary() != null && containerID != null) {
                    String artist;
                    if (containerID.equals("7") && PMS.get().getLibrary().getAlbumFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getAlbumFolder().getResourceId();
                    } else if (containerID.equals("6") && PMS.get().getLibrary().getArtistFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getArtistFolder().getResourceId();
                    } else if (containerID.equals("5") && PMS.get().getLibrary().getGenreFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getGenreFolder().getResourceId();
                    } else if (containerID.equals("F") && PMS.get().getLibrary().getPlaylistFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getPlaylistFolder().getResourceId();
                    } else if (containerID.equals("4") && PMS.get().getLibrary().getAllFolder() != null) {
                        this.objectID = PMS.get().getLibrary().getAllFolder().getResourceId();
                    } else if (containerID.equals("1") && (artist = this.getEnclosingValue(this.content, "upnp:artist = &quot;", "&quot;)")) != null) {
                        this.objectID = PMS.get().getLibrary().getArtistFolder().getResourceId();
                        searchCriteria = artist;
                    }
                }
                List<DLNAResource> files = PMS.get().getRootFolder(this.mediaRenderer).getDLNAResources(this.objectID, this.browseFlag != null && this.browseFlag.equals("BrowseDirectChildren"), this.startingIndex, this.requestCount, this.mediaRenderer);
                if (searchCriteria != null && files != null) {
                    for (int i = files.size() - 1; i >= 0; --i) {
                        if (files.get(i).getName().equals(searchCriteria)) continue;
                        files.remove(i);
                    }
                    if (files.size() > 0) {
                        files = files.get(0).getChildren();
                    }
                }
                int minus = 0;
                if (files != null) {
                    for (DLNAResource uf : files) {
                        if (xbox && containerID != null) {
                            uf.setFakeParentId(containerID);
                        }
                        if (uf.isCompatible(this.mediaRenderer) && (uf.getPlayer() == null || uf.getPlayer().isPlayerCompatible(this.mediaRenderer))) {
                            response.append(uf.toString(this.mediaRenderer));
                            continue;
                        }
                        ++minus;
                    }
                }
                response.append("&lt;/DIDL-Lite&gt;");
                response.append("</Result>");
                response.append(CRLF);
                int filessize = 0;
                if (files != null) {
                    filessize = files.size();
                }
                response.append("<NumberReturned>").append(filessize - minus).append("</NumberReturned>");
                response.append(CRLF);
                DLNAResource parentFolder = null;
                if (files != null && filessize > 0) {
                    parentFolder = files.get(0).getParent();
                }
                if (this.browseFlag != null && this.browseFlag.equals("BrowseDirectChildren") && this.mediaRenderer.isMediaParserV2() && this.mediaRenderer.isDLNATreeHack()) {
                    int totalCount = this.startingIndex + this.requestCount + 1;
                    if (filessize - minus <= 0) {
                        totalCount = this.startingIndex;
                    }
                    response.append("<TotalMatches>").append(totalCount).append("</TotalMatches>");
                } else if (this.browseFlag != null && this.browseFlag.equals("BrowseDirectChildren")) {
                    response.append("<TotalMatches>").append((parentFolder != null ? parentFolder.childrenNumber() : filessize) - minus).append("</TotalMatches>");
                } else {
                    response.append("<TotalMatches>1</TotalMatches>");
                }
                response.append(CRLF);
                response.append("<UpdateID>");
                if (parentFolder != null) {
                    response.append(parentFolder.getUpdateId());
                } else {
                    response.append("1");
                }
                response.append("</UpdateID>");
                response.append(CRLF);
                if (this.soapaction != null && this.soapaction.contains("ContentDirectory:1#Search")) {
                    response.append("</u:SearchResponse>");
                } else {
                    response.append("</u:BrowseResponse>");
                }
                response.append(CRLF);
                response.append("</s:Body>\r\n</s:Envelope>");
                response.append(CRLF);
            }
        }
        this.output(output, "Server: " + PMS.get().getServerName());
        if (response.length() > 0) {
            byte[] responseData = response.toString().getBytes("UTF-8");
            this.output(output, "Content-Length: " + responseData.length);
            this.output(output, "");
            if (!this.method.equals("HEAD")) {
                output.write(responseData);
            }
        } else if (this.inputStream != null) {
            if (CLoverride > -2L) {
                if (CLoverride > -1L && CLoverride != 0x7FFFFFFF7FFFFFFFL) {
                    this.output(output, "Content-Length: " + CLoverride);
                }
            } else {
                int cl = this.inputStream.available();
                logger.trace("Available Content-Length: " + cl);
                this.output(output, "Content-Length: " + cl);
            }
            if (this.timeseek > 0.0 && dlna != null) {
                String timeseekValue = DLNAMediaInfo.getDurationString(this.timeseek);
                String timetotalValue = dlna.getMedia().getDurationString();
                this.output(output, "TimeSeekRange.dlna.org: npt=" + timeseekValue + "-" + timetotalValue + "/" + timetotalValue);
                this.output(output, "X-Seek-Range: npt=" + timeseekValue + "-" + timetotalValue + "/" + timetotalValue);
            }
            this.output(output, "");
            int sendB = 0;
            if (this.lowRange != 99999475712L && !this.method.equals("HEAD")) {
                sendB = this.sendBytes(this.inputStream);
            }
            logger.trace("Sending stream: " + sendB + " bytes of " + this.argument);
            PMS.get().getFrame().setStatusLine(null);
        } else {
            if (this.lowRange > 0L && this.highRange > 0L) {
                this.output(output, "Content-Length: " + (this.highRange - this.lowRange + 1L));
            } else {
                this.output(output, "Content-Length: 0");
            }
            this.output(output, "");
        }
    }

    private void output(OutputStream output, String line) throws IOException {
        output.write((line + CRLF).getBytes("UTF-8"));
        logger.trace("Wrote on socket: " + line);
    }

    private String getFUTUREDATE() {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(new Date(10000000000L + System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendBytes(InputStream fis) throws IOException {
        byte[] buffer = new byte[32768];
        int sendBytes = 0;
        try {
            int bytes;
            while ((bytes = fis.read(buffer)) != -1) {
                this.output.write(buffer, 0, bytes);
                sendBytes += bytes;
            }
        }
        catch (IOException e) {
            logger.trace("Sending stream with premature end: " + sendBytes + " bytes of " + this.argument + ". Reason: " + e.getMessage());
        }
        finally {
            fis.close();
        }
        return sendBytes;
    }

    private String getEnclosingValue(String content, String leftTag, String rightTag) {
        String result = null;
        int leftTagPos = content.indexOf(leftTag);
        int rightTagPos = content.indexOf(rightTag, leftTagPos + 1);
        if (leftTagPos > -1 && rightTagPos > leftTagPos) {
            result = content.substring(leftTagPos + leftTag.length(), rightTagPos);
        }
        return result;
    }
}

