/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.ptr.LongByReference;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.prefs.Preferences;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.io.BasicSystemUtils;
import net.pms.io.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinUtils
extends BasicSystemUtils
implements SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(WinUtils.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private static final int KEY_READ = 131097;
    private boolean kerio;
    private String avsPluginsDir;
    public long lastDontSleepCall = 0L;
    public long lastGoToSleepCall = 0L;

    @Override
    public void disableGoToSleep() {
        if (configuration.isPreventsSleep() && System.currentTimeMillis() - this.lastDontSleepCall > 40000L) {
            logger.trace("Calling SetThreadExecutionState ES_SYSTEM_REQUIRED");
            Kernel32.INSTANCE.SetThreadExecutionState(-2147483647);
            this.lastDontSleepCall = System.currentTimeMillis();
        }
    }

    @Override
    public void reenableGoToSleep() {
        if (configuration.isPreventsSleep() && System.currentTimeMillis() - this.lastGoToSleepCall > 40000L) {
            logger.trace("Calling SetThreadExecutionState ES_CONTINUOUS");
            Kernel32.INSTANCE.SetThreadExecutionState(Integer.MIN_VALUE);
            this.lastGoToSleepCall = System.currentTimeMillis();
        }
    }

    @Override
    public File getAvsPluginsDir() {
        if (this.avsPluginsDir == null) {
            return null;
        }
        File pluginsDir = new File(this.avsPluginsDir);
        if (!pluginsDir.exists()) {
            pluginsDir = null;
        }
        return pluginsDir;
    }

    @Override
    public String getShortPathNameW(String longPathName) {
        boolean unicodeChars = false;
        try {
            byte[] b1 = longPathName.getBytes("UTF-8");
            byte[] b2 = longPathName.getBytes("cp1252");
            unicodeChars = b1.length != b2.length;
        }
        catch (Exception e) {
            return longPathName;
        }
        if (unicodeChars) {
            try {
                WString pathname = new WString(longPathName);
                char[] test = new char[2 + pathname.length() * 2];
                int r = Kernel32.INSTANCE.GetShortPathNameW(pathname, test, test.length);
                if (r > 0) {
                    logger.debug("Forcing short path name on " + pathname);
                    return Native.toString(test);
                }
                logger.info("File does not exist? " + pathname);
                return null;
            }
            catch (Exception e) {
                return longPathName;
            }
        }
        return longPathName;
    }

    @Override
    public String getWindowsDirectory() {
        char[] test = new char[514];
        int r = Kernel32.INSTANCE.GetWindowsDirectoryW(test, 256);
        if (r > 0) {
            return Native.toString(test);
        }
        return null;
    }

    @Override
    public String getDiskLabel(File f) {
        try {
            int nFileSystemNameSize;
            CharBuffer lpFileSystemNameBuffer_char;
            LongByReference lpFileSystemFlags;
            LongByReference lpMaximumComponentLength;
            LongByReference lpVolumeSerialNumber;
            String driveName = f.getCanonicalPath().substring(0, 2) + "\\";
            char[] lpRootPathName_chars = new char[4];
            for (int i = 0; i < 3; ++i) {
                lpRootPathName_chars[i] = driveName.charAt(i);
            }
            lpRootPathName_chars[3] = '\u0000';
            int nVolumeNameSize = 256;
            CharBuffer lpVolumeNameBuffer_char = CharBuffer.allocate(nVolumeNameSize);
            boolean result2 = Kernel32.INSTANCE.GetVolumeInformationW(lpRootPathName_chars, lpVolumeNameBuffer_char, nVolumeNameSize, lpVolumeSerialNumber = new LongByReference(), lpMaximumComponentLength = new LongByReference(), lpFileSystemFlags = new LongByReference(), lpFileSystemNameBuffer_char = CharBuffer.allocate(nFileSystemNameSize = 256), nFileSystemNameSize);
            if (!result2) {
                return null;
            }
            String diskLabel = this.charString2String(lpVolumeNameBuffer_char);
            return diskLabel;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String charString2String(CharBuffer buf) {
        int i;
        char[] chars = buf.array();
        for (i = 0; i < chars.length && chars[i] != '\u0000'; ++i) {
        }
        return new String(chars, 0, i);
    }

    public WinUtils() {
        this.start();
    }

    private void start() {
        Preferences userRoot = Preferences.userRoot();
        Preferences systemRoot = Preferences.systemRoot();
        Class<?> clz = userRoot.getClass();
        try {
            if (clz.getName().endsWith("WindowsPreferences")) {
                byte[] valb;
                Method openKey = clz.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                openKey.setAccessible(true);
                Method closeKey = clz.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                closeKey.setAccessible(true);
                Method winRegQueryValue = clz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                winRegQueryValue.setAccessible(true);
                String key = "SOFTWARE\\VideoLAN\\VLC";
                int[] handles = (int[])openKey.invoke((Object)systemRoot, -2147483646, WinUtils.toCstr(key), 131097);
                if (handles.length != 2 || handles[0] == 0 || handles[1] != 0) {
                    key = "SOFTWARE\\Wow6432Node\\VideoLAN\\VLC";
                    handles = (int[])openKey.invoke((Object)systemRoot, -2147483646, WinUtils.toCstr(key), 131097);
                }
                if (handles.length == 2 && handles[0] != 0 && handles[1] == 0) {
                    valb = (byte[])winRegQueryValue.invoke((Object)systemRoot, handles[0], WinUtils.toCstr(""));
                    this.vlcp = valb != null ? new String(valb).trim() : null;
                    valb = (byte[])winRegQueryValue.invoke((Object)systemRoot, handles[0], WinUtils.toCstr("Version"));
                    this.vlcv = valb != null ? new String(valb).trim() : null;
                    closeKey.invoke((Object)systemRoot, handles[0]);
                }
                key = "SOFTWARE\\AviSynth";
                handles = (int[])openKey.invoke((Object)systemRoot, -2147483646, WinUtils.toCstr(key), 131097);
                if (handles.length != 2 || handles[0] == 0 || handles[1] != 0) {
                    key = "SOFTWARE\\Wow6432Node\\AviSynth";
                    handles = (int[])openKey.invoke((Object)systemRoot, -2147483646, WinUtils.toCstr(key), 131097);
                }
                if (handles.length == 2 && handles[0] != 0 && handles[1] == 0) {
                    this.avis = true;
                    valb = (byte[])winRegQueryValue.invoke((Object)systemRoot, handles[0], WinUtils.toCstr("plugindir2_5"));
                    this.avsPluginsDir = valb != null ? new String(valb).trim() : null;
                    closeKey.invoke((Object)systemRoot, handles[0]);
                }
                key = "SOFTWARE\\Kerio";
                handles = (int[])openKey.invoke((Object)systemRoot, -2147483646, WinUtils.toCstr(key), 131097);
                if (handles.length == 2 && handles[0] != 0 && handles[1] == 0) {
                    this.kerio = true;
                }
            }
        }
        catch (Exception e) {
            logger.debug("Caught exception", e);
        }
    }

    @Override
    public boolean isKerioFirewall() {
        return this.kerio;
    }

    private static byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        for (int i = 0; i < str.length(); ++i) {
            result[i] = (byte)str.charAt(i);
        }
        result[str.length()] = 0;
        return result;
    }

    @Override
    public String[] getPingCommand(String hostAddress, int count, int packetSize) {
        return new String[]{"ping", "-n", Integer.toString(count), "-l", Integer.toString(packetSize), hostAddress};
    }

    public static interface Kernel32
    extends Library {
        public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary("kernel32", Kernel32.class);
        public static final Kernel32 SYNC_INSTANCE = (Kernel32)Native.synchronizedLibrary(INSTANCE);
        public static final int ES_DISPLAY_REQUIRED = 2;
        public static final int ES_SYSTEM_REQUIRED = 1;
        public static final int ES_CONTINUOUS = Integer.MIN_VALUE;

        public int GetShortPathNameW(WString var1, char[] var2, int var3);

        public int GetWindowsDirectoryW(char[] var1, int var2);

        public boolean GetVolumeInformationW(char[] var1, CharBuffer var2, int var3, LongByReference var4, LongByReference var5, LongByReference var6, CharBuffer var7, int var8);

        public int SetThreadExecutionState(int var1);
    }
}

