/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats.v2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum SubtitleType {
    UNKNOWN(0, "Generic", SubtitleType.list(new String[0]), SubtitleType.list(new String[0])),
    SUBRIP(1, "SubRip", SubtitleType.list("srt"), SubtitleType.list("S_TEXT/UTF8", "S_UTF8", "Subrip")),
    TEXT(2, "Text file", SubtitleType.list("txt"), SubtitleType.list(new String[0])),
    MICRODVD(3, "MicroDVD", SubtitleType.list("sub"), SubtitleType.list(new String[0])),
    SAMI(4, "SAMI", SubtitleType.list("smi"), SubtitleType.list(new String[0])),
    ASS(5, "(Advanced) SubStation Alpha", SubtitleType.list("ass", "ssa"), SubtitleType.list("S_TEXT/SSA", "S_TEXT/ASS", "S_SSA", "S_ASS", "SSA", "ASS")),
    VOBSUB(6, "VobSub", SubtitleType.list("idx"), SubtitleType.list("S_VOBSUB", "subp", "mp4s", "E0")),
    UNSUPPORTED(7, "Unsupported", SubtitleType.list(new String[0]), SubtitleType.list(new String[0])),
    USF(8, "Universal Subtitle Format", SubtitleType.list(new String[0]), SubtitleType.list("S_TEXT/USF", "S_USF")),
    BMP(9, "BMP", SubtitleType.list(new String[0]), SubtitleType.list("S_IMAGE/BMP")),
    DIVX(10, "DIVX subtitles", SubtitleType.list(new String[0]), SubtitleType.list("DXSB")),
    TX3G(11, "Timed text (TX3G)", SubtitleType.list(new String[0]), SubtitleType.list("tx3g")),
    PGS(12, "Blu-ray subtitles", SubtitleType.list(new String[0]), SubtitleType.list("S_HDMV/PGS", "PGS", "144"));

    private final int index;
    private final String description;
    private final List<String> fileExtensions;
    private final List<String> libMediaInfoCodecs;
    private static final Map<Integer, SubtitleType> stableIndexToSubtitleTypeMap;
    private static final Map<String, SubtitleType> fileExtensionToSubtitleTypeMap;
    private static final Map<String, SubtitleType> libmediainfoCodecToSubtitleTypeMap;

    private static List<String> list(String ... args) {
        return new ArrayList<String>(Arrays.asList(args));
    }

    public static SubtitleType valueOfStableIndex(int stableIndex) {
        SubtitleType subtitleType = stableIndexToSubtitleTypeMap.get(stableIndex);
        if (subtitleType == null) {
            subtitleType = UNKNOWN;
        }
        return subtitleType;
    }

    @Deprecated
    public static SubtitleType getSubtitleTypeByFileExtension(String fileExtension) {
        return SubtitleType.valueOfFileExtension(fileExtension);
    }

    public static SubtitleType valueOfFileExtension(String fileExtension) {
        if (StringUtils.isBlank(fileExtension)) {
            return UNKNOWN;
        }
        SubtitleType subtitleType = fileExtensionToSubtitleTypeMap.get(fileExtension.toLowerCase());
        if (subtitleType == null) {
            subtitleType = UNKNOWN;
        }
        return subtitleType;
    }

    @Deprecated
    public static SubtitleType getSubtitleTypeByLibMediaInfoCodec(String codec) {
        return SubtitleType.valueOfLibMediaInfoCodec(codec);
    }

    public static SubtitleType valueOfLibMediaInfoCodec(String codec) {
        if (StringUtils.isBlank(codec)) {
            return UNKNOWN;
        }
        SubtitleType subtitleType = libmediainfoCodecToSubtitleTypeMap.get(StringUtils.trim(codec).toLowerCase());
        if (subtitleType == null) {
            subtitleType = UNKNOWN;
        }
        return subtitleType;
    }

    public static Set<String> getSupportedFileExtensions() {
        return fileExtensionToSubtitleTypeMap.keySet();
    }

    private SubtitleType(int index, String description, List<String> fileExtensions, List<String> libMediaInfoCodecs) {
        this.index = index;
        this.description = description;
        this.fileExtensions = fileExtensions;
        this.libMediaInfoCodecs = libMediaInfoCodecs;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        if (this.fileExtensions.isEmpty()) {
            return "";
        }
        return this.fileExtensions.get(0);
    }

    public int getStableIndex() {
        return this.index;
    }

    static {
        stableIndexToSubtitleTypeMap = new HashMap<Integer, SubtitleType>();
        fileExtensionToSubtitleTypeMap = new HashMap<String, SubtitleType>();
        libmediainfoCodecToSubtitleTypeMap = new HashMap<String, SubtitleType>();
        for (SubtitleType subtitleType : SubtitleType.values()) {
            stableIndexToSubtitleTypeMap.put(subtitleType.getStableIndex(), subtitleType);
            for (String fileExtension : subtitleType.fileExtensions) {
                fileExtensionToSubtitleTypeMap.put(fileExtension.toLowerCase(), subtitleType);
            }
            for (String codec : subtitleType.libMediaInfoCodecs) {
                libmediainfoCodecToSubtitleTypeMap.put(codec.toLowerCase(), subtitleType);
            }
        }
    }
}

