/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats.v2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.formats.v2.AudioAttribute;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioProperties {
    private static final Logger logger = LoggerFactory.getLogger(AudioProperties.class);
    private static final Pattern intPattern = Pattern.compile("([\\+-]?\\d+)([eE][\\+-]?\\d+)?");
    private static final Pattern floatPattern = Pattern.compile("([\\+-]?\\d(\\.\\d*)?|\\.\\d+)([eE][\\+-]?(\\d(\\.\\d*)?|\\.\\d+))?");
    private int numberOfChannels = 2;
    private int audioDelay = 0;
    private int sampleFrequency = 48000;

    public int getAttribute(AudioAttribute attribute) {
        switch (attribute) {
            case CHANNELS_NUMBER: {
                return this.getNumberOfChannels();
            }
            case DELAY: {
                return this.getAudioDelay();
            }
            case SAMPLE_FREQUENCY: {
                return this.getSampleFrequency();
            }
        }
        throw new IllegalArgumentException("Unimplemented attribute");
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public void setNumberOfChannels(int numberOfChannels) {
        if (numberOfChannels < 1) {
            throw new IllegalArgumentException("Channel number can't be less than 1.");
        }
        this.numberOfChannels = numberOfChannels;
    }

    public void setNumberOfChannels(String mediaInfoValue) {
        this.numberOfChannels = AudioProperties.getChannelsNumberFromLibMediaInfo(mediaInfoValue);
    }

    public int getAudioDelay() {
        return this.audioDelay;
    }

    public void setAudioDelay(int audioDelay) {
        this.audioDelay = audioDelay;
    }

    public void setAudioDelay(String mediaInfoValue) {
        this.audioDelay = AudioProperties.getAudioDelayFromLibMediaInfo(mediaInfoValue);
    }

    public int getSampleFrequency() {
        return this.sampleFrequency;
    }

    public void setSampleFrequency(int sampleFrequency) {
        if (sampleFrequency < 1) {
            throw new IllegalArgumentException("Sample frequency can't be less than 1 Hz.");
        }
        this.sampleFrequency = sampleFrequency;
    }

    public void setSampleFrequency(String mediaInfoValue) {
        this.sampleFrequency = AudioProperties.getSampleFrequencyFromLibMediaInfo(mediaInfoValue);
    }

    public static int getChannelsNumberFromLibMediaInfo(String mediaInfoValue) {
        if (StringUtils.isEmpty(mediaInfoValue)) {
            logger.warn("Empty value passed in. Returning default number 2.");
            return 2;
        }
        int result = -1;
        Matcher intMatcher = intPattern.matcher(mediaInfoValue);
        while (intMatcher.find()) {
            String matchResult = intMatcher.group();
            try {
                int currentResult = Integer.parseInt(matchResult);
                if (currentResult <= result) continue;
                result = currentResult;
            }
            catch (NumberFormatException ex) {
                logger.warn("NumberFormatException during parsing substring {} from value {}", (Object)matchResult, (Object)mediaInfoValue);
            }
        }
        if (result <= 0) {
            logger.warn("Can't parse value {}. Returning default number 2.", (Object)mediaInfoValue);
            return 2;
        }
        return result;
    }

    public static int getAudioDelayFromLibMediaInfo(String mediaInfoValue) {
        if (StringUtils.isEmpty(mediaInfoValue)) {
            logger.warn("Empty value passed in. Returning default number 0.");
            return 0;
        }
        int result = 0;
        Matcher intMatcher = intPattern.matcher(mediaInfoValue);
        if (intMatcher.find()) {
            String matchResult = intMatcher.group();
            try {
                result = Integer.parseInt(matchResult);
            }
            catch (NumberFormatException ex) {
                logger.warn("NumberFormatException during parsing substring {} from value {}", (Object)matchResult, (Object)mediaInfoValue);
            }
        }
        return result;
    }

    public static int getSampleFrequencyFromLibMediaInfo(String mediaInfoValue) {
        if (StringUtils.isEmpty(mediaInfoValue)) {
            logger.warn("Empty value passed in. Returning default number 48000 Hz.");
            return 48000;
        }
        int result = -1;
        Matcher intMatcher = intPattern.matcher(mediaInfoValue);
        while (intMatcher.find()) {
            String matchResult = intMatcher.group();
            try {
                int currentResult = Integer.parseInt(matchResult);
                if (currentResult <= result) continue;
                result = currentResult;
            }
            catch (NumberFormatException ex) {
                logger.warn("NumberFormatException during parsing substring {} from value {}", (Object)matchResult, (Object)mediaInfoValue);
            }
        }
        if (result < 1) {
            logger.warn("Can't parse value {}. Returning default number 48000 Hz.", (Object)mediaInfoValue);
            return 48000;
        }
        return result;
    }
}

