/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.PlayerPurpose;
import net.pms.encoders.VideoLanVideoStreaming;
import net.pms.util.PlayerUtil;

public class VideoLanAudioStreaming
extends VideoLanVideoStreaming {
    public static final String ID = "vlcaudio";

    public VideoLanAudioStreaming(PmsConfiguration configuration) {
        super(configuration);
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.AUDIO_WEB_STREAM_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String name() {
        return "VLC Web Audio (Legacy)";
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    public String mimeType() {
        return "audio/wav";
    }

    @Override
    protected String getEncodingArgs() {
        return "acodec=s16l,channels=2";
    }

    @Override
    protected String getMux() {
        return "wav";
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isWebAudio(resource);
    }
}

