/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaAudio;
import net.pms.dlna.DLNAMediaLang;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DLNAResource;
import net.pms.formats.FormatFactory;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DVDISOTitle
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(DVDISOTitle.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private File file;
    private int title;
    private long length;

    public DVDISOTitle(File file, int title) {
        this.file = file;
        this.title = title;
        this.setLastModified(file.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void resolveOnce() {
        String[] cmd = new String[]{configuration.getMplayerPath(), "-identify", "-endpos", "0", "-v", "-ao", "null", "-vc", "null", "-vo", "null", "-dvd-device", ProcessUtil.getShortFileNameIfWideChars(this.file.getAbsolutePath()), "dvd://" + this.title};
        OutputParams params = new OutputParams(configuration);
        params.maxBufferSize = 1.0;
        if (configuration.isDvdIsoThumbnails()) {
            try {
                params.workDir = configuration.getTempFolder();
            }
            catch (IOException e1) {
                logger.debug("Caught exception", e1);
            }
            cmd[2] = "-frames";
            cmd[3] = "2";
            cmd[7] = "-quiet";
            cmd[8] = "-quiet";
            String frameName = "" + this.hashCode();
            frameName = "mplayer_thumbs:subdirs=\"" + frameName + "\"";
            frameName = frameName.replace(',', '_');
            cmd[10] = "jpeg:outdir=" + frameName;
        }
        params.log = true;
        final ProcessWrapperImpl pw = new ProcessWrapperImpl(cmd, params, true, false);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pw.stopProcess();
            }
        };
        Thread failsafe = new Thread(r, "DVD ISO Title Failsafe");
        failsafe.start();
        pw.runInSameThread();
        List<String> lines = pw.getOtherResults();
        String duration = null;
        int nbsectors = 0;
        String fps = null;
        String aspect = null;
        String width = null;
        String height = null;
        ArrayList<DLNAMediaAudio> audio = new ArrayList<DLNAMediaAudio>();
        ArrayList<DLNAMediaSubtitle> subs = new ArrayList<DLNAMediaSubtitle>();
        if (lines != null) {
            for (String line : lines) {
                DLNAMediaLang lang;
                if (line.startsWith("DVD start=")) {
                    nbsectors = Integer.parseInt(line.substring(line.lastIndexOf("=") + 1).trim());
                }
                if (line.startsWith("audio stream:")) {
                    lang = new DLNAMediaAudio();
                    lang.setId(Integer.parseInt(line.substring(line.indexOf("aid: ") + 5, line.lastIndexOf(".")).trim()));
                    lang.setLang(line.substring(line.indexOf("language: ") + 10, line.lastIndexOf(" aid")).trim());
                    int end = line.lastIndexOf(" langu");
                    if (line.lastIndexOf("(") < end && line.lastIndexOf("(") > line.indexOf("format: ")) {
                        end = line.lastIndexOf("(");
                    }
                    ((DLNAMediaAudio)lang).setCodecA(line.substring(line.indexOf("format: ") + 8, end).trim());
                    if (line.contains("(stereo)")) {
                        ((DLNAMediaAudio)lang).getAudioProperties().setNumberOfChannels(2);
                    } else {
                        ((DLNAMediaAudio)lang).getAudioProperties().setNumberOfChannels(6);
                    }
                    audio.add((DLNAMediaAudio)lang);
                }
                if (line.startsWith("subtitle")) {
                    lang = new DLNAMediaSubtitle();
                    lang.setId(Integer.parseInt(line.substring(line.indexOf("): ") + 3, line.lastIndexOf("language")).trim()));
                    lang.setLang(line.substring(line.indexOf("language: ") + 10).trim());
                    if (lang.getLang().equals("unknown")) {
                        lang.setLang("und");
                    }
                    ((DLNAMediaSubtitle)lang).setType(SubtitleType.UNKNOWN);
                    subs.add((DLNAMediaSubtitle)lang);
                }
                if (line.startsWith("ID_VIDEO_WIDTH=")) {
                    width = line.substring(line.indexOf("ID_VIDEO_WIDTH=") + 15).trim();
                }
                if (line.startsWith("ID_VIDEO_HEIGHT=")) {
                    height = line.substring(line.indexOf("ID_VIDEO_HEIGHT=") + 16).trim();
                }
                if (line.startsWith("ID_VIDEO_FPS=")) {
                    fps = line.substring(line.indexOf("ID_VIDEO_FPS=") + 13).trim();
                }
                if (line.startsWith("ID_LENGTH=")) {
                    duration = line.substring(line.indexOf("ID_LENGTH=") + 10).trim();
                }
                if (!line.startsWith("ID_VIDEO_ASPECT=")) continue;
                aspect = line.substring(line.indexOf("ID_VIDEO_ASPECT=") + 16).trim();
            }
        }
        if (configuration.isDvdIsoThumbnails()) {
            try {
                String frameName = "" + this.hashCode();
                frameName = configuration.getTempFolder() + "/mplayer_thumbs/" + frameName + "00000001/0000000";
                frameName = frameName.replace(',', '_');
                File jpg = new File(frameName + "2.jpg");
                if (jpg.exists()) {
                    FileInputStream is = new FileInputStream(jpg);
                    try {
                        int sz = ((InputStream)is).available();
                        if (sz > 0) {
                            this.getMedia().setThumb(new byte[sz]);
                            ((InputStream)is).read(this.getMedia().getThumb());
                        }
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    if (!jpg.delete()) {
                        jpg.deleteOnExit();
                    }
                    if (!jpg.getParentFile().delete() && !jpg.getParentFile().delete()) {
                        logger.debug("Failed to delete \"" + jpg.getParentFile().getAbsolutePath() + "\"");
                    }
                }
                if ((jpg = new File(frameName + "1.jpg")).exists()) {
                    if (!jpg.delete()) {
                        jpg.deleteOnExit();
                    }
                    if (!jpg.getParentFile().delete()) {
                        jpg.getParentFile().delete();
                    }
                }
            }
            catch (IOException e) {
                logger.trace("Error in DVD ISO thumbnail retrieval: " + e.getMessage());
            }
        }
        this.length = nbsectors * 2048;
        double d = 0.0;
        if (duration != null) {
            d = Double.parseDouble(duration);
        }
        this.getMedia().setAudioTracksList(audio);
        this.getMedia().setSubtitleTracksList(subs);
        if (duration != null) {
            this.getMedia().setDuration(d);
        }
        this.getMedia().setFrameRate(fps);
        this.getMedia().setAspect(aspect);
        this.getMedia().setDvdtrack(this.title);
        this.getMedia().setContainer("iso");
        this.getMedia().setCodecV("mpeg2video");
        try {
            this.getMedia().setWidth(Integer.parseInt(width));
        }
        catch (NumberFormatException nfe) {
            logger.debug("Could not parse width \"" + width + "\"");
        }
        try {
            this.getMedia().setHeight(Integer.parseInt(height));
        }
        catch (NumberFormatException nfe) {
            logger.debug("Could not parse height \"" + height + "\"");
        }
        this.getMedia().setMediaparsed(true);
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return String.format(Messages.getString("DVDISOTitle.1"), this.title);
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    @Override
    public boolean isValid() {
        if (this.getFormat() == null) {
            this.setFormat(FormatFactory.getAssociatedFormat("dummy.iso"));
        }
        return true;
    }

    @Override
    public long length() {
        return 0x7FFFFFFF7FFFFFFFL;
    }

    @Override
    public long length(RendererConfiguration mediaRenderer) {
        int cbr_video_bitrate = this.getDefaultRenderer().getCBRVideoBitrate();
        return cbr_video_bitrate > 0 ? (long)((double)((cbr_video_bitrate + 256) * 1024 / 8) * 1.04 * this.getMedia().getDurationInSeconds()) : this.length();
    }

    @Override
    public InputStream getThumbnailInputStream() throws IOException {
        File cachedThumbnail = null;
        File thumbFolder = null;
        boolean alternativeCheck = false;
        while (cachedThumbnail == null) {
            if (thumbFolder == null) {
                thumbFolder = this.file.getParentFile();
            }
            if ((cachedThumbnail = FileUtil.getFileNameWithNewExtension(thumbFolder, this.file, "jpg")) == null) {
                cachedThumbnail = FileUtil.getFileNameWithNewExtension(thumbFolder, this.file, "png");
            }
            if (cachedThumbnail == null) {
                cachedThumbnail = FileUtil.getFileNameWithAddedExtension(thumbFolder, this.file, ".cover.jpg");
            }
            if (cachedThumbnail == null) {
                cachedThumbnail = FileUtil.getFileNameWithAddedExtension(thumbFolder, this.file, ".cover.png");
            }
            if (alternativeCheck) break;
            if (StringUtils.isNotBlank(configuration.getAlternateThumbFolder()) && !(thumbFolder = new File(configuration.getAlternateThumbFolder())).isDirectory()) {
                thumbFolder = null;
                break;
            }
            alternativeCheck = true;
        }
        if (cachedThumbnail != null) {
            return new FileInputStream(cachedThumbnail);
        }
        if (this.getMedia() != null && this.getMedia().getThumb() != null) {
            return this.getMedia().getThumbnailInputStream();
        }
        return this.getGenericThumbnailInputStream("images/cdrwblank-256.png");
    }
}

