/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import com.sun.jna.Platform;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.ConfigurationReader;
import net.pms.configuration.FormatConfiguration;
import net.pms.configuration.IpFilter;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.LibMediaInfoParser;
import net.pms.dlna.RootFolder;
import net.pms.formats.Format;
import net.pms.network.SpeedStats;
import net.pms.util.PropertiesUtil;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(RendererConfiguration.class);
    private static ArrayList<RendererConfiguration> rendererConfs;
    private static PmsConfiguration pmsConfiguration;
    private static RendererConfiguration defaultConf;
    private static Map<InetAddress, RendererConfiguration> addressAssociation;
    private RootFolder rootFolder;
    private final PropertiesConfiguration configuration = new PropertiesConfiguration();
    private final ConfigurationReader configurationReader = new ConfigurationReader(this.configuration, false);
    private FormatConfiguration formatConfiguration;
    private int rank;
    private final Map<String, String> mimes;
    private final Map<String, String> DLNAPN;
    private static final String DEPRECATED_MPEGPSAC3 = "MPEGAC3";
    private static final String LPCM = "LPCM";
    private static final String MP3 = "MP3";
    private static final String MPEGPSAC3 = "MPEGPSAC3";
    private static final String MPEGTSAC3 = "MPEGTSAC3";
    private static final String H264TSAC3 = "H264TSAC3";
    private static final String WAV = "WAV";
    private static final String WMV = "WMV";
    private static final String AUDIO = "Audio";
    private static final String AUTO_EXIF_ROTATE = "AutoExifRotate";
    private static final String BYTE_TO_TIMESEEK_REWIND_SECONDS = "ByteToTimeseekRewindSeconds";
    private static final String CBR_VIDEO_BITRATE = "CBRVideoBitrate";
    private static final String CHUNKED_TRANSFER = "ChunkedTransfer";
    private static final String CUSTOM_MENCODER_OPTIONS = "CustomMencoderOptions";
    private static final String CUSTOM_MENCODER_MPEG2_OPTIONS = "CustomMencoderQualitySettings";
    private static final String DEFAULT_VBV_BUFSIZE = "DefaultVBVBufSize";
    private static final String DLNA_LOCALIZATION_REQUIRED = "DLNALocalizationRequired";
    private static final String DLNA_ORGPN_USE = "DLNAOrgPN";
    private static final String DLNA_PN_CHANGES = "DLNAProfileChanges";
    private static final String DLNA_TREE_HACK = "CreateDLNATreeFaster";
    private static final String FORCE_JPG_THUMBNAILS = "ForceJPGThumbnails";
    private static final String H264_L41_LIMITED = "H264Level41Limited";
    private static final String IMAGE = "Image";
    private static final String LONG_FILENAME_FORMAT = "LongFilenameFormat";
    private static final String KEEP_PAD_VIDEO_WITH_BLACK_BORDERS = "PadVideoWithBlackBordersTo169AR";
    private static final String MAX_VIDEO_BITRATE = "MaxVideoBitrateMbps";
    private static final String MAX_VIDEO_HEIGHT = "MaxVideoHeight";
    private static final String MAX_VIDEO_WIDTH = "MaxVideoWidth";
    private static final String MEDIAPARSERV2 = "MediaInfo";
    private static final String MEDIAPARSERV2_THUMB = "MediaParserV2_ThumbnailGeneration";
    private static final String MIME_TYPES_CHANGES = "MimeTypesChanges";
    private static final String MUX_DTS_TO_MPEG = "MuxDTSToMpeg";
    private static final String MUX_H264_WITH_MPEGTS = "MuxH264ToMpegTS";
    private static final String MUX_LPCM_TO_MPEG = "MuxLPCMToMpeg";
    private static final String RENDERER_ICON = "RendererIcon";
    private static final String RENDERER_NAME = "RendererName";
    private static final String RESCALE_BY_RENDERER = "RescaleByRenderer";
    private static final String SEEK_BY_TIME = "SeekByTime";
    private static final String SHORT_FILENAME_FORMAT = "ShortFilenameFormat";
    private static final String SHOW_AUDIO_METADATA = "ShowAudioMetadata";
    private static final String SHOW_DVD_TITLE_DURATION = "ShowDVDTitleDuration";
    private static final String SHOW_SUB_METADATA = "ShowSubMetadata";
    private static final String STREAM_EXT = "StreamExtensions";
    private static final String SUBTITLE_HTTP_HEADER = "SubtitleHttpHeader";
    private static final String SUPPORTED = "Supported";
    private static final String THUMBNAIL_AS_RESOURCE = "ThumbnailAsResource";
    private static final String TRANSCODE_AUDIO_441KHZ = "TranscodeAudioTo441kHz";
    private static final String TRANSCODE_AUDIO = "TranscodeAudio";
    private static final String TRANSCODED_SIZE = "TranscodedVideoFileSize";
    private static final String TRANSCODE_EXT = "TranscodeExtensions";
    private static final String TRANSCODE_FAST_START = "TranscodeFastStart";
    private static final String TRANSCODE_VIDEO = "TranscodeVideo";
    private static final String USER_AGENT_ADDITIONAL_HEADER = "UserAgentAdditionalHeader";
    private static final String USER_AGENT_ADDITIONAL_SEARCH = "UserAgentAdditionalHeaderSearch";
    private static final String USER_AGENT = "UserAgentSearch";
    private static final String USE_SAME_EXTENSION = "UseSameExtension";
    private static final String VIDEO = "Video";
    private static final String WRAP_DTS_INTO_PCM = "WrapDTSIntoPCM";
    private static final String CUSTOM_FFMPEG_OPTIONS = "CustomFFmpegOptions";
    private static final String OVERRIDE_VF = "OverrideVideoFilter";

    public static RendererConfiguration getDefaultConf() {
        return defaultConf;
    }

    public static void loadRendererConfigurations(PmsConfiguration pmsConf) {
        RendererConfiguration fallbackConf;
        String rendererFallback;
        pmsConfiguration = pmsConf;
        rendererConfs = new ArrayList();
        try {
            defaultConf = new RendererConfiguration();
        }
        catch (ConfigurationException e) {
            logger.debug("Caught exception", e);
        }
        File renderersDir = RendererConfiguration.getRenderersDir();
        if (renderersDir != null) {
            logger.info("Loading renderer configurations from " + renderersDir.getAbsolutePath());
            Object[] confs = renderersDir.listFiles();
            Arrays.sort(confs);
            int rank = 1;
            for (Object f : confs) {
                if (!((File)f).getName().endsWith(".conf")) continue;
                try {
                    logger.info("Loading configuration file: {}", (Object)((File)f).getName());
                    RendererConfiguration r = new RendererConfiguration((File)f);
                    r.rank = rank++;
                    rendererConfs.add(r);
                }
                catch (ConfigurationException ce) {
                    logger.info("Error in loading configuration of: {}", (Object)((File)f).getAbsolutePath());
                }
            }
        }
        if (rendererConfs.size() > 0 && StringUtils.isNotBlank(rendererFallback = pmsConfiguration.getRendererDefault()) && (fallbackConf = RendererConfiguration.getRendererConfigurationByName(rendererFallback)) != null) {
            defaultConf = fallbackConf;
        }
    }

    private int getInt(String key, int def) {
        return this.configurationReader.getInt(key, def);
    }

    private long getLong(String key, int def) {
        return this.configurationReader.getLong(key, def);
    }

    private boolean getBoolean(String key, boolean def) {
        return this.configurationReader.getBoolean(key, def);
    }

    private String getString(String key, String def) {
        return this.configurationReader.getString(key, def);
    }

    public static ArrayList<RendererConfiguration> getAllRendererConfigurations() {
        return rendererConfs;
    }

    protected static File getRenderersDir() {
        String[] pathList;
        for (String path : pathList = PropertiesUtil.getProjectProperties().get("project.renderers.dir").split(",")) {
            File file;
            if (path.trim().length() <= 0 || !(file = new File(path.trim())).isDirectory()) continue;
            if (file.canRead()) {
                return file;
            }
            logger.warn("Can't read directory: {}", (Object)file.getAbsolutePath());
        }
        return null;
    }

    public static void resetAllRenderers() {
        for (RendererConfiguration rc : rendererConfs) {
            rc.rootFolder = null;
        }
    }

    public RootFolder getRootFolder() {
        if (this.rootFolder == null) {
            this.rootFolder = new RootFolder();
            if (pmsConfiguration.getUseCache()) {
                this.rootFolder.discoverChildren();
            }
        }
        return this.rootFolder;
    }

    public void associateIP(InetAddress sa) {
        addressAssociation.put(sa, this);
        SpeedStats.getInstance().getSpeedInMBits(sa, this.getRendererName());
    }

    public static RendererConfiguration getRendererConfigurationBySocketAddress(InetAddress inetAddress) {
        String forced = pmsConfiguration.getRendererForceIp();
        if (forced != null && !"".equals(forced)) {
            for (String tuple : forced.split(",")) {
                RendererConfiguration renderer;
                IpFilter filter;
                if (tuple.indexOf("@") <= -1) continue;
                String name = tuple.split("@")[0];
                String ip = tuple.split("@")[1];
                if ("".equals(name) || "".equals(ip) || !(filter = new IpFilter(ip)).isMatch(inetAddress) || (renderer = RendererConfiguration.getRendererConfigurationByName(name)) == null) continue;
                logger.trace("Forcing renderer match to \"" + renderer.getRendererName() + "\" based on forced IP address configuration");
                addressAssociation.put(inetAddress, renderer);
                return renderer;
            }
        }
        return addressAssociation.get(inetAddress);
    }

    public static RendererConfiguration getRendererConfigurationByUA(String userAgentString) {
        if (pmsConfiguration.isRendererForceDefault()) {
            logger.trace("Forcing renderer match to \"" + defaultConf.getRendererName() + "\"");
            return RendererConfiguration.manageRendererMatch(defaultConf);
        }
        for (RendererConfiguration r : rendererConfs) {
            if (!r.matchUserAgent(userAgentString)) continue;
            return RendererConfiguration.manageRendererMatch(r);
        }
        return null;
    }

    private static RendererConfiguration manageRendererMatch(RendererConfiguration r) {
        if (addressAssociation.values().contains(r)) {
            logger.info("Another renderer like " + r.getRendererName() + " was found!");
        }
        return r;
    }

    public static RendererConfiguration getRendererConfigurationByUAAHH(String header) {
        if (pmsConfiguration.isRendererForceDefault()) {
            logger.trace("Forcing renderer match to \"" + defaultConf.getRendererName() + "\"");
            return RendererConfiguration.manageRendererMatch(defaultConf);
        }
        for (RendererConfiguration r : rendererConfs) {
            String value;
            if (!StringUtils.isNotBlank(r.getUserAgentAdditionalHttpHeader()) || !header.startsWith(r.getUserAgentAdditionalHttpHeader()) || !r.matchAdditionalUserAgent(value = header.substring(header.indexOf(":", r.getUserAgentAdditionalHttpHeader().length()) + 1))) continue;
            return RendererConfiguration.manageRendererMatch(r);
        }
        return null;
    }

    public static RendererConfiguration getRendererConfigurationByName(String name) {
        for (RendererConfiguration conf : rendererConfs) {
            if (!conf.getRendererName().toLowerCase().contains(name.toLowerCase())) continue;
            return conf;
        }
        return null;
    }

    public FormatConfiguration getFormatConfiguration() {
        return this.formatConfiguration;
    }

    public int getRank() {
        return this.rank;
    }

    @Deprecated
    public boolean isXBOX() {
        return this.getRendererName().toUpperCase().contains("XBOX");
    }

    @Deprecated
    public boolean isXBMC() {
        return this.getRendererName().toUpperCase().contains("XBMC");
    }

    public boolean isPS3() {
        return this.getRendererName().toUpperCase().contains("PLAYSTATION") || this.getRendererName().toUpperCase().contains("PS3");
    }

    public boolean isBRAVIA() {
        return this.getRendererName().toUpperCase().contains("BRAVIA");
    }

    @Deprecated
    public boolean isFDSSDP() {
        return this.getRendererName().toUpperCase().contains("FDSSDP");
    }

    public int getByteToTimeseekRewindSeconds() {
        return this.getInt(BYTE_TO_TIMESEEK_REWIND_SECONDS, 0);
    }

    public int getCBRVideoBitrate() {
        return this.getInt(CBR_VIDEO_BITRATE, 0);
    }

    public boolean isShowDVDTitleDuration() {
        return this.getBoolean(SHOW_DVD_TITLE_DURATION, false);
    }

    private RendererConfiguration() throws ConfigurationException {
        this(null);
    }

    public RendererConfiguration(File f) throws ConfigurationException {
        this.configuration.setListDelimiter('\u0000');
        if (f != null) {
            this.configuration.load(f);
        }
        this.mimes = new HashMap<String, String>();
        String mimeTypes = this.getString(MIME_TYPES_CHANGES, null);
        if (StringUtils.isNotBlank(mimeTypes)) {
            StringTokenizer st = new StringTokenizer(mimeTypes, "|");
            while (st.hasMoreTokens()) {
                String mime_change = st.nextToken().trim();
                int equals = mime_change.indexOf("=");
                if (equals <= -1) continue;
                String old = mime_change.substring(0, equals).trim().toLowerCase();
                String nw = mime_change.substring(equals + 1).trim().toLowerCase();
                this.mimes.put(old, nw);
            }
        }
        this.DLNAPN = new HashMap<String, String>();
        String DLNAPNchanges = this.getString(DLNA_PN_CHANGES, null);
        if (DLNAPNchanges != null) {
            logger.trace("Config DLNAPNchanges: " + DLNAPNchanges);
        }
        if (StringUtils.isNotBlank(DLNAPNchanges)) {
            StringTokenizer st = new StringTokenizer(DLNAPNchanges, "|");
            while (st.hasMoreTokens()) {
                String DLNAPN_change = st.nextToken().trim();
                int equals = DLNAPN_change.indexOf("=");
                if (equals <= -1) continue;
                String old = DLNAPN_change.substring(0, equals).trim().toUpperCase();
                String nw = DLNAPN_change.substring(equals + 1).trim().toUpperCase();
                this.DLNAPN.put(old, nw);
            }
        }
        if (f == null) {
            this.configuration.addProperty(MEDIAPARSERV2, true);
            this.configuration.addProperty(MEDIAPARSERV2_THUMB, true);
            this.configuration.addProperty(SUPPORTED, "f:.+");
        }
        if (this.isMediaParserV2()) {
            this.formatConfiguration = new FormatConfiguration(this.configuration.getList(SUPPORTED));
        }
    }

    public String getDLNAPN(String old) {
        if (this.DLNAPN.containsKey(old)) {
            return this.DLNAPN.get(old);
        }
        return old;
    }

    public boolean supportsFormat(Format f) {
        switch (f.getType()) {
            case 4: {
                return this.isVideoSupported();
            }
            case 1: {
                return this.isAudioSupported();
            }
            case 2: {
                return this.isImageSupported();
            }
        }
        return false;
    }

    public boolean isVideoSupported() {
        return this.getBoolean(VIDEO, true);
    }

    public boolean isAudioSupported() {
        return this.getBoolean(AUDIO, true);
    }

    public boolean isImageSupported() {
        return this.getBoolean(IMAGE, true);
    }

    public boolean isTranscodeToWMV() {
        return this.getVideoTranscode().equals(WMV);
    }

    public boolean isTranscodeToAC3() {
        return this.isTranscodeToMPEGPSAC3() || this.isTranscodeToMPEGTSAC3() || this.isTranscodeToH264TSAC3();
    }

    public boolean isTranscodeToMPEGPSAC3() {
        String videoTranscode = this.getVideoTranscode();
        return videoTranscode.equals(MPEGPSAC3) || videoTranscode.equals(DEPRECATED_MPEGPSAC3);
    }

    public boolean isTranscodeToMPEGTSAC3() {
        return this.getVideoTranscode().equals(MPEGTSAC3);
    }

    public boolean isTranscodeToH264TSAC3() {
        return this.getVideoTranscode().equals(H264TSAC3);
    }

    public boolean isAutoRotateBasedOnExif() {
        return this.getBoolean(AUTO_EXIF_ROTATE, false);
    }

    public boolean isTranscodeToMP3() {
        return this.getAudioTranscode().equals(MP3);
    }

    public boolean isTranscodeToLPCM() {
        return this.getAudioTranscode().equals(LPCM);
    }

    public boolean isTranscodeToWAV() {
        return this.getAudioTranscode().equals(WAV);
    }

    public boolean isTranscodeAudioTo441() {
        return this.getBoolean(TRANSCODE_AUDIO_441KHZ, false);
    }

    public boolean isH264Level41Limited() {
        return this.getBoolean(H264_L41_LIMITED, false);
    }

    public boolean isTranscodeFastStart() {
        return this.getBoolean(TRANSCODE_FAST_START, false);
    }

    public boolean isDLNALocalizationRequired() {
        return this.getBoolean(DLNA_LOCALIZATION_REQUIRED, false);
    }

    public String getMimeType(String mimetype) {
        if (this.isMediaParserV2()) {
            if (mimetype != null && mimetype.equals("video/transcode")) {
                mimetype = this.getFormatConfiguration().match("mpegps", "mpeg2", "ac3");
                if (this.isTranscodeToMPEGTSAC3()) {
                    mimetype = this.getFormatConfiguration().match("mpegts", "mpeg2", "ac3");
                } else if (this.isTranscodeToWMV()) {
                    mimetype = this.getFormatConfiguration().match("wmv", "wmv", "wma");
                }
            } else if (mimetype != null && mimetype.equals("audio/transcode")) {
                mimetype = this.getFormatConfiguration().match("lpcm", null, null);
                if (mimetype != null) {
                    mimetype = this.isTranscodeAudioTo441() ? mimetype + ";rate=44100;channels=2" : mimetype + ";rate=48000;channels=2";
                }
                if (this.isTranscodeToWAV()) {
                    mimetype = this.getFormatConfiguration().match("wav", null, null);
                } else if (this.isTranscodeToMP3()) {
                    mimetype = this.getFormatConfiguration().match("mp3", null, null);
                }
            }
            return mimetype;
        }
        if (mimetype != null && mimetype.equals("video/transcode")) {
            mimetype = this.isTranscodeToWMV() ? (this.isMediaParserV2() ? this.getFormatConfiguration().match("wmv", "wmv", "wma") : "video/x-ms-wmv") : (this.isTranscodeToMPEGTSAC3() ? (this.isMediaParserV2() ? this.getFormatConfiguration().match("mpegts", "mpeg2", "ac3") : "video/mpeg") : (this.isMediaParserV2() ? this.getFormatConfiguration().match("mpegps", "mpeg2", "ac3") : "video/mpeg"));
        } else if ("audio/transcode".equals(mimetype)) {
            if (this.isTranscodeToWAV()) {
                mimetype = this.isMediaParserV2() ? this.getFormatConfiguration().match("wav", null, null) : "audio/wav";
            } else if (this.isTranscodeToMP3()) {
                mimetype = this.isMediaParserV2() ? this.getFormatConfiguration().match("mp3", null, null) : "audio/mpeg";
            } else {
                mimetype = this.isMediaParserV2() ? this.getFormatConfiguration().match("lpcm", null, null) : "audio/L16";
                mimetype = this.isTranscodeAudioTo441() ? mimetype + ";rate=44100;channels=2" : mimetype + ";rate=48000;channels=2";
            }
            if (this.isTranscodeToMP3()) {
                mimetype = "audio/mpeg";
            }
            if (this.isTranscodeToWAV()) {
                mimetype = "audio/wav";
            }
        }
        if (this.mimes.containsKey(mimetype)) {
            return this.mimes.get(mimetype);
        }
        return mimetype;
    }

    public boolean matchUserAgent(String header) {
        String userAgent = this.getUserAgent();
        if (StringUtils.isNotBlank(userAgent)) {
            Pattern userAgentPattern = Pattern.compile(userAgent, 2);
            return userAgentPattern.matcher(header).find();
        }
        return false;
    }

    public boolean matchAdditionalUserAgent(String header) {
        String userAgentAdditionalHeader = this.getUserAgentAdditionalHttpHeaderSearch();
        if (StringUtils.isNotBlank(userAgentAdditionalHeader)) {
            Pattern userAgentAddtionalPattern = Pattern.compile(userAgentAdditionalHeader, 2);
            return userAgentAddtionalPattern.matcher(header).find();
        }
        return false;
    }

    public String getUserAgent() {
        return this.getString(USER_AGENT, "");
    }

    public String getRendererName() {
        return this.getString(RENDERER_NAME, Messages.getString("PMS.17"));
    }

    public String getRendererIcon() {
        return this.getString(RENDERER_ICON, "unknown.png");
    }

    public String getLongFilenameFormat() {
        return this.getString(LONG_FILENAME_FORMAT, pmsConfiguration.getLongFilenameFormat());
    }

    public String getShortFilenameFormat() {
        return this.getString(SHORT_FILENAME_FORMAT, pmsConfiguration.getShortFilenameFormat());
    }

    public String getUserAgentAdditionalHttpHeader() {
        return this.getString(USER_AGENT_ADDITIONAL_HEADER, null);
    }

    public String getUserAgentAdditionalHttpHeaderSearch() {
        return this.getString(USER_AGENT_ADDITIONAL_SEARCH, "");
    }

    public String getUseSameExtension(String displayName) {
        String s = this.getString(USE_SAME_EXTENSION, null);
        s = s != null ? displayName + "." + s : displayName;
        return s;
    }

    public boolean isSeekByTime() {
        return this.isSeekByTimeExclusive() || this.getBoolean(SEEK_BY_TIME, false);
    }

    public boolean isSeekByTimeExclusive() {
        return this.getString(SEEK_BY_TIME, "").equalsIgnoreCase("exclusive");
    }

    public boolean isMuxH264MpegTS() {
        boolean muxCompatible = this.getBoolean(MUX_H264_WITH_MPEGTS, true);
        if (this.isMediaParserV2()) {
            boolean bl = muxCompatible = this.getFormatConfiguration().match("mpegts", "h264", null) != null;
        }
        if (Platform.isMac() && System.getProperty("os.version") != null && System.getProperty("os.version").contains("10.4.")) {
            muxCompatible = false;
        }
        return muxCompatible;
    }

    public boolean isDTSPlayable() {
        return this.isMuxDTSToMpeg() || this.isWrapDTSIntoPCM() && this.isMuxLPCMToMpeg();
    }

    public boolean isMuxDTSToMpeg() {
        if (this.isMediaParserV2()) {
            return this.getFormatConfiguration().isDTSSupported();
        }
        return this.getBoolean(MUX_DTS_TO_MPEG, false);
    }

    public boolean isWrapDTSIntoPCM() {
        return this.getBoolean(WRAP_DTS_INTO_PCM, true);
    }

    public boolean isLPCMPlayable() {
        return this.isMuxLPCMToMpeg();
    }

    public boolean isMuxLPCMToMpeg() {
        if (this.isMediaParserV2()) {
            return this.getFormatConfiguration().isLPCMSupported();
        }
        return this.getBoolean(MUX_LPCM_TO_MPEG, true);
    }

    public boolean isMpeg2Supported() {
        if (this.isMediaParserV2()) {
            return this.getFormatConfiguration().isMpeg2Supported();
        }
        return this.isPS3();
    }

    public String getVideoTranscode() {
        return this.getString(TRANSCODE_VIDEO, MPEGPSAC3);
    }

    public String getAudioTranscode() {
        return this.getString(TRANSCODE_AUDIO, LPCM);
    }

    public boolean isDefaultVBVSize() {
        return this.getBoolean(DEFAULT_VBV_BUFSIZE, false);
    }

    @Deprecated
    public String getMaxVideoBitrate() {
        return this.getString(MAX_VIDEO_BITRATE, null);
    }

    @Deprecated
    public String getCustomMencoderQualitySettings() {
        return this.getCustomMEncoderMPEG2Options();
    }

    public String getCustomMEncoderMPEG2Options() {
        return this.getString(CUSTOM_MENCODER_MPEG2_OPTIONS, "");
    }

    public String getCustomFFmpegMPEG2Options() {
        String mpegSettings = this.getCustomMEncoderMPEG2Options();
        String[] mpegSettingsArray = mpegSettings.split(":");
        String returnString = "";
        for (String pair : mpegSettingsArray) {
            String[] pairArray = pair.split("=");
            if ("keyint".equals(pairArray[0])) {
                returnString = returnString + "-g " + pairArray[1] + " ";
                continue;
            }
            if ("vqscale".equals(pairArray[0])) {
                returnString = returnString + "-q:v " + pairArray[1] + " ";
                continue;
            }
            if ("vqmin".equals(pairArray[0])) {
                returnString = returnString + "-qmin " + pairArray[1] + " ";
                continue;
            }
            if (!"vqmax".equals(pairArray[0])) continue;
            returnString = returnString + "-qmax " + pairArray[1] + " ";
        }
        return returnString;
    }

    public String getCustomMencoderOptions() {
        return this.getString(CUSTOM_MENCODER_OPTIONS, "");
    }

    public int getMaxVideoWidth() {
        return this.getInt(MAX_VIDEO_WIDTH, 1920);
    }

    public int getMaxVideoHeight() {
        return this.getInt(MAX_VIDEO_HEIGHT, 1080);
    }

    public boolean isVideoRescale() {
        return this.getMaxVideoWidth() > 0 && this.getMaxVideoHeight() > 0;
    }

    public boolean isDLNAOrgPNUsed() {
        return this.getBoolean(DLNA_ORGPN_USE, true);
    }

    public boolean getThumbNailAsResource() {
        return this.getBoolean(THUMBNAIL_AS_RESOURCE, false);
    }

    public String getTranscodedExtensions() {
        return this.getString(TRANSCODE_EXT, "");
    }

    public String getStreamedExtensions() {
        return this.getString(STREAM_EXT, "");
    }

    public long getTranscodedSize() {
        return this.getLong(TRANSCODED_SIZE, 0);
    }

    public String getSubtitleHttpHeader() {
        return this.getString(SUBTITLE_HTTP_HEADER, "");
    }

    public String toString() {
        return this.getRendererName();
    }

    public boolean isMediaParserV2() {
        return this.getBoolean(MEDIAPARSERV2, false) && LibMediaInfoParser.isValid();
    }

    public boolean isMediaParserV2ThumbnailGeneration() {
        return this.getBoolean(MEDIAPARSERV2_THUMB, false) && LibMediaInfoParser.isValid();
    }

    public boolean isForceJPGThumbnails() {
        return this.getBoolean(FORCE_JPG_THUMBNAILS, false) && LibMediaInfoParser.isValid() || this.isBRAVIA();
    }

    public boolean isShowAudioMetadata() {
        return this.getBoolean(SHOW_AUDIO_METADATA, true);
    }

    public boolean isShowSubMetadata() {
        return this.getBoolean(SHOW_SUB_METADATA, true);
    }

    public boolean isDLNATreeHack() {
        return this.getBoolean(DLNA_TREE_HACK, false) && LibMediaInfoParser.isValid();
    }

    public boolean isChunkedTransfer() {
        return this.getBoolean(CHUNKED_TRANSFER, false);
    }

    public boolean isCompatible(DLNAMediaInfo mediainfo, Format format) {
        if (this.isMediaParserV2() && mediainfo != null && this.getFormatConfiguration().match(mediainfo) != null) {
            return true;
        }
        if (format != null) {
            String noTranscode = "";
            if (PMS.getConfiguration() != null) {
                noTranscode = PMS.getConfiguration().getDisableTranscodeForExtensions();
            }
            return format.skip(noTranscode, this.getStreamedExtensions());
        }
        return false;
    }

    public String getCustomFFmpegOptions() {
        return this.getString(CUSTOM_FFMPEG_OPTIONS, "");
    }

    public boolean isPadVideoWithBlackBordersTo169AR() {
        return this.getBoolean(KEEP_PAD_VIDEO_WITH_BLACK_BORDERS, false);
    }

    public boolean isRescaleByRenderer() {
        return this.getBoolean(RESCALE_BY_RENDERER, true);
    }

    public String getFFmpegVideoFilterOverride() {
        return this.getString(OVERRIDE_VF, null);
    }

    protected static void resetAddressAssociation() {
        addressAssociation = new HashMap<InetAddress, RendererConfiguration>();
    }

    static {
        addressAssociation = new HashMap<InetAddress, RendererConfiguration>();
    }
}

