/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.pms.configuration.FileSerializer;
import net.pms.util.FileUtil;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFileConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MapFileConfiguration.class);
    private String name;
    private String thumbnailIcon;
    private List<MapFileConfiguration> children = new ArrayList<MapFileConfiguration>();
    private List<File> files = new ArrayList<File>();

    public String getName() {
        return this.name;
    }

    public String getThumbnailIcon() {
        return this.thumbnailIcon;
    }

    public List<MapFileConfiguration> getChildren() {
        return this.children;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setThumbnailIcon(String t) {
        this.thumbnailIcon = t;
    }

    public void setFiles(List<File> f) {
        this.files = f;
    }

    public static List<MapFileConfiguration> parse(String conf) {
        if (conf != null && conf.startsWith("@")) {
            File file = new File(conf.substring(1));
            conf = null;
            if (FileUtil.isFileReadable(file)) {
                try {
                    conf = FileUtils.readFileToString(file);
                }
                catch (IOException ex) {
                    return null;
                }
            } else {
                logger.warn("Can't read file: {}", (Object)file.getAbsolutePath());
            }
        }
        if (conf == null || conf.length() == 0) {
            return null;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)File.class), new FileSerializer());
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<MapFileConfiguration>>(){}.getType();
        List out = (List)gson.fromJson(conf, listType);
        return out;
    }
}

