/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.BasicJpeg;
import mediautil.image.jpeg.LLJTran;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPEG
extends AbstractImageInfo<LLJTran> {
    int width;
    int height;
    int precision;
    byte[] header = new byte[2];

    public JPEG(int n, int n2, int n3, LLJTran lLJTran) throws FileFormatException {
        this.width = n;
        this.height = n2;
        this.precision = n3;
        this.format = lLJTran;
    }

    public JPEG(InputStream inputStream, byte[] byArray, int n, String string, String string2, int n2, int n3, LLJTran lLJTran) throws FileFormatException {
        super(inputStream, byArray, n, string, string2, lLJTran);
        if (this.width <= 0 && n2 > 0) {
            this.width = n2;
            this.height = n3;
        } else {
            int n4;
            if (byArray.length == 2) {
                n4 = this.readMarker(inputStream, true);
                if (n4 <= 0) {
                    return;
                }
                if (byArray[1] >= -64 && byArray[1] <= -49 && byArray[1] != -60 && byArray[1] != -56) {
                    this.precision = (this.data[0] & 0xFF) * (this.data[5] & 0xFF);
                    this.width = this.bs2i(3, 2);
                    this.height = this.bs2i(1, 2);
                    return;
                }
            }
            while ((n4 = this.readMarker(inputStream, false)) > 0) {
                if (this.header[1] < -64 || this.header[1] > -49 || this.header[1] == -60 || this.header[1] == -56) continue;
                this.precision = (this.data[0] & 0xFF) * (this.data[5] & 0xFF);
                this.width = this.bs2i(3, 2);
                this.height = this.bs2i(1, 2);
                break;
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.width + " x " + this.height + ")";
    }

    @Override
    public int getResolutionX() {
        return this.width;
    }

    @Override
    public int getResolutionY() {
        return this.height;
    }

    @Override
    public int getMetering() {
        return 0;
    }

    @Override
    public int getExpoProgram() {
        return 0;
    }

    @Override
    public String getFormat() {
        return "n/a";
    }

    @Override
    public void readInfo() {
        this.data = null;
    }

    @Override
    public String getMake() {
        return "n/a";
    }

    @Override
    public String getModel() {
        return "n/a";
    }

    @Override
    public String getDataTimeOriginalString() {
        return dateformat.format(new Date());
    }

    @Override
    public float getFNumber() {
        return 0.0f;
    }

    @Override
    public Rational getShutter() {
        return new Rational(0, 1);
    }

    @Override
    public boolean isFlash() {
        return false;
    }

    @Override
    public float getFocalLength() {
        return 0.0f;
    }

    @Override
    public String getQuality() {
        return "n/a";
    }

    @Override
    public String getReport() {
        return "n/a";
    }

    @Override
    public boolean saveThumbnailImage(OutputStream outputStream) {
        try {
            if (!super.saveThumbnailImage(outputStream)) {
                return this.saveSizedImage(outputStream, DEFAULT_THUMB_SIZE);
            }
            return true;
        }
        catch (Exception exception) {
            if (Log.debugLevel >= 1) {
                exception.printStackTrace(System.err);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSizedImage(OutputStream outputStream, Dimension dimension) throws IOException {
        block12: {
            if (outputStream == null) {
                return false;
            }
            if (!super.saveThumbnailImage(outputStream)) {
                Image image = this.createImage();
                Dimension dimension2 = BasicJpeg.getScaledSize(image, dimension, null);
                BufferedImage bufferedImage = new BufferedImage(dimension2.width, dimension2.height, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                try {
                    final Iterator<ImageWriter> iterator = new Iterator<ImageWriter>();
                    ImageObserver imageObserver = new ImageObserver(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                            if ((n & 0x20) == 32 || (n & 0x80) == 128 || (n & 0x40) == 64) {
                                Object object = iterator;
                                synchronized (object) {
                                    iterator.notify();
                                }
                                return false;
                            }
                            return true;
                        }
                    };
                    Iterator<ImageWriter> iterator2 = iterator;
                    synchronized (iterator2) {
                        if (!graphics2D.drawImage(image, 0, 0, dimension2.width, dimension2.height, imageObserver)) {
                            try {
                                iterator.wait(3600000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    iterator2 = ImageIO.getImageWritersByFormatName("JPEG");
                    if (iterator2 != null && iterator2.hasNext()) {
                        ImageWriter imageWriter = iterator2.next();
                        imageWriter.setOutput(new MemoryCacheImageOutputStream(outputStream));
                        imageWriter.write(bufferedImage);
                        boolean bl = true;
                        return bl;
                    }
                    break block12;
                }
                finally {
                    graphics2D.dispose();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Icon getThumbnailIcon(Dimension dimension) {
        try {
            return new ImageIcon(BasicJpeg.getScaled(Toolkit.getDefaultToolkit().getImage(this.getImageFile().getPath()), dimension == null ? DEFAULT_THUMB_SIZE : dimension, 2, null));
        }
        catch (Exception exception) {
            block8: {
                if (Log.debugLevel >= 1) {
                    System.err.println("Exception '" + exception + "' in scaling thumdnail image.");
                }
                if (this.getAdvancedImage() != null) {
                    try {
                        return this.getAdvancedImage().createThumbnailIcon(this.getImageFile().getPath(), dimension);
                    }
                    catch (Throwable throwable) {
                        if (Log.debugLevel < 1) break block8;
                        System.err.println(throwable);
                    }
                }
            }
            int n = 100;
            int n2 = 100;
            int[] nArray = new int[n * n2];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4 = i * 255 / (n2 - 1);
                for (int j = 0; j < n; ++j) {
                    int n5 = j * 255 / (n - 1);
                    nArray[n3++] = 0xFF000000 | n4 << 16 | n5;
                }
            }
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image createImage() throws IOException {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.getImageFile());
            try {
                imageReader.setInput(imageInputStream, true);
                BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                return bufferedImage;
            }
            finally {
                imageInputStream.close();
            }
        }
        return null;
    }

    int readMarker(InputStream inputStream, boolean bl) {
        try {
            if (!bl && inputStream.read(this.header) < this.header.length) {
                return -1;
            }
            this.data = new byte[2];
            if (inputStream.read(this.data) < this.data.length) {
                return -1;
            }
            int n = this.bs2i(0, 2) - 2;
            this.data = new byte[n];
            return JPEG.read(inputStream, this.data) + this.header.length + 2;
        }
        catch (Exception exception) {
            if (Log.debugLevel >= 1) {
                exception.printStackTrace(System.err);
            }
            return -1;
        }
    }
}

