/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import mediautil.gen.FileFormatException;
import mediautil.gen.MediaInfo;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AdvancedImage;
import mediautil.image.jpeg.BasicJpegIo;
import mediautil.image.jpeg.LLJTran;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractImageInfo<F extends LLJTran>
extends BasicJpegIo
implements MediaInfo {
    public static final Dimension DEFAULT_THUMB_SIZE = new Dimension(120, 96);
    public static final DateFormat dateformat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    public static final DecimalFormat fnumberformat = new DecimalFormat("F1:#0.0#");
    public static final String NA = "n/a";
    public static final byte[] BMP_SIG = new byte[]{66, 77};
    public static final int BMP24_HDR_SIZE = 54;
    protected static final Class[] EMPTY_PARAMS = new Class[0];
    protected AdvancedImage advancedImage;
    protected F format;
    public static final double[] AV_TO_FSTOP = new double[]{1.0, 1.4, 2.0, 2.8, 4.0, 5.6, 8.0, 11.0, 16.0, 22.0, 32.0};
    public static final Rational[] TV_TO_SEC = new Rational[]{new Rational(1, 1), new Rational(1, 2), new Rational(1, 4), new Rational(1, 8), new Rational(1, 15), new Rational(1, 30), new Rational(1, 60), new Rational(1, 125), new Rational(1, 250), new Rational(1, 500), new Rational(1, 1000), new Rational(1, 2000), new Rational(1, 4000), new Rational(1, 8000), new Rational(1, 16000)};
    protected transient InputStream is;
    protected int offset;
    protected String name;
    protected String comments;
    protected Object[] fiveObjects = new Object[5];

    public AbstractImageInfo() {
    }

    public AbstractImageInfo(InputStream inputStream, byte[] byArray, int n, String string, String string2, F f) throws FileFormatException {
        this.is = inputStream;
        this.data = byArray;
        this.offset = n;
        this.name = string;
        this.comments = string2;
        this.format = f;
        this.readInfo();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAdvancedImage(AdvancedImage advancedImage) {
        this.advancedImage = advancedImage;
    }

    public AdvancedImage getAdvancedImage() {
        return this.advancedImage;
    }

    public void writeInfo(byte[] byArray, OutputStream outputStream, int n, int n2, boolean bl) throws IOException {
        this.writeInfo(byArray, outputStream, n, n2, bl, -1, -1);
    }

    public void writeInfo(byte[] byArray, OutputStream outputStream, int n, int n2, boolean bl, int n3, int n4) throws IOException {
        this.writeInfo(byArray, outputStream, n, n2, bl, n3, n4, "ISO8859_1");
    }

    public void writeInfo(byte[] byArray, OutputStream outputStream, int n, int n2, boolean bl, int n3, int n4, String string) throws IOException {
    }

    public abstract void readInfo() throws FileFormatException;

    public abstract String getFormat();

    public abstract int getResolutionX();

    public abstract int getResolutionY();

    public abstract String getMake();

    public abstract String getModel();

    public abstract String getDataTimeOriginalString();

    public abstract float getFNumber();

    public abstract Rational getShutter();

    public abstract boolean isFlash();

    public abstract String getQuality();

    public abstract float getFocalLength();

    public abstract int getMetering();

    public abstract int getExpoProgram();

    public abstract String getReport();

    public int getThumbnailOffset() {
        return -1;
    }

    public int getThumbnailLength() {
        return -1;
    }

    public void setThumbnail(byte[] byArray, int n, int n2, String string, OutputStream outputStream) throws IOException {
    }

    public boolean removeThumbnailTags() {
        return false;
    }

    public abstract Icon getThumbnailIcon(Dimension var1);

    public String toString() {
        String string = this.getReport();
        if (string != null && string.length() > 0) {
            return string;
        }
        return super.toString();
    }

    @Override
    public Object[] getFiveMajorAttributes() {
        return this.fiveObjects;
    }

    public Icon getThumbnailIcon() {
        return this.getThumbnailIcon(null);
    }

    public String getThumbnailExtension() {
        return "jpeg";
    }

    public String getComments() {
        return this.comments;
    }

    public File getImageFile() {
        return ((LLJTran)this.format).getFile();
    }

    public boolean saveThumbnailImage(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return false;
        }
        if (this.getAdvancedImage() != null) {
            try {
                this.getAdvancedImage().saveThumbnailImage(this.getImageFile().getPath(), outputStream, null);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public Date getDateTimeOriginal() {
        try {
            return dateformat.parse(this.getDataTimeOriginalString());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ParseException parseException) {
            System.err.println("" + parseException);
        }
        return new Date();
    }

    public float apertureToFnumber(float f) {
        try {
            int n = (int)f;
            float f2 = (float)AV_TO_FSTOP[n];
            if ((f -= (float)n) != 0.0f) {
                f2 = (float)((double)f2 + (AV_TO_FSTOP[n + 1] - AV_TO_FSTOP[n]) * (double)f);
            }
            return f2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1.0f;
        }
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (!"Comments".equals(string)) {
            throw new RuntimeException("Calling this method not allowed by AbstractImageInfo implementation.");
        }
        this.comments = object.toString();
    }

    @Override
    public Object getAttribute(String string) {
        if ("charachter".equals(string)) {
            return this.getShutter();
        }
        if ("timestamp".equals(string)) {
            return this.getDateTimeOriginal();
        }
        if ("quality".equals(string)) {
            return this.getQuality();
        }
        if ("make".equals(string)) {
            return this.getMake();
        }
        return this.getGenericAttribute(string);
    }

    @Override
    public int getIntAttribute(String string) {
        if ("charachter".equals(string)) {
            return (int)this.getFocalLength();
        }
        Object object = this.getGenericAttribute(string);
        if (object != null) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
        } else {
            return 0;
        }
        throw new IllegalArgumentException("Not supported attribute name for int " + string);
    }

    @Override
    public float getFloatAttribute(String string) {
        if ("charachter".equals(string)) {
            return this.getFNumber();
        }
        Object object = this.getGenericAttribute(string);
        if (object != null) {
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
        } else {
            return 0.0f;
        }
        throw new IllegalArgumentException("Not supported attribute name for float " + string);
    }

    @Override
    public long getLongAttribute(String string) {
        throw new IllegalArgumentException("Not supported attribute name for long " + string);
    }

    @Override
    public double getDoubleAttribute(String string) {
        throw new IllegalArgumentException("Not supported attribute name for double " + string);
    }

    @Override
    public boolean getBoolAttribute(String string) {
        if ("charachter".equals(string)) {
            return this.isFlash();
        }
        return this.getGenericBoolAttribute(string);
    }

    protected Object getGenericAttribute(String string) {
        try {
            return this.getClass().getMethod("get" + string, EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Not supported attribute " + string + " <<" + throwable);
        }
    }

    protected Boolean getGenericBoolAttribute(String string) {
        try {
            return (Boolean)this.getClass().getMethod("is" + string, EMPTY_PARAMS).invoke((Object)this, (Object[])EMPTY_PARAMS);
        }
        catch (Throwable throwable) {
            try {
                return (Boolean)this.getGenericAttribute(string);
            }
            catch (Throwable throwable2) {
                throw new IllegalArgumentException("Not supported boolean attribute " + string + " <<" + throwable2 + " <<" + throwable);
            }
        }
    }
}

