/*
 * Decompiled with CFR 0.152.
 */
package mediautil.gen.directio;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import mediautil.gen.BasicIo;
import mediautil.gen.directio.ByteCounter;
import mediautil.gen.directio.IterativeReader;

public class SplitInputStream
extends FilterInputStream {
    private byte[] q;
    private static final int DEF_BUF_SIZE = 5120;
    private static final int DEF_INC_SIZE = 1024;
    private byte[] oneByteArr = new byte[1];
    private int bufSize;
    private int incSize;
    private int qEnd;
    private int q2nd;
    private boolean eofFlag;
    private int[] qPtrs;
    private int[] subReaderIds;
    private IterativeReader[] codes;
    private SubStream[] subStreams;
    private byte[] requestBuf;
    private int requestPos;
    private int requestRemain;
    private int curReaderId;
    private int maxReaderId;
    private int maxBufSize;
    private int maxBufUsage;
    private boolean isSkipCall = false;

    private int dequeue(int n, byte[] byArray, int n2, int n3) {
        int n4 = this.qEnd - this.qPtrs[n];
        if (n4 > n3) {
            n4 = n3;
        }
        if (n4 > 0) {
            if (byArray != null) {
                System.arraycopy(this.q, this.qPtrs[n], byArray, n2, n4);
            }
            int n5 = n;
            this.qPtrs[n5] = this.qPtrs[n5] + n4;
        } else {
            n4 = 0;
        }
        return n4;
    }

    private void reallocBuf(int n) {
        int n2 = this.findQBegin(null);
        byte[] byArray = new byte[n];
        int n3 = this.qEnd - n2;
        if (n3 > 0) {
            System.arraycopy(this.q, n2, byArray, 0, n3);
        } else {
            n2 = this.qEnd;
        }
        this.q = byArray;
        int n4 = 0;
        while (n4 < this.qPtrs.length) {
            int n5 = n4++;
            this.qPtrs[n5] = this.qPtrs[n5] - n2;
        }
        this.qEnd -= n2;
        this.q2nd -= n2;
        if (n > this.maxBufSize) {
            this.maxBufSize = n;
        }
    }

    private int fillAndDequeue(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.dequeue(n, byArray, n2, n3);
        int n5 = n3 - n4;
        n2 += n4;
        int n6 = this.qPtrs[n];
        if (n5 > 0 && !this.eofFlag) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11 = n6 - this.qEnd;
            int n12 = n5 + n11;
            int n13 = n12 + (this.qEnd - this.q2nd);
            if (this.q2nd < n6) {
                n11 = this.q2nd - this.qEnd;
            }
            if (this.q2nd > this.qEnd && n12 > this.bufSize && (n13 <= this.bufSize || (n13 - this.bufSize - 1) / this.incSize < (n12 - this.bufSize - 1) / this.incSize)) {
                n10 = n6 + n5;
                if (n10 > this.q2nd) {
                    n10 = this.q2nd;
                }
                int n14 = n9 = n10 - this.qEnd;
                n8 = 0;
                if (this.requestBuf != null && (n8 = this.requestRemain) > n14) {
                    n8 = n14;
                }
                if (n8 > 0) {
                    int n15;
                    n7 = BasicIo.read(this.in, this.requestBuf, this.requestPos, n8, n8);
                    if (n7 < n8) {
                        this.eofFlag = true;
                    }
                    if ((n15 = n7 - n11) > 0) {
                        if (byArray != null) {
                            System.arraycopy(this.requestBuf, this.requestPos + n11, byArray, n2, n15);
                        }
                        n11 = 0;
                        n2 += n15;
                        n5 -= n15;
                    } else {
                        n11 = -n15;
                    }
                    n14 -= n7;
                }
                if (n11 > 0 && !this.eofFlag) {
                    n7 = (int)BasicIo.skip(this.in, n11);
                    if (n7 < n11) {
                        this.eofFlag = true;
                    }
                    n11 -= n7;
                    n14 -= n7;
                }
                if (n14 > 0 && !this.eofFlag) {
                    n7 = byArray != null ? BasicIo.read(this.in, byArray, n2, n14, n14) : (int)BasicIo.skip(this.in, n14);
                    if (n7 < n14) {
                        this.eofFlag = true;
                    }
                    n2 += n7;
                    n5 -= n7;
                    n14 -= n7;
                }
                n8 = n9 - n14;
                this.qEnd += n8;
                if (n8 > this.requestRemain) {
                    n8 = this.requestRemain;
                }
                this.requestPos += n8;
                this.requestRemain -= n8;
                n6 += n3 - n4 - n5;
            }
            if (this.requestBuf == null && n11 > 0 && !this.eofFlag) {
                n7 = (int)BasicIo.skip(this.in, n11);
                if (n7 < n11) {
                    this.eofFlag = true;
                }
                if ((n8 = this.requestRemain) > n7) {
                    n8 = n7;
                }
                this.requestPos += n8;
                this.requestRemain -= n8;
                this.qEnd += n7;
            }
            this.qPtrs[n] = n6;
            if (n5 > 0 && !this.eofFlag) {
                n10 = this.q2nd;
                if (this.qEnd < this.q2nd) {
                    n10 = this.qEnd;
                }
                if ((n13 = (n12 = n5 + (n6 - this.qEnd)) + (this.qEnd - n10)) > this.maxBufUsage) {
                    this.maxBufUsage = n13;
                }
                if (n13 > this.q.length) {
                    this.reallocBuf(n13 + this.incSize - 1 - (n13 - 1 - this.bufSize) % this.incSize);
                } else {
                    if (this.qEnd > n10 && n10 > 0) {
                        System.arraycopy(this.q, n10, this.q, 0, this.qEnd - n10);
                    }
                    int n16 = 0;
                    do {
                        int n17 = n16++;
                        this.qPtrs[n17] = this.qPtrs[n17] - n10;
                    } while (n16 < this.qPtrs.length);
                    this.qEnd -= n10;
                    this.q2nd -= n10;
                }
                n9 = this.bufSize - this.qEnd;
                if (n9 < n12) {
                    n9 = n12;
                }
                if ((n7 = BasicIo.read(this.in, this.q, this.qEnd, n12, n9)) < n12) {
                    this.eofFlag = true;
                }
                if ((n8 = this.requestRemain) > n7) {
                    n8 = n7;
                }
                if (n8 > 0) {
                    if (this.requestBuf != null) {
                        System.arraycopy(this.q, this.qEnd, this.requestBuf, this.requestPos, n8);
                    }
                    this.requestPos += n8;
                    this.requestRemain -= n8;
                }
                this.qEnd += n7;
                n5 -= this.dequeue(n, byArray, n2, n5);
            }
        }
        return n3 - n5;
    }

    private int findQBegin(int[] nArray) {
        int n;
        int n2 = -1;
        if (this.qPtrs.length == 0) {
            n = 0;
        } else {
            n = Integer.MAX_VALUE;
            int n3 = 0;
            do {
                if (this.qPtrs[n3] >= n) continue;
                n = this.qPtrs[n3];
                n2 = n3;
            } while (++n3 < this.qPtrs.length);
        }
        if (nArray != null) {
            nArray[0] = n2;
        }
        return n;
    }

    private void init(InputStream inputStream, int n, int n2) {
        if (n < 2048) {
            n = 2048;
        }
        if (n2 < 512) {
            n2 = 512;
        }
        this.bufSize = n;
        this.maxBufSize = n;
        this.incSize = n2;
        this.qPtrs = new int[1];
        this.qPtrs[0] = 0;
        this.qEnd = 0;
        this.q = null;
        this.eofFlag = false;
        this.subReaderIds = new int[0];
        this.subStreams = new SubStream[0];
        this.codes = new IterativeReader[0];
        this.curReaderId = -1;
        this.maxReaderId = 0;
    }

    public SplitInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream);
        this.init(inputStream, n, n2);
    }

    public SplitInputStream(InputStream inputStream) {
        this(inputStream, 5120, 1024);
    }

    public InputStream createSubStream(int n, int n2) {
        if (n < 512) {
            n = 512;
        }
        if (n2 < 512) {
            n2 = 512;
        }
        return new SubStream(this, n, n2);
    }

    public InputStream createSubStream() {
        return new SubStream(this);
    }

    public int attachSubReader(IterativeReader iterativeReader, InputStream inputStream) {
        int n;
        String string = null;
        SubStream subStream = null;
        if (iterativeReader == null) {
            throw new NullPointerException("code is NULL");
        }
        if (!(inputStream instanceof SubStream)) {
            string = "subStream passed was not created using createSubStream call";
        } else {
            subStream = (SubStream)inputStream;
            if (subStream.parentThis != this) {
                string = "subStream was created from another SplitInputStream instance";
            } else if (subStream.readerNo > 0 || subStream.readerId > 0) {
                string = "subStream already in use";
            }
        }
        if (string != null) {
            throw new RuntimeException(string);
        }
        int n2 = subStream.minReadSize + subStream.readCushion + 512;
        if (n2 > this.bufSize) {
            if (this.q != null) {
                this.reallocBuf(n2);
            }
            this.bufSize = n2;
        }
        int[] nArray = new int[this.subReaderIds.length + 1];
        IterativeReader[] iterativeReaderArray = new IterativeReader[this.codes.length + 1];
        SubStream[] subStreamArray = new SubStream[this.subStreams.length + 1];
        System.arraycopy(this.subReaderIds, 0, nArray, 0, this.subReaderIds.length);
        System.arraycopy(this.codes, 0, iterativeReaderArray, 0, this.codes.length);
        System.arraycopy(this.subStreams, 0, subStreamArray, 0, this.subStreams.length);
        iterativeReaderArray[this.codes.length] = iterativeReader;
        subStreamArray[this.subStreams.length] = subStream;
        ++this.maxReaderId;
        nArray[this.subReaderIds.length] = n = this.maxReaderId;
        subStream.readerNo = subStreamArray.length;
        subStream.readerId = n;
        int[] nArray2 = new int[this.qPtrs.length + 1];
        System.arraycopy(this.qPtrs, 0, nArray2, 0, this.qPtrs.length);
        nArray2[this.qPtrs.length] = this.findQBegin(null);
        this.qPtrs = nArray2;
        this.subReaderIds = nArray;
        this.codes = iterativeReaderArray;
        this.subStreams = subStreamArray;
        return n;
    }

    public void detachSubReader(int n) {
        int n2;
        for (n2 = 0; n2 < this.subReaderIds.length && this.subReaderIds[n2] != n; ++n2) {
        }
        if (n2 >= this.subReaderIds.length) {
            throw new RuntimeException("SubReaderId " + n + " Not found for detaching from SplitInputStream");
        }
        this.detachSubReaderNo(n2);
    }

    private void detachSubReaderNo(int n) {
        int n2;
        int n3 = n + 1;
        this.codes[n] = null;
        SubStream subStream = this.subStreams[n];
        subStream.readerNo = -1;
        subStream.readerId = 0;
        subStream.closedFlag = true;
        this.subStreams[n] = null;
        int[] nArray = new int[this.subReaderIds.length - 1];
        IterativeReader[] iterativeReaderArray = new IterativeReader[this.codes.length - 1];
        SubStream[] subStreamArray = new SubStream[this.subStreams.length - 1];
        System.arraycopy(this.subReaderIds, 0, nArray, 0, n);
        System.arraycopy(this.codes, 0, iterativeReaderArray, 0, n);
        System.arraycopy(this.subStreams, 0, subStreamArray, 0, n);
        System.arraycopy(this.subReaderIds, n + 1, nArray, n, nArray.length - n);
        System.arraycopy(this.codes, n + 1, iterativeReaderArray, n, iterativeReaderArray.length - n);
        System.arraycopy(this.subStreams, n + 1, subStreamArray, n, subStreamArray.length - n);
        int[] nArray2 = new int[this.qPtrs.length - 1];
        int n4 = 0;
        for (n2 = 0; n2 < this.qPtrs.length; ++n2) {
            if (n2 == n3) continue;
            nArray2[n4] = this.qPtrs[n2];
            ++n4;
        }
        this.codes = iterativeReaderArray;
        this.subStreams = subStreamArray;
        this.qPtrs = nArray2;
        this.subReaderIds = nArray;
        for (n2 = 0; n2 < this.subStreams.length; ++n2) {
            if (this.subStreams[n2].readerNo <= n3) continue;
            this.subStreams[n2].readerNo--;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        boolean bl = this.isSkipCall;
        this.isSkipCall = false;
        if (!bl) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + n2);
            }
            byte by = byArray[n];
            byte by2 = byArray[n + n2 - 1];
        }
        if (n2 <= 0) {
            return 0;
        }
        if (this.q == null) {
            this.q = new byte[this.bufSize];
        }
        if ((n5 = this.qEnd - this.qPtrs[0]) > (n4 = n2)) {
            n5 = n4;
        }
        if (n5 > 0) {
            if (byArray != null) {
                System.arraycopy(this.q, this.qPtrs[0], byArray, n, n5);
            }
            n4 -= n5;
            n += n5;
        }
        this.qPtrs[0] = this.qPtrs[0] + n2;
        this.requestBuf = byArray;
        this.requestPos = n;
        this.requestRemain = n4;
        int[] nArray = null;
        this.maxBufUsage = 0;
        while (!(this.requestRemain <= 0 || this.qPtrs.length <= 1 && this.eofFlag)) {
            Object object;
            int n6;
            if (nArray == null) {
                nArray = new int[1];
            }
            n3 = this.findQBegin(nArray);
            int n7 = Integer.MAX_VALUE;
            int n8 = nArray[0];
            int n9 = 0;
            if (this.qPtrs.length > 1) {
                n6 = 0;
                do {
                    int n10;
                    if (n6 == n8 || (n10 = this.qPtrs[n6]) > n7) continue;
                    n7 = n10;
                    n9 = n6;
                } while (++n6 < this.qPtrs.length);
            }
            if (n3 >= this.qEnd) {
                n6 = 0;
                if (this.eofFlag) {
                    do {
                        IterativeReader iterativeReader = this.codes[0];
                        object = this.subStreams[0];
                        this.curReaderId = this.subReaderIds[0];
                        iterativeReader.nextRead(((SubStream)object).minReadSize);
                        this.curReaderId = -1;
                        if (((SubStream)object).closedFlag) continue;
                        this.detachSubReaderNo(0);
                    } while (this.codes.length > 0);
                    continue;
                }
                n4 = this.requestRemain;
                this.requestRemain = 0;
                this.qPtrs[0] = this.qPtrs[0] - n4;
                n5 = this.bufSize;
                if (n5 > n4) {
                    n5 = n4;
                }
                this.q2nd = n3;
                n5 = this.fillAndDequeue(0, byArray, this.requestPos, n5);
                this.requestPos += n5;
                this.requestRemain = n4 - n5;
                if (this.eofFlag) continue;
                this.qPtrs[0] = this.qPtrs[0] + this.requestRemain;
                continue;
            }
            this.q2nd = n7;
            int n11 = n8 - 1;
            object = this.codes[n11];
            SubStream subStream = this.subStreams[n11];
            int n12 = this.qEnd - n3 - subStream.readCushion;
            SubStream subStream2 = null;
            if (n9 > 0) {
                subStream2 = this.subStreams[n9 - 1];
            }
            if (n12 < subStream.minReadSize || n9 == 0 || this.qEnd - n7 - subStream2.readCushion < subStream2.minReadSize) {
                n12 += this.bufSize - (this.qEnd - n7);
            }
            this.curReaderId = this.subReaderIds[n11];
            int n13 = object.nextRead(n12);
            this.curReaderId = -1;
            if (subStream.closedFlag || n13 == 0) continue;
            this.detachSubReaderNo(n11);
        }
        if (this.q.length > this.bufSize && this.maxBufUsage > 0 && this.q.length - this.maxBufUsage >= this.incSize) {
            n3 = this.bufSize;
            if (this.maxBufUsage > this.bufSize) {
                n3 = this.maxBufUsage + (this.incSize - 1 - (this.maxBufUsage - 1 - this.bufSize) % this.incSize);
            }
            this.reallocBuf(n3);
        }
        n3 = n2 - this.requestRemain;
        this.requestBuf = null;
        this.requestRemain = 0;
        if (n3 == 0) {
            n3 = -1;
        }
        return n3;
    }

    public int read() throws IOException {
        int n = -1;
        if (this.read(this.oneByteArr, 0, 1) == 1) {
            n = this.oneByteArr[0] & 0xFF;
        }
        return n;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 > 0L) {
            this.isSkipCall = true;
            if ((l2 = (long)this.read(null, 0, (int)l2)) < 0L) {
                l2 = 0L;
            }
        }
        return l2;
    }

    public int available() {
        int n = this.qEnd - this.qPtrs[0];
        if (n <= 0) {
            n = this.eofFlag ? 0 : 1;
        }
        return n;
    }

    public int getMaxBufSize() {
        return this.maxBufSize;
    }

    public void wrapup() throws IOException {
        while (this.codes.length > 0) {
            this.skip(100000L);
        }
        this.q = null;
    }

    static /* synthetic */ byte[] access$102(SplitInputStream splitInputStream, byte[] byArray) {
        splitInputStream.q = byArray;
        return byArray;
    }

    private class SubStream
    extends InputStream
    implements ByteCounter {
        public SplitInputStream parentThis;
        private byte[] oneByteArr = new byte[1];
        private int readerNo;
        private int readerId;
        public int minReadSize;
        public int readCushion;
        public boolean closedFlag;
        private int[] counterArr;
        private boolean upMode;
        private long totalBytes;

        public SubStream(SplitInputStream splitInputStream2, int n, int n2) {
            this.parentThis = splitInputStream2;
            this.readCushion = n2;
            this.minReadSize = n;
            this.closedFlag = false;
            this.readerNo = -1;
            this.readerId = 0;
            this.totalBytes = 0L;
            this.counterArr = null;
        }

        public SubStream(SplitInputStream splitInputStream2) {
            this(splitInputStream2, 750, 750);
        }

        public void setCounter(int[] nArray, boolean bl) {
            int n = nArray[0];
            this.counterArr = nArray;
            this.upMode = bl;
        }

        public long getTotalBytes() {
            return this.totalBytes;
        }

        private String validate() {
            String string = null;
            if (!this.closedFlag) {
                if (this.readerNo < 0) {
                    string = "Attempt to read from an invalid or unattached substream";
                } else if (this.readerId != SplitInputStream.this.curReaderId) {
                    string = "Substream Context Error: Iterative code attached as id " + SplitInputStream.this.curReaderId + " attempting to read from substream with id " + this.readerId;
                }
            }
            return string;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            String string = null;
            if (!this.closedFlag) {
                if (this.readerNo < 0) {
                    string = "Attempt to read from an invalid or unattached substream";
                } else if (this.readerId != SplitInputStream.this.curReaderId) {
                    string = "Substream Context Error: Iterative code attached as id " + SplitInputStream.this.curReaderId + " attempting to read from substream with id " + this.readerId;
                }
                if (string != null) {
                    throw new IOException(string);
                }
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Negative Length Read attempted, len = " + n2);
            }
            byte by = byArray[n];
            byte by2 = byArray[n + n2 - 1];
            if (n2 == 0) {
                return 0;
            }
            if (this.closedFlag) {
                return -1;
            }
            if (SplitInputStream.this.q == null) {
                SplitInputStream.access$102(SplitInputStream.this, new byte[SplitInputStream.this.bufSize]);
            }
            int n3 = n2;
            int n4 = SplitInputStream.this.qEnd - SplitInputStream.this.qPtrs[this.readerNo];
            if (n4 > n2) {
                n4 = n2;
            }
            if (n4 > 0) {
                System.arraycopy(SplitInputStream.this.q, SplitInputStream.this.qPtrs[this.readerNo], byArray, n, n4);
                int[] nArray = SplitInputStream.this.qPtrs;
                int n5 = this.readerNo;
                nArray[n5] = nArray[n5] + n4;
                n += n4;
                n3 -= n4;
            }
            int n6 = n2;
            if (n3 > 0) {
                if (!SplitInputStream.this.eofFlag) {
                    n3 -= SplitInputStream.this.fillAndDequeue(this.readerNo, byArray, n, n3);
                }
                if ((n6 -= n3) <= 0) {
                    n6 = -1;
                    SplitInputStream.this.detachSubReaderNo(this.readerNo - 1);
                }
            }
            if (n6 > 0) {
                this.totalBytes += (long)n6;
                if (this.counterArr != null) {
                    this.counterArr[0] = this.upMode ? this.counterArr[0] + n6 : this.counterArr[0] - n6;
                }
            }
            return n6;
        }

        public int read() throws IOException {
            int n = -1;
            if (this.read(this.oneByteArr, 0, 1) == 1) {
                n = this.oneByteArr[0] & 0xFF;
            }
            return n;
        }

        public long skip(long l) throws IOException {
            String string = this.validate();
            if (string != null) {
                throw new IOException(string);
            }
            int n = (int)l;
            if (this.closedFlag || n < 0) {
                n = 0;
            }
            int[] nArray = SplitInputStream.this.qPtrs;
            int n2 = this.readerNo;
            nArray[n2] = nArray[n2] + n;
            this.totalBytes += (long)n;
            if (this.counterArr != null) {
                this.counterArr[0] = this.upMode ? this.counterArr[0] + n : this.counterArr[0] - n;
            }
            return n;
        }

        public int available() throws IOException {
            String string = this.validate();
            if (string != null) {
                throw new IOException(string);
            }
            int n = 0;
            if (!this.closedFlag && (n = SplitInputStream.this.qEnd - SplitInputStream.this.qPtrs[this.readerNo]) <= 0) {
                n = SplitInputStream.this.eofFlag ? 0 : 1;
            }
            return n;
        }

        public void close() throws IOException {
            String string = this.validate();
            if (string != null) {
                throw new IOException(string);
            }
            if (this.readerNo > 0) {
                SplitInputStream.this.detachSubReaderNo(this.readerNo - 1);
            }
        }
    }
}

