import { DecodedValueMap, EncodedQuery, QueryParamConfigMap } from 'serialize-query-params';
import { DecodedParamCache } from './decodedParamCache';
/**
 * Helper to get the latest decoded values with smart caching.
 * Abstracted into its own function to allow re-use in a functional setter (#26)
 */
export declare function getLatestDecodedValues<QPCMap extends QueryParamConfigMap>(parsedParams: EncodedQuery, paramConfigMap: QPCMap, decodedParamCache: DecodedParamCache): DecodedValueMap<QPCMap>;
/**
 * Wrap get latest so we use the same exact object if the current
 * values are shallow equal to the previous.
 */
export declare function makeStableGetLatestDecodedValues(): <QPCMap extends QueryParamConfigMap>(parsedParams: EncodedQuery, paramConfigMap: QPCMap, decodedParamCache: DecodedParamCache) => DecodedValueMap<any>;
