/***************************************************************************
                          io.cpp  -  main insane odyssey source file
                             -------------------
    begin                : Sun Jan 30 2000
    copyright            : (C) 2000 by aaron p. matthews
    email                : aaron@rivalgames.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------INCLUDES--------------------------------*/

#define MIXER

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <SDL/SDL.h>

#include <SDL/SDL_image.h>

#ifdef MIXER
	#include <SDL/SDL_mixer.h>
#endif

#include "io.h"

Uint32 GameTime;
float FrameRatio;

/*----------------------------BASE GRAPHICS FUNCTIONS------------------------*/

SDL_Surface *LoadImage(char *datafile, short transparent)
{
	SDL_Surface *image, *surface;

	image = IMG_Load(datafile);
	if ( image == NULL ) {
		fprintf(stderr, "Couldn't load image %s\n",
					datafile);
		return NULL;
	}
	if ( image->format->BitsPerPixel <= 16 )
	{
		if ( transparent ) {
		// Assuming 8-bit BMP image
			SDL_SetColorKey(image, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)image->pixels);
		}
		if ( coolwhip )
			SDL_SetAlpha( image, SDL_SRCALPHA, 64 );
		surface = SDL_DisplayFormat(image);
		SDL_FreeSurface(image);
		return surface;
	}
	return image;
}

SDL_Surface *LoadImageTile(char *datafile, short transparent)
{
	SDL_Surface *image, *surface;

	image = IMG_Load(datafile);
	if ( image == NULL ) {
		fprintf(stderr, "Couldn't load image %s\n", datafile);
		return(NULL);
	}
	if ( transparent ) {
		/* Assuming 8-bit BMP image */
		SDL_SetColorKey(image, SDL_SRCCOLORKEY|SDL_RLEACCEL, (Uint8) 0 );
	}
	if ( coolwhip )
		SDL_SetAlpha( image, SDL_SRCALPHA, 192 );
	surface = SDL_DisplayFormat(image);
	SDL_FreeSurface(image);
	return(surface);
}

void LoadImagePalette ( char *datafile )
{
        SDL_Surface *image;

        /* Load the BMP file into a surface */
        image = IMG_Load(datafile);
        if ( image == NULL ) {
                fprintf(stderr, "Couldn't load %s: %s\n", datafile,
                                                        SDL_GetError());
                return;
        }
	if ( image->format->palette ) {
		SDL_SetColors(screen, image->format->palette->colors,
				0, image->format->palette->ncolors);
	}
}

void ClearKeys ()
{
	memset ( keys, 0, 127 );
}

/*--------------------------GAME GRAPHICS FUNCTIONS---------------------------*/

float Max ( float d )
{
	if ( d > TILESIZE )
		return TILESIZE;
	if ( d < -TILESIZE )
		return -TILESIZE;
	return d;
}

char test_bit(unsigned short num, unsigned short bit)
{
   /* test bit flags, used for tile attributes */
   return((num >> bit) & 1);
}

void Clip ( SDL_Rect *r, short width, short height )
{
        if ( r->x+r->w > width )
        {
                r->w -= (r->x+r->w)-width;
        }
		else
          if ( r->x < 0 )
          {
                  r->x = 0;
                  r->w -= r->x;
          }
        if ( r->y < 0 )
        {
                r->y = 0;
                r->h -= r->y;
        }
		else
          if ( r->y+r->h > height )
          {
                r->h -= (r->y+r->h)-height;
          }
}

void DrawTile ( short x, short y, short layer )
{
	SDL_Rect dst, src;
	short xsize, ysize;
	unsigned short num = map[layer][x+tile_orgx][y+tile_orgy];

	if ( num >= MAXTILES )
		return;
	
	src.x = (num%20)*TILESIZE;
	src.y = (num/20)*TILESIZE;
	src.w = TILESIZE;
	src.h = TILESIZE;
	dst.x = (x*TILESIZE)-(realx-nextx);
	dst.y = (y*TILESIZE)-(realy-nexty);
	dst.w = TILESIZE;
	dst.h = TILESIZE;

  	if ( num )
		if ( num == 1 && parallax )
		{
			src.x = dst.x + realx / 6;
			src.y = dst.y + realy / 6;
				
			xsize = background->w - TILESIZE;
			ysize = background->h - TILESIZE;
				
			src.x -= (src.x/xsize)*xsize;
			src.y -= (src.y/ysize)*ysize;

               		SDL_BlitSurface(background, &src, screen, &dst);
          	}
          	else
			SDL_BlitSurface(tile[num], NULL, screen, &dst);
}

void DrawMiddleTile ( short x, short y )
{
	SDL_Rect dst;
	unsigned short num = map[FG][x+tile_orgx][y+tile_orgy];
	
	if ( !num )
		return;
	if ( num >= MAXTILES )
		return;

	if(!test_bit(tileatt[num].bits, 4))
		return;
		
	dst.x = (x*TILESIZE)-(realx-nextx);
	dst.y = (y*TILESIZE)-(realy-nexty);
	dst.w = TILESIZE;
	dst.h = TILESIZE;

	SDL_BlitSurface(tile[num], NULL, screen, &dst);
}

void DrawForegroundTile ( short x, short y )
{
	SDL_Rect dst;
	unsigned short num = map[FG][x+tile_orgx][y+tile_orgy];
	
	if ( !num )
		return;
	if ( num >= MAXTILES )
		return;
	
	if(test_bit(tileatt[num].bits, 4))
    		return;
	
	dst.x = (x*TILESIZE)-(realx-nextx);
	dst.y = (y*TILESIZE)-(realy-nexty);
	dst.w = TILESIZE;
	dst.h = TILESIZE;
	
	SDL_BlitSurface(tile[num], NULL, screen, &dst);
}

void Draw_Level ()
{
	short x, y;

	for ( y = -1; y < (screen_height/TILESIZE)+1; y ++ )
    	for ( x = -1; x < screen_width/TILESIZE; x ++ )
     	{
        	DrawTile ( x, y, BG );
            	DrawMiddleTile ( x, y );
        }
}

void Draw_Level_Foreground ()
{
	short x, y;

	for ( y = -1; y < (screen_height/TILESIZE)+1; y ++ )
    	for ( x = -1; x < screen_width/TILESIZE; x ++ )
      	{
        	DrawForegroundTile ( x, y );
      	}
}


void DrawChar ( short x, short y, char c, short color )
{
	SDL_Rect dst, src;
	short num;

	if ( c >= 'A' )
		num = c - 'A';
	else
		num = (c - '0') + 26;

	src.x = (num%20)*32;
	src.y = (num/20)*32;
	src.w = 32;
	src.h = 32;

	dst.x = x;
	dst.y = y;
	dst.w = 32;
	dst.h = 32;

	SDL_BlitSurface(font[color], &src, screen, &dst);
}

void Print_Number ( short x, short y, short num, short color )
{
	char letter;

	letter = '0' + (num/100);
	DrawChar ( x, y, letter, color );
	letter = '0' + ((num%100)/10);
	DrawChar ( x+28, y, letter, color );
	letter = '0' + ((num%100)%10);
	DrawChar ( x+56, y, letter, color );
}

void Print_Text(short x, short y, char *text, short color)
{
	short Pos = 0;

	while (text[Pos] != '\0')
	{
	 	if (text[Pos] != ' ')
 		{
   	 		DrawChar(x, y, text[Pos], color);
  	  		x += 28;
	 	}
 		else
   	 		x += 24;
 		Pos++;
	}
}

short Find_Length ( char *text )
{
	short Pos = 0;
	short Length = 0;
	
	while ( text[Pos] != '\0' )
	{
		if ( text[Pos] == ' ' )
			Length += 24;
		else
			Length += 28;

		Pos ++;
	}

	return Length;
}

void Print_Center ( short y, char *text, short color )
{
	short x = screen_width/2 - Find_Length(text)/2;
	Print_Text ( x, y, text, color );
}

/*--------------------------GAME INIT/DEINIT FUNCTIONS------------------------*/

void Load_Fonts ()
{
	font[0] = LoadImage ( "font00a.bmp", 1 );
	font[1] = LoadImage ( "font00b.bmp", 1 );
}

void Free_Fonts ()
{
	SDL_FreeSurface ( font[0] );
	SDL_FreeSurface ( font[1] );
}

void Load_Tiles ()
{
	FILE *fp = fopen ( "tiles.dat", "rt" );
	char filename[32];
	char transparent[32];

	if ( fp == NULL)
	{
		fprintf(stderr, "Error reading file tiles.dat!\n" );
		exit(1);
	}
		
	while ( !feof ( fp ) )
	{
		fscanf ( fp, "%s", filename );
		fscanf ( fp, "%s", transparent ); // won't read as INT for some darn reason!!
		tile[tiles] = LoadImageTile ( filename, (transparent[0]-'0') );
		tiles ++;
	}

	fclose ( fp );
}

void Free_Tiles ()
{
	while ( tiles )
	{
		SDL_FreeSurface ( tile[tiles] );
		tiles --;
	}
}

void Load_Sprites ()
{
	FILE *fp = fopen ( "sprites.dat", "rt" );
	short transparent = 1;

	if ( fp == NULL)
	{
		fprintf(stderr, "Error reading file sprites.dat!\n" );
		exit(1);
	}


	while ( !feof ( fp ) )
	{
		fscanf ( fp, "%s",  sprite[sprites].name);
		fscanf ( fp, "%d", &sprite[sprites].xoff);
		fscanf ( fp, "%d", &sprite[sprites].yoff);
		fscanf ( fp, "%d", &sprite[sprites].wait);
		fscanf ( fp, "%d", &sprite[sprites].next);
		transparent =  (sprite[sprites].name[6] != 'd');

		if ( !feof ( fp ) )
			sprite[sprites].image = LoadImage ( sprite[sprites].name, transparent );
		sprites ++;
	}

	fclose ( fp );
}

short SpriteNameLookup ( char *name )
{
	short i;
	short r = 0;
	
	for ( i = 0; i < sprites; i ++ )
	{
		if ( !strcmp ( sprite[i].name, name ) )
			r = i;
	}

	return r;
}

void Free_Sprites ()
{
	while ( sprites )
	{
		SDL_FreeSurface ( sprite[sprites].image );
		sprites --;
	}
}

void Load_Sounds ()
{
	#ifdef MIXER
	sound[0] = Mix_LoadWAV ( "shot.wav" );
	#endif
}

void Free_Sounds ()
{
	#ifdef MIXER
	Mix_FreeChunk ( sound[0] );
	#endif
}

void Free_Background ()
{
	SDL_FreeSurface ( background );
}

void Load_Background ()
{
	if ( last_level != -1 )
		if ( !strcmp (level[curr_level].bg, level[last_level].bg) )
			return;
	Free_Background ();
	background = LoadImageTile ( level[curr_level].bg, 0 );
}

void Load_Music ()
{
	#ifdef MIXER
	if ( last_level != -1 )
		if ( !strcmp (level[curr_level].music, level[last_level].music) )
			return;
	Mix_FreeMusic(music);
	music = Mix_LoadMUS(level[curr_level].music);
	if ( music == NULL )
	{
		fprintf ( stderr, "Error loading music." );
		exit ( 1 );
	}
	Mix_PlayMusic(music, 0);
	#endif
}

void Free_Music ()
{
	#ifdef MIXER
	Mix_FreeMusic(music);
	#endif
}

void Load_Att(char *FileName)
{
 short j = 0;
 FILE *fp = fopen(FileName,"rt");
 if ( fp != NULL )
    while( !feof(fp) && j < MAXTILES )
    {
    	fscanf ( fp, "%d %d %d\n", &tileatt[j].nexttile, &tileatt[j].bits, &tileatt[j].wait );
       	j++;
    }
 else
 	fprintf (stderr, "AArrrghh! File not found!");
 fclose(fp);
}

void Clear_List ()
{
	obj *current = list;
	obj *temp = NULL;

	while ( current != NULL )
	{
		temp = current->next;
		delete current;
		current = temp;
	}

	list = NULL;
}

void Load_Levels ()
{
	FILE *fp = fopen ( "levels.dat", "rt" );

	levels = 0;
	
	while ( !feof ( fp ) )
	{
		fscanf( fp, "%s %s %s", level[levels].name, level[levels].music, level[levels].bg );
		if ( !strcmp( level[levels].name, "BATTAGLIA" ) )
			batt_level = levels;
		else			
			levels ++;
	}

	levels --;

	fclose ( fp );
}

void Load_Level()
{
   FILE *stream;
   short i,j;
   /* open the level file and read the level information */
   memset ( map, 0, sizeof(map) );
   AnimTiles->Delete ();
   Clear_List ();
   player[0] = NULL;
   player[1] = NULL;
   players = 0;

   if ((stream = fopen(level[curr_level].name,"rb")) != NULL)
   {
      fread( &map_width, sizeof(short), 1, stream);
      fread( &map_height, sizeof(short), 1, stream);
      for (i = 0; i < map_width; i++)
         fread(&map[BG][i][0],sizeof(short),map_height,stream);
      for (i = 0; i < map_width; i++)
         fread(&map[FG][i][0],sizeof(short),map_height,stream);
   }
   else
   	{
   		fprintf ( stderr, "Error, unable to open level %d: %s", curr_level, level[curr_level].name );
   		exit ( 1 );
   	}

   for (i=0;i < map_height;i++)
    for (j=0;j < map_width;j++)
    {
	 if ( map[FG][j][i] > MAXTILES )
	 {
		map[AM][j][i] = map[FG][j][i] - ICONSTART + 1;
	 	map[FG][j][i] = 0;
	 }
     if(map[FG][j][i] && tileatt[map[FG][j][i]].bits != 0 )
      map[CM][j][i] = tileatt[map[FG][j][i]].bits;
     else
      map[CM][j][i] = tileatt[map[BG][j][i]].bits;

     if ( test_bit ( map[CM][j][i], 7 ) )
     {
        AnimTiles->Add ( j, i, map[BG][j][i] );
     }
    }

   map_width_pix = map_width * TILESIZE + TILESIZE;
   map_height_pix = map_height * TILESIZE + TILESIZE;

   Scan_Level ();

   fclose(stream);
}

void Load_New_Level ()
{
	Load_Level ();
	Load_Background ();
	Load_Music ();
}

void Play_Sound ( short num, short x, short y )
{
	#ifdef MIXER
	if ( x < realx )
		return;
	if ( y < realy )
		return;
	if ( x > realx + screen_width )
		return;
	if ( y > realy + screen_height )
		return;
	Mix_PlayChannel(num, sound[num], 0);
	#endif
}

/*------------------------ACTOR FUNCTIONS-------------------------------------*/

AnimTile::AnimTile ( short newx, short newy, short newTile )
{
        Next = NULL;
        x = newx;
        y = newy;
        Tile = newTile;
        Wait = tileatt[Tile].wait * 20;
        Time = SDL_GetTicks();
}

void AnimTile::Add ( short newx, short newy, short newTile )
{
        AnimTile *Temp = this;
        while ( Temp->Next != NULL )
              Temp = Temp->Next;
        if ( (Temp->Next = new AnimTile(newx,newy,newTile)) == NULL )
           printf("Error allocating memory for Sprite!");
}

void AnimTile::Delete ()
{
        AnimTile *Looper = Next;
        AnimTile *Temp = NULL;

        while ( Looper != NULL )
        {
              Temp = Looper->Next;
              delete Looper;
              Looper = Temp;
        }

        Next = NULL;
}

void AnimTile::Go ()
{
        if ( Next != NULL )
           Next->Go ();

        if ( SDL_GetTicks() > Time+Wait )
        {
           Tile = tileatt[Tile].nexttile;
           map [BG][x][y] = Tile;
           map [CM][x][y] = tileatt[Tile].bits;
           Wait = tileatt[Tile].wait * 20;
           Time = SDL_GetTicks ();
        }
}

obj::obj ()
{
	next 		= NULL;
	target		= NULL;
	owner		= NULL;	

	killme		= false;
	alpha 		= 0;

	x		= TILESIZE;
	y		= TILESIZE;
	width 		= TILESIZE;
	height		= TILESIZE;
	xspeed		= 0;
	yspeed		= 0;
	maxspeed	= 8;
	jumpheight	= 12;
	start_image 	= 0;
	start_imagel	= 0;
	image 		= 0;
	time		= SDL_GetTicks ();
	frame		= 0L;
	dir		= Right;
	jumping 	= false;
	OnObject	= false;
	kind    	= Other;

	health		= 100;
	ammo		= 100;
}

void obj::DrawSprite ()
{
	SDL_Rect dst;
	dst.x = x - realx + TILESIZE;
	dst.y = y - realy + TILESIZE + sprite[start_image+image].yoff;
	dst.w = sprite[start_image+image].image->w;
	dst.h = sprite[start_image+image].image->h;
	if ( dst.x+dst.w < TILESIZE && dst.y+dst.h < TILESIZE )
           return;
    	if ( dst.x > screen_width+TILESIZE && dst.y > screen_height+TILESIZE )
           return;

	if ( alpha )
	   SDL_SetAlpha( sprite[start_image+image].image, SDL_SRCALPHA, alpha );

	if ( sprite[start_image+image].name[6] != 'c' && dir == Left)
	{
		dst.x += sprite[start_imagel+image].xoff;
		SDL_BlitSurface(sprite[start_imagel+image].image, NULL, screen, &dst);
	}
	else
	{
		dst.x += sprite[start_image+image].xoff;
		SDL_BlitSurface(sprite[start_image+image].image, NULL, screen, &dst);
	}

	if ( alpha )
		SDL_SetAlpha ( sprite[start_image+image].image, SDL_SRCALPHA, 0 );
}

bool obj::Can_Move_Right()
{
   	short tile_x,tile_y;
   	short Height;
   	short tile_num;

   	tile_x = (x + width + Max(xspeed*FrameRatio) ) / TILESIZE;

   	for(Height = y; Height < (y + height); Height += 4)
   	{
   		tile_y = (Height / TILESIZE);
    	tile_num = map[CM][tile_x][tile_y];
     	if (test_bit(tile_num, 3))
     		return false;
   	}
 	return true;
}

bool obj::Can_Move_Left()
{
   	short tile_x,tile_y;
   	short Height;
   	short tile_num;

   	tile_x = (x + Max(xspeed*FrameRatio) ) / TILESIZE;

   	if (tile_x < 1)
    	return false;

   	for(Height = y; Height < (y + height); Height += 4)
	{
    	tile_y = (Height / TILESIZE);
    	tile_num = map[CM][tile_x][tile_y];
    	if (test_bit(tile_num, 2))
     		return false;
	}

	return true;
}

bool obj::Can_Move_Up ()
{
    	short newx = x;
	short newy = y + Max(yspeed*FrameRatio);
	short x1 = newx / TILESIZE;
	short x2 = (newx+width) / TILESIZE;
	short y1 = newy / TILESIZE;

	if ( !test_bit(map[CM][x1][y1],1) && !test_bit(map[CM][x2][y1],1) )
    		return true;
	else
	    return false;
}

bool obj::Can_Move_Down ()
{
 	short newx = x;
	short newy = y + Max(yspeed*FrameRatio);
	short x1 = newx / TILESIZE;
	short x2 = (newx+width) / TILESIZE;
	short y2 = (newy+height)/ TILESIZE;

	if ( OnObject )
		return false;

 	if ( !test_bit(map[CM][x1][y2],0) && !test_bit(map[CM][x2][y2],0) )
		return true;	
	else
		return false;
}

bool obj::OnGround ()
{
 	short newx = x;
	short newy = 1 + y + Max(yspeed*FrameRatio);
	short x1 = newx / TILESIZE;
	short x2 = (newx+width) / TILESIZE;
	short y2 = (newy+height)/ TILESIZE;

	if ( OnObject )
		return true;

 	if ( !test_bit(map[CM][x1][y2],0) && !test_bit(map[CM][x2][y2],0) )
		return false;	
	else
		return true;
}

void obj::Move ()
{
    	if ( xspeed > 0 )
    	{
		while ( !Can_Move_Right () )
			xspeed -= 1;
		x += Max(xspeed * FrameRatio);
	}
    	if ( xspeed < 0 )
    	{
		while ( !Can_Move_Left () )
			xspeed += 1;
		x += Max(xspeed * FrameRatio);
	}
    	if ( yspeed < 0 )
    	{
		while ( !Can_Move_Up() )
			yspeed += 1;
 		y += Max(yspeed*FrameRatio);
	}

    	if ( yspeed > 0 )
	{
		if ( !Can_Move_Down () )
		{
			y += Max(yspeed*FrameRatio);
			yspeed = 0;
			y = (((y+height) / TILESIZE)*TILESIZE) - height - 1;
		}
		else
			y += Max(yspeed*FrameRatio);

	}

	if ( xspeed > maxspeed )
           xspeed = maxspeed;
	if ( xspeed < -maxspeed )
           xspeed = -maxspeed;
	if ( yspeed > gravity )
           yspeed = gravity;
/*	
	if ( yspeed < -jumpheight )
           yspeed = -jumpheight;
*/
	if ( xspeed > 0 )
	        xspeed -= 1;
 	if ( xspeed < 0 )
         	xspeed += 1;

// this stuff should be in another function

	if ( x > map_width_pix )
		killme = true;
	if ( x+width < 0 )
		killme = true;
	if ( y+height < 0 )
		killme = true;
	if ( y > map_height*TILESIZE )
		killme = true;

	if ( killme )
		health = 0;
}

void obj::Newtonize ()
{
	if ( !OnGround () )
	{
		if ( yspeed < 0 )
			if ( jumping )
				yspeed -= 0.25*FrameRatio;
			else
				yspeed += 1*FrameRatio;
          	yspeed += 1*FrameRatio;
	}
	else
	{	
	   if ( jumping )
	      yspeed = -jumpheight - abs(xspeed)/4;
	}

    	short TempX = (x + width/2) / TILESIZE;
    	short TempY = (y + height/2) / TILESIZE;
    	unsigned short TempTile = map[BG][TempX][TempY];

	switch(TempTile)
    	{
      		case 107: 	
      			yspeed = 32;
      			xspeed = 0;
                break;
      		case 108: 	
      			xspeed = -32;
      			yspeed = 0;
                	dir = Left;
                break;
      		case 109: 	
      			yspeed = -32;
      			xspeed = 0;
                break;
      		case 110: 	
      			xspeed = 32;
      			yspeed = 0;
                	dir = Right;
                break;
    	}
}

void obj::Go ()
{
}


bool obj::Touching(obj *objp1)
{
   short xmin1,xmax1,xmin2,xmax2;
   short ymin1,ymax1,ymin2,ymax2;
//   short x1diff, x2diff, y1diff, y2diff;

   if( objp1 == this || objp1 == NULL ) return false;

//   x1diff = width / 10;
//   y1diff = height / 10;
//   x2diff = objp1->width / 10;
//   y2diff = objp1->height / 10;

   xmin1 = objp1->x;
   xmax1 = xmin1 + objp1->width;

   xmin2 = x;
   xmax2 = xmin2 + width;

   ymin1 = objp1->y;
   ymax1 = ymin1 + objp1->height;

   ymin2 = y;
   ymax2 = ymin2 + height;

   if (xmax2 < xmin1) return false;

   if (xmin2 > xmax1) return false;

   if (ymax2 < ymin1) return false;

   if (ymin2 > ymax1) return false;

   return true;
}


/*-------------------------------ACTORS FUNCTIONS-----------------------------*/

obj *Collision_Player ( obj *o )
{
	for ( short i = 0; i < players; i ++ )
		if ( o->Touching ( player [i] ) )
			return ( player[i] );
	return NULL;
}

//                              Dead Stuff

class Dead : public obj
{
  public:
    Dead(obj *ob, short p);
    void Go(void);
    bool Can_Move_Down ();
    bool Can_Move_Left ();
    bool Can_Move_Right();
    bool Can_Move_Up   ();
    bool OnGround ();
};

bool OnGround ()
{
	return false;
}

bool Dead :: Can_Move_Left ()
{
	return true;
}

bool Dead :: Can_Move_Right ()
{
	return true;
}

bool Dead :: Can_Move_Up ()
{
	return true;
}

bool Dead :: Can_Move_Down ()
{
	return true;
}

void Add_Dead(obj *ob, short p)
{
	obj *o = new Dead ( ob, p );
	o->next = list;
	list = o;
}

Dead::Dead(obj *ob, short p)
{
 	x              	= ob->x;
	y              	= ob->y;
 	start_image    	= ob->start_image;
	image          	= p;
	dir            	= ob->dir;
	xspeed         	= ob->xspeed;
	width          	= ob->width;
	height         	= ob->height;
	maxspeed	= 8;
}

void Dead::Go (void)
{
        if ( dir == Left )
           	xspeed += 2;
        else
           	xspeed -= 2;

	yspeed += FrameRatio;
	
	if ( SDL_GetTicks()-time > 1000*5 )
		killme = true;
}

// Explosion!

class Explode : public obj
{
	public:
		void Go ();
		void Newtonize ();
		Explode ( obj *o );
};

Explode::Explode ( obj *o )
{
	x = o->x;
	y = o->y;
	width = 32;
	height = 32;
	start_image =  SpriteNameLookup ( "expl00c.bmp" );
}

void Add_Explode ( obj *ob )
{
	obj *o = new Explode ( ob );
	o->next = list;
	list = o;
}


void Explode::Newtonize ()
{
}

void Explode::Go ()
{
    if (SDL_GetTicks()-time >= 1000/20)
    {
       time = SDL_GetTicks();
    	if ( image >= 5 )
				killme = true;
    	image = sprite[start_image+image].next;
    }
}

// Smoke!

class Smoke : public obj
{
	public:
		void Go ();
		Smoke (obj *src);
		void Move ();
};

void Smoke::Move () {}

Smoke::Smoke (obj *src)
{
	x		= src->x;
	y		= src->y;
	kind		= Projectile;
	start_image	= src->start_image;
}

void Smoke::Go ()
{
	if ( alpha < 224 )
           alpha += 32;
	else
	{
           killme = true;
	   alpha = 255;
	}
}

void Add_Smoke (obj *src)
{
	obj *o = new Smoke(src);
	o->next = list;
	list = o;
}

// TEAM ROCKET BLASTS OFF AGAIN!

class Rocket : public obj
{
	public:
		void Go ();
		Rocket (obj *src);
		short bounce;
};

Rocket::Rocket (obj *src)
{
	owner	= src;
	start_image	= SpriteNameLookup ( "ball00c.bmp" );
	width	= 21;
	height	= 21;
	bounce = 0;
	jumpheight = 8;
	kind = Projectile;
	dir = src->dir;
	if ( dir == Right )
		x = src->x + src->width - (width/2);
	else
		x = src->x - (width/2);
	y = src->y + (src->height/2) - (height/2);
	maxspeed = 13;
	if ( dir == Right )
		xspeed	=  16;
	if ( dir == Left )
		xspeed 	= -16;
	Play_Sound ( 0, x, y );
}

void Rocket::Go ()
{
	obj *current;

	current = list;
	while ( current != NULL )
	{
		if ( Touching ( current ) && current != owner && current->kind == Actor )
		{
			current->xspeed = xspeed;
			current->yspeed = yspeed;
			current->health -= 10;
			Add_Explode ( this );
			killme = true;
		}
		current = current->next;
	}

	if ( dir == Right )
      	xspeed += 2;
  if ( dir == Left )
    		xspeed -= 2;
	if ( !Can_Move_Right () || !Can_Move_Left () )
				killme = true;
	jumping = true;
/*
	if ( !Can_Move_Right () || !Can_Move_Left () )
	{
		if ( bounce > 2 )
		{
	           	killme = true;
			Add_Dead ( this, 0 );
		}
		if ( dir == Left )
			dir = Right;
		else
			dir = Left;
		bounce ++;
	}
	else
	    if ( bpp == 16 )
           	Add_Smoke ( this );
	*/
}

void Add_Rocket (obj *src)
{
	obj *o = new Rocket(src);
	o->next = list;
	list = o;
}

// Bullet

class Bullet : public obj
{
	public:
		void Go ();
		Bullet (obj *src);
};

Bullet::Bullet (obj *src)
{
	owner	= src;
	start_image	= SpriteNameLookup ( "ball01c.bmp" );
	width	= 21;
	height	= 21;
	jumpheight = 8;
	kind = Projectile;
	dir = src->dir;
	if ( dir == Right )
		x = src->x + src->width - (width/2);
	else
		x = src->x - (width/2);
	y = src->y + (src->height/2) - (height/2);
	maxspeed = 13;
	if ( dir == Right )
		xspeed	=  16;
	if ( dir == Left )
		xspeed 	= -16;
	Play_Sound ( 0, x, y );
}

void Bullet::Go ()
{
	obj *current;

	current = list;
	while ( current != NULL )
	{
		if ( Touching ( current ) && current != owner && current->kind == Actor )
		{
			current->xspeed = xspeed;
			current->yspeed = yspeed;
			current->health -= 10;
			Add_Explode ( this );
			killme = true;
		}
		current = current->next;
	}

	if ( dir == Right )
      	xspeed += 2;
  if ( dir == Left )
    		xspeed -= 2;
	if ( !Can_Move_Right () || !Can_Move_Left () )
				killme = true;
	jumping = true;
}

void Add_Bullet (obj *src)
{
	obj *o = new Bullet(src);
	o->next = list;
	list = o;
}

// 									PLAYER!

class Player : public obj
{
	public:
		Player (short newx, short newy);
		void Go ();
		short FireFrame;
		Uint32 FireWait;
};

Player::Player (short newx, short newy)
{
	start_image	= SpriteNameLookup ( "west00r.png" );
	start_imagel= SpriteNameLookup ( "west00l.png" );
	width		= 42;
	height		= 127;
	x		= newx;
	y		= newy - height;
	kind		= Actor;
	jumpheight	= 16;

	FireWait	= SDL_GetTicks();
	FireFrame	= SpriteNameLookup ( "west11r.bmp" ) - start_image;

	P1_Upkey = SDLK_UP;
	P1_Leftkey = SDLK_LEFT;
	P1_Rightkey = SDLK_RIGHT;
	P1_Jumpkey = SDLK_LCTRL;
	P1_Firekey = SDLK_LALT;
}

void Player::Go ()
{
	if ( keys[P1_Leftkey] )
	{
        	xspeed -= 2;
        	dir = Left;
	}
	if ( keys[P1_Rightkey] )
	{
	      	xspeed += 2;
	      	dir = Right;
	}
	
	if ( keys[P1_Jumpkey]  )
		jumping = true;
	else
        	jumping = false;
//	keys[P1_Jumpkey] = 0;

	if ( keys[P1_Firekey] && SDL_GetTicks()-FireWait > 1000/5 && ammo > 0 )
	{
		Add_Bullet ( this );
		FireWait = SDL_GetTicks();
//		image = FireFrame;
		frame = 0;
		ammo --;
	}

    if ( health <= 0 )
    	killme = true;
    if ( killme )
	Add_Dead ( this, FireFrame-1 );
 /*
    frame ++;
    if ( frame < sprite[start_image+image].wait )
       return;
    frame = 0;
    image = sprite[start_image+image].next;
    if (xspeed == 0)
    {
       image = 0;
    }
    else
       if ( image == 0 )
       {
          image = 1;
       }
    if ( !OnGround() )
    {
	   if ( yspeed > 0 )
       	image = FireFrame+2;
       else
        image = FireFrame+1;
    }
*/
}

void Add_Player (short newx, short newy)
{
	obj *o = new Player(newx, newy);
	o->next = list;
	list = o;
	player[0] = o;
	players = 1;
}

//                              HAL Stuff

class HAL : public obj
{
  public:
    HAL (short newx, short newy);
    void Go(void);
};

void Add_HAL(short x, short y)
{
 obj *o = new HAL(x, y);
 o->next = list;
 list = o;
}

HAL::HAL(short newx, short newy)
{
 x              = newx;
 y              = newy;
 start_image    = SpriteNameLookup ( "rbot00c.bmp" );
 width          = 32;
 height         = 31;
 maxspeed				= 8;
}

void HAL::Go(void)
{
        obj *Actor = Collision_Player(this);
        if (Actor != NULL)
        {
           Actor->xspeed = xspeed;
        }

				x += TILESIZE;
        if (!OnGround())
           dir = Left;
        x -= TILESIZE*2;
        if (!OnGround())
           dir = Right;
        x += TILESIZE;

        if (!Can_Move_Right())
           dir = Left;
        if (!Can_Move_Left())
           dir = Right;

        if (dir == Right)
           xspeed += 2;
        if (dir == Left)
           xspeed -= 2;
}

//                              Yorp Stuff

class Yorp : public obj
{
  public:
    Yorp (short newx, short newy);
    void Go(void);
};

void Add_Yorp(short x, short y)
{
 obj *o = new Yorp(x, y);
 o->next = list;
 list = o;
}

Yorp::Yorp(short newx, short newy)
{
	x             = newx;
	y             = newy;
	start_image   = SpriteNameLookup ( "rbot00c.bmp" );
	width         = 32;
	height        = 31;
	maxspeed	= 8;
	kind		= Actor;
	health		= 50;	
}

void Yorp::Go(void)
{
       obj *Actor = Collision_Player(this);
       if (Actor != NULL)
       {
           Actor->xspeed = xspeed;
       }

	x += TILESIZE;
       if (!OnGround())
       	dir = Left;
       x -= TILESIZE*2;
        if (!OnGround())
       	dir = Right;
       x += TILESIZE;

        if (!Can_Move_Right())
           dir = Left;
        if (!Can_Move_Left())
           dir = Right;

        if (dir == Right)
           xspeed += 2;
        if (dir == Left)
           xspeed -= 2;

	if ( killme || health <= 0 )
	{
		Add_Dead ( this, 0 );
		killme = true;
	}
}

//                              Morpher Stuff

class Morpher : public obj
{
  public:
      Morpher ();
      void Go ();
      void Newtonize ();
};

Morpher::Morpher ()
{
      width = 15;
      height = 15;
}

void Morpher::Newtonize () {}

void Add_Morpher ()
{
 obj *o = new Morpher();
 o->next = list;
 list = o;
}

void Morpher::Go ()
{
  bool done = false;
  short tX, tY;

  while ( !done )
  {
       y += TILESIZE;
       if ( y > map_height * TILESIZE )
       {
          y = 0;
          x += TILESIZE;
          if ( x > map_width_pix )
          {
             killme = true;
             done = true;
          }
       }
       tX = x / TILESIZE;
       tY = y / TILESIZE;
       if ( map[FG][tX][tY] == 6 )
       {
          map[FG][tX][tY] = 5;
          map[CM][tX][tY] = 0;
          done = true;
       }
       else
          if ( map[FG][tX][tY] == 5 )
          {
             map[FG][tX][tY] = 6;
             map[CM][tX][tY] = 15;
             done = true;
          }
  }
}

//                              Switch Stuff

class Switch : public obj
{
  public:
      Switch (short newx, short newy);
      void Go ();
      void Newtonize ();
};

Switch::Switch (short newx, short newy)
{
      x = newx;
      y = newy;
      start_image = SpriteNameLookup("yorn00d.bmp");
      width = TILESIZE;
      height = TILESIZE + TILESIZE/8;
}

void Switch::Newtonize () {}

void Add_Switch(short x, short y)
{
 obj *o = new Switch(x, y);
 o->next = list;
 list = o;
}

void Switch::Go ()
{
      obj *Actor = Collision_Player ( this );
      if ( Actor != NULL && Actor->yspeed < 0 && Actor->y > (y + 15))
      {
         Actor->yspeed = 0;
         image ^= 1;
         Add_Morpher ();
      }
}

//                              Spike Stuff

class Spike : public obj
{
     public:
          Spike ( short newx, short newy );
          void Go ( void );
	   bool Can_Move_Down ();
};

bool Spike::Can_Move_Down ()
{
	if ( OnObject )
		return false;
	return true;
}

Spike::Spike ( short newx, short newy )
{
     x              = newx;
     y              = newy;
     start_image    = SpriteNameLookup("spke00c.bmp");
     width          = 64;
     height         = 63;
     OnObject		= true;
}

void Add_Spike ( short x, short y )
{
    obj *o = new Spike ( x, y );
 	o->next = list;
	list = o;
}

void Spike::Go ( void )
{
     if ( player[0] == NULL )
	return;
     if ( Touching ( player [0] ) )
     {
        player[0]->health = 0;
     }

     if (y > map_height * TILESIZE)
     {
      killme = true;
     }

     if ( (player[0]->x+player[0]->width > x-width) && (player[0]->x < x+width) )
      if ( player[0]->y > y && player[0]->y < y + 6*TILESIZE )
	OnObject = false;
}

//                              Garg Stuff

class Garg : public obj
{
  short startx, starty;
public:
  Garg(short newx, short newy);
  void Go(void);
  void Newtonize();
};

void Garg::Newtonize()
{
}

Garg::Garg(short newx, short newy)
{
 start_image = SpriteNameLookup("meln00c.bmp");
 width=32;
 height=32;
 startx = newx;
 starty = newy;
 x = newx + 64;
 y = newy - height + 47;
}

void Add_Garg(short x, short y)
{
 	obj *o = new Garg(x, y);
	o->next = list;
	list = o;
}

void Garg::Go(void)
{
 obj *Actor = Collision_Player(this);

 if(Actor != NULL)
 {
   	if( xspeed < 0 )
    	Actor->xspeed = -8;
   	else
    	Actor->xspeed =  8;
	if ( SDL_GetTicks()-time > 1000 )
	{
		Actor->health -= 10;
		time = SDL_GetTicks();
	}
 }

 if(x < startx)
 	xspeed += 3*FrameRatio;
 if(y < starty)
 	yspeed += 1*FrameRatio;
 if(x > startx)
 	xspeed -= 3*FrameRatio;
 if(y > starty)
 	yspeed -= 1*FrameRatio;
}

//                              Robot Stuff

class Robot : public obj
{
public:
  Robot(short newx, short newy);
  void Go(void);
};

Robot::Robot(short newx, short newy)
{
 start_image = SpriteNameLookup("tbot00c.bmp");
 width = 64;
 height = 64;
 maxspeed = 8;
 x = newx;
 y = newy - height;
 kind = Actor;
 health = 25;
}

void Add_Robot(short x, short y)
{
 obj *o = new Robot(x, y);
 o->next = list;
 list = o;
}

void Robot::Go(void)
{
	if ( player[0] == NULL )
		return;
         if(Touching(player[0]))
         {
           if(xspeed < 0)
            player[0]->xspeed = -16;
           else
            player[0]->xspeed =  16;
          }
         if(x < player[0]->x)
         {
          xspeed += 2;
          dir = Right;
         }
         else
         {
          xspeed -= 2;
          dir = Left;
         }
         if(y > player[0]->y)
          jumping = true;
         if(SDL_GetTicks()-time >= 1000/2 )
          {
           time = SDL_GetTicks();
           Add_Rocket(this);
          }
         if ( health <= 0 )
         	killme = true;

	if ( killme || health <= 0 )
		Add_Dead ( this, 0 );
}

//                              Board Stuff

class Board : public obj
{
public:
  Board(short newx, short newy);
  void Go(void);
  void Newtonize();
  obj *Actor;
};

void Board::Newtonize()
{
}

Board::Board(short newx, short newy)
{
 Actor = NULL;
 x = newx;
 y = newy;
 start_image = SpriteNameLookup ("bord00c.bmp");
 maxspeed = 6;
 width = 127;
 height = 63;
}

void Add_Board(short x, short y)
{
 obj *o = new Board(x, y);
 o->next = list;
 list = o;
}

void Board::Go(void)
{
  if(dir == Right)
   xspeed += 2;
  else
   xspeed -= 2;

  if(!Can_Move_Right())
  {
   dir = Left;
   xspeed = -2;
  }

  if(!Can_Move_Left())
  {
   dir = Right;
   xspeed = 2;
  }
 y -= 4;
  if (Actor == NULL)
     Actor = Collision_Player(this);
  if ( Actor != NULL && !Touching ( Actor ) )
  {
     Actor->OnObject = false;
     Actor = NULL;
  }
 y += 4;

  if (Actor != NULL)
  {
    if ((Actor->y + Actor->height) >= (y + height))
    {
        Actor = NULL;
    	return;
    }

    Actor->y = y - Actor->height;

	if ( Actor->Can_Move_Left() && Actor->Can_Move_Right() )
		Actor->x += xspeed*FrameRatio;

    if (!Actor->jumping)
    	Actor->OnObject = true;
  }

}

//                              DirBoard Stuff

class DirBoard : public obj
{
public:
  DirBoard(short newx, short newy);
  void Go(void);
  void Newtonize();
  obj *Actor;
};

void DirBoard::Newtonize() {}

DirBoard::DirBoard(short newx, short newy)
{
 Actor = NULL;
 x = newx;
 y = newy;
 start_image = SpriteNameLookup( "bord00c.bmp" );
 width = 112;
 height = 63;
}

void Add_DirBoard(short x, short y)
{
 obj *o = new DirBoard(x, y);
 o->next = list;
 list = o;
}

void DirBoard::Go(void)
{
  unsigned short tile;

  switch ( dir )
  {
    case Right: xspeed = 2;
                break;
    case  Left: xspeed = -2;
                break;
    case    Up: yspeed = -2;
                break;
    case  Down: yspeed = 2;
                break;

    case DownLeft:  xspeed = -2;
                    yspeed = 2;
                    break;
    case UpLeft:    yspeed = -2;
                    xspeed = -2;
                    break;
    case DownRight: yspeed = 2;
                    xspeed = 2;
                    break;
    case UpRight:   xspeed = 2;
                    yspeed = -2;
                    break;
  }
  tile = map[AM] [ x / TILESIZE ] [ y / TILESIZE ];

  if ( tile )
  {
     switch ( tile-1 )
     {
       case 20: dir = Right;
                break;
       case 21: dir = Left;
                break;
       case 22: dir = Up;
                break;
       case 23: dir = Down;
                break;

       case 24: dir = UpRight;
                break;
       case 26: dir = DownRight;
                break;
       case 25: dir = UpLeft;
                break;
       case 27: dir = DownLeft;
                break;
     }
  }

 y -= 4;
  if (Actor == NULL)
     Actor = Collision_Player(this);
  if ( Actor != NULL && !Touching ( Actor ) )
  {
     Actor->OnObject = false;
     Actor = NULL;
  }
 y += 4;

  if (Actor != NULL)
  {
    if ((Actor->y + Actor->height) >= (y + height))
    {
        Actor = NULL;
    	return;
    }

    Actor->y = y - Actor->height;

	if ( Actor->Can_Move_Left() && Actor->Can_Move_Right() )
		Actor->x += xspeed*FrameRatio;

    if (!Actor->jumping)
    	Actor->OnObject = true;
  }
}

//                              Lift Stuff

class Lift : public obj
{
 private:
  short startx, starty;
  obj *Actor;

 public:
  Lift(short newx, short newy);
  void Go(void);
};

Lift::Lift(short newx, short newy)
{
 Actor = NULL;
 startx = x = newx;
 starty = y = newy;
 start_image = SpriteNameLookup("bord00c.bmp");
 width = 127;
 height = 32;
 jumpheight = 18;
}

void Add_Lift(short x, short y)
{
 obj *o = new Lift(x, y);
 o->next = list;
 list = o;
}

void Lift::Go(void)
{
	jumping = true;

 y -= 4;
  if (Actor == NULL)
     Actor = Collision_Player(this);
  if ( Actor != NULL && !Touching ( Actor ) )
  {
     Actor->OnObject = false;
     Actor = NULL;
  }
 y += 4;

  if (Actor != NULL)
  {
     if ((Actor->y + Actor->height) >= (y + height))
     {
        Actor = NULL;
        return;
     }

     Actor->y = y - Actor->height;
//     Actor->x += x_vel*FrameRatio;

     if (!Actor->jumping)
        Actor->OnObject = true;
  }
}

//                              Door  Stuff

class Door : public obj
{
  public:
    short x2, y2;
    bool moved;
    Door(short newx, short newy, short x2v, short y2v);
    void Go(void);
};

Door::Door(short newx, short newy, short x2v, short y2v)
{
    x           = newx;
    y           = newy;
    x2          = x2v;
    y2          = y2v;
    width       = 127;
    height      = 127;
    start_image = SpriteNameLookup("door00d.bmp");
}

void Add_Door(short x, short y, short newx, short newy)
{
 obj *o = new Door(x, y, newx, newy);
 o->next = list;
 list = o;
}

void Door::Go()
{
	
    if (image == 5 && keys[P1_Upkey] )
    {
       player[0]->x = x2*TILESIZE;
       player[0]->y = y2*TILESIZE;
       image = 0;
       keys[P1_Upkey] = false;
    }

    if (SDL_GetTicks()-time >= 1000/20)
    {
       time = SDL_GetTicks();

       if (Touching(player[0]))
       {
          if(image < 5)
               image++;
       }
       else
       {
          if(image > 0)
               image--;
       }
    }
}

//                              Flob Stuff
class Flob : public obj
{
  public:
    Flob(short newx, short newy);
    void Go(void);
};

void Add_Flob(short x, short y)
{
 obj *o = new Flob(x, y);
 o->next = list;
 list = o;
}

Flob::Flob(short newx, short newy)
{
	x             = newx;
	y             = newy;
	start_image   = SpriteNameLookup("flob00c.bmp");
	width         = 45;
	height        = 45;
	dir           = Down;
	jumpheight    = 18;
	kind		= Actor;
	health		= 50;
}

void Flob::Go(void)
{
        obj *Actor = Collision_Player(this);
        if(Actor != NULL)
        {
                Actor->health = 0;
        }

        jumping = true;

        if (dir == Right)
           xspeed += 2;
        if (dir == Left)
           xspeed -= 2;

        if (xspeed > 2)
           dir = Right;
        if (xspeed < -2)
           dir = Left;

	 xspeed += 8;
        if (!Can_Move_Right())
           dir = Left;
	 xspeed -= 16;
        if (!Can_Move_Left())
           dir = Right;
	 xspeed += 8;
}

//                              Car Stuff

class Car : public obj
{
 public:
  Car ( short newx, short newy );
  void Go (void);
  bool InCar;
};

Car::Car ( short newx, short newy )
{
   x = newx;
   y = newy;
   width = 310;
   height = 88;
   maxspeed = 16;
   start_image = SpriteNameLookup ( "acar00r.bmp");
   start_imagel = SpriteNameLookup ( "acar00l.bmp" );
   InCar = false;
}

void Add_Car(short x, short y)
{
	obj *o = new Car(x, y);
	o->next = list;
	list = o;
}

void Car::Go(void)
{
  obj *Lcurrent;

	if ( player[0] == NULL )
		return;

  if ( !InCar )
  {
     image = 0;
     if ( Touching ( player[0] ) && keys[P1_Upkey] )
     {
        player[0]->killme = true;
        player[0] = this;
        InCar = true;
     }
  }
  else
  {
     image = 1;
     if (keys[SDLK_RIGHT])
     {
        xspeed += 2;
        dir = Right;
     }
     if (keys[SDLK_LEFT])
     {
        xspeed -= 2;
        dir = Left;
     }
     Lcurrent = list;
     while ( Lcurrent != NULL )
     {
           if ( Lcurrent->kind == Actor )
              if ( Touching ( Lcurrent ) )
              {
                 Lcurrent->health = 0;
              }
           Lcurrent = Lcurrent->next;
     }
     if (keys[P1_Jumpkey])
     {
        Add_Player ( x + 56, y + player[0]->height );
        player[0] = list;
        InCar = false;
	keys[P1_Jumpkey] = 0;
     }
  }
}

//                              Mark Stuff

class Mark : public obj
{
public:
  Mark(short newx, short newy);
  void Go(void);
};

Mark::Mark(short newx, short newy)
{
	start_image = SpriteNameLookup ( "aran00r.bmp" );
	start_imagel = SpriteNameLookup ( "aran00l.bmp" );
	height = 230;
	width = 99;
	x = newx;
	y = newy - height;
	kind = Actor;
	health = 200;
}

void Add_Mark(short x, short y)
{
	obj *o = new Mark ( x, y );
	o->next = list;
	list = o;
}

void Mark::Go(void)
{
	if ( player[0] == NULL )
		return;

         if ( health <= 0 )
            Add_Morpher ();
         if(Touching(player[0]))
          {
           if(xspeed < 0)
            player[0]->xspeed = -48;
           else
            player[0]->xspeed =  48;
          }
         if (x < player[0]->x)
         {
           xspeed += 2;
           if ( SDL_GetTicks()-time >= 1000 )
              dir = Right;
         }
         else
            if (x > player[0]->x)
            {
              xspeed -= 2;
              if ( SDL_GetTicks()-time >= 1000 )
                 dir = Left;
            }

         if(y > player[0]->y)
          jumping = true;
         if(SDL_GetTicks()-time >= 2000)
         {
           time = SDL_GetTicks();
           Add_Rocket(this);
         }

	if ( killme || health <= 0 )
	{
		Add_Dead ( this, 0 );
		killme = true;
	}

    frame ++;
    if ( frame < sprite[start_image+image].wait )
       return;
    frame = 0;
    image = sprite[start_image+image].next;
    if ( jumping )
       image = 3;
}

// 					Opponent!

class Opponent : public obj
{
	public:
		Opponent (short newx, short newy);
		void Go ();
		short FireFrame;
		short FireWait;
};

Opponent::Opponent (short newx, short newy)
{
	start_image	= SpriteNameLookup ( "wnst00r.bmp" );
	start_imagel    = SpriteNameLookup ( "wnst00l.bmp" );
	width		= 127;
	height		= 127;
	x		= newx;
	y		= newy - height;
	kind		= Actor;
	dir		= Left;
	FireWait	= 0;
	jumpheight	= 16;
}

void Opponent::Go ()
{
  if(Touching(player[0]))
  {
    if((player[0]->x+8) < (x+8))
    {
     player[0]->xspeed  = -16;
     xspeed =  24;
    }
    else
    {
     player[0]->xspeed  =  16;
     xspeed = -24;
    }
    if(player[0]->yspeed > 0)
	player[0]->jumping = true;
    if( yspeed > 0 )
	jumping = true;
  }

	if ( keys[SDLK_a] )
	{
        	xspeed -= 2;
        	dir = Left;
	}
	if ( keys[SDLK_d] )
	{
	      	xspeed += 2;
	      	dir = Right;
	}
	if ( keys[SDLK_LCTRL]  )
		jumping = true;
	else
        	jumping = false;

	FireWait ++;
	if ( FireWait > 256 )
           FireWait --;

	if ( keys[SDLK_LALT] && FireWait > 16 && ammo > 0 )
	{
		Add_Rocket ( this );
		FireWait = 0;
		frame = 0;
		ammo --;
	}


    if ( health <= 0 )
    	killme = true;
    if ( killme )
	Add_Dead ( this, 0 );

    if ( SDL_GetTicks() < time+sprite[start_image+image].wait*20 )
       return;
	time = SDL_GetTicks ();
    image = sprite[start_image+image].next;
    if (xspeed == 0)
    {
       image = 0;
    }
    else
       if ( image == 0 )
       {
          image = 1;
       }
    if ( !OnGround() )
    {
      	image = 4;
    }
}

void Add_Opponent (short newx, short newy)
{
	obj *o = new Opponent(newx, newy);
	o->next = list;
	list = o;
	player[1] = o;
	players ++;
	P1_Jumpkey = SDLK_RCTRL;
	P1_Firekey = SDLK_RALT;
}

/*-------------------------------------GAME LOOP-----------------------------*/

void Scan_Level ()
{
   short i,j;
   for (i=0; i <= map_height; i++)
    for (j=0; j <= map_width; j++)
      switch( (map[AM][j][i]-1) )
      {
       case   0: Add_Player( j*TILESIZE, i*TILESIZE );
                 break;
       case   1: Add_Board(j*TILESIZE,i*TILESIZE);
                 break;
       case   2: Add_Lift(j*TILESIZE,i*TILESIZE);
                 break;
       case   3: Add_Yorp(j*TILESIZE,i*TILESIZE);
                 break;
       case   4: Add_Mark(j*TILESIZE,i*TILESIZE);
                 break;
	case   5: Add_Robot(j*TILESIZE,i*TILESIZE);
                 break;
       case   6: Add_Garg(j*TILESIZE, i*TILESIZE);
                 break;
       case   7: Add_Opponent(j*TILESIZE, i*TILESIZE);
                 break;
       case   8: Add_Flob(j*TILESIZE, i*TILESIZE);
                 break;
       case   9: Add_Door(j*TILESIZE, i*TILESIZE, map[FG][j + 1][i], map[FG][j][i + 1]);
       			 map[FG][j+1][i] = 0;
       			 map[FG][j][i+1] = 0;
                 break;
       case  10: Add_HAL(j*TILESIZE, i*TILESIZE);
                 break;
       case  12: Add_Switch(j*TILESIZE,i*TILESIZE);
                 break;
       case  13: Add_Car(j*TILESIZE,i*TILESIZE);
                 break;
       case  14: Add_Spike(j*TILESIZE,i*TILESIZE);
                 break;
       case  16: Add_DirBoard(j*TILESIZE,i*TILESIZE);
                 break;
	}

	ClearKeys ();
}

void Set_Screen ()
{
	short ScreenX, ScreenY;

	if ( !players )
		return;

	if ( players == 2 )
	{
		ScreenX = ((player[0]->x+player[1]->x)/2) - screen_width/2 + player[0]->width/2 + TILESIZE;
		ScreenY = ((player[0]->y+player[1]->y)/2) - screen_height/2 + player[0]->height/2 + TILESIZE;
	}
	else
	{
		ScreenX = player[0]->x - screen_width/2 + player[0]->width/2 + TILESIZE;
		ScreenY = player[0]->y - screen_height/2 + player[0]->height/2 + TILESIZE;
	}

	realx = ScreenX;
	realy = ScreenY;

	if ( ScreenX >= map_width_pix-screen_width )
		realx = map_width_pix-screen_width;
	if ( ScreenY >= map_height_pix-screen_height )
		realy = map_height_pix-screen_height;
    	if ( ScreenX <= TILESIZE )
    		realx = TILESIZE;
    	if ( ScreenY <= TILESIZE )
    		realy = TILESIZE;
}

void Draw_Health ()
{
	SDL_Rect dst;
	short i;
	static short num = SpriteNameLookup("info00c.bmp");
	
	if ( player[0]->x+player[0]->width > map_width_pix-player[0]->width )
	{
		last_level = curr_level;
		curr_level ++;
  		if ( curr_level == batt_level )
			curr_level = 0;
		Load_New_Level ();
	}
	else	
	if ( player[0]->killme )
	{
		Load_Level ();
	}
	else
	{
		for ( i = 0; i < player[0]->health/10; i ++ )
		{
			dst.x = i*28;
			dst.y = 0;
			dst.w = sprite[num].image->w;
			dst.h = sprite[num].image->h;
			SDL_BlitSurface(sprite[num].image, NULL, screen, &dst);
		}
		Print_Number ( 0, 32, player[0]->ammo, 0);		
	}

	if ( players == 2 )
		if ( player[1]->killme )
		{
			Print_Center ( 6*32, "PLAYER 2 IS DEAD", 0 );
			Print_Center ( 7*32, "PRESS R", 1 );
		}
		else
		{
			for ( i = 0; i < player[1]->health/10; i ++ )
			{
				dst.x = screen_width - i*28 - 28;
				dst.y = 0;
				dst.w = sprite[num].image->w;
				dst.h = sprite[num].image->h;
				SDL_BlitSurface(sprite[num].image, NULL, screen, &dst);
			}
			Print_Number ( screen_width, 32, player[1]->ammo, 0);		
		}
}

Uint32 RunGame ()
{
	obj *current;
	obj *temp = NULL;
	bool done = false;
	Uint32 frames = 0;

	Uint32 LastTime;
		
	Load_New_Level ();
	Draw_Health ();

	GameTime = SDL_GetTicks ();
	
	while ( !done )
	{
		LastTime = GameTime;
		GameTime = SDL_GetTicks ();
		FrameRatio=(float)(GameTime-LastTime)/(float)(FRAMES_PER_SEC);

   	SDL_PollEvent(NULL);			// get input
   	keys = SDL_GetKeyState ( NULL );	// catch it

	      	/* Traverse list, move objects */
			current = list;
            if ( list != NULL && list->killme )
            {
                   temp = current;
                   current = current->next;
                   delete temp;
                   list = current;
            }
			while ( current != NULL )
            {
  	
  	        	current->Newtonize ();
		    	  	current->Move ();
		      	  current->Go ();
                  temp = current->next;
        	      if ( temp != NULL )
                  {
                         if ( temp->killme )
                         {
                            current->next = temp->next;
                            delete temp;
                         }
		      	  }
                  temp = current;
           	      current = current->next;
			}
			AnimTiles->Go();

	frames ++;

 	/* draw everything */
 	
 	Set_Screen ();

	tile_orgx = realx / TILESIZE;
	tile_orgy = realy / TILESIZE;
	nextx = (tile_orgx+1)*TILESIZE;
	nexty = (tile_orgy+1)*TILESIZE;

	Draw_Level ();

 	current = list;

 	while ( current != NULL )
	{
	      current->DrawSprite ();	
	      current = current->next;
	}

	Draw_Level_Foreground ();

 	Draw_Health();

	SDL_Flip ( screen );

     	/* other keys */
     	if ( keys[SDLK_ESCAPE] )
            done = true;
        if ( keys[SDLK_l] )
        {
		keys[SDLK_l] = 0;
		last_level = curr_level;
		curr_level ++;
		if ( battaglia )
		{
			if ( curr_level == levels )
				curr_level = batt_level;
		}
		else
		{
			if ( curr_level == batt_level )
				curr_level = 0;
		}
		Load_New_Level ();
        }
        if ( keys[SDLK_r] )
        {
			Load_Level ();
			keys[SDLK_r] = 0;
        }
	}

	return frames;
}

short Main_Menu ()
{
	char *menu[] = {
				"BEGIN SOLO GAME",
				"BEGIN BATTAGLIA",
				"EXIT PROGRAM"
			 };
 	bool done = false;
	short i, p = 0;
	short max = 2;
	SDL_Surface *Pic;
	
	Pic = LoadImageTile ( "menu.bmp", 0 );
	SDL_BlitSurface(Pic, NULL, screen, NULL );
	SDL_Flip ( screen );
	SDL_BlitSurface(Pic, NULL, screen, NULL );
	SDL_Flip ( screen );
	SDL_FreeSurface ( Pic );
	
	#ifdef MIXER
	Free_Music ();
	music = Mix_LoadMUS("IO_TITLE.IT");
	if ( music == NULL )
		printf ( "Error loading music." );
	Mix_PlayMusic(music, 1);
	#endif

	while ( !done )
	{
		for ( i = 0; i <= max; i++ )
		{
			if ( i == p )
				Print_Center ( 160 + i*32, menu[i], 1 );
			else
				Print_Center ( 160 + i*32, menu[i], 0 );
		}

		SDL_Flip ( screen );
		while ( SDL_PollEvent(NULL) == 0 );
	      	keys = SDL_GetKeyState ( NULL );	// catch it

		if ( keys[SDLK_UP] && p > 0 )
		{
			p --;
			keys[SDLK_UP] = 0;
		}
		if ( keys[SDLK_DOWN] && p < max )
		{
			p ++;
			keys[SDLK_DOWN] = 0;
		}
		if ( keys[SDLK_ESCAPE] )
		{
			p = -1;
			done = true;
			keys[SDLK_ESCAPE] = 0;
		}

		if ( keys[SDLK_RETURN] )
		{
			done = true;
		}
	}

	return p;
}

/*---------------------------------------MAIN---------------------------------*/

int CheckParm (int argc, char *argv[], char *check)
{
	int             i;

        for (i = 1;i<argc;i++)
                if ( !strcmp(check,argv[i]) )
			return i;

	return 0;
}

int main(int argc, char *argv[])
{
	Uint32 before, after, frames;
	short n = 0;

	/* parse command line, set video mode */
	n = CheckParm ( argc, argv, "-w" );
	if ( n )
		screen_width = atoi ( argv[n+1] );
	n = CheckParm ( argc, argv, "-h" );
	if ( n )
		screen_height = atoi ( argv[n+1] );
	n = CheckParm ( argc, argv, "-bpp" );
	if ( n )
		bpp = atoi ( argv[n+1] );
	if ( CheckParm ( argc, argv, "-coolwhip" ) && bpp > 8 )
			coolwhip = true;
	if ( CheckParm ( argc, argv, "-noparallax" ) )
			parallax = false;
 	if ( CheckParm( argc, argv, "-swmem" ) )
    	hwmem = false;
	
	if (SDL_Init (SDL_INIT_VIDEO|SDL_INIT_AUDIO) < 0)
	{
		fprintf(stderr, "Initialization failed: %s\n", SDL_GetError());
		exit(1);
	}
	atexit(SDL_Quit);

 	if ( CheckParm( argc, argv, "-window" ) )
		screen = SDL_SetVideoMode(screen_width, screen_height, bpp, SDL_HWSURFACE );
	else {
		if ( hwmem )
			screen = SDL_SetVideoMode(screen_width, screen_height, bpp, SDL_HWSURFACE|SDL_FULLSCREEN|SDL_DOUBLEBUF );
		else
			screen = SDL_SetVideoMode(screen_width, screen_height, bpp, SDL_SWSURFACE|SDL_FULLSCREEN );
  }

	if ( screen == NULL)
	{
		fprintf(stderr, "Can't set video mode: %s\n", SDL_GetError());
		exit(1);
	}

	/* init the audio device */
	#ifdef MIXER
	if ( Mix_OpenAudio(44100, AUDIO_S16, 1, 2048) < 0 )
	{
		fprintf(stderr,
		"Warning: Couldn't set 44100 Hz 16-bit audio\n- Reason: %s\n",
							SDL_GetError());
	}
	#endif
	SDL_WM_SetCaption ( "Insane Odyssey X", NULL );
	
	/*ignore mouse / focus events*/
	SDL_EventState(SDL_ACTIVEEVENT, SDL_IGNORE);
	SDL_EventState(SDL_MOUSEMOTION, SDL_IGNORE);

	SDL_ShowCursor ( 0 );

  /* load data */
	LoadImagePalette ( "palette.bmp" );
	Load_Tiles ();
	Load_Fonts ();
	Load_Sprites ();
	Load_Levels ();
	Load_Att ( "tiles.att" );
	Load_Sounds ();
	
	bool done = false;

	while ( !done )
		switch ( Main_Menu () )
		{
			case 0: before = SDL_GetTicks ();
				battaglia = false;
		  	 	curr_level = 0;
		  	 	last_level = -1;
				frames = RunGame();
				after = SDL_GetTicks ();
				break;
			case 1: before = SDL_GetTicks ();
				battaglia = true;
		  	 	curr_level = batt_level;
		  	 	last_level = -1;
				frames = RunGame();
				after = SDL_GetTicks ();
				break;
			case 21:done = true;
				break;
			case 2: done = true;
				break;
		}
	
	if ( after > before )
	{
		fprintf( stderr, "%2.2f frames per second\n",
					((float)frames*1000)/(after-before));
	}
	
	/* free data */

	Clear_List();
	Free_Sounds ();
	Free_Music ();
	Free_Tiles ();
	Free_Fonts ();
	Free_Background ();
	Free_Sprites ();
	
	#ifdef MIXER
	Mix_CloseAudio();
	#endif

	return 0;
}
