<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# stack

```go
import "github.com/zyedidia/generic/stack"
```

Package stack provides an implementation of a LIFO stack built using a resizing array.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"

	"github.com/zyedidia/generic/stack"
)

func main() {
	st := stack.New[string]()
	st.Push("foo")
	st.Push("bar")

	fmt.Println(st.Pop())
	fmt.Println(st.Peek())

	st.Push("baz")
	fmt.Println(st.Size())
}
```

#### Output

```
bar
foo
2
```

</p>
</details>

## Index

- [type Stack](<#type-stack>)
  - [func New[T any]() *Stack[T]](<#func-new>)
  - [func (s *Stack[T]) Copy() *Stack[T]](<#func-stackt-copy>)
  - [func (s *Stack[T]) Peek() (t T)](<#func-stackt-peek>)
  - [func (s *Stack[T]) Pop() (t T)](<#func-stackt-pop>)
  - [func (s *Stack[T]) Push(value T)](<#func-stackt-push>)
  - [func (s *Stack[T]) Size() int](<#func-stackt-size>)


## type [Stack](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L6-L8>)

Stack implements a LIFO stack with peeking.

```go
type Stack[T any] struct {
    // contains filtered or unexported fields
}
```

### func [New](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L11>)

```go
func New[T any]() *Stack[T]
```

New returns an empty stack.

### func \(\*Stack\[T\]\) [Copy](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L48>)

```go
func (s *Stack[T]) Copy() *Stack[T]
```

Copy returns a copy of this stack.

### func \(\*Stack\[T\]\) [Peek](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L35>)

```go
func (s *Stack[T]) Peek() (t T)
```

Peek returns the stack's top element but does not remove it. If the stack is empty the zero value is returned.

### func \(\*Stack\[T\]\) [Pop](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L24>)

```go
func (s *Stack[T]) Pop() (t T)
```

Pop removes the stack's top element and returns it. If the stack is empty it returns the zero value.

### func \(\*Stack\[T\]\) [Push](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L18>)

```go
func (s *Stack[T]) Push(value T)
```

Push places 'value' at the top of the stack.

### func \(\*Stack\[T\]\) [Size](<https://github.com/zyedidia/generic/blob/master/stack/stack.go#L43>)

```go
func (s *Stack[T]) Size() int
```

Size returns the number of elements in the stack.



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
