/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import org.minidns.record.Data;
import org.minidns.record.NSEC3;
import org.minidns.record.Record;

public class NSEC3PARAM
extends Data {
    public final NSEC3.HashAlgorithm hashAlgorithm;
    public final byte hashAlgorithmByte;
    public final byte flags;
    public final int iterations;
    private final byte[] salt;

    public static NSEC3PARAM parse(DataInputStream dis) throws IOException {
        byte hashAlgorithm = dis.readByte();
        byte flags = dis.readByte();
        int iterations = dis.readUnsignedShort();
        int saltLength = dis.readUnsignedByte();
        byte[] salt = new byte[saltLength];
        if (dis.read(salt) != salt.length && salt.length != 0) {
            throw new IOException();
        }
        return new NSEC3PARAM(hashAlgorithm, flags, iterations, salt);
    }

    private NSEC3PARAM(NSEC3.HashAlgorithm hashAlgorithm, byte hashAlgorithmByte, byte flags, int iterations, byte[] salt) {
        assert (hashAlgorithmByte == (hashAlgorithm != null ? hashAlgorithm.value : hashAlgorithmByte));
        this.hashAlgorithmByte = hashAlgorithmByte;
        this.hashAlgorithm = hashAlgorithm != null ? hashAlgorithm : NSEC3.HashAlgorithm.forByte(hashAlgorithmByte);
        this.flags = flags;
        this.iterations = iterations;
        this.salt = salt;
    }

    NSEC3PARAM(byte hashAlgorithm, byte flags, int iterations, byte[] salt) {
        this(null, hashAlgorithm, flags, iterations, salt);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.NSEC3PARAM;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeByte(this.hashAlgorithmByte);
        dos.writeByte(this.flags);
        dos.writeShort(this.iterations);
        dos.writeByte(this.salt.length);
        dos.write(this.salt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append((Object)this.hashAlgorithm).append(' ').append(this.flags).append(' ').append(this.iterations).append(' ').append(this.salt.length == 0 ? "-" : new BigInteger(1, this.salt).toString(16).toUpperCase(Locale.ROOT));
        return sb.toString();
    }

    public int getSaltLength() {
        return this.salt.length;
    }
}

