/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.abstr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public abstract class AbstractOpenPgpTrustStore
implements OpenPgpTrustStore {
    private final Map<BareJid, Map<OpenPgpV4Fingerprint, OpenPgpTrustStore.Trust>> trustCache = new HashMap<BareJid, Map<OpenPgpV4Fingerprint, OpenPgpTrustStore.Trust>>();

    protected abstract OpenPgpTrustStore.Trust readTrust(BareJid var1, OpenPgpV4Fingerprint var2) throws IOException;

    protected abstract void writeTrust(BareJid var1, OpenPgpV4Fingerprint var2, OpenPgpTrustStore.Trust var3) throws IOException;

    @Override
    public OpenPgpTrustStore.Trust getTrust(BareJid owner2, OpenPgpV4Fingerprint fingerprint) throws IOException {
        OpenPgpTrustStore.Trust trust;
        Map<OpenPgpV4Fingerprint, OpenPgpTrustStore.Trust> trustMap = this.trustCache.get(owner2);
        if (trustMap != null) {
            trust = trustMap.get(fingerprint);
            if (trust != null) {
                return trust;
            }
        } else {
            trustMap = new HashMap<OpenPgpV4Fingerprint, OpenPgpTrustStore.Trust>();
            this.trustCache.put(owner2, trustMap);
        }
        trust = this.readTrust(owner2, fingerprint);
        trustMap.put(fingerprint, trust);
        return trust;
    }

    @Override
    public void setTrust(BareJid owner2, OpenPgpV4Fingerprint fingerprint, OpenPgpTrustStore.Trust trust) throws IOException {
        Map<OpenPgpV4Fingerprint, OpenPgpTrustStore.Trust> trustMap = this.trustCache.get(owner2);
        if (trustMap == null) {
            trustMap = new HashMap<OpenPgpV4Fingerprint, OpenPgpTrustStore.Trust>();
            this.trustCache.put(owner2, trustMap);
        }
        if (trustMap.get(fingerprint) == trust) {
            return;
        }
        trustMap.put(fingerprint, trust);
        this.writeTrust(owner2, fingerprint, trust);
    }
}

