/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.admin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandManager;
import org.jivesoftware.smackx.commands.AdHocCommandResult;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public class ServiceAdministrationManager
extends Manager {
    public static final String COMMAND_NODE = "http://jabber.org/protocol/admin";
    private static final String COMMAND_NODE_HASHSIGN = "http://jabber.org/protocol/admin#";
    private static final Map<XMPPConnection, ServiceAdministrationManager> INSTANCES = new WeakHashMap<XMPPConnection, ServiceAdministrationManager>();
    private final AdHocCommandManager adHocCommandManager;

    public static synchronized ServiceAdministrationManager getInstanceFor(XMPPConnection connection) {
        ServiceAdministrationManager serviceAdministrationManager = INSTANCES.get(connection);
        if (serviceAdministrationManager == null) {
            serviceAdministrationManager = new ServiceAdministrationManager(connection);
            INSTANCES.put(connection, serviceAdministrationManager);
        }
        return serviceAdministrationManager;
    }

    public ServiceAdministrationManager(XMPPConnection connection) {
        super(connection);
        this.adHocCommandManager = AdHocCommandManager.getInstance(connection);
    }

    public AdHocCommand addUser() {
        return this.addUser(this.connection().getXMPPServiceDomain());
    }

    public AdHocCommand addUser(Jid service) {
        return this.adHocCommandManager.getRemoteCommand(service, "http://jabber.org/protocol/admin#add-user");
    }

    public void addUser(EntityBareJid userJid, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommand command = this.addUser();
        AdHocCommandResult.StatusExecuting commandExecutingResult = command.execute().asExecutingOrThrow();
        FillableForm answerForm = commandExecutingResult.getFillableForm();
        answerForm.setAnswer("accountjid", userJid);
        answerForm.setAnswer("password", password);
        answerForm.setAnswer("password-verify", password);
        AdHocCommandResult result = command.execute(answerForm);
        assert (result.isCompleted());
    }

    public AdHocCommand deleteUser() {
        return this.deleteUser(this.connection().getXMPPServiceDomain());
    }

    public AdHocCommand deleteUser(Jid service) {
        return this.adHocCommandManager.getRemoteCommand(service, "http://jabber.org/protocol/admin#delete-user");
    }

    public void deleteUser(EntityBareJid userJidToDelete) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Set<EntityBareJid> userJidsToDelete = Collections.singleton(userJidToDelete);
        this.deleteUser(userJidsToDelete);
    }

    public void deleteUser(Set<EntityBareJid> jidsToDelete) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        AdHocCommand command = this.deleteUser();
        AdHocCommandResult.StatusExecuting commandExecutingResult = command.execute().asExecutingOrThrow();
        FillableForm answerForm = commandExecutingResult.getFillableForm();
        answerForm.setAnswer("accountjids", jidsToDelete);
        AdHocCommandResult result = command.execute(answerForm);
        assert (result.isCompleted());
    }
}

