/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression.zlib;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.compression.XmppCompressionFactory;

public final class ZlibXmppCompressionFactory
extends XmppCompressionFactory {
    public static final ZlibXmppCompressionFactory INSTANCE = new ZlibXmppCompressionFactory();

    private ZlibXmppCompressionFactory() {
        super("zlib", 100);
    }

    @Override
    public XmppInputOutputFilter fabricate(ConnectionConfiguration configuration) {
        return new ZlibXmppInputOutputFilter();
    }

    private static final class ZlibXmppInputOutputFilter
    implements XmppInputOutputFilter {
        private static final int MINIMUM_OUTPUT_BUFFER_INITIAL_SIZE = 4;
        private static final int MINIMUM_OUTPUT_BUFFER_INCREASE = 480;
        private final Deflater compressor;
        private final Inflater decompressor = new Inflater();
        private long compressorInBytes;
        private long compressorOutBytes;
        private long decompressorInBytes;
        private long decompressorOutBytes;
        private int maxOutputOutput = -1;
        private int maxInputOutput = -1;
        private int maxBytesWrittenAfterFullFlush = -1;
        private ByteBuffer outputBuffer;

        private ZlibXmppInputOutputFilter() {
            this(-1);
        }

        private ZlibXmppInputOutputFilter(int compressionLevel) {
            this.compressor = new Deflater(compressionLevel);
        }

        @Override
        public XmppInputOutputFilter.OutputResult output(ByteBuffer outputData, boolean isFinalDataOfElement, boolean destinationAddressChanged, boolean moreDataAvailable) throws IOException {
            int compressorInputBufferLength;
            int compressorInputBufferOffset;
            byte[] compressorInputBuffer;
            if (destinationAddressChanged && XMPPInputOutputStream.getFlushMethod() == XMPPInputOutputStream.FlushMethod.FULL_FLUSH) {
                this.outputBuffer = ByteBuffer.allocate(256);
                int bytesWritten = this.deflate(3);
                this.maxBytesWrittenAfterFullFlush = Math.max(bytesWritten, this.maxBytesWrittenAfterFullFlush);
                this.compressorOutBytes += (long)bytesWritten;
            }
            if (outputData == null && this.outputBuffer == null) {
                return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
            }
            int bytesRemaining = outputData.remaining();
            if (this.outputBuffer == null) {
                int outputBufferSize = bytesRemaining < 4 ? 4 : bytesRemaining;
                this.outputBuffer = ByteBuffer.allocate(outputBufferSize);
            }
            assert (this.compressor.needsInput());
            if (outputData.hasArray()) {
                compressorInputBuffer = outputData.array();
                compressorInputBufferOffset = outputData.arrayOffset();
                compressorInputBufferLength = outputData.remaining();
            } else {
                compressorInputBuffer = new byte[outputData.remaining()];
                compressorInputBufferOffset = 0;
                compressorInputBufferLength = compressorInputBuffer.length;
                outputData.get(compressorInputBuffer);
            }
            this.compressorInBytes += (long)compressorInputBufferLength;
            this.compressor.setInput(compressorInputBuffer, compressorInputBufferOffset, compressorInputBufferLength);
            int flushMode = moreDataAvailable ? 0 : 2;
            int bytesWritten = this.deflate(flushMode);
            this.maxOutputOutput = Math.max(this.outputBuffer.position(), this.maxOutputOutput);
            this.compressorOutBytes += (long)bytesWritten;
            XmppInputOutputFilter.OutputResult outputResult = new XmppInputOutputFilter.OutputResult(this.outputBuffer);
            this.outputBuffer = null;
            return outputResult;
        }

        private int deflate(int flushMode) {
            int totalBytesWritten = 0;
            while (true) {
                int initialOutputBufferPosition = this.outputBuffer.position();
                byte[] buffer = this.outputBuffer.array();
                int length = this.outputBuffer.limit() - initialOutputBufferPosition;
                int bytesWritten = this.compressor.deflate(buffer, initialOutputBufferPosition, length, flushMode);
                int newOutputBufferPosition = initialOutputBufferPosition + bytesWritten;
                ((Buffer)this.outputBuffer).position(newOutputBufferPosition);
                totalBytesWritten += bytesWritten;
                if (this.compressor.needsInput() && this.outputBuffer.hasRemaining()) break;
                int increasedBufferSize = this.outputBuffer.capacity() * 2;
                if (increasedBufferSize < 480) {
                    increasedBufferSize = 480;
                }
                ByteBuffer newCurrentOutputBuffer = ByteBuffer.allocate(increasedBufferSize);
                ((Buffer)this.outputBuffer).flip();
                newCurrentOutputBuffer.put(this.outputBuffer);
                this.outputBuffer = newCurrentOutputBuffer;
            }
            return totalBytesWritten;
        }

        @Override
        public ByteBuffer input(ByteBuffer inputData) throws IOException {
            int bytesInflated;
            int length;
            int offset;
            byte[] inputBytes;
            int bytesRemaining = inputData.remaining();
            if (inputData.hasArray()) {
                inputBytes = inputData.array();
                offset = inputData.arrayOffset();
                length = inputData.remaining();
            } else {
                inputBytes = new byte[bytesRemaining];
                inputData.get(inputBytes);
                offset = 0;
                length = inputBytes.length;
            }
            this.decompressorInBytes += (long)length;
            this.decompressor.setInput(inputBytes, offset, length);
            ByteBuffer outputBuffer = ByteBuffer.allocate(2 * length);
            while (true) {
                byte[] inflateOutputBuffer = outputBuffer.array();
                int inflateOutputBufferOffset = outputBuffer.position();
                int inflateOutputBufferLength = outputBuffer.limit() - inflateOutputBufferOffset;
                try {
                    bytesInflated = this.decompressor.inflate(inflateOutputBuffer, inflateOutputBufferOffset, inflateOutputBufferLength);
                }
                catch (DataFormatException e) {
                    throw new IOException(e);
                }
                ((Buffer)outputBuffer).position(inflateOutputBufferOffset + bytesInflated);
                this.decompressorOutBytes += (long)bytesInflated;
                if (this.decompressor.needsInput()) break;
                int increasedBufferSize = outputBuffer.capacity() * 2;
                ByteBuffer increasedOutputBuffer = ByteBuffer.allocate(increasedBufferSize);
                ((Buffer)outputBuffer).flip();
                increasedOutputBuffer.put(outputBuffer);
                outputBuffer = increasedOutputBuffer;
            }
            if (bytesInflated == 0) {
                return null;
            }
            this.maxInputOutput = Math.max(outputBuffer.position(), this.maxInputOutput);
            return outputBuffer;
        }

        @Override
        public Stats getStats() {
            return new Stats(this);
        }

        @Override
        public String getFilterName() {
            return "Compression (zlib)";
        }
    }

    public static final class Stats {
        public final long compressorInBytes;
        public final long compressorOutBytes;
        public final double compressionRatio;
        public final long decompressorInBytes;
        public final long decompressorOutBytes;
        public final double decompressionRatio;
        public final int maxOutputOutput;
        public final int maxInputOutput;
        public final int maxBytesWrittenAfterFullFlush;
        private transient String toStringCache;

        private Stats(ZlibXmppInputOutputFilter filter) {
            this.compressorOutBytes = filter.compressorOutBytes;
            this.compressorInBytes = filter.compressorInBytes;
            this.compressionRatio = (double)this.compressorOutBytes / (double)this.compressorInBytes;
            this.decompressorOutBytes = filter.decompressorOutBytes;
            this.decompressorInBytes = filter.decompressorInBytes;
            this.decompressionRatio = (double)this.decompressorInBytes / (double)this.decompressorOutBytes;
            this.maxOutputOutput = filter.maxOutputOutput;
            this.maxInputOutput = filter.maxInputOutput;
            this.maxBytesWrittenAfterFullFlush = filter.maxBytesWrittenAfterFullFlush;
        }

        public String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "compressor-in-bytes: " + this.compressorInBytes + "\ncompressor-out-bytes: " + this.compressorOutBytes + "\ncompression-ratio: " + this.compressionRatio + "\ndecompressor-in-bytes: " + this.decompressorInBytes + "\ndecompressor-out-bytes: " + this.decompressorOutBytes + "\ndecompression-ratio: " + this.decompressionRatio + "\nmax-output-output: " + this.maxOutputOutput + "\nmax-input-output: " + this.maxInputOutput + "\nmax-bytes-written-after-full-flush: " + this.maxBytesWrittenAfterFullFlush + "\n";
            return this.toStringCache;
        }
    }
}

