/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.apache.bzip2;

import org.bouncycastle.util.Integers;

class CRC {
    private static final int[] CRC32_TABLE = new int[]{0, -1222786812, 1849393673, -651803891, -596245485, 1802224919, -1303542246, 89147166, -1192425434, 267438370, -690582993, 1640713003, 1687882805, -746140367, 178294332, -1111666888, 1893405004, -943271864, 518034245, -1443016127, -1397942945, 464573531, -1030318250, 1972065874, -935978646, 2133579886, -1509057693, 286284391, 339746169, -1554129795, 2054922096, -848929164, -524934248, 1470882460, -1903320687, 965763221, 1019225995, -1948391793, 1392223618, -437885818, 1482369982, -280565062, 912304567, -2122487629, -2077413459, 858844841, -367612508, 1561029792, -1871891756, 661713872, -27873059, 1229681113, 1276851911, -83429437, 572568782, -1791134262, 679492338, -1617036298, 1186707707, -240748033, -185188639, 1139539941, -1697792792, 768638444, 2003863092, -1066580176, 424346685, -1370045127, -1425636825, 471548707, -985858002, 1914749226, -811758062, 2021674774, -1582953445, 381406495, 334203393, -1527362811, 2110785544, -892483316, 128685944, -1330227588, 1771050353, -561130379, -606235797, 1824543343, -1243213470, 50057318, -1085890722, 140205658, -780329641, 1717623891, 1664129869, -735225271, 218831172, -1172907968, -1748589140, 551249064, -100849755, 1323361953, 1269866943, -55746373, 629875638, -1835605326, 791391626, -1741263730, 1091579779, -166859129, -211965543, 1145071773, -1654248560, 712764052, -417483552, 1342207460, -1993984279, 1044117485, 996913395, -1938394633, 1431319290, -498207746, 1609612486, -387088958, 835403471, -2032730165, -2088322859, 882604497, -306365732, 1520499672, -287306647, 1509805421, -2133094816, 935743332, 848693370, -2054436482, 1554877043, -340767881, 1443693647, -518994613, 943097414, -1892989118, -1971650468, 1030144344, -465534379, 1398621009, -1640293083, 690412577, -268394708, 1193106984, 1112348982, -179251150, 745970495, -1687463365, 651564291, -1848912889, 1223530250, -1026546, -90173168, 1304285204, -1801743591, 596005405, 240529393, -1186205963, 1617800696, -680497924, -769643550, 1698556646, -1139037717, 184969455, -1229248553, 27715283, -662657570, 1872585946, 1791828932, -573513024, 83272141, -1276419895, 2123185853, -913244231, 280411316, -1481933392, -1560593746, 367459242, -859785049, 2078112163, -966773093, 1904080799, -1470385006, 524711318, 437662344, -1391725684, 1949151361, -1020235387, -1718580643, 781011801, -139786156, 1085720912, 1172737614, -218411190, 735906887, -1665086141, 561873531, -1772076161, 1329987698, -128204426, -49576344, 1242974060, -1825569695, 606979429, -380921071, 1582717461, -2022696680, 812505116, 893230850, -2111807994, 1527127307, -333718513, 1369871159, -423931341, 1067258174, -2004824006, -1915709660, 986535456, -471132883, 1425462313, 2032576965, -834967359, 387787724, -1610552632, -1521439274, 307064018, -882167841, 2088169179, -1043619357, 1993760999, -1343216662, 418243310, 498968048, -1432328972, 1938171897, -996415747, 167622793, -1092585075, 1741044352, -790889596, -712262502, 1654029726, -1146077549, 212729751, -1324306257, 101544363, -550817114, 1748431778, 1835447484, -629443144, 56440501, -1270810703};
    private int value = 0;

    CRC() {
    }

    void initialise() {
        this.value = -1;
    }

    int getFinal() {
        return ~Integers.reverseBytes(this.value);
    }

    void update(int n) {
        this.value = this.value >>> 8 ^ CRC32_TABLE[(this.value ^ n) & 0xFF];
    }

    void updateRun(int n, int n2) {
        int n3 = n << 8 | n;
        int n4 = n3 << 16 | n3;
        do {
            this.value ^= n4;
            this.value = this.value >>> 8 ^ CRC32_TABLE[this.value & 0xFF];
            this.value = this.value >>> 8 ^ CRC32_TABLE[this.value & 0xFF];
            this.value = this.value >>> 8 ^ CRC32_TABLE[this.value & 0xFF];
            this.value = this.value >>> 8 ^ CRC32_TABLE[this.value & 0xFF];
        } while ((n2 -= 4) >= 4);
        switch (n2 & 3) {
            case 0: {
                break;
            }
            case 1: {
                this.update(n);
                break;
            }
            case 2: {
                this.update(n);
                this.update(n);
                break;
            }
            case 3: {
                this.update(n);
                this.update(n);
                this.update(n);
            }
        }
    }
}

