using System.Diagnostics.Contracts;

namespace Microsoft.Dafny;

/// <summary>
/// An AutoGeneratedExpression is simply a wrapper around an expression.  This expression tells the generation of hover text (in the Dafny IDE)
/// that the expression was no supplied directly in the program text and should therefore be ignored.  In other places, an AutoGeneratedExpression
/// is just a parenthesized expression, which means that it works just the like expression .E that it contains.
/// (Ironically, AutoGeneratedExpression, which is like the antithesis of concrete syntax, inherits from ConcreteSyntaxExpression, which perhaps
/// should rather have been called SemanticsNeutralExpressionWrapper.)
/// </summary>
// TODO replace this with AutoGeneratedToken.
public class AutoGeneratedExpression : ParensExpression, ICloneable<AutoGeneratedExpression> {
  public AutoGeneratedExpression(IOrigin origin, Expression e)
    : base(origin, e) {
    Contract.Requires(origin != null);
    Contract.Requires(e != null);
  }

  public new AutoGeneratedExpression Clone(Cloner cloner) {
    return new AutoGeneratedExpression(cloner, this);
  }

  public AutoGeneratedExpression(Cloner cloner, AutoGeneratedExpression original) : base(cloner, original) {
  }

  /// <summary>
  /// This maker method takes a resolved expression "e" and wraps a resolved AutoGeneratedExpression
  /// around it.
  /// </summary>
  public static AutoGeneratedExpression Create(Expression e, IOrigin token = null) {
    Contract.Requires(e != null);
    var a = new AutoGeneratedExpression(token ?? e.Origin, e);
    a.type = e.Type;
    a.ResolvedExpression = e;
    return a;
  }
}