/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GUI_SCREENS_H
#define __GUI_SCREENS_H

#include "globals.h"
#include "gui.h"
#include "SDL.h"
#include "SDL_image.h"
#include "SDL_net.h"
#include "coord.h"
#include "game_client.h"
#include "game_server.h"
#include "gfx.h"
#include "gfx_functions.h"
#include "monitor_queue.h"
#include "mosaic.h"
#include "config.h"

class connect_screen;
class host_screen;
class numpl_screen;
class options_screen;
class bind_screen;
class confirm_quit_screen;

class main_screen : public gui_screen
{
 protected:
  static const char *button_files[4][3];
  SDL_Surface *button_gfx[4][3];

 public:
  main_screen(SDL_Surface *scr, TTF_Font *font, gfx *graphix, starfield_efect *se, audio *aud, config *cfg);
  virtual ~main_screen();

  virtual void activate(int signum);



 protected:
  numpl_screen *ns;
  options_screen *opts;
  confirm_quit_screen *qs;
  SDL_Surface *logogfx;

  gui_button  *qbtn;
};

class connect_screen : public gui_screen
{
 public:
  connect_screen(SDL_Surface *scr, TTF_Font *font, gfx *graphix, starfield_efect *se, audio *aud, config *cfg);
  virtual ~connect_screen();

  virtual void activate(int signum);

  static void start_game(gui_screen *this_scr);



 protected:
  static const char *imgtext_files[4];
  SDL_Surface *imgtext_gfx[4];

  static const char *button_files[][3];
  SDL_Surface *button_gfx[1][3];

  gui_editbox * namebox;
  gui_editbox * serverbox;
  gui_editbox * portbox;

  gui_image *pl2img;
  gui_editbox *namebox2;
  
  int numlocal_pl;
};

class host_screen : public gui_screen
{
 public:
  host_screen(SDL_Surface *scr, TTF_Font *font, gfx *graphix, starfield_efect *se, audio *aud, config *cfg);
  virtual ~host_screen();

  virtual void activate(int signum);

  static void start_game(gui_screen *this_scr);

 protected:
  static const char *imgtext_files[6];
  SDL_Surface *imgtext_gfx[6];

  static const char *button_files[][3];
  SDL_Surface *button_gfx[1][3];

  gui_image *pl2img;
  gui_editbox *namebox2;
  gui_editbox * namebox;
  gui_editbox * portbox;
  gui_numchooser * num_plchooser;
  gui_numchooser * num_castchooser;
  gui_numchooser * num_winschooser;
  int numlocal_pl;
};

int serv_starter (void *data);


class numpl_screen : public gui_screen
{
 public:
  numpl_screen(SDL_Surface *scr, TTF_Font *font, gfx *graphix, starfield_efect *se, audio *aud, config *cfg);
  virtual ~numpl_screen();

  virtual void activate(int signum);

  enum next_scr { next_connect = 1, next_host };
 protected:
  static const char *imgtext_files[1];
  SDL_Surface *imgtext_gfx[1];

  static const char *button_files[][3];
  SDL_Surface *button_gfx[2][3];

  connect_screen *ls;
  host_screen *hs;

  gui_button *b1, *b2;
};

class options_screen : public gui_screen
{
  public:
    options_screen( SDL_Surface *scr, TTF_Font *font, gfx *graphix, starfield_efect *se, audio *aud, config *cfg );
    virtual ~options_screen();

    virtual void activate( int signum );
    static void apply_cb( gui_screen *scr );
    static void cancel_cb( gui_screen *scr );

  protected:
    /*
     *     static const char *imgtext_files[2];
     *         SDL_Surface *imgtext_gfx[2];
     *             */
    static const char *button_files[][3];
    SDL_Surface *button_gfx[2][3];

    gui_textbutton  *keybtns[config::MAX_LOCAL_PLAYERS][config::_NUM_KEYS];

    gui_button  *apply, *cancel;
    bind_screen *bs;
    config        localconf;
};

class bind_screen : public gui_screen
{
  public:
    bind_screen( SDL_Surface *scr, TTF_Font *font, gfx *graphix, starfield_efect *se, audio *aud, config *cfg );
    virtual ~bind_screen();

    virtual void activate( int signum );

    bool did_bind() { return ( really_bound ); }
    int get_bound_pl() { return ( bound_pl ); }
    int get_bound_action() { return ( bound_action ); }
    int get_action_value() { return ( action_value ); }

  protected:
    string        bannertext;
    gui_textbox   *banner;
    bool          really_bound;
    int           bound_pl;
    int           bound_action;
    int           action_value;
};

class confirm_quit_screen : public gui_screen
{
  public:
    confirm_quit_screen( SDL_Surface *scr, TTF_Font *fnt, gfx *graphics, starfield_efect *se, audio *au, config *cfg );
    virtual void  activate( int signum );
    static void   yes_cb( gui_screen *gs );
    static void   no_cb( gui_screen *gs );
    void set_quit( bool quit )
    { this->quit = quit; }

  private:
    bool      quit;
};

#endif
