/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __GAME_SERVER_H
#define __GAME_SERVER_H

#include "SDL.h"
#include "SDL_net.h"
#include "SDL_thread.h"
#include "monitor_queue.h"
#include "msg.h"
#include "player.h"
#include <string>
#include <typeinfo>
#include "terrain.h"
#include "coord.h"
#include "connects.h"

using namespace std;

#define ACCEPT_YIELDWAIT 100

// Muuttaa SDL_Colorin int-tyyppiin
#define ColorToInt(c) ((int) ((((((((c).r&0xFF)<<8)|((c).g&0xFF))<<8)|((c).b&0xFF))<<8)|((c).unused&0xFF)))

class game_server
{
 public:
  game_server(IPaddress _ip, int num_castles, int _wins) throw (string &);
  ~game_server();
  void init_net();
  // PreCond: init_net() executed!
  void start_game();
  int no_players() const;
  int no_alive_players() const;
  int no_ready_connections() const;
  int no_connections() const;
  void probe_disconnected_players();
  int get_mode() const;
  void shutdown_server();
  // PreCond: init_net() not executed!
  void add_local_connects(vector<string> &pl_names, monitor_queue<msg *> *in, monitor_queue<msg *> *out);

  enum game_state {
	ID_MODE_NOTACTIVE = 0,
	ID_MODE_PLACEC,
	ID_MODE_SHOOT,
	ID_MODE_REPAIR,
	ID_MODE_ENDR,
	ID_MODE_CSELECT,
	ID_MODE_CHSELECT,
	ID_MODE_ENDGAME,
	ID_MODE_SHUTTING_DOWN
  };
  enum character {
    ROCMAN=0,
    ANUZ,
    FIREMAN,
    DOD,
    NOONE
  };

  SDL_sem *d_smp;

 protected:
  void clear_connection_readys();
  void mode_place_cannons();
  void mode_character_select();
  void mode_castle_select();
  void main_gameloop();
  void mode_shooting();
  void mode_repair();
  void mode_end_round();
  void mode_end_game();
  int add_player(const string &name, connects *c);
  bool remove_player (int index);
  void process_chooser_req(int owner, bool down);
  void assign_default_castles();
  void process_choose_character(int owner, const coord &place, int ch);
  void process_chooser_lock (int player_index);
  void process_place_cannon (int owner, const coord &place);
  void process_change_cannon(int owner);
  void process_place_big_cannon (int owner, const coord &place);
  void build_default_walls();
  void dispatch_playerinfo();
  void process_shoot(const coord &c, int owner, int ammosize);
  void process_place_block (int owner, int next_block, int next_orientation);
  static int connection_accepter (void *data);
  void data_transfer();
  void remove_connect(connects *c);

  vector<connects *> conns;
  TCPsocket ssocket;
  player players[MAX_PLAYERS];
  IPaddress ip;
  terrain *terra;
  int castles_placed;
  int character_selected;
  //int charactes[MAX_PLAYERS];
  int cannons_to_place[MAX_PLAYERS];
  int big_cannons_to_place[MAX_PLAYERS];
  block block_placers[MAX_PLAYERS];
  coord home_castles[MAX_PLAYERS];
  SDL_sem *pl_arr_smp;
  SDL_sem *con_smp;


  int num_castles;
  bool game_on;
  int wins;
  int round;
  SDL_Thread* con_th;
  monitor_queue<msg *> output_queue;
  int mode;
  bool game_won;
};


#endif
