#ifndef __CONNECTS_H__
#define __CONNECTS_H__

#include <map>
#include <cassert>
#include <cstdio>
#include "SDL.h"
#include "SDL_net.h"
#include "globals.h"
#include "msg.h"
#include "monitor_queue.h"

class connects
{
 public:
  connects();
  virtual ~connects();
  
  virtual bool has_msgs() const throw (string &) = 0;
  virtual msg *receive() throw (string &) = 0;
  virtual void send (msg *m) throw (string &) = 0;

  virtual void remove_player(int pindex);
  virtual int num_players() const;
  virtual bool includes_player(int pindex);
  virtual const vector<int> & get_player_indices();
  virtual void set_ready(bool read);
  virtual bool is_ready() const;
  virtual void add_player (int pindex);

 protected:
  bool ready_to_change;
  vector<int> pindices;
};

class tcp_connects : public connects
{
 public:
  tcp_connects(TCPsocket s) throw (string &);
  tcp_connects(const tcp_connects &c);
  ~tcp_connects();

  void send (msg *m) throw (string &);
  bool has_msgs() const throw (string &);
  msg* receive() throw (string &);

 protected:
  TCPsocket sock;
  SDLNet_SocketSet sockset;
};

class local_connects : public connects
{
 public:
  local_connects(monitor_queue<msg *> *in, monitor_queue<msg *> *out) throw (string &);
  ~local_connects();

  void send (msg *m) throw (string &);
  bool has_msgs() const throw (string &);
  msg* receive() throw (string &);

 protected:
  monitor_queue<msg *> *in;
  monitor_queue<msg *> *out;
};

#endif
