/*
 * GQradio
 * (C) 2005 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "intl.h"

/*
 *-------------------------------------
 * Standard library includes
 *-------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

/*
 *-------------------------------------
 * includes for glib / gtk / etc.
 *-------------------------------------
 */

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

/*
 *----------------------------------------------------------------------------
 * defines
 *----------------------------------------------------------------------------
 */

#define		GQRADIO_RC_DIR		".gqradio"
#define		GQRADIO_RC_DIR_SKIN	".gqradio/skins"

#define		GQRADIO_RC		"gqradiorc"

#define		GQRADIO_PRESET_FILE	"presets.gqmpeg"

#define		PATH_HISTORY_NAME	"history"
#define		RC_STATES_NAME		"window_states"

#define		GQRADIO_SLIK_HELP_PATH	GQRADIO_SKINDIR"/SKIN-SPECS"

typedef enum {
	SEEK_MODE_MANUAL = 0,
	SEEK_MODE_PRESET,
	SEEK_MODE_AUTO
} SeekMode;

#include "ui2_typedefs.h"

/*
 *----------------------------------------------------------------------------
 * globals
 *----------------------------------------------------------------------------
 */

	/* main window widgets */
extern UIData *main_window;

extern gint wm_decorations;

extern gchar *skin_default_path;
extern gchar *skin_mode_key;

extern guint32 frequency;
extern guint32 freq_step;

extern gint muted;
extern gint stereo;
extern gint signal_strength;

extern gint preset;

extern SeekMode seek_mode;

extern gint description_scrolls_always;
extern gint skinned_menus_enable;

extern gchar *mixer_command;
extern gint mixer_device_id;

extern gchar *radio_custom_device;

extern const gchar **gqradio_logo_xpm;

extern gint auto_seek_nomute;

/*
 * =========================== main.c
 */

void show_about(void);
void help_window_show(const gchar *key);

void gqradio_exit(gint mute);

/*
 * =========================== gqradio.c
 */

void main_loop_init(void);

void seek_to_freq(guint32 freq);
void seek_increment(guint32 step, gint direction_up);
void seek_start(gint direction_up);
void seek_start_by_mode(SeekMode mode, gint direction_up);
void seek_stop(void);

void mute_set(gint set);
void mute_toggle(void);
void mode_set(SeekMode mode);
void mode_toggle(void);

void preset_select(gint p);
void preset_next(void);
void preset_prev(void);
void preset_button_click(void);
void preset_cancel(void);
gint preset_mode_get(void);
void preset_clear_one(gint p);
void preset_clear_all(void);

void preset_auto_scan_click(void);

void volume_adjust(float pos);
void btn_volume_up_pressed(void);
void btn_volume_down_pressed(void);
void btn_volume_released(void);

void balance_adjust(float pos);
void btn_balance_left_pressed(void);
void btn_balance_right_pressed(void);
void btn_balance_released(void);

void mixer_run(void);

