// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudasset provides access to the Cloud Asset API.
//
// For product documentation, see: https://cloud.google.com/asset-inventory/docs/quickstart
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/cloudasset/v1"
//   ...
//   ctx := context.Background()
//   cloudassetService, err := cloudasset.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   cloudassetService, err := cloudasset.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   cloudassetService, err := cloudasset.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package cloudasset // import "google.golang.org/api/cloudasset/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "cloudasset:v1"
const apiName = "cloudasset"
const apiVersion = "v1"
const basePath = "https://cloudasset.googleapis.com/"
const mtlsBasePath = "https://cloudasset.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your data across Google Cloud Platform services
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Feeds = NewFeedsService(s)
	s.Operations = NewOperationsService(s)
	s.V1 = NewV1Service(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Feeds *FeedsService

	Operations *OperationsService

	V1 *V1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewFeedsService(s *Service) *FeedsService {
	rs := &FeedsService{s: s}
	return rs
}

type FeedsService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewV1Service(s *Service) *V1Service {
	rs := &V1Service{s: s}
	return rs
}

type V1Service struct {
	s *Service
}

// AccessSelector: Specifies roles and/or permissions to analyze, to
// determine both the identities possessing them and the resources they
// control. If multiple values are specified, results will include roles
// or permissions matching any of them. The total number of roles and
// permissions should be equal or less than 10.
type AccessSelector struct {
	// Permissions: Optional. The permissions to appear in result.
	Permissions []string `json:"permissions,omitempty"`

	// Roles: Optional. The roles to appear in result.
	Roles []string `json:"roles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AccessSelector) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnalyzeIamPolicyLongrunningRequest: A request message for
// AssetService.AnalyzeIamPolicyLongrunning.
type AnalyzeIamPolicyLongrunningRequest struct {
	// AnalysisQuery: Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `json:"analysisQuery,omitempty"`

	// OutputConfig: Required. Output configuration indicating where the
	// results will be output to.
	OutputConfig *IamPolicyAnalysisOutputConfig `json:"outputConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisQuery") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AnalyzeIamPolicyLongrunningRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeIamPolicyLongrunningRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AnalyzeIamPolicyResponse: A response message for
// AssetService.AnalyzeIamPolicy.
type AnalyzeIamPolicyResponse struct {
	// FullyExplored: Represents whether all entries in the main_analysis
	// and service_account_impersonation_analysis have been fully explored
	// to answer the query in the request.
	FullyExplored bool `json:"fullyExplored,omitempty"`

	// MainAnalysis: The main analysis that matches the original request.
	MainAnalysis *IamPolicyAnalysis `json:"mainAnalysis,omitempty"`

	// ServiceAccountImpersonationAnalysis: The service account
	// impersonation analysis if
	// AnalyzeIamPolicyRequest.analyze_service_account_impersonation is
	// enabled.
	ServiceAccountImpersonationAnalysis []*IamPolicyAnalysis `json:"serviceAccountImpersonationAnalysis,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FullyExplored") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullyExplored") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *AnalyzeIamPolicyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeIamPolicyResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Asset: An asset in Google Cloud. An asset can be any resource in the
// Google Cloud resource hierarchy
// (https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
// a resource outside the Google Cloud resource hierarchy (such as
// Google Kubernetes Engine clusters and objects), or a policy (e.g.
// Cloud IAM policy). See Supported asset types
// (https://cloud.google.com/asset-inventory/docs/supported-asset-types)
// for more information.
type Asset struct {
	// AccessLevel: Please also refer to the access level user guide
	// (https://cloud.google.com/access-context-manager/docs/overview#access-levels).
	AccessLevel *GoogleIdentityAccesscontextmanagerV1AccessLevel `json:"accessLevel,omitempty"`

	// AccessPolicy: Please also refer to the access policy user guide
	// (https://cloud.google.com/access-context-manager/docs/overview#access-policies).
	AccessPolicy *GoogleIdentityAccesscontextmanagerV1AccessPolicy `json:"accessPolicy,omitempty"`

	// Ancestors: The ancestry path of an asset in Google Cloud resource
	// hierarchy
	// (https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
	// represented as a list of relative resource names. An ancestry path
	// starts with the closest ancestor in the hierarchy and ends at root.
	// If the asset is a project, folder, or organization, the ancestry path
	// starts from the asset itself. Example: `["projects/123456789",
	// "folders/5432", "organizations/1234"]`
	Ancestors []string `json:"ancestors,omitempty"`

	// AssetType: The type of the asset. Example:
	// `compute.googleapis.com/Disk` See Supported asset types
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for more information.
	AssetType string `json:"assetType,omitempty"`

	// IamPolicy: A representation of the Cloud IAM policy set on a Google
	// Cloud resource. There can be a maximum of one Cloud IAM policy set on
	// any given resource. In addition, Cloud IAM policies inherit their
	// granted access scope from any policies set on parent resources in the
	// resource hierarchy. Therefore, the effectively policy is the union of
	// both the policy set on this resource and each policy set on all of
	// the resource's ancestry resource levels in the hierarchy. See this
	// topic (https://cloud.google.com/iam/docs/policies#inheritance) for
	// more information.
	IamPolicy *Policy `json:"iamPolicy,omitempty"`

	// Name: The full name of the asset. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instance
	// s/instance1` See Resource names
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	Name string `json:"name,omitempty"`

	// OrgPolicy: A representation of an organization policy
	// (https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
	// There can be more than one organization policy with different
	// constraints set on a given resource.
	OrgPolicy []*GoogleCloudOrgpolicyV1Policy `json:"orgPolicy,omitempty"`

	// OsInventory: A representation of runtime OS Inventory information.
	// See this topic
	// (https://cloud.google.com/compute/docs/instances/os-inventory-management)
	// for more information.
	OsInventory *Inventory `json:"osInventory,omitempty"`

	// Resource: A representation of the resource.
	Resource *Resource `json:"resource,omitempty"`

	// ServicePerimeter: Please also refer to the service perimeter user
	// guide (https://cloud.google.com/vpc-service-controls/docs/overview).
	ServicePerimeter *GoogleIdentityAccesscontextmanagerV1ServicePerimeter `json:"servicePerimeter,omitempty"`

	// UpdateTime: The last update timestamp of an asset. update_time is
	// updated when create/update/delete operation is performed.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessLevel") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessLevel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Asset) MarshalJSON() ([]byte, error) {
	type NoMethod Asset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must
// have one or more AuditLogConfigs. If there are AuditConfigs for both
// `allServices` and a specific service, the union of the two
// AuditConfigs is used for that service: the log_types specified in
// each AuditConfig are enabled, and the exempted_members in each
// AuditLogConfig are exempted. Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// jose@example.com from DATA_READ logging, and aliya@example.com from
// DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BatchGetAssetsHistoryResponse: Batch get assets history response.
type BatchGetAssetsHistoryResponse struct {
	// Assets: A list of assets with valid time windows.
	Assets []*TemporalAsset `json:"assets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Assets") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assets") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BatchGetAssetsHistoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BatchGetAssetsHistoryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BigQueryDestination: A BigQuery destination for exporting assets to.
type BigQueryDestination struct {
	// Dataset: Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call
	// returns an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`

	// Force: If the destination table already exists and this flag is
	// `TRUE`, the table will be overwritten by the contents of assets
	// snapshot. If the flag is `FALSE` or unset and the destination table
	// already exists, the export call returns an INVALID_ARGUMEMT error.
	Force bool `json:"force,omitempty"`

	// PartitionSpec: [partition_spec] determines whether to export to
	// partitioned table(s) and how to partition the data. If
	// [partition_spec] is unset or [partition_spec.partition_key] is unset
	// or `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported
	// to non-partitioned table(s). [force] will decide whether to overwrite
	// existing table(s). If [partition_spec] is specified. First, the
	// snapshot results will be written to partitioned table(s) with two
	// additional timestamp columns, readTime and requestTime, one of which
	// will be the partition key. Secondly, in the case when any destination
	// table already exists, it will first try to update existing table's
	// schema as necessary by appending additional columns. Then, if [force]
	// is `TRUE`, the corresponding partition will be overwritten by the
	// snapshot results (data in different partitions will remain intact);
	// if [force] is unset or `FALSE`, it will append the data. An error
	// will be returned if the schema update or data appension fails.
	PartitionSpec *PartitionSpec `json:"partitionSpec,omitempty"`

	// SeparateTablesPerAssetType: If this flag is `TRUE`, the snapshot
	// results will be written to one or multiple tables, each of which
	// contains results of one asset type. The [force] and [partition_spec]
	// fields will apply to each of them. Field [table] will be concatenated
	// with "_" and the asset type names (see
	// https://cloud.google.com/asset-inventory/docs/supported-asset-types
	// for supported asset types) to construct per-asset-type table names,
	// in which all non-alphanumeric characters like "." and "/" will be
	// substituted by "_". Example: if field [table] is "mytable" and
	// snapshot results contain "storage.googleapis.com/Bucket" assets, the
	// corresponding table name will be
	// "mytable_storage_googleapis_com_Bucket". If any of these tables does
	// not exist, a new table with the concatenated name will be created.
	// When [content_type] in the ExportAssetsRequest is `RESOURCE`, the
	// schema of each table will include RECORD-type columns mapped to the
	// nested fields in the Asset.resource.data field of that asset type (up
	// to the 15 nested level BigQuery supports
	// (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)).
	// The fields in >15 nested levels will be stored in JSON format string
	// as a child column of its parent RECORD column. If error occurs when
	// exporting to any table, the whole export call will return an error
	// but the export results that already succeed will persist. Example: if
	// exporting to table_type_A succeeds when exporting to table_type_B
	// fails during one export call, the results in table_type_A will
	// persist and there will not be partial results persisting in a table.
	SeparateTablesPerAssetType bool `json:"separateTablesPerAssetType,omitempty"`

	// Table: Required. The BigQuery table to which the snapshot result
	// should be written. If this table does not exist, a new table with the
	// given name will be created.
	Table string `json:"table,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members` with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the members
	// in this binding. To learn which resources support conditions in their
	// IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`

	// Members: Specifies the identities requesting access for a Cloud
	// Platform resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. *
	// `user:{emailid}`: An email address that represents a specific Google
	// account. For example, `alice@example.com` . *
	// `serviceAccount:{emailid}`: An email address that represents a
	// service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An
	// email address that represents a Google group. For example,
	// `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An
	// email address (plus unique identifier) representing a user that has
	// been recently deleted. For example,
	// `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered
	// user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding. * `domain:{domain}`: The G
	// Suite domain (primary) that represents all the users of that domain.
	// For example, `google.com` or `example.com`.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to `members`. For example,
	// `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateFeedRequest: Create asset feed request.
type CreateFeedRequest struct {
	// Feed: Required. The feed details. The field `name` must be empty and
	// it will be generated in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed *Feed `json:"feed,omitempty"`

	// FeedId: Required. This is the client-assigned asset feed identifier
	// and it needs to be unique under a specific parent
	// project/folder/organization.
	FeedId string `json:"feedId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Feed") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Feed") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateFeedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateFeedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); } The JSON representation for `Empty` is
// empty JSON object `{}`.
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// Explanation: Explanation about the IAM policy search result.
type Explanation struct {
	// MatchedPermissions: The map from roles to their included permissions
	// that match the permission query (i.e., a query containing
	// `policy.role.permissions:`). Example: if query
	// `policy.role.permissions:compute.disk.get` matches a policy binding
	// that contains owner role, the matched_permissions will be
	// `{"roles/owner": ["compute.disk.get"]}`. The roles can also be found
	// in the returned `policy` bindings. Note that the map is populated
	// only for requests with permission queries.
	MatchedPermissions map[string]Permissions `json:"matchedPermissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchedPermissions")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchedPermissions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Explanation) MarshalJSON() ([]byte, error) {
	type NoMethod Explanation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExportAssetsRequest: Export asset request.
type ExportAssetsRequest struct {
	// AssetTypes: A list of asset types to take a snapshot for. For
	// example: "compute.googleapis.com/Disk". Regular expressions are also
	// supported. For example: * "compute.googleapis.com.*" snapshots
	// resources whose asset type starts with "compute.googleapis.com". *
	// ".*Instance" snapshots resources whose asset type ends with
	// "Instance". * ".*Instance.*" snapshots resources whose asset type
	// contains "Instance". See RE2
	// (https://github.com/google/re2/wiki/Syntax) for all supported regular
	// expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned. If
	// specified, only matching assets will be returned, otherwise, it will
	// snapshot all asset types. See Introduction to Cloud Asset Inventory
	// (https://cloud.google.com/asset-inventory/docs/overview) for all
	// supported asset types.
	AssetTypes []string `json:"assetTypes,omitempty"`

	// ContentType: Asset content type. If not specified, no content but the
	// asset name will be returned.
	//
	// Possible values:
	//   "CONTENT_TYPE_UNSPECIFIED" - Unspecified content type.
	//   "RESOURCE" - Resource metadata.
	//   "IAM_POLICY" - The actual IAM policy set on a resource.
	//   "ORG_POLICY" - The Cloud Organization Policy set on an asset.
	//   "ACCESS_POLICY" - The Cloud Access context manager Policy set on an
	// asset.
	//   "OS_INVENTORY" - The runtime OS Inventory information.
	ContentType string `json:"contentType,omitempty"`

	// OutputConfig: Required. Output configuration indicating where the
	// results will be output to.
	OutputConfig *OutputConfig `json:"outputConfig,omitempty"`

	// ReadTime: Timestamp to take an asset snapshot. This can only be set
	// to a timestamp between the current time and the current time minus 35
	// days (inclusive). If not specified, the current time will be used.
	// Due to delays in resource data collection and indexing, there is a
	// volatile window during which running the same query may get different
	// results.
	ReadTime string `json:"readTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetTypes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExportAssetsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExportAssetsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The
// syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Feed: An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported. The asset
// feed must be created within a project, organization, or folder.
// Supported destinations are: Pub/Sub topics.
type Feed struct {
	// AssetNames: A list of the full names of the assets to receive
	// updates. You must specify either or both of asset_names and
	// asset_types. Only asset updates matching specified asset_names or
	// asset_types are exported to the feed. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instance
	// s/instance1`. See Resource Names
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more info.
	AssetNames []string `json:"assetNames,omitempty"`

	// AssetTypes: A list of types of the assets to receive updates. You
	// must specify either or both of asset_names and asset_types. Only
	// asset updates matching specified asset_names or asset_types are
	// exported to the feed. Example: "compute.googleapis.com/Disk" See
	// this topic
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for a list of all supported asset types.
	AssetTypes []string `json:"assetTypes,omitempty"`

	// Condition: A condition which determines whether an asset update
	// should be published. If specified, an asset will be returned only
	// when the expression evaluates to true. When set, `expression` field
	// in the `Expr` must be a valid [CEL expression]
	// (https://github.com/google/cel-spec) on a TemporalAsset with name
	// `temporal_asset`. Example: a Feed with expression
	// ("temporal_asset.deleted == true") will only publish Asset deletions.
	// Other fields of `Expr` are optional. See our user guide
	// (https://cloud.google.com/asset-inventory/docs/monitoring-asset-changes#feed_with_condition)
	// for detailed instructions.
	Condition *Expr `json:"condition,omitempty"`

	// ContentType: Asset content type. If not specified, no content but the
	// asset name and type will be returned.
	//
	// Possible values:
	//   "CONTENT_TYPE_UNSPECIFIED" - Unspecified content type.
	//   "RESOURCE" - Resource metadata.
	//   "IAM_POLICY" - The actual IAM policy set on a resource.
	//   "ORG_POLICY" - The Cloud Organization Policy set on an asset.
	//   "ACCESS_POLICY" - The Cloud Access context manager Policy set on an
	// asset.
	//   "OS_INVENTORY" - The runtime OS Inventory information.
	ContentType string `json:"contentType,omitempty"`

	// FeedOutputConfig: Required. Feed output configuration defining where
	// the asset updates are published to.
	FeedOutputConfig *FeedOutputConfig `json:"feedOutputConfig,omitempty"`

	// Name: Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identi
	// fier} The client-assigned feed identifier must be unique within the
	// parent project/folder/organization.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AssetNames") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetNames") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Feed) MarshalJSON() ([]byte, error) {
	type NoMethod Feed
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FeedOutputConfig: Output configuration for asset feed destination.
type FeedOutputConfig struct {
	// PubsubDestination: Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `json:"pubsubDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PubsubDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PubsubDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *FeedOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FeedOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GcsDestination: A Cloud Storage location.
type GcsDestination struct {
	// Uri: The uri of the Cloud Storage object. It's the same uri that is
	// used by gsutil. Example: "gs://bucket_name/object_name". See Viewing
	// and Editing Object Metadata
	// (https://cloud.google.com/storage/docs/viewing-editing-metadata) for
	// more information.
	Uri string `json:"uri,omitempty"`

	// UriPrefix: The uri prefix of all generated Cloud Storage objects.
	// Example: "gs://bucket_name/object_name_prefix". Each object uri is in
	// format: "gs://bucket_name/object_name_prefix// and only contains
	// assets for that type. starts from 0. Example:
	// "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0"
	// is the first shard of output objects containing all
	// compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
	// returned if file with the same name
	// "gs://bucket_name/object_name_prefix" already exists.
	UriPrefix string `json:"uriPrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GcsDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1Access: An IAM role or permission under analysis.
type GoogleCloudAssetV1Access struct {
	// AnalysisState: The analysis state of this access.
	AnalysisState *IamPolicyAnalysisState `json:"analysisState,omitempty"`

	// Permission: The permission.
	Permission string `json:"permission,omitempty"`

	// Role: The role.
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisState") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1Access) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1Access
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1AccessControlList: An access control list, derived
// from the above IAM policy binding, which contains a set of resources
// and accesses. May include one item from each set to compose an access
// control entry. NOTICE that there could be multiple access control
// lists for one IAM policy binding. The access control lists are
// created based on resource and access combinations. For example,
// assume we have the following cases in one IAM policy binding: -
// Permission P1 and P2 apply to resource R1 and R2; - Permission P3
// applies to resource R2 and R3; This will result in the following
// access control lists: - AccessControlList 1: [R1, R2], [P1, P2] -
// AccessControlList 2: [R2, R3], [P3]
type GoogleCloudAssetV1AccessControlList struct {
	// Accesses: The accesses that match one of the following conditions: -
	// The access_selector, if it is specified in request; - Otherwise,
	// access specifiers reachable from the policy binding's role.
	Accesses []*GoogleCloudAssetV1Access `json:"accesses,omitempty"`

	// ResourceEdges: Resource edges of the graph starting from the policy
	// attached resource to any descendant resources. The Edge.source_node
	// contains the full resource name of a parent resource and
	// Edge.target_node contains the full resource name of a child resource.
	// This field is present only if the output_resource_edges option is
	// enabled in request.
	ResourceEdges []*GoogleCloudAssetV1Edge `json:"resourceEdges,omitempty"`

	// Resources: The resources that match one of the following conditions:
	// - The resource_selector, if it is specified in request; - Otherwise,
	// resources reachable from the policy attached resource.
	Resources []*GoogleCloudAssetV1Resource `json:"resources,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Accesses") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Accesses") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1AccessControlList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1AccessControlList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1BigQueryDestination: A BigQuery destination.
type GoogleCloudAssetV1BigQueryDestination struct {
	// Dataset: Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the analysis
	// results should be exported. If this dataset does not exist, the
	// export call will return an INVALID_ARGUMENT error.
	Dataset string `json:"dataset,omitempty"`

	// PartitionKey: The partition key for BigQuery partitioned table.
	//
	// Possible values:
	//   "PARTITION_KEY_UNSPECIFIED" - Unspecified partition key. Tables
	// won't be partitioned using this option.
	//   "REQUEST_TIME" - The time when the request is received. If
	// specified as partition key, the result table(s) is partitoned by the
	// RequestTime column, an additional timestamp column representing when
	// the request was received.
	PartitionKey string `json:"partitionKey,omitempty"`

	// TablePrefix: Required. The prefix of the BigQuery tables to which the
	// analysis results will be written. Tables will be created based on
	// this table_prefix if not exist: * _analysis table will contain export
	// operation's metadata. * _analysis_result will contain all the
	// IamPolicyAnalysisResult. When [partition_key] is specified, both
	// tables will be partitioned based on the [partition_key].
	TablePrefix string `json:"tablePrefix,omitempty"`

	// WriteDisposition: Optional. Specifies the action that occurs if the
	// destination table or partition already exists. The following values
	// are supported: * WRITE_TRUNCATE: If the table or partition already
	// exists, BigQuery overwrites the entire table or all the partitions
	// data. * WRITE_APPEND: If the table or partition already exists,
	// BigQuery appends the data to the table or the latest partition. *
	// WRITE_EMPTY: If the table already exists and contains data, an error
	// is returned. The default value is WRITE_APPEND. Each action is atomic
	// and only occurs if BigQuery is able to complete the job successfully.
	// Details are at
	// https://cloud.google.com/bigquery/docs/loading-data-local#appending_to_or_overwriting_a_table_using_a_local_file.
	WriteDisposition string `json:"writeDisposition,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dataset") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dataset") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1BigQueryDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1BigQueryDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1Edge: A directional edge.
type GoogleCloudAssetV1Edge struct {
	// SourceNode: The source node of the edge. For example, it could be a
	// full resource name for a resource node or an email of an identity.
	SourceNode string `json:"sourceNode,omitempty"`

	// TargetNode: The target node of the edge. For example, it could be a
	// full resource name for a resource node or an email of an identity.
	TargetNode string `json:"targetNode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SourceNode") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SourceNode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1Edge) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1Edge
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1GcsDestination: A Cloud Storage location.
type GoogleCloudAssetV1GcsDestination struct {
	// Uri: Required. The uri of the Cloud Storage object. It's the same uri
	// that is used by gsutil. For example: "gs://bucket_name/object_name".
	// See [Quickstart: Using the gsutil tool]
	// (https://cloud.google.com/storage/docs/quickstart-gsutil) for
	// examples.
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Uri") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Uri") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1GcsDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1GcsDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1Identity: An identity under analysis.
type GoogleCloudAssetV1Identity struct {
	// AnalysisState: The analysis state of this identity.
	AnalysisState *IamPolicyAnalysisState `json:"analysisState,omitempty"`

	// Name: The identity name in any form of members appear in IAM policy
	// binding (https://cloud.google.com/iam/reference/rest/v1/Binding),
	// such as: - user:foo@google.com - group:group1@google.com -
	// serviceAccount:s1@prj1.iam.gserviceaccount.com -
	// projectOwner:some_project_id - domain:google.com - allUsers - etc.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisState") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1Identity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1Identity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1IdentityList: The identities and group edges.
type GoogleCloudAssetV1IdentityList struct {
	// GroupEdges: Group identity edges of the graph starting from the
	// binding's group members to any node of the identities. The
	// Edge.source_node contains a group, such as `group:parent@google.com`.
	// The Edge.target_node contains a member of the group, such as
	// `group:child@google.com` or `user:foo@google.com`. This field is
	// present only if the output_group_edges option is enabled in request.
	GroupEdges []*GoogleCloudAssetV1Edge `json:"groupEdges,omitempty"`

	// Identities: Only the identities that match one of the following
	// conditions will be presented: - The identity_selector, if it is
	// specified in request; - Otherwise, identities reachable from the
	// policy binding's members.
	Identities []*GoogleCloudAssetV1Identity `json:"identities,omitempty"`

	// ForceSendFields is a list of field names (e.g. "GroupEdges") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GroupEdges") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1IdentityList) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1IdentityList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudAssetV1Resource: A Google Cloud resource under analysis.
type GoogleCloudAssetV1Resource struct {
	// AnalysisState: The analysis state of this resource.
	AnalysisState *IamPolicyAnalysisState `json:"analysisState,omitempty"`

	// FullResourceName: The full resource name
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	FullResourceName string `json:"fullResourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisState") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisState") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudAssetV1Resource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudAssetV1Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV1BooleanPolicy: Used in `policy_type` to specify
// how `boolean_policy` will behave at this resource.
type GoogleCloudOrgpolicyV1BooleanPolicy struct {
	// Enforced: If `true`, then the `Policy` is enforced. If `false`, then
	// any configuration is acceptable. Suppose you have a `Constraint`
	// `constraints/compute.disableSerialPortAccess` with
	// `constraint_default` set to `ALLOW`. A `Policy` for that `Constraint`
	// exhibits the following behavior: - If the `Policy` at this resource
	// has enforced set to `false`, serial port connection attempts will be
	// allowed. - If the `Policy` at this resource has enforced set to
	// `true`, serial port connection attempts will be refused. - If the
	// `Policy` at this resource is `RestoreDefault`, serial port connection
	// attempts will be allowed. - If no `Policy` is set at this resource or
	// anywhere higher in the resource hierarchy, serial port connection
	// attempts will be allowed. - If no `Policy` is set at this resource,
	// but one exists higher in the resource hierarchy, the behavior is as
	// if the`Policy` were set at this resource. The following examples
	// demonstrate the different possible layerings: Example 1 (nearest
	// `Constraint` wins): `organizations/foo` has a `Policy` with:
	// {enforced: false} `projects/bar` has no `Policy` set. The constraint
	// at `projects/bar` and `organizations/foo` will not be enforced.
	// Example 2 (enforcement gets replaced): `organizations/foo` has a
	// `Policy` with: {enforced: false} `projects/bar` has a `Policy` with:
	// {enforced: true} The constraint at `organizations/foo` is not
	// enforced. The constraint at `projects/bar` is enforced. Example 3
	// (RestoreDefault): `organizations/foo` has a `Policy` with: {enforced:
	// true} `projects/bar` has a `Policy` with: {RestoreDefault: {}} The
	// constraint at `organizations/foo` is enforced. The constraint at
	// `projects/bar` is not enforced, because `constraint_default` for the
	// `Constraint` is `ALLOW`.
	Enforced bool `json:"enforced,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enforced") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enforced") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudOrgpolicyV1BooleanPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV1BooleanPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV1ListPolicy: Used in `policy_type` to specify
// how `list_policy` behaves at this resource. `ListPolicy` can define
// specific values and subtrees of Cloud Resource Manager resource
// hierarchy (`Organizations`, `Folders`, `Projects`) that are allowed
// or denied by setting the `allowed_values` and `denied_values` fields.
// This is achieved by using the `under:` and optional `is:` prefixes.
// The `under:` prefix is used to denote resource subtree values. The
// `is:` prefix is used to denote specific values, and is required only
// if the value contains a ":". Values prefixed with "is:" are treated
// the same as values with no prefix. Ancestry subtrees must be in one
// of the following formats: - "projects/", e.g.
// "projects/tokyo-rain-123" - "folders/", e.g. "folders/1234" -
// "organizations/", e.g. "organizations/1234" The `supports_under`
// field of the associated `Constraint` defines whether ancestry
// prefixes can be used. You can set `allowed_values` and
// `denied_values` in the same `Policy` if `all_values` is
// `ALL_VALUES_UNSPECIFIED`. `ALLOW` or `DENY` are used to allow or deny
// all values. If `all_values` is set to either `ALLOW` or `DENY`,
// `allowed_values` and `denied_values` must be unset.
type GoogleCloudOrgpolicyV1ListPolicy struct {
	// AllValues: The policy all_values state.
	//
	// Possible values:
	//   "ALL_VALUES_UNSPECIFIED" - Indicates that allowed_values or
	// denied_values must be set.
	//   "ALLOW" - A policy with this set allows all values.
	//   "DENY" - A policy with this set denies all values.
	AllValues string `json:"allValues,omitempty"`

	// AllowedValues: List of values allowed at this resource. Can only be
	// set if `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
	AllowedValues []string `json:"allowedValues,omitempty"`

	// DeniedValues: List of values denied at this resource. Can only be set
	// if `all_values` is set to `ALL_VALUES_UNSPECIFIED`.
	DeniedValues []string `json:"deniedValues,omitempty"`

	// InheritFromParent: Determines the inheritance behavior for this
	// `Policy`. By default, a `ListPolicy` set at a resource supersedes any
	// `Policy` set anywhere up the resource hierarchy. However, if
	// `inherit_from_parent` is set to `true`, then the values from the
	// effective `Policy` of the parent resource are inherited, meaning the
	// values set in this `Policy` are added to the values inherited up the
	// hierarchy. Setting `Policy` hierarchies that inherit both allowed
	// values and denied values isn't recommended in most circumstances to
	// keep the configuration simple and understandable. However, it is
	// possible to set a `Policy` with `allowed_values` set that inherits a
	// `Policy` with `denied_values` set. In this case, the values that are
	// allowed must be in `allowed_values` and not present in
	// `denied_values`. For example, suppose you have a `Constraint`
	// `constraints/serviceuser.services`, which has a `constraint_type` of
	// `list_constraint`, and with `constraint_default` set to `ALLOW`.
	// Suppose that at the Organization level, a `Policy` is applied that
	// restricts the allowed API activations to {`E1`, `E2`}. Then, if a
	// `Policy` is applied to a project below the Organization that has
	// `inherit_from_parent` set to `false` and field all_values set to
	// DENY, then an attempt to activate any API will be denied. The
	// following examples demonstrate different possible layerings for
	// `projects/bar` parented by `organizations/foo`: Example 1 (no
	// inherited values): `organizations/foo` has a `Policy` with values:
	// {allowed_values: "E1" allowed_values:"E2"} `projects/bar` has
	// `inherit_from_parent` `false` and values: {allowed_values: "E3"
	// allowed_values: "E4"} The accepted values at `organizations/foo` are
	// `E1`, `E2`. The accepted values at `projects/bar` are `E3`, and `E4`.
	// Example 2 (inherited values): `organizations/foo` has a `Policy` with
	// values: {allowed_values: "E1" allowed_values:"E2"} `projects/bar` has
	// a `Policy` with values: {value: "E3" value: "E4" inherit_from_parent:
	// true} The accepted values at `organizations/foo` are `E1`, `E2`. The
	// accepted values at `projects/bar` are `E1`, `E2`, `E3`, and `E4`.
	// Example 3 (inheriting both allowed and denied values):
	// `organizations/foo` has a `Policy` with values: {allowed_values: "E1"
	// allowed_values: "E2"} `projects/bar` has a `Policy` with:
	// {denied_values: "E1"} The accepted values at `organizations/foo` are
	// `E1`, `E2`. The value accepted at `projects/bar` is `E2`. Example 4
	// (RestoreDefault): `organizations/foo` has a `Policy` with values:
	// {allowed_values: "E1" allowed_values:"E2"} `projects/bar` has a
	// `Policy` with values: {RestoreDefault: {}} The accepted values at
	// `organizations/foo` are `E1`, `E2`. The accepted values at
	// `projects/bar` are either all or none depending on the value of
	// `constraint_default` (if `ALLOW`, all; if `DENY`, none). Example 5
	// (no policy inherits parent policy): `organizations/foo` has no
	// `Policy` set. `projects/bar` has no `Policy` set. The accepted values
	// at both levels are either all or none depending on the value of
	// `constraint_default` (if `ALLOW`, all; if `DENY`, none). Example 6
	// (ListConstraint allowing all): `organizations/foo` has a `Policy`
	// with values: {allowed_values: "E1" allowed_values: "E2"}
	// `projects/bar` has a `Policy` with: {all: ALLOW} The accepted values
	// at `organizations/foo` are `E1`, E2`. Any value is accepted at
	// `projects/bar`. Example 7 (ListConstraint allowing none):
	// `organizations/foo` has a `Policy` with values: {allowed_values: "E1"
	// allowed_values: "E2"} `projects/bar` has a `Policy` with: {all: DENY}
	// The accepted values at `organizations/foo` are `E1`, E2`. No value is
	// accepted at `projects/bar`. Example 10 (allowed and denied subtrees
	// of Resource Manager hierarchy): Given the following resource
	// hierarchy O1->{F1, F2}; F1->{P1}; F2->{P2, P3}, `organizations/foo`
	// has a `Policy` with values: {allowed_values:
	// "under:organizations/O1"} `projects/bar` has a `Policy` with:
	// {allowed_values: "under:projects/P3"} {denied_values:
	// "under:folders/F2"} The accepted values at `organizations/foo` are
	// `organizations/O1`, `folders/F1`, `folders/F2`, `projects/P1`,
	// `projects/P2`, `projects/P3`. The accepted values at `projects/bar`
	// are `organizations/O1`, `folders/F1`, `projects/P1`.
	InheritFromParent bool `json:"inheritFromParent,omitempty"`

	// SuggestedValue: Optional. The Google Cloud Console will try to
	// default to a configuration that matches the value specified in this
	// `Policy`. If `suggested_value` is not set, it will inherit the value
	// specified higher in the hierarchy, unless `inherit_from_parent` is
	// `false`.
	SuggestedValue string `json:"suggestedValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllValues") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllValues") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudOrgpolicyV1ListPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV1ListPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV1Policy: Defines a Cloud Organization `Policy`
// which is used to specify `Constraints` for configurations of Cloud
// Platform resources.
type GoogleCloudOrgpolicyV1Policy struct {
	// BooleanPolicy: For boolean `Constraints`, whether to enforce the
	// `Constraint` or not.
	BooleanPolicy *GoogleCloudOrgpolicyV1BooleanPolicy `json:"booleanPolicy,omitempty"`

	// Constraint: The name of the `Constraint` the `Policy` is configuring,
	// for example, `constraints/serviceuser.services`. A list of available
	// constraints
	// (/resource-manager/docs/organization-policy/org-policy-constraints)
	// is available. Immutable after creation.
	Constraint string `json:"constraint,omitempty"`

	// Etag: An opaque tag indicating the current version of the `Policy`,
	// used for concurrency control. When the `Policy` is returned from
	// either a `GetPolicy` or a `ListOrgPolicy` request, this `etag`
	// indicates the version of the current `Policy` to use when executing a
	// read-modify-write loop. When the `Policy` is returned from a
	// `GetEffectivePolicy` request, the `etag` will be unset. When the
	// `Policy` is used in a `SetOrgPolicy` method, use the `etag` value
	// that was returned from a `GetOrgPolicy` request as part of a
	// read-modify-write loop for concurrency control. Not setting the
	// `etag`in a `SetOrgPolicy` request will result in an unconditional
	// write of the `Policy`.
	Etag string `json:"etag,omitempty"`

	// ListPolicy: List of values either allowed or disallowed.
	ListPolicy *GoogleCloudOrgpolicyV1ListPolicy `json:"listPolicy,omitempty"`

	// RestoreDefault: Restores the default behavior of the constraint;
	// independent of `Constraint` type.
	RestoreDefault *GoogleCloudOrgpolicyV1RestoreDefault `json:"restoreDefault,omitempty"`

	// UpdateTime: The time stamp the `Policy` was previously updated. This
	// is set by the server, not specified by the caller, and represents the
	// last time a call to `SetOrgPolicy` was made for that `Policy`. Any
	// value set by the client will be ignored.
	UpdateTime string `json:"updateTime,omitempty"`

	// Version: Version of the `Policy`. Default version is 0;
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BooleanPolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BooleanPolicy") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudOrgpolicyV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudOrgpolicyV1Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudOrgpolicyV1RestoreDefault: Ignores policies set above this
// resource and restores the `constraint_default` enforcement behavior
// of the specific `Constraint` at this resource. Suppose that
// `constraint_default` is set to `ALLOW` for the `Constraint`
// `constraints/serviceuser.services`. Suppose that organization foo.com
// sets a `Policy` at their Organization resource node that restricts
// the allowed service activations to deny all service activations. They
// could then set a `Policy` with the `policy_type` `restore_default` on
// several experimental projects, restoring the `constraint_default`
// enforcement of the `Constraint` for only those projects, allowing
// those projects to have all services activated.
type GoogleCloudOrgpolicyV1RestoreDefault struct {
}

// GoogleIdentityAccesscontextmanagerV1AccessLevel: An `AccessLevel` is
// a label that can be applied to requests to Google Cloud services,
// along with a list of requirements necessary for the label to be
// applied.
type GoogleIdentityAccesscontextmanagerV1AccessLevel struct {
	// Basic: A `BasicLevel` composed of `Conditions`.
	Basic *GoogleIdentityAccesscontextmanagerV1BasicLevel `json:"basic,omitempty"`

	// Custom: A `CustomLevel` written in the Common Expression Language.
	Custom *GoogleIdentityAccesscontextmanagerV1CustomLevel `json:"custom,omitempty"`

	// Description: Description of the `AccessLevel` and its use. Does not
	// affect behavior.
	Description string `json:"description,omitempty"`

	// Name: Required. Resource name for the Access Level. The `short_name`
	// component must begin with a letter and only include alphanumeric and
	// '_'. Format: `accessPolicies/{policy_id}/accessLevels/{short_name}`.
	// The maximum length of the `short_name` component is 50 characters.
	Name string `json:"name,omitempty"`

	// Title: Human readable title. Must be unique within the Policy.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Basic") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Basic") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1AccessLevel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1AccessLevel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1AccessPolicy: `AccessPolicy` is a
// container for `AccessLevels` (which define the necessary attributes
// to use Google Cloud services) and `ServicePerimeters` (which define
// regions of services able to freely pass data within a perimeter). An
// access policy is globally visible within an organization, and the
// restrictions it specifies apply to all projects within an
// organization.
type GoogleIdentityAccesscontextmanagerV1AccessPolicy struct {
	// Etag: Output only. An opaque identifier for the current version of
	// the `AccessPolicy`. This will always be a strongly validated etag,
	// meaning that two Access Polices will be identical if and only if
	// their etags are identical. Clients should not expect this to be in
	// any specific format.
	Etag string `json:"etag,omitempty"`

	// Name: Output only. Resource name of the `AccessPolicy`. Format:
	// `accessPolicies/{policy_id}`
	Name string `json:"name,omitempty"`

	// Parent: Required. The parent of this `AccessPolicy` in the Cloud
	// Resource Hierarchy. Currently immutable once created. Format:
	// `organizations/{organization_id}`
	Parent string `json:"parent,omitempty"`

	// Title: Required. Human readable title. Does not affect behavior.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1AccessPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1AccessPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1ApiOperation: Identification for
// an API Operation.
type GoogleIdentityAccesscontextmanagerV1ApiOperation struct {
	// MethodSelectors: API methods or permissions to allow. Method or
	// permission must belong to the service specified by `service_name`
	// field. A single MethodSelector entry with `*` specified for the
	// `method` field will allow all methods AND permissions for the service
	// specified in `service_name`.
	MethodSelectors []*GoogleIdentityAccesscontextmanagerV1MethodSelector `json:"methodSelectors,omitempty"`

	// ServiceName: The name of the API whose methods or permissions the
	// IngressPolicy or EgressPolicy want to allow. A single ApiOperation
	// with `service_name` field set to `*` will allow all methods AND
	// permissions for all services.
	ServiceName string `json:"serviceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MethodSelectors") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MethodSelectors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1ApiOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1ApiOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1BasicLevel: `BasicLevel` is an
// `AccessLevel` using a set of recommended features.
type GoogleIdentityAccesscontextmanagerV1BasicLevel struct {
	// CombiningFunction: How the `conditions` list should be combined to
	// determine if a request is granted this `AccessLevel`. If AND is used,
	// each `Condition` in `conditions` must be satisfied for the
	// `AccessLevel` to be applied. If OR is used, at least one `Condition`
	// in `conditions` must be satisfied for the `AccessLevel` to be
	// applied. Default behavior is AND.
	//
	// Possible values:
	//   "AND" - All `Conditions` must be true for the `BasicLevel` to be
	// true.
	//   "OR" - If at least one `Condition` is true, then the `BasicLevel`
	// is true.
	CombiningFunction string `json:"combiningFunction,omitempty"`

	// Conditions: Required. A list of requirements for the `AccessLevel` to
	// be granted.
	Conditions []*GoogleIdentityAccesscontextmanagerV1Condition `json:"conditions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CombiningFunction")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CombiningFunction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1BasicLevel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1BasicLevel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1Condition: A condition necessary
// for an `AccessLevel` to be granted. The Condition is an AND over its
// fields. So a Condition is true if: 1) the request IP is from one of
// the listed subnetworks AND 2) the originating device complies with
// the listed device policy AND 3) all listed access levels are granted
// AND 4) the request was sent at a time allowed by the
// DateTimeRestriction.
type GoogleIdentityAccesscontextmanagerV1Condition struct {
	// DevicePolicy: Device specific restrictions, all restrictions must
	// hold for the Condition to be true. If not specified, all devices are
	// allowed.
	DevicePolicy *GoogleIdentityAccesscontextmanagerV1DevicePolicy `json:"devicePolicy,omitempty"`

	// IpSubnetworks: CIDR block IP subnetwork specification. May be IPv4 or
	// IPv6. Note that for a CIDR IP address block, the specified IP address
	// portion must be properly truncated (i.e. all the host bits must be
	// zero) or the input is considered malformed. For example,
	// "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly, for
	// IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32" is not.
	// The originating IP of a request must be in one of the listed subnets
	// in order for this Condition to be true. If empty, all IP addresses
	// are allowed.
	IpSubnetworks []string `json:"ipSubnetworks,omitempty"`

	// Members: The request must be made by one of the provided user or
	// service accounts. Groups are not supported. Syntax: `user:{emailid}`
	// `serviceAccount:{emailid}` If not specified, a request may come from
	// any user.
	Members []string `json:"members,omitempty"`

	// Negate: Whether to negate the Condition. If true, the Condition
	// becomes a NAND over its non-empty fields, each field must be false
	// for the Condition overall to be satisfied. Defaults to false.
	Negate bool `json:"negate,omitempty"`

	// Regions: The request must originate from one of the provided
	// countries/regions. Must be valid ISO 3166-1 alpha-2 codes.
	Regions []string `json:"regions,omitempty"`

	// RequiredAccessLevels: A list of other access levels defined in the
	// same `Policy`, referenced by resource name. Referencing an
	// `AccessLevel` which does not exist is an error. All access levels
	// listed must be granted for the Condition to be true. Example:
	// "accessPolicies/MY_POLICY/accessLevels/LEVEL_NAME"
	RequiredAccessLevels []string `json:"requiredAccessLevels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DevicePolicy") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DevicePolicy") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1Condition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1CustomLevel: `CustomLevel` is an
// `AccessLevel` using the Cloud Common Expression Language to represent
// the necessary conditions for the level to apply to a request. See CEL
// spec at: https://github.com/google/cel-spec
type GoogleIdentityAccesscontextmanagerV1CustomLevel struct {
	// Expr: Required. A Cloud CEL expression evaluating to a boolean.
	Expr *Expr `json:"expr,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Expr") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Expr") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1CustomLevel) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1CustomLevel
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1DevicePolicy: `DevicePolicy`
// specifies device specific restrictions necessary to acquire a given
// access level. A `DevicePolicy` specifies requirements for requests
// from devices to be granted access levels, it does not do any
// enforcement on the device. `DevicePolicy` acts as an AND over all
// specified fields, and each repeated field is an OR over its elements.
// Any unset fields are ignored. For example, if the proto is { os_type
// : DESKTOP_WINDOWS, os_type : DESKTOP_LINUX, encryption_status:
// ENCRYPTED}, then the DevicePolicy will be true for requests
// originating from encrypted Linux desktops and encrypted Windows
// desktops.
type GoogleIdentityAccesscontextmanagerV1DevicePolicy struct {
	// AllowedDeviceManagementLevels: Allowed device management levels, an
	// empty list allows all management levels.
	//
	// Possible values:
	//   "MANAGEMENT_UNSPECIFIED" - The device's management level is not
	// specified or not known.
	//   "NONE" - The device is not managed.
	//   "BASIC" - Basic management is enabled, which is generally limited
	// to monitoring and wiping the corporate account.
	//   "COMPLETE" - Complete device management. This includes more
	// thorough monitoring and the ability to directly manage the device
	// (such as remote wiping). This can be enabled through the Android
	// Enterprise Platform.
	AllowedDeviceManagementLevels []string `json:"allowedDeviceManagementLevels,omitempty"`

	// AllowedEncryptionStatuses: Allowed encryptions statuses, an empty
	// list allows all statuses.
	//
	// Possible values:
	//   "ENCRYPTION_UNSPECIFIED" - The encryption status of the device is
	// not specified or not known.
	//   "ENCRYPTION_UNSUPPORTED" - The device does not support encryption.
	//   "UNENCRYPTED" - The device supports encryption, but is currently
	// unencrypted.
	//   "ENCRYPTED" - The device is encrypted.
	AllowedEncryptionStatuses []string `json:"allowedEncryptionStatuses,omitempty"`

	// OsConstraints: Allowed OS versions, an empty list allows all types
	// and all versions.
	OsConstraints []*GoogleIdentityAccesscontextmanagerV1OsConstraint `json:"osConstraints,omitempty"`

	// RequireAdminApproval: Whether the device needs to be approved by the
	// customer admin.
	RequireAdminApproval bool `json:"requireAdminApproval,omitempty"`

	// RequireCorpOwned: Whether the device needs to be corp owned.
	RequireCorpOwned bool `json:"requireCorpOwned,omitempty"`

	// RequireScreenlock: Whether or not screenlock is required for the
	// DevicePolicy to be true. Defaults to `false`.
	RequireScreenlock bool `json:"requireScreenlock,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowedDeviceManagementLevels") to unconditionally include in API
	// requests. By default, fields with empty values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AllowedDeviceManagementLevels") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1DevicePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1DevicePolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1EgressFrom: Defines the
// conditions under which an EgressPolicy matches a request. Conditions
// based on information about the source of the request. Note that if
// the destination of the request is protected by a ServicePerimeter,
// then that ServicePerimeter must have an IngressPolicy which allows
// access in order for this request to succeed.
type GoogleIdentityAccesscontextmanagerV1EgressFrom struct {
	// Identities: A list of identities that are allowed access through this
	// [EgressPolicy]. Should be in the format of email address. The email
	// address should represent individual user or service account only.
	Identities []string `json:"identities,omitempty"`

	// IdentityType: Specifies the type of identities that are allowed
	// access to outside the perimeter. If left unspecified, then members of
	// `identities` field will be allowed access.
	//
	// Possible values:
	//   "IDENTITY_TYPE_UNSPECIFIED" - No blanket identity group specified.
	//   "ANY_IDENTITY" - Authorize access from all identities outside the
	// perimeter.
	//   "ANY_USER_ACCOUNT" - Authorize access from all human users outside
	// the perimeter.
	//   "ANY_SERVICE_ACCOUNT" - Authorize access from all service accounts
	// outside the perimeter.
	IdentityType string `json:"identityType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Identities") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Identities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1EgressFrom) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1EgressFrom
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1EgressPolicy: Policy for egress
// from perimeter. EgressPolicies match requests based on `egress_from`
// and `egress_to` stanzas. For an EgressPolicy to match, both
// `egress_from` and `egress_to` stanzas must be matched. If an
// EgressPolicy matches a request, the request is allowed to span the
// ServicePerimeter boundary. For example, an EgressPolicy can be used
// to allow VMs on networks within the ServicePerimeter to access a
// defined set of projects outside the perimeter in certain contexts
// (e.g. to read data from a Cloud Storage bucket or query against a
// BigQuery dataset). EgressPolicies are concerned with the *resources*
// that a request relates as well as the API services and API actions
// being used. They do not related to the direction of data movement.
// More detailed documentation for this concept can be found in the
// descriptions of EgressFrom and EgressTo.
type GoogleIdentityAccesscontextmanagerV1EgressPolicy struct {
	// EgressFrom: Defines conditions on the source of a request causing
	// this EgressPolicy to apply.
	EgressFrom *GoogleIdentityAccesscontextmanagerV1EgressFrom `json:"egressFrom,omitempty"`

	// EgressTo: Defines the conditions on the ApiOperation and destination
	// resources that cause this EgressPolicy to apply.
	EgressTo *GoogleIdentityAccesscontextmanagerV1EgressTo `json:"egressTo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EgressFrom") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EgressFrom") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1EgressPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1EgressPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1EgressTo: Defines the conditions
// under which an EgressPolicy matches a request. Conditions are based
// on information about the ApiOperation intended to be performed on the
// `resources` specified. Note that if the destination of the request is
// protected by a ServicePerimeter, then that ServicePerimeter must have
// an IngressPolicy which allows access in order for this request to
// succeed.
type GoogleIdentityAccesscontextmanagerV1EgressTo struct {
	// Operations: A list of ApiOperations that this egress rule applies to.
	// A request matches if it contains an operation/service in this list.
	Operations []*GoogleIdentityAccesscontextmanagerV1ApiOperation `json:"operations,omitempty"`

	// Resources: A list of resources, currently only projects in the form
	// `projects/`, that match this to stanza. A request matches if it
	// contains a resource in this list. If `*` is specified for resources,
	// then this EgressTo rule will authorize access to all resources
	// outside the perimeter.
	Resources []string `json:"resources,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Operations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Operations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1EgressTo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1EgressTo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1IngressFrom: Defines the
// conditions under which an IngressPolicy matches a request. Conditions
// are based on information about the source of the request.
type GoogleIdentityAccesscontextmanagerV1IngressFrom struct {
	// Identities: A list of identities that are allowed access through this
	// ingress policy. Should be in the format of email address. The email
	// address should represent individual user or service account only.
	Identities []string `json:"identities,omitempty"`

	// IdentityType: Specifies the type of identities that are allowed
	// access from outside the perimeter. If left unspecified, then members
	// of `identities` field will be allowed access.
	//
	// Possible values:
	//   "IDENTITY_TYPE_UNSPECIFIED" - No blanket identity group specified.
	//   "ANY_IDENTITY" - Authorize access from all identities outside the
	// perimeter.
	//   "ANY_USER_ACCOUNT" - Authorize access from all human users outside
	// the perimeter.
	//   "ANY_SERVICE_ACCOUNT" - Authorize access from all service accounts
	// outside the perimeter.
	IdentityType string `json:"identityType,omitempty"`

	// Sources: Sources that this IngressPolicy authorizes access from.
	Sources []*GoogleIdentityAccesscontextmanagerV1IngressSource `json:"sources,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Identities") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Identities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1IngressFrom) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1IngressFrom
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1IngressPolicy: Policy for ingress
// into ServicePerimeter. IngressPolicies match requests based on
// `ingress_from` and `ingress_to` stanzas. For an ingress policy to
// match, both the `ingress_from` and `ingress_to` stanzas must be
// matched. If an IngressPolicy matches a request, the request is
// allowed through the perimeter boundary from outside the perimeter.
// For example, access from the internet can be allowed either based on
// an AccessLevel or, for traffic hosted on Google Cloud, the project of
// the source network. For access from private networks, using the
// project of the hosting network is required. Individual ingress
// policies can be limited by restricting which services and/or actions
// they match using the `ingress_to` field.
type GoogleIdentityAccesscontextmanagerV1IngressPolicy struct {
	// IngressFrom: Defines the conditions on the source of a request
	// causing this IngressPolicy to apply.
	IngressFrom *GoogleIdentityAccesscontextmanagerV1IngressFrom `json:"ingressFrom,omitempty"`

	// IngressTo: Defines the conditions on the ApiOperation and request
	// destination that cause this IngressPolicy to apply.
	IngressTo *GoogleIdentityAccesscontextmanagerV1IngressTo `json:"ingressTo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IngressFrom") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IngressFrom") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1IngressPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1IngressPolicy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1IngressSource: The source that
// IngressPolicy authorizes access from.
type GoogleIdentityAccesscontextmanagerV1IngressSource struct {
	// AccessLevel: An AccessLevel resource name that allow resources within
	// the ServicePerimeters to be accessed from the internet. AccessLevels
	// listed must be in the same policy as this ServicePerimeter.
	// Referencing a nonexistent AccessLevel will cause an error. If no
	// AccessLevel names are listed, resources within the perimeter can only
	// be accessed via Google Cloud calls with request origins within the
	// perimeter. Example: `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`.
	// If `*` is specified, then all IngressSources will be allowed.
	AccessLevel string `json:"accessLevel,omitempty"`

	// Resource: A Google Cloud resource that is allowed to ingress the
	// perimeter. Requests from these resources will be allowed to access
	// perimeter data. Currently only projects are allowed. Format:
	// `projects/{project_number}` The project may be in any Google Cloud
	// organization, not just the organization that the perimeter is defined
	// in. `*` is not allowed, the case of allowing all Google Cloud
	// resources only is not supported.
	Resource string `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessLevel") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessLevel") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1IngressSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1IngressSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1IngressTo: Defines the conditions
// under which an IngressPolicy matches a request. Conditions are based
// on information about the ApiOperation intended to be performed on the
// destination of the request.
type GoogleIdentityAccesscontextmanagerV1IngressTo struct {
	// Operations: A list of ApiOperations the sources specified in
	// corresponding IngressFrom are allowed to perform in this
	// ServicePerimeter.
	Operations []*GoogleIdentityAccesscontextmanagerV1ApiOperation `json:"operations,omitempty"`

	// Resources: A list of resources, currently only projects in the form
	// `projects/`, protected by this ServicePerimeter that are allowed to
	// be accessed by sources defined in the corresponding IngressFrom. A
	// request matches if it contains a resource in this list. If `*` is
	// specified for resources, then this IngressTo rule will authorize
	// access to all resources inside the perimeter, provided that the
	// request also matches the `operations` field.
	Resources []string `json:"resources,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Operations") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Operations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1IngressTo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1IngressTo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1MethodSelector: An allowed method
// or permission of a service specified in ApiOperation.
type GoogleIdentityAccesscontextmanagerV1MethodSelector struct {
	// Method: Value for `method` should be a valid method name for the
	// corresponding `service_name` in ApiOperation. If `*` used as value
	// for `method`, then ALL methods and permissions are allowed.
	Method string `json:"method,omitempty"`

	// Permission: Value for `permission` should be a valid Cloud IAM
	// permission for the corresponding `service_name` in ApiOperation.
	Permission string `json:"permission,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Method") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Method") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1MethodSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1MethodSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1OsConstraint: A restriction on
// the OS type and version of devices making requests.
type GoogleIdentityAccesscontextmanagerV1OsConstraint struct {
	// MinimumVersion: The minimum allowed OS version. If not set, any
	// version of this OS satisfies the constraint. Format:
	// "major.minor.patch". Examples: "10.5.301", "9.2.1".
	MinimumVersion string `json:"minimumVersion,omitempty"`

	// OsType: Required. The allowed OS type.
	//
	// Possible values:
	//   "OS_UNSPECIFIED" - The operating system of the device is not
	// specified or not known.
	//   "DESKTOP_MAC" - A desktop Mac operating system.
	//   "DESKTOP_WINDOWS" - A desktop Windows operating system.
	//   "DESKTOP_LINUX" - A desktop Linux operating system.
	//   "DESKTOP_CHROME_OS" - A desktop ChromeOS operating system.
	//   "ANDROID" - An Android operating system.
	//   "IOS" - An iOS operating system.
	OsType string `json:"osType,omitempty"`

	// RequireVerifiedChromeOs: Only allows requests from devices with a
	// verified Chrome OS. Verifications includes requirements that the
	// device is enterprise-managed, conformant to domain policies, and the
	// caller has permission to call the API targeted by the request.
	RequireVerifiedChromeOs bool `json:"requireVerifiedChromeOs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MinimumVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MinimumVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1OsConstraint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1OsConstraint
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1ServicePerimeter:
// `ServicePerimeter` describes a set of Google Cloud resources which
// can freely import and export data amongst themselves, but not export
// outside of the `ServicePerimeter`. If a request with a source within
// this `ServicePerimeter` has a target outside of the
// `ServicePerimeter`, the request will be blocked. Otherwise the
// request is allowed. There are two types of Service Perimeter -
// Regular and Bridge. Regular Service Perimeters cannot overlap, a
// single Google Cloud project can only belong to a single regular
// Service Perimeter. Service Perimeter Bridges can contain only Google
// Cloud projects as members, a single Google Cloud project may belong
// to multiple Service Perimeter Bridges.
type GoogleIdentityAccesscontextmanagerV1ServicePerimeter struct {
	// Description: Description of the `ServicePerimeter` and its use. Does
	// not affect behavior.
	Description string `json:"description,omitempty"`

	// Name: Required. Resource name for the ServicePerimeter. The
	// `short_name` component must begin with a letter and only include
	// alphanumeric and '_'. Format:
	// `accessPolicies/{policy_id}/servicePerimeters/{short_name}`
	Name string `json:"name,omitempty"`

	// PerimeterType: Perimeter type indicator. A single project is allowed
	// to be a member of single regular perimeter, but multiple service
	// perimeter bridges. A project cannot be a included in a perimeter
	// bridge without being included in regular perimeter. For perimeter
	// bridges, the restricted service list as well as access level lists
	// must be empty.
	//
	// Possible values:
	//   "PERIMETER_TYPE_REGULAR" - Regular Perimeter.
	//   "PERIMETER_TYPE_BRIDGE" - Perimeter Bridge.
	PerimeterType string `json:"perimeterType,omitempty"`

	// Spec: Proposed (or dry run) ServicePerimeter configuration. This
	// configuration allows to specify and test ServicePerimeter
	// configuration without enforcing actual access restrictions. Only
	// allowed to be set when the "use_explicit_dry_run_spec" flag is set.
	Spec *GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig `json:"spec,omitempty"`

	// Status: Current ServicePerimeter configuration. Specifies sets of
	// resources, restricted services and access levels that determine
	// perimeter content and boundaries.
	Status *GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig `json:"status,omitempty"`

	// Title: Human readable title. Must be unique within the Policy.
	Title string `json:"title,omitempty"`

	// UseExplicitDryRunSpec: Use explicit dry run spec flag. Ordinarily, a
	// dry-run spec implicitly exists for all Service Perimeters, and that
	// spec is identical to the status for those Service Perimeters. When
	// this flag is set, it inhibits the generation of the implicit spec,
	// thereby allowing the user to explicitly provide a configuration
	// ("spec") to use in a dry-run version of the Service Perimeter. This
	// allows the user to test changes to the enforced config ("status")
	// without actually enforcing them. This testing is done through
	// analyzing the differences between currently enforced and suggested
	// restrictions. use_explicit_dry_run_spec must bet set to True if any
	// of the fields in the spec are set to non-default values.
	UseExplicitDryRunSpec bool `json:"useExplicitDryRunSpec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1ServicePerimeter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1ServicePerimeter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig:
// `ServicePerimeterConfig` specifies a set of Google Cloud resources
// that describe specific Service Perimeter configuration.
type GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig struct {
	// AccessLevels: A list of `AccessLevel` resource names that allow
	// resources within the `ServicePerimeter` to be accessed from the
	// internet. `AccessLevels` listed must be in the same policy as this
	// `ServicePerimeter`. Referencing a nonexistent `AccessLevel` is a
	// syntax error. If no `AccessLevel` names are listed, resources within
	// the perimeter can only be accessed via Google Cloud calls with
	// request origins within the perimeter. Example:
	// "accessPolicies/MY_POLICY/accessLevels/MY_LEVEL". For Service
	// Perimeter Bridge, must be empty.
	AccessLevels []string `json:"accessLevels,omitempty"`

	// EgressPolicies: List of EgressPolicies to apply to the perimeter. A
	// perimeter may have multiple EgressPolicies, each of which is
	// evaluated separately. Access is granted if any EgressPolicy grants
	// it. Must be empty for a perimeter bridge.
	EgressPolicies []*GoogleIdentityAccesscontextmanagerV1EgressPolicy `json:"egressPolicies,omitempty"`

	// IngressPolicies: List of IngressPolicies to apply to the perimeter. A
	// perimeter may have multiple IngressPolicies, each of which is
	// evaluated separately. Access is granted if any Ingress Policy grants
	// it. Must be empty for a perimeter bridge.
	IngressPolicies []*GoogleIdentityAccesscontextmanagerV1IngressPolicy `json:"ingressPolicies,omitempty"`

	// Resources: A list of Google Cloud resources that are inside of the
	// service perimeter. Currently only projects are allowed. Format:
	// `projects/{project_number}`
	Resources []string `json:"resources,omitempty"`

	// RestrictedServices: Google Cloud services that are subject to the
	// Service Perimeter restrictions. For example, if
	// `storage.googleapis.com` is specified, access to the storage buckets
	// inside the perimeter must meet the perimeter's access restrictions.
	RestrictedServices []string `json:"restrictedServices,omitempty"`

	// VpcAccessibleServices: Configuration for APIs allowed within
	// Perimeter.
	VpcAccessibleServices *GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices `json:"vpcAccessibleServices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessLevels") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessLevels") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1ServicePerimeterConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices: Specifies
// how APIs are allowed to communicate within the Service Perimeter.
type GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices struct {
	// AllowedServices: The list of APIs usable within the Service
	// Perimeter. Must be empty unless 'enable_restriction' is True. You can
	// specify a list of individual services, as well as include the
	// 'RESTRICTED-SERVICES' value, which automatically includes all of the
	// services protected by the perimeter.
	AllowedServices []string `json:"allowedServices,omitempty"`

	// EnableRestriction: Whether to restrict API calls within the Service
	// Perimeter to the list of APIs specified in 'allowed_services'.
	EnableRestriction bool `json:"enableRestriction,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AllowedServices") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowedServices") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIdentityAccesscontextmanagerV1VpcAccessibleServices
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicyAnalysis: An analysis message to group the query and
// results.
type IamPolicyAnalysis struct {
	// AnalysisQuery: The analysis query.
	AnalysisQuery *IamPolicyAnalysisQuery `json:"analysisQuery,omitempty"`

	// AnalysisResults: A list of IamPolicyAnalysisResult that matches the
	// analysis query, or empty if no result is found.
	AnalysisResults []*IamPolicyAnalysisResult `json:"analysisResults,omitempty"`

	// FullyExplored: Represents whether all entries in the analysis_results
	// have been fully explored to answer the query.
	FullyExplored bool `json:"fullyExplored,omitempty"`

	// NonCriticalErrors: A list of non-critical errors happened during the
	// query handling.
	NonCriticalErrors []*IamPolicyAnalysisState `json:"nonCriticalErrors,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalysisQuery") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalysisQuery") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicyAnalysis) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicyAnalysis
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicyAnalysisOutputConfig: Output configuration for export IAM
// policy analysis destination.
type IamPolicyAnalysisOutputConfig struct {
	// BigqueryDestination: Destination on BigQuery.
	BigqueryDestination *GoogleCloudAssetV1BigQueryDestination `json:"bigqueryDestination,omitempty"`

	// GcsDestination: Destination on Cloud Storage.
	GcsDestination *GoogleCloudAssetV1GcsDestination `json:"gcsDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicyAnalysisOutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicyAnalysisOutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicyAnalysisQuery: ## IAM policy analysis query message.
type IamPolicyAnalysisQuery struct {
	// AccessSelector: Optional. Specifies roles or permissions for
	// analysis. This is optional.
	AccessSelector *AccessSelector `json:"accessSelector,omitempty"`

	// IdentitySelector: Optional. Specifies an identity for analysis.
	IdentitySelector *IdentitySelector `json:"identitySelector,omitempty"`

	// Options: Optional. The query options.
	Options *Options `json:"options,omitempty"`

	// ResourceSelector: Optional. Specifies a resource for analysis.
	ResourceSelector *ResourceSelector `json:"resourceSelector,omitempty"`

	// Scope: Required. The relative name of the root asset. Only resources
	// and IAM policies within the scope will be analyzed. This can only be
	// an organization number (such as "organizations/123"), a folder number
	// (such as "folders/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as
	// "projects/12345"). To know how to get organization id, visit here
	// (https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	// To know how to get folder or project id, visit here
	// (https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
	Scope string `json:"scope,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessSelector") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessSelector") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicyAnalysisQuery) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicyAnalysisQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicyAnalysisResult: IAM Policy analysis result, consisting of
// one IAM policy binding and derived access control lists.
type IamPolicyAnalysisResult struct {
	// AccessControlLists: The access control lists derived from the
	// iam_binding that match or potentially match resource and access
	// selectors specified in the request.
	AccessControlLists []*GoogleCloudAssetV1AccessControlList `json:"accessControlLists,omitempty"`

	// AttachedResourceFullName: The full resource name
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of the resource to which the iam_binding policy attaches.
	AttachedResourceFullName string `json:"attachedResourceFullName,omitempty"`

	// FullyExplored: Represents whether all analyses on the iam_binding
	// have successfully finished.
	FullyExplored bool `json:"fullyExplored,omitempty"`

	// IamBinding: The Cloud IAM policy binding under analysis.
	IamBinding *Binding `json:"iamBinding,omitempty"`

	// IdentityList: The identity list derived from members of the
	// iam_binding that match or potentially match identity selector
	// specified in the request.
	IdentityList *GoogleCloudAssetV1IdentityList `json:"identityList,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessControlLists")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessControlLists") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicyAnalysisResult) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicyAnalysisResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicyAnalysisState: Represents the detailed state of an entity
// under analysis, such as a resource, an identity or an access.
type IamPolicyAnalysisState struct {
	// Cause: The human-readable description of the cause of failure.
	Cause string `json:"cause,omitempty"`

	// Code: The Google standard error code that best describes the state.
	// For example: - OK means the analysis on this entity has been
	// successfully finished; - PERMISSION_DENIED means an access denied
	// error is encountered; - DEADLINE_EXCEEDED means the analysis on this
	// entity hasn't been started in time;
	//
	// Possible values:
	//   "OK" - Not an error; returned on success HTTP Mapping: 200 OK
	//   "CANCELLED" - The operation was cancelled, typically by the caller.
	// HTTP Mapping: 499 Client Closed Request
	//   "UNKNOWN" - Unknown error. For example, this error may be returned
	// when a `Status` value received from another address space belongs to
	// an error space that is not known in this address space. Also errors
	// raised by APIs that do not return enough error information may be
	// converted to this error. HTTP Mapping: 500 Internal Server Error
	//   "INVALID_ARGUMENT" - The client specified an invalid argument. Note
	// that this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT`
	// indicates arguments that are problematic regardless of the state of
	// the system (e.g., a malformed file name). HTTP Mapping: 400 Bad
	// Request
	//   "DEADLINE_EXCEEDED" - The deadline expired before the operation
	// could complete. For operations that change the state of the system,
	// this error may be returned even if the operation has completed
	// successfully. For example, a successful response from a server could
	// have been delayed long enough for the deadline to expire. HTTP
	// Mapping: 504 Gateway Timeout
	//   "NOT_FOUND" - Some requested entity (e.g., file or directory) was
	// not found. Note to server developers: if a request is denied for an
	// entire class of users, such as gradual feature rollout or
	// undocumented allowlist, `NOT_FOUND` may be used. If a request is
	// denied for some users within a class of users, such as user-based
	// access control, `PERMISSION_DENIED` must be used. HTTP Mapping: 404
	// Not Found
	//   "ALREADY_EXISTS" - The entity that a client attempted to create
	// (e.g., file or directory) already exists. HTTP Mapping: 409 Conflict
	//   "PERMISSION_DENIED" - The caller does not have permission to
	// execute the specified operation. `PERMISSION_DENIED` must not be used
	// for rejections caused by exhausting some resource (use
	// `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
	// must not be used if the caller can not be identified (use
	// `UNAUTHENTICATED` instead for those errors). This error code does not
	// imply the request is valid or the requested entity exists or
	// satisfies other pre-conditions. HTTP Mapping: 403 Forbidden
	//   "UNAUTHENTICATED" - The request does not have valid authentication
	// credentials for the operation. HTTP Mapping: 401 Unauthorized
	//   "RESOURCE_EXHAUSTED" - Some resource has been exhausted, perhaps a
	// per-user quota, or perhaps the entire file system is out of space.
	// HTTP Mapping: 429 Too Many Requests
	//   "FAILED_PRECONDITION" - The operation was rejected because the
	// system is not in a state required for the operation's execution. For
	// example, the directory to be deleted is non-empty, an rmdir operation
	// is applied to a non-directory, etc. Service implementors can use the
	// following guidelines to decide between `FAILED_PRECONDITION`,
	// `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
	// retry just the failing call. (b) Use `ABORTED` if the client should
	// retry at a higher level (e.g., when a client-specified test-and-set
	// fails, indicating the client should restart a read-modify-write
	// sequence). (c) Use `FAILED_PRECONDITION` if the client should not
	// retry until the system state has been explicitly fixed. E.g., if an
	// "rmdir" fails because the directory is non-empty,
	// `FAILED_PRECONDITION` should be returned since the client should not
	// retry unless the files are deleted from the directory. HTTP Mapping:
	// 400 Bad Request
	//   "ABORTED" - The operation was aborted, typically due to a
	// concurrency issue such as a sequencer check failure or transaction
	// abort. See the guidelines above for deciding between
	// `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping:
	// 409 Conflict
	//   "OUT_OF_RANGE" - The operation was attempted past the valid range.
	// E.g., seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`,
	// this error indicates a problem that may be fixed if the system state
	// changes. For example, a 32-bit file system will generate
	// `INVALID_ARGUMENT` if asked to read at an offset that is not in the
	// range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to
	// read from an offset past the current file size. There is a fair bit
	// of overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We
	// recommend using `OUT_OF_RANGE` (the more specific error) when it
	// applies so that callers who are iterating through a space can easily
	// look for an `OUT_OF_RANGE` error to detect when they are done. HTTP
	// Mapping: 400 Bad Request
	//   "UNIMPLEMENTED" - The operation is not implemented or is not
	// supported/enabled in this service. HTTP Mapping: 501 Not Implemented
	//   "INTERNAL" - Internal errors. This means that some invariants
	// expected by the underlying system have been broken. This error code
	// is reserved for serious errors. HTTP Mapping: 500 Internal Server
	// Error
	//   "UNAVAILABLE" - The service is currently unavailable. This is most
	// likely a transient condition, which can be corrected by retrying with
	// a backoff. Note that it is not always safe to retry non-idempotent
	// operations. See the guidelines above for deciding between
	// `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping:
	// 503 Service Unavailable
	//   "DATA_LOSS" - Unrecoverable data loss or corruption. HTTP Mapping:
	// 500 Internal Server Error
	Code string `json:"code,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cause") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cause") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicyAnalysisState) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicyAnalysisState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IamPolicySearchResult: A result of IAM Policy search, containing
// information of an IAM policy.
type IamPolicySearchResult struct {
	// Explanation: Explanation about the IAM policy search result. It
	// contains additional information to explain why the search result
	// matches the query.
	Explanation *Explanation `json:"explanation,omitempty"`

	// Policy: The IAM policy directly set on the given resource. Note that
	// the original IAM policy can contain multiple bindings. This only
	// contains the bindings that match the given query. For queries that
	// don't contain a constrain on policies (e.g., an empty query), this
	// contains all the bindings. To search against the `policy` bindings: *
	// use a field query: - query by the policy contained members. Example:
	// `policy:amy@gmail.com` - query by the policy contained roles.
	// Example: `policy:roles/compute.admin` - query by the policy contained
	// roles' included permissions. Example:
	// `policy.role.permissions:compute.instances.create`
	Policy *Policy `json:"policy,omitempty"`

	// Project: The project that the associated GCP resource belongs to, in
	// the form of projects/{PROJECT_NUMBER}. If an IAM policy is set on a
	// resource (like VM instance, Cloud Storage bucket), the project field
	// will indicate the project that contains the resource. If an IAM
	// policy is set on a folder or orgnization, this field will be empty.
	// To search against the `project`: * specify the `scope` field as this
	// project in your search request.
	Project string `json:"project,omitempty"`

	// Resource: The full resource name of the resource associated with this
	// IAM policy. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instance
	// s/instance1`. See Cloud Asset Inventory Resource Name Format
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information. To search against the `resource`: * use a field
	// query. Example: `resource:organizations/123`
	Resource string `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Explanation") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Explanation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IamPolicySearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicySearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IdentitySelector: Specifies an identity for which to determine
// resource access, based on roles assigned either directly to them or
// to the groups they belong to, directly or indirectly.
type IdentitySelector struct {
	// Identity: Required. The identity appear in the form of members in IAM
	// policy binding
	// (https://cloud.google.com/iam/reference/rest/v1/Binding). The
	// examples of supported forms are: "user:mike@example.com",
	// "group:admins@example.com", "domain:google.com",
	// "serviceAccount:my-project-id@appspot.gserviceaccount.com". Notice
	// that wildcard characters (such as * and ?) are not supported. You
	// must give a specific identity.
	Identity string `json:"identity,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Identity") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Identity") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *IdentitySelector) MarshalJSON() ([]byte, error) {
	type NoMethod IdentitySelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Inventory: The inventory details of a VM.
type Inventory struct {
	// Items: Inventory items related to the VM keyed by an opaque unique
	// identifier for each inventory item. The identifier is unique to each
	// distinct and addressable inventory item and will change, when there
	// is a new package version.
	Items map[string]Item `json:"items,omitempty"`

	// OsInfo: Base level operating system information for the VM.
	OsInfo *OsInfo `json:"osInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Items") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Inventory) MarshalJSON() ([]byte, error) {
	type NoMethod Inventory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Item: A single piece of inventory on a VM.
type Item struct {
	// AvailablePackage: Software package available to be installed on the
	// VM instance.
	AvailablePackage *SoftwarePackage `json:"availablePackage,omitempty"`

	// CreateTime: When this inventory item was first detected.
	CreateTime string `json:"createTime,omitempty"`

	// Id: Identifier for this item, unique across items for this VM.
	Id string `json:"id,omitempty"`

	// InstalledPackage: Software package present on the VM instance.
	InstalledPackage *SoftwarePackage `json:"installedPackage,omitempty"`

	// OriginType: The origin of this inventory item.
	//
	// Possible values:
	//   "ORIGIN_TYPE_UNSPECIFIED" - Invalid. An origin type must be
	// specified.
	//   "INVENTORY_REPORT" - This inventory item was discovered as the
	// result of the agent reporting inventory via the reporting API.
	OriginType string `json:"originType,omitempty"`

	// Type: The specific type of inventory, correlating to its specific
	// details.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Invalid. An type must be specified.
	//   "INSTALLED_PACKAGE" - This represents a package that is installed
	// on the VM.
	//   "AVAILABLE_PACKAGE" - This represents an update that is available
	// for a package.
	Type string `json:"type,omitempty"`

	// UpdateTime: When this inventory item was last modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AvailablePackage") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AvailablePackage") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Item) MarshalJSON() ([]byte, error) {
	type NoMethod Item
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type ListFeedsResponse struct {
	// Feeds: A list of feeds.
	Feeds []*Feed `json:"feeds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Feeds") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Feeds") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListFeedsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListFeedsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Options: Contains query options.
type Options struct {
	// AnalyzeServiceAccountImpersonation: Optional. If true, the response
	// will include access analysis from identities to resources via service
	// account impersonation. This is a very expensive operation, because
	// many derived queries will be executed. We highly recommend you use
	// AssetService.AnalyzeIamPolicyLongrunning rpc instead. For example, if
	// the request analyzes for which resources user A has permission P, and
	// there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account
	// SA, and there's another IAM policy states service account SA has
	// permission P to a GCP folder F, then user A potentially has access to
	// the GCP folder F. And those advanced analysis results will be
	// included in
	// AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
	// Another example, if the request analyzes for who has permission P to
	// a GCP folder F, and there's an IAM policy states user A has
	// iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P
	// to the GCP folder F, then user A potentially has access to the GCP
	// folder F. And those advanced analysis results will be included in
	// AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `json:"analyzeServiceAccountImpersonation,omitempty"`

	// ExpandGroups: Optional. If true, the identities section of the result
	// will expand any Google groups appearing in an IAM policy binding. If
	// IamPolicyAnalysisQuery.identity_selector is specified, the identity
	// in the result will be determined by the selector, and this flag is
	// not allowed to set. Default is false.
	ExpandGroups bool `json:"expandGroups,omitempty"`

	// ExpandResources: Optional. If true and
	// IamPolicyAnalysisQuery.resource_selector is not specified, the
	// resource section of the result will expand any resource attached to
	// an IAM policy to include resources lower in the resource hierarchy.
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P. If true and IamPolicyAnalysisQuery.resource_selector is
	// specified, the resource section of the result will expand the
	// specified resource to include resources lower in the resource
	// hierarchy. Only project or lower resources are supported. Folder and
	// organization resource cannot be used together with this option. For
	// example, if the request analyzes for which users have permission P on
	// a GCP project with this option enabled, the results will include all
	// users who have permission P on that project or any lower resource.
	// Default is false.
	ExpandResources bool `json:"expandResources,omitempty"`

	// ExpandRoles: Optional. If true, the access section of result will
	// expand any roles appearing in IAM policy bindings to include their
	// permissions. If IamPolicyAnalysisQuery.access_selector is specified,
	// the access section of the result will be determined by the selector,
	// and this flag is not allowed to set. Default is false.
	ExpandRoles bool `json:"expandRoles,omitempty"`

	// OutputGroupEdges: Optional. If true, the result will output group
	// identity edges, starting from the binding's group members, to any
	// expanded identities. Default is false.
	OutputGroupEdges bool `json:"outputGroupEdges,omitempty"`

	// OutputResourceEdges: Optional. If true, the result will output
	// resource edges, starting from the policy attached resource, to any
	// expanded resources. Default is false.
	OutputResourceEdges bool `json:"outputResourceEdges,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AnalyzeServiceAccountImpersonation") to unconditionally include in
	// API requests. By default, fields with empty values are omitted from
	// API requests. However, any non-pointer, non-interface field appearing
	// in ForceSendFields will be sent to the server regardless of whether
	// the field is empty or not. This may be used to include empty fields
	// in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AnalyzeServiceAccountImpersonation") to include in API requests with
	// the JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Options) MarshalJSON() ([]byte, error) {
	type NoMethod Options
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OsInfo: Operating system information for the VM.
type OsInfo struct {
	// Architecture: The system architecture of the operating system.
	Architecture string `json:"architecture,omitempty"`

	// Hostname: The VM hostname.
	Hostname string `json:"hostname,omitempty"`

	// KernelRelease: The kernel release of the operating system.
	KernelRelease string `json:"kernelRelease,omitempty"`

	// KernelVersion: The kernel version of the operating system.
	KernelVersion string `json:"kernelVersion,omitempty"`

	// LongName: The operating system long name. For example 'Debian
	// GNU/Linux 9' or 'Microsoft Window Server 2019 Datacenter'.
	LongName string `json:"longName,omitempty"`

	// OsconfigAgentVersion: The current version of the OS Config agent
	// running on the VM.
	OsconfigAgentVersion string `json:"osconfigAgentVersion,omitempty"`

	// ShortName: The operating system short name. For example, 'windows' or
	// 'debian'.
	ShortName string `json:"shortName,omitempty"`

	// Version: The version of the operating system.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Architecture") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *OsInfo) MarshalJSON() ([]byte, error) {
	type NoMethod OsInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// OutputConfig: Output configuration for export assets destination.
type OutputConfig struct {
	// BigqueryDestination: Destination on BigQuery. The output table stores
	// the fields in asset proto as columns in BigQuery.
	BigqueryDestination *BigQueryDestination `json:"bigqueryDestination,omitempty"`

	// GcsDestination: Destination on Cloud Storage.
	GcsDestination *GcsDestination `json:"gcsDestination,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryDestination")
	// to unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryDestination") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *OutputConfig) MarshalJSON() ([]byte, error) {
	type NoMethod OutputConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PartitionSpec: Specifications of BigQuery partitioned table as export
// destination.
type PartitionSpec struct {
	// PartitionKey: The partition key for BigQuery partitioned table.
	//
	// Possible values:
	//   "PARTITION_KEY_UNSPECIFIED" - Unspecified partition key. If used,
	// it means using non-partitioned table.
	//   "READ_TIME" - The time when the snapshot is taken. If specified as
	// partition key, the result table(s) is partitoned by the additional
	// timestamp column, readTime. If [read_time] in ExportAssetsRequest is
	// specified, the readTime column's value will be the same as it.
	// Otherwise, its value will be the current time that is used to take
	// the snapshot.
	//   "REQUEST_TIME" - The time when the request is received and started
	// to be processed. If specified as partition key, the result table(s)
	// is partitoned by the requestTime column, an additional timestamp
	// column representing when the request was received.
	PartitionKey string `json:"partitionKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PartitionKey") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PartitionKey") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PartitionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod PartitionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Permissions: IAM permissions
type Permissions struct {
	// Permissions: A list of permissions. A sample permission string:
	// `compute.disk.get`.
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Permissions) MarshalJSON() ([]byte, error) {
	type NoMethod Permissions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members` to
// a single `role`. Members can be user accounts, service accounts,
// Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical
// expression that allows access to a resource only if the expression
// evaluates to `true`. A condition can add constraints based on
// attributes of the request, the resource, or both. To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
// **JSON example:** { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= - version:
// 3 For a description of IAM and its features, see the IAM
// documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of `members` to a `role`. Optionally, may
	// specify a `condition` that determines how and when the `bindings` are
	// applied. Each of the `bindings` must contain at least one member.
	Bindings []*Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the `etag`
	// in the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An `etag` is returned in the response to
	// `getIamPolicy`, and systems are expected to put that etag in the
	// request to `setIamPolicy` to ensure that their change will be applied
	// to the same version of the policy. **Important:** If you use IAM
	// Conditions, you must include the `etag` field whenever you call
	// `setIamPolicy`. If you omit this field, then IAM allows you to
	// overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy. Valid values are `0`,
	// `1`, and `3`. Requests that specify an invalid value are rejected.
	// Any operation that affects conditional role bindings must specify
	// version `3`. This requirement applies to the following operations: *
	// Getting a policy that includes a conditional role binding * Adding a
	// conditional role binding to a policy * Changing a conditional role
	// binding in a policy * Removing any role binding, with or without a
	// condition, from a policy that includes conditions **Important:** If
	// you use IAM Conditions, you must include the `etag` field whenever
	// you call `setIamPolicy`. If you omit this field, then IAM allows you
	// to overwrite a version `3` policy with a version `1` policy, and all
	// of the conditions in the version `3` policy are lost. If a policy
	// does not include any conditions, operations on that policy may
	// specify any valid version or leave the field unset. To learn which
	// resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PubsubDestination: A Pub/Sub destination.
type PubsubDestination struct {
	// Topic: The name of the Pub/Sub topic to publish to. Example:
	// `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic string `json:"topic,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Topic") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Topic") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PubsubDestination) MarshalJSON() ([]byte, error) {
	type NoMethod PubsubDestination
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Resource: A representation of a Google Cloud resource.
type Resource struct {
	// Data: The content of the resource, in which some sensitive fields are
	// removed and may not be present.
	Data googleapi.RawMessage `json:"data,omitempty"`

	// DiscoveryDocumentUri: The URL of the discovery document containing
	// the resource's JSON schema. Example:
	// `https://www.googleapis.com/discovery/v1/apis/compute/v1/rest` This
	// value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryDocumentUri string `json:"discoveryDocumentUri,omitempty"`

	// DiscoveryName: The JSON schema name listed in the discovery document.
	// Example: `Project` This value is unspecified for resources that do
	// not have an API based on a discovery document, such as Cloud
	// Bigtable.
	DiscoveryName string `json:"discoveryName,omitempty"`

	// Location: The location of the resource in Google Cloud, such as its
	// zone and region. For more information, see
	// https://cloud.google.com/about/locations/.
	Location string `json:"location,omitempty"`

	// Parent: The full name of the immediate parent of this resource. See
	// Resource Names
	// (https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information. For Google Cloud assets, this value is the
	// parent resource defined in the Cloud IAM policy hierarchy
	// (https://cloud.google.com/iam/docs/overview#policy_hierarchy).
	// Example:
	// `//cloudresourcemanager.googleapis.com/projects/my_project_123` For
	// third-party assets, this field may be set differently.
	Parent string `json:"parent,omitempty"`

	// ResourceUrl: The REST URL for accessing the resource. An HTTP `GET`
	// request using this URL returns the resource itself. Example:
	// `https://cloudresourcemanager.googleapis.com/v1/projects/my-project-12
	// 3` This value is unspecified for resources without a REST API.
	ResourceUrl string `json:"resourceUrl,omitempty"`

	// Version: The API version. Example: `v1`
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Resource) MarshalJSON() ([]byte, error) {
	type NoMethod Resource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceSearchResult: A result of Resource Search, containing
// information of a cloud resource.
type ResourceSearchResult struct {
	// AdditionalAttributes: The additional searchable attributes of this
	// resource. The attributes may vary from one resource type to another.
	// Examples: `projectId` for Project, `dnsName` for DNS ManagedZone.
	// This field contains a subset of the resource metadata fields that are
	// returned by the List or Get APIs provided by the corresponding GCP
	// service (e.g., Compute Engine). see API references and supported
	// searchable attributes
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types)
	// to see which fields are included. You can search values of these
	// fields through free text search. However, you should not consume the
	// field programically as the field names and values may change as the
	// GCP service updates to a new incompatible API version. To search
	// against the `additional_attributes`: * use a free text query to match
	// the attributes values. Example: to search `additional_attributes = {
	// dnsName: "foobar" }`, you can issue a query `foobar`.
	AdditionalAttributes googleapi.RawMessage `json:"additionalAttributes,omitempty"`

	// AssetType: The type of this resource. Example:
	// `compute.googleapis.com/Disk`. To search against the `asset_type`: *
	// specify the `asset_type` field in your search request.
	AssetType string `json:"assetType,omitempty"`

	// CreateTime: The create timestamp of this resource, at which the
	// resource was created. The granularity is in seconds. Timestamp.nanos
	// will always be 0. This field is available only when the resource's
	// proto contains it. To search against `create_time`: * use a field
	// query (value in seconds). Example: `createTime >= 1594294238`
	CreateTime string `json:"createTime,omitempty"`

	// Description: One or more paragraphs of text description of this
	// resource. Maximum length could be up to 1M bytes. This field is
	// available only when the resource's proto contains it. To search
	// against the `description`: * use a field query. Example:
	// `description:"important instance" * use a free text query. Example:
	// "important instance"
	Description string `json:"description,omitempty"`

	// DisplayName: The display name of this resource. This field is
	// available only when the resource's proto contains it. To search
	// against the `display_name`: * use a field query. Example:
	// `displayName:"My Instance" * use a free text query. Example: "My
	// Instance"
	DisplayName string `json:"displayName,omitempty"`

	// Folders: The folder(s) that this resource belongs to, in the form of
	// folders/{FOLDER_NUMBER}. This field is available when the resource
	// belongs to one or more folders. To search against `folders`: * use a
	// field query. Example: `folders:(123 OR 456)` * specify the `scope`
	// field as this folder in your search request.
	Folders []string `json:"folders,omitempty"`

	// KmsKey: The Cloud KMS CryptoKey
	// (https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys?hl=en)
	// name or CryptoKeyVersion
	// (https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
	// name. This field is available only when the resource's proto contains
	// it. To search against the `kms_key`: * use a field query. Example:
	// `kmsKey:key` * use a free text query. Example: `key`
	KmsKey string `json:"kmsKey,omitempty"`

	// Labels: Labels associated with this resource. See Labelling and
	// grouping GCP resources
	// (https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
	// for more information. This field is available only when the
	// resource's proto contains it. To search against the `labels`: * use a
	// field query: - query on any label's key or value. Example:
	// `labels:prod` - query by a given label. Example: `labels.env:prod` -
	// query by a given label's existence. Example: `labels.env:*` * use a
	// free text query. Example: `prod`
	Labels map[string]string `json:"labels,omitempty"`

	// Location: Location can be `global`, regional like `us-east1`, or
	// zonal like `us-west1-b`. This field is available only when the
	// resource's proto contains it. To search against the `location`: * use
	// a field query. Example: `location:us-west*` * use a free text query.
	// Example: `us-west*`
	Location string `json:"location,omitempty"`

	// Name: The full resource name of this resource. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instance
	// s/instance1`. See Cloud Asset Inventory Resource Name Format
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information. To search against the `name`: * use a field
	// query. Example: `name:instance1` * use a free text query. Example:
	// `instance1`
	Name string `json:"name,omitempty"`

	// NetworkTags: Network tags associated with this resource. Like labels,
	// network tags are a type of annotations used to group GCP resources.
	// See Labelling GCP resources
	// (https://cloud.google.com/blog/products/gcp/labelling-and-grouping-your-google-cloud-platform-resources)
	// for more information. This field is available only when the
	// resource's proto contains it. To search against the `network_tags`: *
	// use a field query. Example: `networkTags:internal` * use a free text
	// query. Example: `internal`
	NetworkTags []string `json:"networkTags,omitempty"`

	// Organization: The organization that this resource belongs to, in the
	// form of organizations/{ORGANIZATION_NUMBER}. This field is available
	// when the resource belongs to an organization. To search against
	// `organization`: * use a field query. Example: `organization:123` *
	// specify the `scope` field as this organization in your search
	// request.
	Organization string `json:"organization,omitempty"`

	// Project: The project that this resource belongs to, in the form of
	// projects/{PROJECT_NUMBER}. This field is available when the resource
	// belongs to a project. To search against `project`: * use a field
	// query. Example: `project:12345` * specify the `scope` field as this
	// project in your search request.
	Project string `json:"project,omitempty"`

	// State: The state of this resource. Different resources types have
	// different state definitions that are mapped from various fields of
	// different resource types. This field is available only when the
	// resource's proto contains it. Example: If the resource is an instance
	// provided by Compute Engine, its state will include PROVISIONING,
	// STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and
	// TERMINATED. See `status` definition in API Reference
	// (https://cloud.google.com/compute/docs/reference/rest/v1/instances).
	// If the resource is a project provided by Cloud Resource Manager, its
	// state will include LIFECYCLE_STATE_UNSPECIFIED, ACTIVE,
	// DELETE_REQUESTED and DELETE_IN_PROGRESS. See `lifecycleState`
	// definition in API Reference
	// (https://cloud.google.com/resource-manager/reference/rest/v1/projects).
	// To search against the `state`: * use a field query. Example:
	// `state:RUNNING` * use a free text query. Example: `RUNNING`
	State string `json:"state,omitempty"`

	// UpdateTime: The last update timestamp of this resource, at which the
	// resource was last modified or deleted. The granularity is in seconds.
	// Timestamp.nanos will always be 0. This field is available only when
	// the resource's proto contains it. To search against `update_time`: *
	// use a field query (value in seconds). Example: `updateTime <
	// 1594294238`
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AdditionalAttributes") to unconditionally include in API requests.
	// By default, fields with empty values are omitted from API requests.
	// However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalAttributes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ResourceSearchResult) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceSearchResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ResourceSelector: Specifies the resource to analyze for access
// policies, which may be set directly on the resource, or on ancestors
// such as organizations, folders or projects.
type ResourceSelector struct {
	// FullResourceName: Required. The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of a resource of supported resource types
	// (https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
	FullResourceName string `json:"fullResourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FullResourceName") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FullResourceName") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *ResourceSelector) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceSelector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchAllIamPoliciesResponse: Search all IAM policies response.
type SearchAllIamPoliciesResponse struct {
	// NextPageToken: Set if there are more results than those appearing in
	// this response; to get the next set of results, call this method
	// again, using this value as the `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: A list of IamPolicy that match the search query. Related
	// information such as the associated resource is returned along with
	// the policy.
	Results []*IamPolicySearchResult `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchAllIamPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchAllIamPoliciesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchAllResourcesResponse: Search all resources response.
type SearchAllResourcesResponse struct {
	// NextPageToken: If there are more results than those appearing in this
	// response, then `next_page_token` is included. To get the next set of
	// results, call this method again using the value of `next_page_token`
	// as `page_token`.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: A list of Resources that match the search query. It contains
	// the resource standard metadata information.
	Results []*ResourceSearchResult `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchAllResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchAllResourcesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SoftwarePackage: Software package information of the operating
// system.
type SoftwarePackage struct {
	// AptPackage: Details of an APT package. For details about the apt
	// package manager, see https://wiki.debian.org/Apt.
	AptPackage *VersionedPackage `json:"aptPackage,omitempty"`

	// CosPackage: Details of a COS package.
	CosPackage *VersionedPackage `json:"cosPackage,omitempty"`

	// GoogetPackage: Details of a Googet package. For details about the
	// googet package manager, see https://github.com/google/googet.
	GoogetPackage *VersionedPackage `json:"googetPackage,omitempty"`

	// QfePackage: Details of a Windows Quick Fix engineering package. See
	// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
	// for info in Windows Quick Fix Engineering.
	QfePackage *WindowsQuickFixEngineeringPackage `json:"qfePackage,omitempty"`

	// WuaPackage: Details of a Windows Update package. See
	// https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
	// information about Windows Update.
	WuaPackage *WindowsUpdatePackage `json:"wuaPackage,omitempty"`

	// YumPackage: Yum package info. For details about the yum package
	// manager, see
	// https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
	YumPackage *VersionedPackage `json:"yumPackage,omitempty"`

	// ZypperPackage: Details of a Zypper package. For details about the
	// Zypper package manager, see
	// https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPackage *VersionedPackage `json:"zypperPackage,omitempty"`

	// ZypperPatch: Details of a Zypper patch. For details about the Zypper
	// package manager, see https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPatch *ZypperPatch `json:"zypperPatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AptPackage") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AptPackage") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SoftwarePackage) MarshalJSON() ([]byte, error) {
	type NoMethod SoftwarePackage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TemporalAsset: An asset in Google Cloud and its temporal metadata,
// including the time window when it was observed and its status during
// that window.
type TemporalAsset struct {
	// Asset: An asset in Google Cloud.
	Asset *Asset `json:"asset,omitempty"`

	// Deleted: Whether the asset has been deleted or not.
	Deleted bool `json:"deleted,omitempty"`

	// PriorAsset: Prior copy of the asset. Populated if prior_asset_state
	// is PRESENT. Currently this is only set for responses in Real-Time
	// Feed.
	PriorAsset *Asset `json:"priorAsset,omitempty"`

	// PriorAssetState: State of prior_asset.
	//
	// Possible values:
	//   "PRIOR_ASSET_STATE_UNSPECIFIED" - prior_asset is not applicable for
	// the current asset.
	//   "PRESENT" - prior_asset is populated correctly.
	//   "INVALID" - Failed to set prior_asset.
	//   "DOES_NOT_EXIST" - Current asset is the first known state.
	//   "DELETED" - prior_asset is a deletion.
	PriorAssetState string `json:"priorAssetState,omitempty"`

	// Window: The time window when the asset data and state was observed.
	Window *TimeWindow `json:"window,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TemporalAsset) MarshalJSON() ([]byte, error) {
	type NoMethod TemporalAsset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TimeWindow: A time window specified by its `start_time` and
// `end_time`.
type TimeWindow struct {
	// EndTime: End time of the time window (inclusive). If not specified,
	// the current timestamp is used instead.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: Start time of the time window (exclusive).
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TimeWindow) MarshalJSON() ([]byte, error) {
	type NoMethod TimeWindow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateFeedRequest: Update asset feed request.
type UpdateFeedRequest struct {
	// Feed: Required. The new values of feed details. It must match an
	// existing feed and the field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `json:"feed,omitempty"`

	// UpdateMask: Required. Only updates the `feed` fields indicated by
	// this mask. The field mask must not be empty, and it must not contain
	// fields that are immutable or only set by the server.
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Feed") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Feed") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateFeedRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateFeedRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// VersionedPackage: Information related to the a standard versioned
// package. This includes package info for APT, Yum, Zypper, and Googet
// package managers.
type VersionedPackage struct {
	// Architecture: The system architecture this package is intended for.
	Architecture string `json:"architecture,omitempty"`

	// PackageName: The name of the package.
	PackageName string `json:"packageName,omitempty"`

	// Version: The version of the package.
	Version string `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Architecture") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Architecture") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *VersionedPackage) MarshalJSON() ([]byte, error) {
	type NoMethod VersionedPackage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WindowsQuickFixEngineeringPackage: Information related to a Quick Fix
// Engineering package. Fields are taken from Windows
// QuickFixEngineering Interface and match the source names:
// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
type WindowsQuickFixEngineeringPackage struct {
	// Caption: A short textual description of the QFE update.
	Caption string `json:"caption,omitempty"`

	// Description: A textual description of the QFE update.
	Description string `json:"description,omitempty"`

	// HotFixId: Unique identifier associated with a particular QFE update.
	HotFixId string `json:"hotFixId,omitempty"`

	// InstallTime: Date that the QFE update was installed. Mapped from
	// installed_on field.
	InstallTime string `json:"installTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Caption") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Caption") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WindowsQuickFixEngineeringPackage) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsQuickFixEngineeringPackage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WindowsUpdateCategory: Categories specified by the Windows Update.
type WindowsUpdateCategory struct {
	// Id: The identifier of the windows update category.
	Id string `json:"id,omitempty"`

	// Name: The name of the windows update category.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WindowsUpdateCategory) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsUpdateCategory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WindowsUpdatePackage: Details related to a Windows Update package.
// Field data and names are taken from Windows Update API IUpdate
// Interface: https://docs.microsoft.com/en-us/windows/win32/api/_wua/
// Descriptive fields like title, and description are localized based on
// the locale of the VM being updated.
type WindowsUpdatePackage struct {
	// Categories: The categories that are associated with this update
	// package.
	Categories []*WindowsUpdateCategory `json:"categories,omitempty"`

	// Description: The localized description of the update package.
	Description string `json:"description,omitempty"`

	// KbArticleIds: A collection of Microsoft Knowledge Base article IDs
	// that are associated with the update package.
	KbArticleIds []string `json:"kbArticleIds,omitempty"`

	// LastDeploymentChangeTime: The last published date of the update, in
	// (UTC) date and time.
	LastDeploymentChangeTime string `json:"lastDeploymentChangeTime,omitempty"`

	// MoreInfoUrls: A collection of URLs that provide more information
	// about the update package.
	MoreInfoUrls []string `json:"moreInfoUrls,omitempty"`

	// RevisionNumber: The revision number of this update package.
	RevisionNumber int64 `json:"revisionNumber,omitempty"`

	// SupportUrl: A hyperlink to the language-specific support information
	// for the update.
	SupportUrl string `json:"supportUrl,omitempty"`

	// Title: The localized title of the update package.
	Title string `json:"title,omitempty"`

	// UpdateId: Gets the identifier of an update package. Stays the same
	// across revisions.
	UpdateId string `json:"updateId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Categories") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WindowsUpdatePackage) MarshalJSON() ([]byte, error) {
	type NoMethod WindowsUpdatePackage
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ZypperPatch: Details related to a Zypper Patch.
type ZypperPatch struct {
	// Category: The category of the patch.
	Category string `json:"category,omitempty"`

	// PatchName: The name of the patch.
	PatchName string `json:"patchName,omitempty"`

	// Severity: The severity specified for this patch
	Severity string `json:"severity,omitempty"`

	// Summary: Any summary information provided about this patch.
	Summary string `json:"summary,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with
	// empty values are omitted from API requests. However, any non-pointer,
	// non-interface field appearing in ForceSendFields will be sent to the
	// server regardless of whether the field is empty or not. This may be
	// used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Category") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ZypperPatch) MarshalJSON() ([]byte, error) {
	type NoMethod ZypperPatch
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "cloudasset.feeds.create":

type FeedsCreateCall struct {
	s                 *Service
	parent            string
	createfeedrequest *CreateFeedRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates a feed in a parent project/folder/organization to
// listen to its asset updates.
func (r *FeedsService) Create(parent string, createfeedrequest *CreateFeedRequest) *FeedsCreateCall {
	c := &FeedsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.createfeedrequest = createfeedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FeedsCreateCall) Fields(s ...googleapi.Field) *FeedsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FeedsCreateCall) Context(ctx context.Context) *FeedsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FeedsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FeedsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createfeedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feeds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.feeds.create" call.
// Exactly one of *Feed or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Feed.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FeedsCreateCall) Do(opts ...googleapi.CallOption) (*Feed, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Feed{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a feed in a parent project/folder/organization to listen to its asset updates.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}/feeds",
	//   "httpMethod": "POST",
	//   "id": "cloudasset.feeds.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The name of the project/folder/organization where this feed should be created in. It can only be an organization number (such as \"organizations/123\"), a folder number (such as \"folders/123\"), a project ID (such as \"projects/my-project-id\")\", or a project number (such as \"projects/12345\").",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/feeds",
	//   "request": {
	//     "$ref": "CreateFeedRequest"
	//   },
	//   "response": {
	//     "$ref": "Feed"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.feeds.delete":

type FeedsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an asset feed.
func (r *FeedsService) Delete(name string) *FeedsDeleteCall {
	c := &FeedsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FeedsDeleteCall) Fields(s ...googleapi.Field) *FeedsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FeedsDeleteCall) Context(ctx context.Context) *FeedsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FeedsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FeedsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.feeds.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *FeedsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an asset feed.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}/feeds/{feedsId}",
	//   "httpMethod": "DELETE",
	//   "id": "cloudasset.feeds.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the feed and it must be in the format of: projects/project_number/feeds/feed_id folders/folder_number/feeds/feed_id organizations/organization_number/feeds/feed_id",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/feeds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.feeds.get":

type FeedsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets details about an asset feed.
func (r *FeedsService) Get(name string) *FeedsGetCall {
	c := &FeedsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FeedsGetCall) Fields(s ...googleapi.Field) *FeedsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FeedsGetCall) IfNoneMatch(entityTag string) *FeedsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FeedsGetCall) Context(ctx context.Context) *FeedsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FeedsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FeedsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.feeds.get" call.
// Exactly one of *Feed or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Feed.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FeedsGetCall) Do(opts ...googleapi.CallOption) (*Feed, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Feed{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets details about an asset feed.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}/feeds/{feedsId}",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.feeds.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the Feed and it must be in the format of: projects/project_number/feeds/feed_id folders/folder_number/feeds/feed_id organizations/organization_number/feeds/feed_id",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/feeds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Feed"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.feeds.list":

type FeedsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all asset feeds in a parent project/folder/organization.
func (r *FeedsService) List(parent string) *FeedsListCall {
	c := &FeedsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FeedsListCall) Fields(s ...googleapi.Field) *FeedsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *FeedsListCall) IfNoneMatch(entityTag string) *FeedsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FeedsListCall) Context(ctx context.Context) *FeedsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FeedsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FeedsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/feeds")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.feeds.list" call.
// Exactly one of *ListFeedsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListFeedsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *FeedsListCall) Do(opts ...googleapi.CallOption) (*ListFeedsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListFeedsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all asset feeds in a parent project/folder/organization.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}/feeds",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.feeds.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent project/folder/organization whose feeds are to be listed. It can only be using project/folder/organization number (such as \"folders/12345\")\", or a project ID (such as \"projects/my-project-id\").",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/feeds",
	//   "response": {
	//     "$ref": "ListFeedsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.feeds.patch":

type FeedsPatchCall struct {
	s                 *Service
	nameid            string
	updatefeedrequest *UpdateFeedRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Patch: Updates an asset feed configuration.
func (r *FeedsService) Patch(nameid string, updatefeedrequest *UpdateFeedRequest) *FeedsPatchCall {
	c := &FeedsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.nameid = nameid
	c.updatefeedrequest = updatefeedrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *FeedsPatchCall) Fields(s ...googleapi.Field) *FeedsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *FeedsPatchCall) Context(ctx context.Context) *FeedsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *FeedsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FeedsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.updatefeedrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.nameid,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.feeds.patch" call.
// Exactly one of *Feed or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Feed.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *FeedsPatchCall) Do(opts ...googleapi.CallOption) (*Feed, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Feed{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an asset feed configuration.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}/feeds/{feedsId}",
	//   "httpMethod": "PATCH",
	//   "id": "cloudasset.feeds.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The format will be projects/{project_number}/feeds/{client-assigned_feed_identifier} or folders/{folder_number}/feeds/{client-assigned_feed_identifier} or organizations/{organization_number}/feeds/{client-assigned_feed_identifier} The client-assigned feed identifier must be unique within the parent project/folder/organization.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/feeds/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "UpdateFeedRequest"
	//   },
	//   "response": {
	//     "$ref": "Feed"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.operations.get":

type OperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can
// use this method to poll the operation result at intervals as
// recommended by the API service.
func (r *OperationsService) Get(name string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.operations.get" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}/operations/{operationsId}/{operationsId1}",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.operations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The name of the operation resource.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/operations/[^/]+/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.analyzeIamPolicy":

type V1AnalyzeIamPolicyCall struct {
	s            *Service
	scope        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AnalyzeIamPolicy: Analyzes IAM policies to answer which identities
// have what accesses on which resources.
func (r *V1Service) AnalyzeIamPolicy(scope string) *V1AnalyzeIamPolicyCall {
	c := &V1AnalyzeIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.scope = scope
	return c
}

// AnalysisQueryAccessSelectorPermissions sets the optional parameter
// "analysisQuery.accessSelector.permissions": The permissions to appear
// in result.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryAccessSelectorPermissions(analysisQueryAccessSelectorPermissions ...string) *V1AnalyzeIamPolicyCall {
	c.urlParams_.SetMulti("analysisQuery.accessSelector.permissions", append([]string{}, analysisQueryAccessSelectorPermissions...))
	return c
}

// AnalysisQueryAccessSelectorRoles sets the optional parameter
// "analysisQuery.accessSelector.roles": The roles to appear in result.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryAccessSelectorRoles(analysisQueryAccessSelectorRoles ...string) *V1AnalyzeIamPolicyCall {
	c.urlParams_.SetMulti("analysisQuery.accessSelector.roles", append([]string{}, analysisQueryAccessSelectorRoles...))
	return c
}

// AnalysisQueryIdentitySelectorIdentity sets the optional parameter
// "analysisQuery.identitySelector.identity": Required. The identity
// appear in the form of members in IAM policy binding
// (https://cloud.google.com/iam/reference/rest/v1/Binding). The
// examples of supported forms are: "user:mike@example.com",
// "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com". Notice
// that wildcard characters (such as * and ?) are not supported. You
// must give a specific identity.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryIdentitySelectorIdentity(analysisQueryIdentitySelectorIdentity string) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.identitySelector.identity", analysisQueryIdentitySelectorIdentity)
	return c
}

// AnalysisQueryOptionsAnalyzeServiceAccountImpersonation sets the
// optional parameter
// "analysisQuery.options.analyzeServiceAccountImpersonation": If true,
// the response will include access analysis from identities to
// resources via service account impersonation. This is a very expensive
// operation, because many derived queries will be executed. We highly
// recommend you use AssetService.AnalyzeIamPolicyLongrunning rpc
// instead. For example, if the request analyzes for which resources
// user A has permission P, and there's an IAM policy states user A has
// iam.serviceAccounts.getAccessToken permission to a service account
// SA, and there's another IAM policy states service account SA has
// permission P to a GCP folder F, then user A potentially has access to
// the GCP folder F. And those advanced analysis results will be
// included in
// AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
// Another example, if the request analyzes for who has permission P to
// a GCP folder F, and there's an IAM policy states user A has
// iam.serviceAccounts.actAs permission to a service account SA, and
// there's another IAM policy states service account SA has permission P
// to the GCP folder F, then user A potentially has access to the GCP
// folder F. And those advanced analysis results will be included in
// AnalyzeIamPolicyResponse.service_account_impersonation_analysis.
// Default is false.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryOptionsAnalyzeServiceAccountImpersonation(analysisQueryOptionsAnalyzeServiceAccountImpersonation bool) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.options.analyzeServiceAccountImpersonation", fmt.Sprint(analysisQueryOptionsAnalyzeServiceAccountImpersonation))
	return c
}

// AnalysisQueryOptionsExpandGroups sets the optional parameter
// "analysisQuery.options.expandGroups": If true, the identities section
// of the result will expand any Google groups appearing in an IAM
// policy binding. If IamPolicyAnalysisQuery.identity_selector is
// specified, the identity in the result will be determined by the
// selector, and this flag is not allowed to set. Default is false.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryOptionsExpandGroups(analysisQueryOptionsExpandGroups bool) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.options.expandGroups", fmt.Sprint(analysisQueryOptionsExpandGroups))
	return c
}

// AnalysisQueryOptionsExpandResources sets the optional parameter
// "analysisQuery.options.expandResources": If true and
// IamPolicyAnalysisQuery.resource_selector is not specified, the
// resource section of the result will expand any resource attached to
// an IAM policy to include resources lower in the resource hierarchy.
// For example, if the request analyzes for which resources user A has
// permission P, and the results include an IAM policy with P on a GCP
// folder, the results will also include resources in that folder with
// permission P. If true and IamPolicyAnalysisQuery.resource_selector is
// specified, the resource section of the result will expand the
// specified resource to include resources lower in the resource
// hierarchy. Only project or lower resources are supported. Folder and
// organization resource cannot be used together with this option. For
// example, if the request analyzes for which users have permission P on
// a GCP project with this option enabled, the results will include all
// users who have permission P on that project or any lower resource.
// Default is false.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryOptionsExpandResources(analysisQueryOptionsExpandResources bool) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.options.expandResources", fmt.Sprint(analysisQueryOptionsExpandResources))
	return c
}

// AnalysisQueryOptionsExpandRoles sets the optional parameter
// "analysisQuery.options.expandRoles": If true, the access section of
// result will expand any roles appearing in IAM policy bindings to
// include their permissions. If IamPolicyAnalysisQuery.access_selector
// is specified, the access section of the result will be determined by
// the selector, and this flag is not allowed to set. Default is false.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryOptionsExpandRoles(analysisQueryOptionsExpandRoles bool) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.options.expandRoles", fmt.Sprint(analysisQueryOptionsExpandRoles))
	return c
}

// AnalysisQueryOptionsOutputGroupEdges sets the optional parameter
// "analysisQuery.options.outputGroupEdges": If true, the result will
// output group identity edges, starting from the binding's group
// members, to any expanded identities. Default is false.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryOptionsOutputGroupEdges(analysisQueryOptionsOutputGroupEdges bool) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.options.outputGroupEdges", fmt.Sprint(analysisQueryOptionsOutputGroupEdges))
	return c
}

// AnalysisQueryOptionsOutputResourceEdges sets the optional parameter
// "analysisQuery.options.outputResourceEdges": If true, the result will
// output resource edges, starting from the policy attached resource, to
// any expanded resources. Default is false.
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryOptionsOutputResourceEdges(analysisQueryOptionsOutputResourceEdges bool) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.options.outputResourceEdges", fmt.Sprint(analysisQueryOptionsOutputResourceEdges))
	return c
}

// AnalysisQueryResourceSelectorFullResourceName sets the optional
// parameter "analysisQuery.resourceSelector.fullResourceName":
// Required. The [full resource name]
// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
// of a resource of supported resource types
// (https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
func (c *V1AnalyzeIamPolicyCall) AnalysisQueryResourceSelectorFullResourceName(analysisQueryResourceSelectorFullResourceName string) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("analysisQuery.resourceSelector.fullResourceName", analysisQueryResourceSelectorFullResourceName)
	return c
}

// ExecutionTimeout sets the optional parameter "executionTimeout":
// Amount of time executable has to complete. See JSON representation of
// Duration
// (https://developers.google.com/protocol-buffers/docs/proto3#json). If
// this field is set with a value less than the RPC deadline, and the
// execution of your query hasn't finished in the specified execution
// timeout, you will get a response with partial result. Otherwise, your
// query's execution will continue until the RPC deadline. If it's not
// finished until then, you will get a DEADLINE_EXCEEDED error. Default
// is empty.
func (c *V1AnalyzeIamPolicyCall) ExecutionTimeout(executionTimeout string) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("executionTimeout", executionTimeout)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1AnalyzeIamPolicyCall) Fields(s ...googleapi.Field) *V1AnalyzeIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *V1AnalyzeIamPolicyCall) IfNoneMatch(entityTag string) *V1AnalyzeIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1AnalyzeIamPolicyCall) Context(ctx context.Context) *V1AnalyzeIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1AnalyzeIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1AnalyzeIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+scope}:analyzeIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"scope": c.scope,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.analyzeIamPolicy" call.
// Exactly one of *AnalyzeIamPolicyResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *AnalyzeIamPolicyResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *V1AnalyzeIamPolicyCall) Do(opts ...googleapi.CallOption) (*AnalyzeIamPolicyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &AnalyzeIamPolicyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Analyzes IAM policies to answer which identities have what accesses on which resources.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}:analyzeIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.analyzeIamPolicy",
	//   "parameterOrder": [
	//     "scope"
	//   ],
	//   "parameters": {
	//     "analysisQuery.accessSelector.permissions": {
	//       "description": "Optional. The permissions to appear in result.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "analysisQuery.accessSelector.roles": {
	//       "description": "Optional. The roles to appear in result.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "analysisQuery.identitySelector.identity": {
	//       "description": "Required. The identity appear in the form of members in [IAM policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding). The examples of supported forms are: \"user:mike@example.com\", \"group:admins@example.com\", \"domain:google.com\", \"serviceAccount:my-project-id@appspot.gserviceaccount.com\". Notice that wildcard characters (such as * and ?) are not supported. You must give a specific identity.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "analysisQuery.options.analyzeServiceAccountImpersonation": {
	//       "description": "Optional. If true, the response will include access analysis from identities to resources via service account impersonation. This is a very expensive operation, because many derived queries will be executed. We highly recommend you use AssetService.AnalyzeIamPolicyLongrunning rpc instead. For example, if the request analyzes for which resources user A has permission P, and there's an IAM policy states user A has iam.serviceAccounts.getAccessToken permission to a service account SA, and there's another IAM policy states service account SA has permission P to a GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another example, if the request analyzes for who has permission P to a GCP folder F, and there's an IAM policy states user A has iam.serviceAccounts.actAs permission to a service account SA, and there's another IAM policy states service account SA has permission P to the GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "analysisQuery.options.expandGroups": {
	//       "description": "Optional. If true, the identities section of the result will expand any Google groups appearing in an IAM policy binding. If IamPolicyAnalysisQuery.identity_selector is specified, the identity in the result will be determined by the selector, and this flag is not allowed to set. Default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "analysisQuery.options.expandResources": {
	//       "description": "Optional. If true and IamPolicyAnalysisQuery.resource_selector is not specified, the resource section of the result will expand any resource attached to an IAM policy to include resources lower in the resource hierarchy. For example, if the request analyzes for which resources user A has permission P, and the results include an IAM policy with P on a GCP folder, the results will also include resources in that folder with permission P. If true and IamPolicyAnalysisQuery.resource_selector is specified, the resource section of the result will expand the specified resource to include resources lower in the resource hierarchy. Only project or lower resources are supported. Folder and organization resource cannot be used together with this option. For example, if the request analyzes for which users have permission P on a GCP project with this option enabled, the results will include all users who have permission P on that project or any lower resource. Default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "analysisQuery.options.expandRoles": {
	//       "description": "Optional. If true, the access section of result will expand any roles appearing in IAM policy bindings to include their permissions. If IamPolicyAnalysisQuery.access_selector is specified, the access section of the result will be determined by the selector, and this flag is not allowed to set. Default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "analysisQuery.options.outputGroupEdges": {
	//       "description": "Optional. If true, the result will output group identity edges, starting from the binding's group members, to any expanded identities. Default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "analysisQuery.options.outputResourceEdges": {
	//       "description": "Optional. If true, the result will output resource edges, starting from the policy attached resource, to any expanded resources. Default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "analysisQuery.resourceSelector.fullResourceName": {
	//       "description": "Required. The [full resource name] (https://cloud.google.com/asset-inventory/docs/resource-name-format) of a resource of [supported resource types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "executionTimeout": {
	//       "description": "Optional. Amount of time executable has to complete. See JSON representation of [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json). If this field is set with a value less than the RPC deadline, and the execution of your query hasn't finished in the specified execution timeout, you will get a response with partial result. Otherwise, your query's execution will continue until the RPC deadline. If it's not finished until then, you will get a DEADLINE_EXCEEDED error. Default is empty.",
	//       "format": "google-duration",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "scope": {
	//       "description": "Required. The relative name of the root asset. Only resources and IAM policies within the scope will be analyzed. This can only be an organization number (such as \"organizations/123\"), a folder number (such as \"folders/123\"), a project ID (such as \"projects/my-project-id\"), or a project number (such as \"projects/12345\"). To know how to get organization id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id). To know how to get folder or project id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+scope}:analyzeIamPolicy",
	//   "response": {
	//     "$ref": "AnalyzeIamPolicyResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.analyzeIamPolicyLongrunning":

type V1AnalyzeIamPolicyLongrunningCall struct {
	s                                  *Service
	scope                              string
	analyzeiampolicylongrunningrequest *AnalyzeIamPolicyLongrunningRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// AnalyzeIamPolicyLongrunning: Analyzes IAM policies asynchronously to
// answer which identities have what accesses on which resources, and
// writes the analysis results to a Google Cloud Storage or a BigQuery
// destination. For Cloud Storage destination, the output format is the
// JSON format that represents a AnalyzeIamPolicyResponse. This method
// implements the google.longrunning.Operation, which allows you to
// track the operation status. We recommend intervals of at least 2
// seconds with exponential backoff retry to poll the operation result.
// The metadata contains the request to help callers to map responses to
// requests.
func (r *V1Service) AnalyzeIamPolicyLongrunning(scope string, analyzeiampolicylongrunningrequest *AnalyzeIamPolicyLongrunningRequest) *V1AnalyzeIamPolicyLongrunningCall {
	c := &V1AnalyzeIamPolicyLongrunningCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.scope = scope
	c.analyzeiampolicylongrunningrequest = analyzeiampolicylongrunningrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1AnalyzeIamPolicyLongrunningCall) Fields(s ...googleapi.Field) *V1AnalyzeIamPolicyLongrunningCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1AnalyzeIamPolicyLongrunningCall) Context(ctx context.Context) *V1AnalyzeIamPolicyLongrunningCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1AnalyzeIamPolicyLongrunningCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1AnalyzeIamPolicyLongrunningCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.analyzeiampolicylongrunningrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+scope}:analyzeIamPolicyLongrunning")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"scope": c.scope,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.analyzeIamPolicyLongrunning" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1AnalyzeIamPolicyLongrunningCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Analyzes IAM policies asynchronously to answer which identities have what accesses on which resources, and writes the analysis results to a Google Cloud Storage or a BigQuery destination. For Cloud Storage destination, the output format is the JSON format that represents a AnalyzeIamPolicyResponse. This method implements the google.longrunning.Operation, which allows you to track the operation status. We recommend intervals of at least 2 seconds with exponential backoff retry to poll the operation result. The metadata contains the request to help callers to map responses to requests.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}:analyzeIamPolicyLongrunning",
	//   "httpMethod": "POST",
	//   "id": "cloudasset.analyzeIamPolicyLongrunning",
	//   "parameterOrder": [
	//     "scope"
	//   ],
	//   "parameters": {
	//     "scope": {
	//       "description": "Required. The relative name of the root asset. Only resources and IAM policies within the scope will be analyzed. This can only be an organization number (such as \"organizations/123\"), a folder number (such as \"folders/123\"), a project ID (such as \"projects/my-project-id\"), or a project number (such as \"projects/12345\"). To know how to get organization id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id). To know how to get folder or project id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+scope}:analyzeIamPolicyLongrunning",
	//   "request": {
	//     "$ref": "AnalyzeIamPolicyLongrunningRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.batchGetAssetsHistory":

type V1BatchGetAssetsHistoryCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// BatchGetAssetsHistory: Batch gets the update history of assets that
// overlap a time window. For IAM_POLICY content, this API outputs
// history when the asset and its attached IAM POLICY both exist. This
// can create gaps in the output history. Otherwise, this API outputs
// history with asset in both non-delete or deleted status. If a
// specified asset does not exist, this API returns an INVALID_ARGUMENT
// error.
func (r *V1Service) BatchGetAssetsHistory(parent string) *V1BatchGetAssetsHistoryCall {
	c := &V1BatchGetAssetsHistoryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// AssetNames sets the optional parameter "assetNames": A list of the
// full names of the assets. See:
// https://cloud.google.com/asset-inventory/docs/resource-name-format
// Example:
// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instance
// s/instance1`. The request becomes a no-op if the asset name list is
// empty, and the max size of the asset name list is 100 in one request.
func (c *V1BatchGetAssetsHistoryCall) AssetNames(assetNames ...string) *V1BatchGetAssetsHistoryCall {
	c.urlParams_.SetMulti("assetNames", append([]string{}, assetNames...))
	return c
}

// ContentType sets the optional parameter "contentType": The content
// type.
//
// Possible values:
//   "CONTENT_TYPE_UNSPECIFIED" - Unspecified content type.
//   "RESOURCE" - Resource metadata.
//   "IAM_POLICY" - The actual IAM policy set on a resource.
//   "ORG_POLICY" - The Cloud Organization Policy set on an asset.
//   "ACCESS_POLICY" - The Cloud Access context manager Policy set on an
// asset.
//   "OS_INVENTORY" - The runtime OS Inventory information.
func (c *V1BatchGetAssetsHistoryCall) ContentType(contentType string) *V1BatchGetAssetsHistoryCall {
	c.urlParams_.Set("contentType", contentType)
	return c
}

// ReadTimeWindowEndTime sets the optional parameter
// "readTimeWindow.endTime": End time of the time window (inclusive). If
// not specified, the current timestamp is used instead.
func (c *V1BatchGetAssetsHistoryCall) ReadTimeWindowEndTime(readTimeWindowEndTime string) *V1BatchGetAssetsHistoryCall {
	c.urlParams_.Set("readTimeWindow.endTime", readTimeWindowEndTime)
	return c
}

// ReadTimeWindowStartTime sets the optional parameter
// "readTimeWindow.startTime": Start time of the time window
// (exclusive).
func (c *V1BatchGetAssetsHistoryCall) ReadTimeWindowStartTime(readTimeWindowStartTime string) *V1BatchGetAssetsHistoryCall {
	c.urlParams_.Set("readTimeWindow.startTime", readTimeWindowStartTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1BatchGetAssetsHistoryCall) Fields(s ...googleapi.Field) *V1BatchGetAssetsHistoryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *V1BatchGetAssetsHistoryCall) IfNoneMatch(entityTag string) *V1BatchGetAssetsHistoryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1BatchGetAssetsHistoryCall) Context(ctx context.Context) *V1BatchGetAssetsHistoryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1BatchGetAssetsHistoryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1BatchGetAssetsHistoryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:batchGetAssetsHistory")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.batchGetAssetsHistory" call.
// Exactly one of *BatchGetAssetsHistoryResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *BatchGetAssetsHistoryResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *V1BatchGetAssetsHistoryCall) Do(opts ...googleapi.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &BatchGetAssetsHistoryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Batch gets the update history of assets that overlap a time window. For IAM_POLICY content, this API outputs history when the asset and its attached IAM POLICY both exist. This can create gaps in the output history. Otherwise, this API outputs history with asset in both non-delete or deleted status. If a specified asset does not exist, this API returns an INVALID_ARGUMENT error.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}:batchGetAssetsHistory",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.batchGetAssetsHistory",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "assetNames": {
	//       "description": "A list of the full names of the assets. See: https://cloud.google.com/asset-inventory/docs/resource-name-format Example: `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`. The request becomes a no-op if the asset name list is empty, and the max size of the asset name list is 100 in one request.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "contentType": {
	//       "description": "Optional. The content type.",
	//       "enum": [
	//         "CONTENT_TYPE_UNSPECIFIED",
	//         "RESOURCE",
	//         "IAM_POLICY",
	//         "ORG_POLICY",
	//         "ACCESS_POLICY",
	//         "OS_INVENTORY"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified content type.",
	//         "Resource metadata.",
	//         "The actual IAM policy set on a resource.",
	//         "The Cloud Organization Policy set on an asset.",
	//         "The Cloud Access context manager Policy set on an asset.",
	//         "The runtime OS Inventory information."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The relative name of the root asset. It can only be an organization number (such as \"organizations/123\"), a project ID (such as \"projects/my-project-id\")\", or a project number (such as \"projects/12345\").",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "readTimeWindow.endTime": {
	//       "description": "End time of the time window (inclusive). If not specified, the current timestamp is used instead.",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "readTimeWindow.startTime": {
	//       "description": "Start time of the time window (exclusive).",
	//       "format": "google-datetime",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}:batchGetAssetsHistory",
	//   "response": {
	//     "$ref": "BatchGetAssetsHistoryResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.exportAssets":

type V1ExportAssetsCall struct {
	s                   *Service
	parent              string
	exportassetsrequest *ExportAssetsRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// ExportAssets: Exports assets with time and resource types to a given
// Cloud Storage location/BigQuery table. For Cloud Storage location
// destinations, the output format is newline-delimited JSON. Each line
// represents a google.cloud.asset.v1.Asset in the JSON format; for
// BigQuery table destinations, the output table stores the fields in
// asset proto as columns. This API implements the
// google.longrunning.Operation API , which allows you to keep track of
// the export. We recommend intervals of at least 2 seconds with
// exponential retry to poll the export operation result. For
// regular-size resource parent, the export operation usually finishes
// within 5 minutes.
func (r *V1Service) ExportAssets(parent string, exportassetsrequest *ExportAssetsRequest) *V1ExportAssetsCall {
	c := &V1ExportAssetsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.exportassetsrequest = exportassetsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1ExportAssetsCall) Fields(s ...googleapi.Field) *V1ExportAssetsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1ExportAssetsCall) Context(ctx context.Context) *V1ExportAssetsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1ExportAssetsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1ExportAssetsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.exportassetsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}:exportAssets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.exportAssets" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1ExportAssetsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Exports assets with time and resource types to a given Cloud Storage location/BigQuery table. For Cloud Storage location destinations, the output format is newline-delimited JSON. Each line represents a google.cloud.asset.v1.Asset in the JSON format; for BigQuery table destinations, the output table stores the fields in asset proto as columns. This API implements the google.longrunning.Operation API , which allows you to keep track of the export. We recommend intervals of at least 2 seconds with exponential retry to poll the export operation result. For regular-size resource parent, the export operation usually finishes within 5 minutes.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}:exportAssets",
	//   "httpMethod": "POST",
	//   "id": "cloudasset.exportAssets",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The relative name of the root asset. This can only be an organization number (such as \"organizations/123\"), a project ID (such as \"projects/my-project-id\"), or a project number (such as \"projects/12345\"), or a folder number (such as \"folders/123\").",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}:exportAssets",
	//   "request": {
	//     "$ref": "ExportAssetsRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudasset.searchAllIamPolicies":

type V1SearchAllIamPoliciesCall struct {
	s            *Service
	scope        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchAllIamPolicies: Searches all IAM policies within the specified
// scope, such as a project, folder, or organization. The caller must be
// granted the `cloudasset.assets.searchAllIamPolicies` permission on
// the desired scope, otherwise the request will be rejected.
func (r *V1Service) SearchAllIamPolicies(scope string) *V1SearchAllIamPoliciesCall {
	c := &V1SearchAllIamPoliciesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.scope = scope
	return c
}

// PageSize sets the optional parameter "pageSize": The page size for
// search result pagination. Page size is capped at 500 even if a larger
// value is given. If set to zero, server will pick an appropriate
// default. Returned results may be fewer than requested. When this
// happens, there could be more results as long as `next_page_token` is
// returned.
func (c *V1SearchAllIamPoliciesCall) PageSize(pageSize int64) *V1SearchAllIamPoliciesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present,
// retrieve the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of all other method parameters must be
// identical to those in the previous call.
func (c *V1SearchAllIamPoliciesCall) PageToken(pageToken string) *V1SearchAllIamPoliciesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": The query statement. See
// how to construct a query
// (https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
// for more information. If not specified or empty, it will search all
// the IAM policies within the specified `scope`. Note that the query
// string is compared against each Cloud IAM policy binding, including
// its members, roles, and Cloud IAM conditions. The returned Cloud IAM
// policies will only contain the bindings that match your query. To
// learn more about the IAM policy structure, see IAM policy doc
// (https://cloud.google.com/iam/docs/policies#structure). Examples: *
// `policy:amy@gmail.com` to find IAM policy bindings that specify user
// "amy@gmail.com". * `policy:roles/compute.admin` to find IAM policy
// bindings that specify the Compute Admin role. * `policy:comp*` to
// find IAM policy bindings that contain "comp" as a prefix of any word
// in the binding. * `policy.role.permissions:storage.buckets.update` to
// find IAM policy bindings that specify a role containing
// "storage.buckets.update" permission. Note that if callers don't have
// `iam.roles.get` access to a role's included permissions, policy
// bindings that specify this role will be dropped from the search
// results. * `policy.role.permissions:upd*` to find IAM policy bindings
// that specify a role containing "upd" as a prefix of any word in the
// role permission. Note that if callers don't have `iam.roles.get`
// access to a role's included permissions, policy bindings that specify
// this role will be dropped from the search results. *
// `resource:organizations/123456` to find IAM policy bindings that are
// set on "organizations/123456". *
// `resource=//cloudresourcemanager.googleapis.com/projects/myproject`
// to find IAM policy bindings that are set on the project named
// "myproject". * `Important` to find IAM policy bindings that contain
// "Important" as a word in any of the searchable fields (except for the
// included permissions). * `resource:(instance1 OR instance2)
// policy:amy` to find IAM policy bindings that are set on resources
// "instance1" or "instance2" and also specify user "amy".
func (c *V1SearchAllIamPoliciesCall) Query(query string) *V1SearchAllIamPoliciesCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1SearchAllIamPoliciesCall) Fields(s ...googleapi.Field) *V1SearchAllIamPoliciesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *V1SearchAllIamPoliciesCall) IfNoneMatch(entityTag string) *V1SearchAllIamPoliciesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1SearchAllIamPoliciesCall) Context(ctx context.Context) *V1SearchAllIamPoliciesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1SearchAllIamPoliciesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1SearchAllIamPoliciesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+scope}:searchAllIamPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"scope": c.scope,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.searchAllIamPolicies" call.
// Exactly one of *SearchAllIamPoliciesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SearchAllIamPoliciesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *V1SearchAllIamPoliciesCall) Do(opts ...googleapi.CallOption) (*SearchAllIamPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchAllIamPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches all IAM policies within the specified scope, such as a project, folder, or organization. The caller must be granted the `cloudasset.assets.searchAllIamPolicies` permission on the desired scope, otherwise the request will be rejected.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}:searchAllIamPolicies",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.searchAllIamPolicies",
	//   "parameterOrder": [
	//     "scope"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. The page size for search result pagination. Page size is capped at 500 even if a larger value is given. If set to zero, server will pick an appropriate default. Returned results may be fewer than requested. When this happens, there could be more results as long as `next_page_token` is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, retrieve the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of all other method parameters must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Optional. The query statement. See [how to construct a query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query) for more information. If not specified or empty, it will search all the IAM policies within the specified `scope`. Note that the query string is compared against each Cloud IAM policy binding, including its members, roles, and Cloud IAM conditions. The returned Cloud IAM policies will only contain the bindings that match your query. To learn more about the IAM policy structure, see [IAM policy doc](https://cloud.google.com/iam/docs/policies#structure). Examples: * `policy:amy@gmail.com` to find IAM policy bindings that specify user \"amy@gmail.com\". * `policy:roles/compute.admin` to find IAM policy bindings that specify the Compute Admin role. * `policy:comp*` to find IAM policy bindings that contain \"comp\" as a prefix of any word in the binding. * `policy.role.permissions:storage.buckets.update` to find IAM policy bindings that specify a role containing \"storage.buckets.update\" permission. Note that if callers don't have `iam.roles.get` access to a role's included permissions, policy bindings that specify this role will be dropped from the search results. * `policy.role.permissions:upd*` to find IAM policy bindings that specify a role containing \"upd\" as a prefix of any word in the role permission. Note that if callers don't have `iam.roles.get` access to a role's included permissions, policy bindings that specify this role will be dropped from the search results. * `resource:organizations/123456` to find IAM policy bindings that are set on \"organizations/123456\". * `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to find IAM policy bindings that are set on the project named \"myproject\". * `Important` to find IAM policy bindings that contain \"Important\" as a word in any of the searchable fields (except for the included permissions). * `resource:(instance1 OR instance2) policy:amy` to find IAM policy bindings that are set on resources \"instance1\" or \"instance2\" and also specify user \"amy\".",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "scope": {
	//       "description": "Required. A scope can be a project, a folder, or an organization. The search is limited to the IAM policies within the `scope`. The caller must be granted the [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions) permission on the desired scope. The allowed values are: * projects/{PROJECT_ID} (e.g., \"projects/foo-bar\") * projects/{PROJECT_NUMBER} (e.g., \"projects/12345678\") * folders/{FOLDER_NUMBER} (e.g., \"folders/1234567\") * organizations/{ORGANIZATION_NUMBER} (e.g., \"organizations/123456\")",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+scope}:searchAllIamPolicies",
	//   "response": {
	//     "$ref": "SearchAllIamPoliciesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *V1SearchAllIamPoliciesCall) Pages(ctx context.Context, f func(*SearchAllIamPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudasset.searchAllResources":

type V1SearchAllResourcesCall struct {
	s            *Service
	scope        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchAllResources: Searches all Cloud resources within the specified
// scope, such as a project, folder, or organization. The caller must be
// granted the `cloudasset.assets.searchAllResources` permission on the
// desired scope, otherwise the request will be rejected.
func (r *V1Service) SearchAllResources(scope string) *V1SearchAllResourcesCall {
	c := &V1SearchAllResourcesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.scope = scope
	return c
}

// AssetTypes sets the optional parameter "assetTypes": A list of asset
// types that this request searches for. If empty, it will search all
// the searchable asset types
// (https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
// Regular expressions are also supported. For example: *
// "compute.googleapis.com.*" snapshots resources whose asset type
// starts with "compute.googleapis.com". * ".*Instance" snapshots
// resources whose asset type ends with "Instance". * ".*Instance.*"
// snapshots resources whose asset type contains "Instance". See RE2
// (https://github.com/google/re2/wiki/Syntax) for all supported regular
// expression syntax. If the regular expression does not match any
// supported asset type, an INVALID_ARGUMENT error will be returned.
func (c *V1SearchAllResourcesCall) AssetTypes(assetTypes ...string) *V1SearchAllResourcesCall {
	c.urlParams_.SetMulti("assetTypes", append([]string{}, assetTypes...))
	return c
}

// OrderBy sets the optional parameter "orderBy": A comma separated list
// of fields specifying the sorting order of the results. The default
// order is ascending. Add " DESC" after the field name to indicate
// descending order. Redundant space characters are ignored. Example:
// "location DESC, name". Only string fields in the response are
// sortable, including `name`, `displayName`, `description`, `location`.
// All the other fields such as repeated fields (e.g., `networkTags`),
// map fields (e.g., `labels`) and struct fields (e.g.,
// `additionalAttributes`) are not supported.
func (c *V1SearchAllResourcesCall) OrderBy(orderBy string) *V1SearchAllResourcesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The page size for
// search result pagination. Page size is capped at 500 even if a larger
// value is given. If set to zero, server will pick an appropriate
// default. Returned results may be fewer than requested. When this
// happens, there could be more results as long as `next_page_token` is
// returned.
func (c *V1SearchAllResourcesCall) PageSize(pageSize int64) *V1SearchAllResourcesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then
// retrieve the next batch of results from the preceding call to this
// method. `page_token` must be the value of `next_page_token` from the
// previous response. The values of all other method parameters, must be
// identical to those in the previous call.
func (c *V1SearchAllResourcesCall) PageToken(pageToken string) *V1SearchAllResourcesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": The query statement. See
// how to construct a query
// (https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
// for more information. If not specified or empty, it will search all
// the resources within the specified `scope`. Examples: *
// `name:Important` to find Cloud resources whose name contains
// "Important" as a word. * `name=Important` to find the Cloud resource
// whose name is exactly "Important". * `displayName:Impor*` to find
// Cloud resources whose display name contains "Impor" as a prefix of
// any word in the field. * `location:us-west*` to find Cloud resources
// whose location contains both "us" and "west" as prefixes. *
// `labels:prod` to find Cloud resources whose labels contain "prod" as
// a key or value. * `labels.env:prod` to find Cloud resources that have
// a label "env" and its value is "prod". * `labels.env:*` to find Cloud
// resources that have a label "env". * `kmsKey:key` to find Cloud
// resources encrypted with a customer-managed encryption key whose name
// contains the word "key". * `state:ACTIVE` to find Cloud resources
// whose state contains "ACTIVE" as a word. * `createTime<1609459200` to
// find Cloud resources that were created before "2021-01-01 00:00:00
// UTC". 1609459200 is the epoch timestamp of "2021-01-01 00:00:00 UTC"
// in seconds. * `updateTime>1609459200` to find Cloud resources that
// were updated after "2021-01-01 00:00:00 UTC". 1609459200 is the epoch
// timestamp of "2021-01-01 00:00:00 UTC" in seconds. * `Important` to
// find Cloud resources that contain "Important" as a word in any of the
// searchable fields. * `Impor*` to find Cloud resources that contain
// "Impor" as a prefix of any word in any of the searchable fields. *
// `Important location:(us-west1 OR global)` to find Cloud resources
// that contain "Important" as a word in any of the searchable fields
// and are also located in the "us-west1" region or the "global"
// location.
func (c *V1SearchAllResourcesCall) Query(query string) *V1SearchAllResourcesCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *V1SearchAllResourcesCall) Fields(s ...googleapi.Field) *V1SearchAllResourcesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *V1SearchAllResourcesCall) IfNoneMatch(entityTag string) *V1SearchAllResourcesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *V1SearchAllResourcesCall) Context(ctx context.Context) *V1SearchAllResourcesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *V1SearchAllResourcesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1SearchAllResourcesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20210211")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+scope}:searchAllResources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"scope": c.scope,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudasset.searchAllResources" call.
// Exactly one of *SearchAllResourcesResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *SearchAllResourcesResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *V1SearchAllResourcesCall) Do(opts ...googleapi.CallOption) (*SearchAllResourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchAllResourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches all Cloud resources within the specified scope, such as a project, folder, or organization. The caller must be granted the `cloudasset.assets.searchAllResources` permission on the desired scope, otherwise the request will be rejected.",
	//   "flatPath": "v1/{v1Id}/{v1Id1}:searchAllResources",
	//   "httpMethod": "GET",
	//   "id": "cloudasset.searchAllResources",
	//   "parameterOrder": [
	//     "scope"
	//   ],
	//   "parameters": {
	//     "assetTypes": {
	//       "description": "Optional. A list of asset types that this request searches for. If empty, it will search all the [searchable asset types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types). Regular expressions are also supported. For example: * \"compute.googleapis.com.*\" snapshots resources whose asset type starts with \"compute.googleapis.com\". * \".*Instance\" snapshots resources whose asset type ends with \"Instance\". * \".*Instance.*\" snapshots resources whose asset type contains \"Instance\". See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported regular expression syntax. If the regular expression does not match any supported asset type, an INVALID_ARGUMENT error will be returned.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. A comma separated list of fields specifying the sorting order of the results. The default order is ascending. Add \" DESC\" after the field name to indicate descending order. Redundant space characters are ignored. Example: \"location DESC, name\". Only string fields in the response are sortable, including `name`, `displayName`, `description`, `location`. All the other fields such as repeated fields (e.g., `networkTags`), map fields (e.g., `labels`) and struct fields (e.g., `additionalAttributes`) are not supported.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The page size for search result pagination. Page size is capped at 500 even if a larger value is given. If set to zero, server will pick an appropriate default. Returned results may be fewer than requested. When this happens, there could be more results as long as `next_page_token` is returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If present, then retrieve the next batch of results from the preceding call to this method. `page_token` must be the value of `next_page_token` from the previous response. The values of all other method parameters, must be identical to those in the previous call.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Optional. The query statement. See [how to construct a query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query) for more information. If not specified or empty, it will search all the resources within the specified `scope`. Examples: * `name:Important` to find Cloud resources whose name contains \"Important\" as a word. * `name=Important` to find the Cloud resource whose name is exactly \"Important\". * `displayName:Impor*` to find Cloud resources whose display name contains \"Impor\" as a prefix of any word in the field. * `location:us-west*` to find Cloud resources whose location contains both \"us\" and \"west\" as prefixes. * `labels:prod` to find Cloud resources whose labels contain \"prod\" as a key or value. * `labels.env:prod` to find Cloud resources that have a label \"env\" and its value is \"prod\". * `labels.env:*` to find Cloud resources that have a label \"env\". * `kmsKey:key` to find Cloud resources encrypted with a customer-managed encryption key whose name contains the word \"key\". * `state:ACTIVE` to find Cloud resources whose state contains \"ACTIVE\" as a word. * `createTime\u003c1609459200` to find Cloud resources that were created before \"2021-01-01 00:00:00 UTC\". 1609459200 is the epoch timestamp of \"2021-01-01 00:00:00 UTC\" in seconds. * `updateTime\u003e1609459200` to find Cloud resources that were updated after \"2021-01-01 00:00:00 UTC\". 1609459200 is the epoch timestamp of \"2021-01-01 00:00:00 UTC\" in seconds. * `Important` to find Cloud resources that contain \"Important\" as a word in any of the searchable fields. * `Impor*` to find Cloud resources that contain \"Impor\" as a prefix of any word in any of the searchable fields. * `Important location:(us-west1 OR global)` to find Cloud resources that contain \"Important\" as a word in any of the searchable fields and are also located in the \"us-west1\" region or the \"global\" location.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "scope": {
	//       "description": "Required. A scope can be a project, a folder, or an organization. The search is limited to the resources within the `scope`. The caller must be granted the [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions) permission on the desired scope. The allowed values are: * projects/{PROJECT_ID} (e.g., \"projects/foo-bar\") * projects/{PROJECT_NUMBER} (e.g., \"projects/12345678\") * folders/{FOLDER_NUMBER} (e.g., \"folders/1234567\") * organizations/{ORGANIZATION_NUMBER} (e.g., \"organizations/123456\")",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+scope}:searchAllResources",
	//   "response": {
	//     "$ref": "SearchAllResourcesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *V1SearchAllResourcesCall) Pages(ctx context.Context, f func(*SearchAllResourcesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
