// Code generated by github.com/gobuffalo/mapgen. DO NOT EDIT.

package packr

import (
	"sort"
	"testing"

	"github.com/stretchr/testify/require"
)

func Test_boxMap(t *testing.T) {
	r := require.New(t)

	sm := &boxMap{}

	sm.Store("a", New(`test-a`, ``))

	s, ok := sm.Load("a")
	r.True(ok)
	r.Equal(New(`test-a`, ``), s)

	s, ok = sm.LoadOrStore("b", New(`test-b`, ``))
	r.True(ok)
	r.Equal(New(`test-b`, ``), s)

	s, ok = sm.LoadOrStore("b", New(`test-bb`, ``))
	r.True(ok)
	r.Equal(New(`test-b`, ``), s)

	var keys []string

	sm.Range(func(key string, value *Box) bool {
		keys = append(keys, key)
		return true
	})

	sort.Strings(keys)

	r.Equal(sm.Keys(), keys)

	sm.Delete("b")
	r.Equal([]string{"a", "b"}, keys)

	sm.Delete("b")
	_, ok = sm.Load("b")
	r.False(ok)

	func(m *boxMap) {
		m.Store("c", New(`test-c`, ``))
	}(sm)
	s, ok = sm.Load("c")
	r.True(ok)
	r.Equal(New(`test-c`, ``), s)
}
