// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package channel

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	"github.com/golang/protobuf/proto"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	channelpb "google.golang.org/genproto/googleapis/cloud/channel/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"
)

var newCloudChannelClientHook clientHook

// CloudChannelCallOptions contains the retry settings for each method of CloudChannelClient.
type CloudChannelCallOptions struct {
	ListCustomers                   []gax.CallOption
	GetCustomer                     []gax.CallOption
	CheckCloudIdentityAccountsExist []gax.CallOption
	CreateCustomer                  []gax.CallOption
	UpdateCustomer                  []gax.CallOption
	DeleteCustomer                  []gax.CallOption
	ProvisionCloudIdentity          []gax.CallOption
	ListEntitlements                []gax.CallOption
	ListTransferableSkus            []gax.CallOption
	ListTransferableOffers          []gax.CallOption
	GetEntitlement                  []gax.CallOption
	CreateEntitlement               []gax.CallOption
	ChangeParameters                []gax.CallOption
	ChangeRenewalSettings           []gax.CallOption
	ChangeOffer                     []gax.CallOption
	StartPaidService                []gax.CallOption
	SuspendEntitlement              []gax.CallOption
	CancelEntitlement               []gax.CallOption
	ActivateEntitlement             []gax.CallOption
	TransferEntitlements            []gax.CallOption
	TransferEntitlementsToGoogle    []gax.CallOption
	ListChannelPartnerLinks         []gax.CallOption
	GetChannelPartnerLink           []gax.CallOption
	CreateChannelPartnerLink        []gax.CallOption
	UpdateChannelPartnerLink        []gax.CallOption
	ListProducts                    []gax.CallOption
	ListSkus                        []gax.CallOption
	ListOffers                      []gax.CallOption
	ListPurchasableSkus             []gax.CallOption
	ListPurchasableOffers           []gax.CallOption
	RegisterSubscriber              []gax.CallOption
	UnregisterSubscriber            []gax.CallOption
	ListSubscribers                 []gax.CallOption
}

func defaultCloudChannelClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("cloudchannel.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("cloudchannel.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://cloudchannel.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		option.WithGRPCDialOption(grpc.WithDisableServiceConfig()),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCloudChannelCallOptions() *CloudChannelCallOptions {
	return &CloudChannelCallOptions{
		ListCustomers: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetCustomer: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CheckCloudIdentityAccountsExist: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateCustomer: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateCustomer: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteCustomer: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ProvisionCloudIdentity: []gax.CallOption{},
		ListEntitlements: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListTransferableSkus: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListTransferableOffers: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetEntitlement: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateEntitlement:            []gax.CallOption{},
		ChangeParameters:             []gax.CallOption{},
		ChangeRenewalSettings:        []gax.CallOption{},
		ChangeOffer:                  []gax.CallOption{},
		StartPaidService:             []gax.CallOption{},
		SuspendEntitlement:           []gax.CallOption{},
		CancelEntitlement:            []gax.CallOption{},
		ActivateEntitlement:          []gax.CallOption{},
		TransferEntitlements:         []gax.CallOption{},
		TransferEntitlementsToGoogle: []gax.CallOption{},
		ListChannelPartnerLinks: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetChannelPartnerLink: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateChannelPartnerLink: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpdateChannelPartnerLink: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListProducts: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListSkus: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListOffers: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListPurchasableSkus: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListPurchasableOffers: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RegisterSubscriber: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UnregisterSubscriber: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListSubscribers: []gax.CallOption{
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// CloudChannelClient is a client for interacting with Cloud Channel API.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type CloudChannelClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// The gRPC API client.
	cloudChannelClient channelpb.CloudChannelServiceClient

	// LROClient is used internally to handle longrunning operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient

	// The call options for this service.
	CallOptions *CloudChannelCallOptions

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewCloudChannelClient creates a new cloud channel service client.
//
// CloudChannelService enables Google cloud resellers and distributors to manage
// their customers, channel partners, entitlements and reports.
//
// Using this service:
//
// Resellers or distributors can manage a customer entity.
//
// Distributors can register an authorized reseller in their channel and then
// enable delegated admin access for the reseller.
//
// Resellers or distributors can manage entitlements for their customers.
//
// The service primarily exposes the following resources:
//
//   Customers: A Customer represents an entity managed by a reseller or
//   distributor. A customer typically represents an enterprise. In an n-tier
//   resale channel hierarchy, customers are generally represented as leaf nodes.
//   Customers primarily have an Entitlement sub-resource discussed below.
//
//   Entitlements: An Entitlement represents an entity which provides a
//   customer means to start using a service. Entitlements are created or updated
//   as a result of a successful fulfillment.
//
//   ChannelPartnerLinks: A ChannelPartnerLink is an entity that identifies
//   links between distributors and their indirect resellers in a channel.
func NewCloudChannelClient(ctx context.Context, opts ...option.ClientOption) (*CloudChannelClient, error) {
	clientOpts := defaultCloudChannelClientOptions()

	if newCloudChannelClientHook != nil {
		hookOpts, err := newCloudChannelClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	c := &CloudChannelClient{
		connPool:         connPool,
		disableDeadlines: disableDeadlines,
		CallOptions:      defaultCloudChannelCallOptions(),

		cloudChannelClient: channelpb.NewCloudChannelServiceClient(connPool),
	}
	c.setGoogleClientInfo()

	c.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	return c, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *CloudChannelClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *CloudChannelClient) Close() error {
	return c.connPool.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *CloudChannelClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", versionClient, "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// ListCustomers list downstream Customers.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
// Return Value:
//  List of Customers pertaining to the reseller or empty list if
// there are none.
func (c *CloudChannelClient) ListCustomers(ctx context.Context, req *channelpb.ListCustomersRequest, opts ...gax.CallOption) *CustomerIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListCustomers[0:len(c.CallOptions.ListCustomers):len(c.CallOptions.ListCustomers)], opts...)
	it := &CustomerIterator{}
	req = proto.Clone(req).(*channelpb.ListCustomersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.Customer, string, error) {
		var resp *channelpb.ListCustomersResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListCustomers(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCustomers(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// GetCustomer returns a requested Customer resource.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: If the customer resource doesn’t exist. Usually
//   the result of an invalid name parameter.
//
// Return Value:
//  Customer resource if found, error otherwise.
func (c *CloudChannelClient) GetCustomer(ctx context.Context, req *channelpb.GetCustomerRequest, opts ...gax.CallOption) (*channelpb.Customer, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.GetCustomer[0:len(c.CallOptions.GetCustomer):len(c.CallOptions.GetCustomer)], opts...)
	var resp *channelpb.Customer
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.GetCustomer(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CheckCloudIdentityAccountsExist confirms the existence of Cloud Identity accounts, based on the domain and
// whether the Cloud Identity accounts are owned by the reseller.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   INVALID_VALUE: Invalid domain value in the request.
//
//   NOT_FOUND: If there is no CloudIdentityCustomerAccount customer
//   for the domain specified in the request.
//
// Return Value:
//  List of CloudIdentityCustomerAccount resources if any exist for
// the domain, otherwise an error is returned.
func (c *CloudChannelClient) CheckCloudIdentityAccountsExist(ctx context.Context, req *channelpb.CheckCloudIdentityAccountsExistRequest, opts ...gax.CallOption) (*channelpb.CheckCloudIdentityAccountsExistResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CheckCloudIdentityAccountsExist[0:len(c.CallOptions.CheckCloudIdentityAccountsExist):len(c.CallOptions.CheckCloudIdentityAccountsExist)], opts...)
	var resp *channelpb.CheckCloudIdentityAccountsExistResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.CheckCloudIdentityAccountsExist(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateCustomer creates a new Customer resource under the reseller or distributor
// account.
//
// Possible Error Codes:
//
// Return Value:
//  If successful, the newly created Customer resource, otherwise
// returns an error.
func (c *CloudChannelClient) CreateCustomer(ctx context.Context, req *channelpb.CreateCustomerRequest, opts ...gax.CallOption) (*channelpb.Customer, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateCustomer[0:len(c.CallOptions.CreateCustomer):len(c.CallOptions.CreateCustomer)], opts...)
	var resp *channelpb.Customer
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.CreateCustomer(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// UpdateCustomer updates an existing Customer resource belonging to the reseller or
// distributor.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: No Customer resource found for the name
//   specified in the request.
//
// Return Value:
//  If successful, the updated Customer resource, otherwise returns
// an error.
func (c *CloudChannelClient) UpdateCustomer(ctx context.Context, req *channelpb.UpdateCustomerRequest, opts ...gax.CallOption) (*channelpb.Customer, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "customer.name", url.QueryEscape(req.GetCustomer().GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UpdateCustomer[0:len(c.CallOptions.UpdateCustomer):len(c.CallOptions.UpdateCustomer)], opts...)
	var resp *channelpb.Customer
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.UpdateCustomer(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// DeleteCustomer deletes the given Customer permanently and irreversibly.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the account making the request does not own
//   this customer.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   FAILED_PRECONDITION: If the customer has existing entitlements.
//
//   NOT_FOUND: No Customer resource found for the name
//   specified in the request.
func (c *CloudChannelClient) DeleteCustomer(ctx context.Context, req *channelpb.DeleteCustomerRequest, opts ...gax.CallOption) error {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.DeleteCustomer[0:len(c.CallOptions.DeleteCustomer):len(c.CallOptions.DeleteCustomer)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.cloudChannelClient.DeleteCustomer(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// ProvisionCloudIdentity creates a Cloud Identity for the given customer using the customer’s
// information or the information provided here, if present.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the request.
//
//   NOT_FOUND: If the customer is not found for the reseller.
//
//   ALREADY_EXISTS: If the customer’s primary email already exists. In this
//   case, retry after changing the customer’s primary contact email.
//
//   INTERNAL: Any non-user error related to a technical issue in the
//   backend. Contact Cloud Channel support in this case.
//
//   UNKNOWN: Any non-user error related to a technical issue in the backend.
//   Contact Cloud Channel support in this case.
//
// Return Value:
//   Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) ProvisionCloudIdentity(ctx context.Context, req *channelpb.ProvisionCloudIdentityRequest, opts ...gax.CallOption) (*ProvisionCloudIdentityOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "customer", url.QueryEscape(req.GetCustomer())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ProvisionCloudIdentity[0:len(c.CallOptions.ProvisionCloudIdentity):len(c.CallOptions.ProvisionCloudIdentity)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.ProvisionCloudIdentity(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ProvisionCloudIdentityOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// ListEntitlements list Entitlements belonging to a customer.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the request.
//
// Return Value:
//  List of Entitlements belonging to the customer, or empty list if
// there are none.
func (c *CloudChannelClient) ListEntitlements(ctx context.Context, req *channelpb.ListEntitlementsRequest, opts ...gax.CallOption) *EntitlementIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListEntitlements[0:len(c.CallOptions.ListEntitlements):len(c.CallOptions.ListEntitlements)], opts...)
	it := &EntitlementIterator{}
	req = proto.Clone(req).(*channelpb.ListEntitlementsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.Entitlement, string, error) {
		var resp *channelpb.ListEntitlementsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListEntitlements(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEntitlements(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ListTransferableSkus list TransferableSkus of a customer based on Cloud Identity ID or
// Customer Name in the request.
//
// This method is used when a reseller lists the entitlements
// information of a customer that is not owned. The reseller should provide
// the customer’s Cloud Identity ID or Customer Name.
//
// Possible Error Codes:
//
// Return Value:
//  List of TransferableSku for the given customer.
func (c *CloudChannelClient) ListTransferableSkus(ctx context.Context, req *channelpb.ListTransferableSkusRequest, opts ...gax.CallOption) *TransferableSkuIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListTransferableSkus[0:len(c.CallOptions.ListTransferableSkus):len(c.CallOptions.ListTransferableSkus)], opts...)
	it := &TransferableSkuIterator{}
	req = proto.Clone(req).(*channelpb.ListTransferableSkusRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.TransferableSku, string, error) {
		var resp *channelpb.ListTransferableSkusResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListTransferableSkus(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTransferableSkus(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ListTransferableOffers list TransferableOffers of a customer based on Cloud Identity ID or
// Customer Name in the request.
//
// This method is used when a reseller gets the entitlement
// information of a customer that is not owned. The reseller should provide
// the customer’s Cloud Identity ID or Customer Name.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED, due to one of the following reasons: (a) If the
//   customer doesn’t belong to the reseller and no auth token or invalid auth
//   token is supplied. (b) If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
// Return Value:
// List of TransferableOffer for the given customer and SKU.
func (c *CloudChannelClient) ListTransferableOffers(ctx context.Context, req *channelpb.ListTransferableOffersRequest, opts ...gax.CallOption) *TransferableOfferIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListTransferableOffers[0:len(c.CallOptions.ListTransferableOffers):len(c.CallOptions.ListTransferableOffers)], opts...)
	it := &TransferableOfferIterator{}
	req = proto.Clone(req).(*channelpb.ListTransferableOffersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.TransferableOffer, string, error) {
		var resp *channelpb.ListTransferableOffersResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListTransferableOffers(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTransferableOffers(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// GetEntitlement returns a requested Entitlement resource.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: If the entitlement is not found for the customer.
//
// Return Value:
//  If found, the requested Entitlement resource, otherwise returns
// an error.
func (c *CloudChannelClient) GetEntitlement(ctx context.Context, req *channelpb.GetEntitlementRequest, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.GetEntitlement[0:len(c.CallOptions.GetEntitlement):len(c.CallOptions.GetEntitlement)], opts...)
	var resp *channelpb.Entitlement
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.GetEntitlement(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateEntitlement creates an entitlement for a customer.
//
// Possible Error Codes:
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) CreateEntitlement(ctx context.Context, req *channelpb.CreateEntitlementRequest, opts ...gax.CallOption) (*CreateEntitlementOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateEntitlement[0:len(c.CallOptions.CreateEntitlement):len(c.CallOptions.CreateEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.CreateEntitlement(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// ChangeParameters change parameters of the entitlement
//
// An entitlement parameters update is a long-running operation and results in
// updates to the entitlement as a result of fulfillment.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request. For example, if the number of seats being changed to is greater
//   than the allowed number of max seats for the resource. Or decreasing seats
//   for a commitment based plan.
//
//   NOT_FOUND: Entitlement resource not found.
//
//   INTERNAL: Any non-user error related to a technical issue
//   in the backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) ChangeParameters(ctx context.Context, req *channelpb.ChangeParametersRequest, opts ...gax.CallOption) (*ChangeParametersOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ChangeParameters[0:len(c.CallOptions.ChangeParameters):len(c.CallOptions.ChangeParameters)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.ChangeParameters(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ChangeParametersOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// ChangeRenewalSettings updates the renewal settings for an existing customer entitlement.
//
// An entitlement update is a long-running operation and results in updates to
// the entitlement as a result of fulfillment.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: Entitlement resource not found.
//
//   NOT_COMMITMENT_PLAN: Renewal Settings are only applicable for a
//   commitment plan. Can’t enable or disable renewal for non-commitment plans.
//
//   INTERNAL: Any non user error related to a technical issue in the
//   backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) ChangeRenewalSettings(ctx context.Context, req *channelpb.ChangeRenewalSettingsRequest, opts ...gax.CallOption) (*ChangeRenewalSettingsOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ChangeRenewalSettings[0:len(c.CallOptions.ChangeRenewalSettings):len(c.CallOptions.ChangeRenewalSettings)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.ChangeRenewalSettings(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ChangeRenewalSettingsOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// ChangeOffer updates the Offer for an existing customer entitlement.
//
// An entitlement update is a long-running operation and results in updates to
// the entitlement as a result of fulfillment.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: Offer or Entitlement resource not found.
//
//   INTERNAL: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) ChangeOffer(ctx context.Context, req *channelpb.ChangeOfferRequest, opts ...gax.CallOption) (*ChangeOfferOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ChangeOffer[0:len(c.CallOptions.ChangeOffer):len(c.CallOptions.ChangeOffer)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.ChangeOffer(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ChangeOfferOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// StartPaidService starts paid service for a trial entitlement.
//
// Starts paid service for a trial entitlement immediately. This method is
// only applicable if a plan has already been set up for a trial entitlement
// but has some trial days remaining.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: Entitlement resource not found.
//
//   FAILED_PRECONDITION/NOT_IN_TRIAL: This method only works for
//   entitlement on trial plans.
//
//   INTERNAL: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue
//   in the backend. In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) StartPaidService(ctx context.Context, req *channelpb.StartPaidServiceRequest, opts ...gax.CallOption) (*StartPaidServiceOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.StartPaidService[0:len(c.CallOptions.StartPaidService):len(c.CallOptions.StartPaidService)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.StartPaidService(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartPaidServiceOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// SuspendEntitlement suspends a previously fulfilled entitlement.
// An entitlement suspension is a long-running operation.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: Entitlement resource not found.
//
//   NOT_ACTIVE: Entitlement is not active.
//
//   INTERNAL: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) SuspendEntitlement(ctx context.Context, req *channelpb.SuspendEntitlementRequest, opts ...gax.CallOption) (*SuspendEntitlementOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.SuspendEntitlement[0:len(c.CallOptions.SuspendEntitlement):len(c.CallOptions.SuspendEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.SuspendEntitlement(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SuspendEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// CancelEntitlement cancels a previously fulfilled entitlement.
// An entitlement cancellation is a long-running operation.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller or
//   if the reseller account making the request and reseller account being
//   queried for are different.
//
//   FAILED_PRECONDITION: If there are any Google Cloud projects linked to the
//   Google Cloud entitlement’s Cloud Billing subaccount.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: Entitlement resource not found.
//
//   DELETION_TYPE_NOT_ALLOWED: Cancel is only allowed for Google Workspace
//   add-ons or entitlements for Google Cloud’s development platform.
//
//   INTERNAL: Any non-user error related to a technical issue in the
//   backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The response will contain
// google.protobuf.Empty on success. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) CancelEntitlement(ctx context.Context, req *channelpb.CancelEntitlementRequest, opts ...gax.CallOption) (*CancelEntitlementOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CancelEntitlement[0:len(c.CallOptions.CancelEntitlement):len(c.CallOptions.CancelEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.CancelEntitlement(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CancelEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// ActivateEntitlement activates a previously suspended entitlement. The entitlement must be in a
// suspended state for it to be activated. Entitlements suspended for pending
// ToS acceptance can’t be activated using this method. An entitlement
// activation is a long-running operation and can result in updates to
// the state of the customer entitlement.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller or
//   if the reseller account making the request and reseller account being
//   queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: Entitlement resource not found.
//
//   SUSPENSION_NOT_RESELLER_INITIATED: Can’t activate an
//   entitlement that is pending TOS acceptance. Only reseller initiated
//   suspensions can be activated.
//
//   NOT_SUSPENDED: Can’t activate entitlements that are already in ACTIVE
//   state. Can only activate suspended entitlements.
//
//   INTERNAL: Any non-user error related to a technical issue
//   in the backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in the backend.
//   In this case, contact Cloud Channel support.
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) ActivateEntitlement(ctx context.Context, req *channelpb.ActivateEntitlementRequest, opts ...gax.CallOption) (*ActivateEntitlementOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ActivateEntitlement[0:len(c.CallOptions.ActivateEntitlement):len(c.CallOptions.ActivateEntitlement)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.ActivateEntitlement(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ActivateEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// TransferEntitlements transfers customer entitlements to new reseller.
//
// Possible Error Codes:
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) TransferEntitlements(ctx context.Context, req *channelpb.TransferEntitlementsRequest, opts ...gax.CallOption) (*TransferEntitlementsOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.TransferEntitlements[0:len(c.CallOptions.TransferEntitlements):len(c.CallOptions.TransferEntitlements)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.TransferEntitlements(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &TransferEntitlementsOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// TransferEntitlementsToGoogle transfers customer entitlements from current reseller to Google.
//
// Possible Error Codes:
//
// Return Value:
//  Long Running Operation ID.
//
// To get the results of the operation, call the GetOperation method of
// CloudChannelOperationsService. The response will contain
// google.protobuf.Empty on success. The Operation metadata will contain an
// instance of OperationMetadata.
func (c *CloudChannelClient) TransferEntitlementsToGoogle(ctx context.Context, req *channelpb.TransferEntitlementsToGoogleRequest, opts ...gax.CallOption) (*TransferEntitlementsToGoogleOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.TransferEntitlementsToGoogle[0:len(c.CallOptions.TransferEntitlementsToGoogle):len(c.CallOptions.TransferEntitlementsToGoogle)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.TransferEntitlementsToGoogle(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &TransferEntitlementsToGoogleOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, resp),
	}, nil
}

// ListChannelPartnerLinks list ChannelPartnerLinks belonging to a distributor.
// To call this method, you must be a distributor.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
// Return Value:
//  If successful, returns the list of ChannelPartnerLink resources
// for the distributor account, otherwise returns an error.
func (c *CloudChannelClient) ListChannelPartnerLinks(ctx context.Context, req *channelpb.ListChannelPartnerLinksRequest, opts ...gax.CallOption) *ChannelPartnerLinkIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListChannelPartnerLinks[0:len(c.CallOptions.ListChannelPartnerLinks):len(c.CallOptions.ListChannelPartnerLinks)], opts...)
	it := &ChannelPartnerLinkIterator{}
	req = proto.Clone(req).(*channelpb.ListChannelPartnerLinksRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.ChannelPartnerLink, string, error) {
		var resp *channelpb.ListChannelPartnerLinksResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListChannelPartnerLinks(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetChannelPartnerLinks(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// GetChannelPartnerLink returns a requested ChannelPartnerLink resource.
// To call this method, you must be a distributor.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: ChannelPartnerLink resource not found. Results
//   due invalid channel partner link name.
//
// Return Value:
//  ChannelPartnerLink resource if found, otherwise returns an error.
func (c *CloudChannelClient) GetChannelPartnerLink(ctx context.Context, req *channelpb.GetChannelPartnerLinkRequest, opts ...gax.CallOption) (*channelpb.ChannelPartnerLink, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.GetChannelPartnerLink[0:len(c.CallOptions.GetChannelPartnerLink):len(c.CallOptions.GetChannelPartnerLink)], opts...)
	var resp *channelpb.ChannelPartnerLink
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.GetChannelPartnerLink(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// CreateChannelPartnerLink initiates a channel partner link between a distributor and a reseller or
// between resellers in an n-tier reseller channel.
// To accept the invite, the invited partner should follow the invite_link_uri
// provided in the response. If the link creation is accepted, a valid link is
// set up between the two involved parties.
// To call this method, you must be a distributor.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being queried for are different.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   ALREADY_EXISTS: If the ChannelPartnerLink sent in the request already
//   exists.
//
//   NOT_FOUND: If no Cloud Identity customer exists for domain provided.
//
//   INTERNAL: Any non-user error related to a technical issue in the
//   backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in
//   the backend. In this case, contact Cloud Channel support.
//
// Return Value:
//  Newly created ChannelPartnerLink resource if successful,
// otherwise error is returned.
func (c *CloudChannelClient) CreateChannelPartnerLink(ctx context.Context, req *channelpb.CreateChannelPartnerLinkRequest, opts ...gax.CallOption) (*channelpb.ChannelPartnerLink, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.CreateChannelPartnerLink[0:len(c.CallOptions.CreateChannelPartnerLink):len(c.CallOptions.CreateChannelPartnerLink)], opts...)
	var resp *channelpb.ChannelPartnerLink
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.CreateChannelPartnerLink(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// UpdateChannelPartnerLink updates a channel partner link. A distributor calls this method to change a
// link’s status. For example, suspend a partner link.
// To call this method, you must be a distributor.
//
// Possible Error Codes:
//
// Return Value:
//  If successful, the updated ChannelPartnerLink resource, otherwise
// returns an error.
func (c *CloudChannelClient) UpdateChannelPartnerLink(ctx context.Context, req *channelpb.UpdateChannelPartnerLinkRequest, opts ...gax.CallOption) (*channelpb.ChannelPartnerLink, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UpdateChannelPartnerLink[0:len(c.CallOptions.UpdateChannelPartnerLink):len(c.CallOptions.UpdateChannelPartnerLink)], opts...)
	var resp *channelpb.ChannelPartnerLink
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.UpdateChannelPartnerLink(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ListProducts lists the Products the reseller is authorized to sell.
//
// Possible Error Codes:
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
func (c *CloudChannelClient) ListProducts(ctx context.Context, req *channelpb.ListProductsRequest, opts ...gax.CallOption) *ProductIterator {
	ctx = insertMetadata(ctx, c.xGoogMetadata)
	opts = append(c.CallOptions.ListProducts[0:len(c.CallOptions.ListProducts):len(c.CallOptions.ListProducts)], opts...)
	it := &ProductIterator{}
	req = proto.Clone(req).(*channelpb.ListProductsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.Product, string, error) {
		var resp *channelpb.ListProductsResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListProducts(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetProducts(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ListSkus lists the SKUs for a product the reseller is authorized to sell.
//
// Possible Error Codes:
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
func (c *CloudChannelClient) ListSkus(ctx context.Context, req *channelpb.ListSkusRequest, opts ...gax.CallOption) *SkuIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListSkus[0:len(c.CallOptions.ListSkus):len(c.CallOptions.ListSkus)], opts...)
	it := &SkuIterator{}
	req = proto.Clone(req).(*channelpb.ListSkusRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.Sku, string, error) {
		var resp *channelpb.ListSkusResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListSkus(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetSkus(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ListOffers lists the Offers the reseller can sell.
//
// Possible Error Codes:
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
func (c *CloudChannelClient) ListOffers(ctx context.Context, req *channelpb.ListOffersRequest, opts ...gax.CallOption) *OfferIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListOffers[0:len(c.CallOptions.ListOffers):len(c.CallOptions.ListOffers)], opts...)
	it := &OfferIterator{}
	req = proto.Clone(req).(*channelpb.ListOffersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.Offer, string, error) {
		var resp *channelpb.ListOffersResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListOffers(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOffers(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ListPurchasableSkus lists the Purchasable SKUs for following cases:
//
//   SKUs that can be newly purchased for a customer
//
//   SKUs that can be upgraded/downgraded to, for an entitlement.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
func (c *CloudChannelClient) ListPurchasableSkus(ctx context.Context, req *channelpb.ListPurchasableSkusRequest, opts ...gax.CallOption) *PurchasableSkuIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "customer", url.QueryEscape(req.GetCustomer())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListPurchasableSkus[0:len(c.CallOptions.ListPurchasableSkus):len(c.CallOptions.ListPurchasableSkus)], opts...)
	it := &PurchasableSkuIterator{}
	req = proto.Clone(req).(*channelpb.ListPurchasableSkusRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.PurchasableSku, string, error) {
		var resp *channelpb.ListPurchasableSkusResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListPurchasableSkus(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPurchasableSkus(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ListPurchasableOffers lists the Purchasable Offers for the following cases:
//
//   Offers that can be newly purchased for a customer
//
//   Offers that can be changed to, for an entitlement.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the customer doesn’t belong to the reseller
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
func (c *CloudChannelClient) ListPurchasableOffers(ctx context.Context, req *channelpb.ListPurchasableOffersRequest, opts ...gax.CallOption) *PurchasableOfferIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "customer", url.QueryEscape(req.GetCustomer())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListPurchasableOffers[0:len(c.CallOptions.ListPurchasableOffers):len(c.CallOptions.ListPurchasableOffers)], opts...)
	it := &PurchasableOfferIterator{}
	req = proto.Clone(req).(*channelpb.ListPurchasableOffersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*channelpb.PurchasableOffer, string, error) {
		var resp *channelpb.ListPurchasableOffersResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListPurchasableOffers(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPurchasableOffers(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// RegisterSubscriber registers a service account with subscriber privileges on the Cloud Pub/Sub
// topic created for this Channel Services account. Once you create a
// subscriber, you will get the events as per SubscriberEvent
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being provided are different, or if the impersonated user
//   is not a super admin.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   INTERNAL: Any non-user error related to a technical issue in the
//   backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in
//   the backend. In this case, contact Cloud Channel support.
//
// Return Value:
// Topic name with service email address registered if successful,
// otherwise error is returned.
func (c *CloudChannelClient) RegisterSubscriber(ctx context.Context, req *channelpb.RegisterSubscriberRequest, opts ...gax.CallOption) (*channelpb.RegisterSubscriberResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "account", url.QueryEscape(req.GetAccount())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.RegisterSubscriber[0:len(c.CallOptions.RegisterSubscriber):len(c.CallOptions.RegisterSubscriber)], opts...)
	var resp *channelpb.RegisterSubscriberResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.RegisterSubscriber(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// UnregisterSubscriber unregisters a service account with subscriber privileges on the Cloud
// Pub/Sub topic created for this Channel Services account. If there are no
// more service account left with sunbscriber privileges, the topic will be
// deleted. You can check this by calling ListSubscribers api.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being provided are different, or if the impersonated user
//   is not a super admin.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: If the topic resource doesn’t exist.
//
//   INTERNAL: Any non-user error related to a technical issue in the
//   backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in
//   the backend. In this case, contact Cloud Channel support.
//
// Return Value:
// Topic name from which service email address has been unregistered if
// successful, otherwise error is returned. If the service email was already
// not associated with the topic, the success response will be returned.
func (c *CloudChannelClient) UnregisterSubscriber(ctx context.Context, req *channelpb.UnregisterSubscriberRequest, opts ...gax.CallOption) (*channelpb.UnregisterSubscriberResponse, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "account", url.QueryEscape(req.GetAccount())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.UnregisterSubscriber[0:len(c.CallOptions.UnregisterSubscriber):len(c.CallOptions.UnregisterSubscriber)], opts...)
	var resp *channelpb.UnregisterSubscriberResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.cloudChannelClient.UnregisterSubscriber(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ListSubscribers lists service accounts with subscriber privileges on the Cloud Pub/Sub
// topic created for this Channel Services account.
//
// Possible Error Codes:
//
//   PERMISSION_DENIED: If the reseller account making the request and the
//   reseller account being provided are different, or if the account is not
//   a super admin.
//
//   INVALID_ARGUMENT: Missing or invalid required parameters in the
//   request.
//
//   NOT_FOUND: If the topic resource doesn’t exist.
//
//   INTERNAL: Any non-user error related to a technical issue in the
//   backend. In this case, contact Cloud Channel support.
//
//   UNKNOWN: Any non-user error related to a technical issue in
//   the backend. In this case, contact Cloud Channel support.
//
// Return Value:
// List of service email addresses if successful, otherwise error is
// returned.
func (c *CloudChannelClient) ListSubscribers(ctx context.Context, req *channelpb.ListSubscribersRequest, opts ...gax.CallOption) *StringIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "account", url.QueryEscape(req.GetAccount())))
	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append(c.CallOptions.ListSubscribers[0:len(c.CallOptions.ListSubscribers):len(c.CallOptions.ListSubscribers)], opts...)
	it := &StringIterator{}
	req = proto.Clone(req).(*channelpb.ListSubscribersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]string, string, error) {
		var resp *channelpb.ListSubscribersResponse
		req.PageToken = pageToken
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.cloudChannelClient.ListSubscribers(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServiceAccounts(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}
	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()
	return it
}

// ActivateEntitlementOperation manages a long-running operation from ActivateEntitlement.
type ActivateEntitlementOperation struct {
	lro *longrunning.Operation
}

// ActivateEntitlementOperation returns a new ActivateEntitlementOperation from a given name.
// The name must be that of a previously created ActivateEntitlementOperation, possibly from a different process.
func (c *CloudChannelClient) ActivateEntitlementOperation(name string) *ActivateEntitlementOperation {
	return &ActivateEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ActivateEntitlementOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ActivateEntitlementOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ActivateEntitlementOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ActivateEntitlementOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ActivateEntitlementOperation) Name() string {
	return op.lro.Name()
}

// CancelEntitlementOperation manages a long-running operation from CancelEntitlement.
type CancelEntitlementOperation struct {
	lro *longrunning.Operation
}

// CancelEntitlementOperation returns a new CancelEntitlementOperation from a given name.
// The name must be that of a previously created CancelEntitlementOperation, possibly from a different process.
func (c *CloudChannelClient) CancelEntitlementOperation(name string) *CancelEntitlementOperation {
	return &CancelEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CancelEntitlementOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CancelEntitlementOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CancelEntitlementOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CancelEntitlementOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CancelEntitlementOperation) Name() string {
	return op.lro.Name()
}

// ChangeOfferOperation manages a long-running operation from ChangeOffer.
type ChangeOfferOperation struct {
	lro *longrunning.Operation
}

// ChangeOfferOperation returns a new ChangeOfferOperation from a given name.
// The name must be that of a previously created ChangeOfferOperation, possibly from a different process.
func (c *CloudChannelClient) ChangeOfferOperation(name string) *ChangeOfferOperation {
	return &ChangeOfferOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ChangeOfferOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ChangeOfferOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ChangeOfferOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ChangeOfferOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ChangeOfferOperation) Name() string {
	return op.lro.Name()
}

// ChangeParametersOperation manages a long-running operation from ChangeParameters.
type ChangeParametersOperation struct {
	lro *longrunning.Operation
}

// ChangeParametersOperation returns a new ChangeParametersOperation from a given name.
// The name must be that of a previously created ChangeParametersOperation, possibly from a different process.
func (c *CloudChannelClient) ChangeParametersOperation(name string) *ChangeParametersOperation {
	return &ChangeParametersOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ChangeParametersOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ChangeParametersOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ChangeParametersOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ChangeParametersOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ChangeParametersOperation) Name() string {
	return op.lro.Name()
}

// ChangeRenewalSettingsOperation manages a long-running operation from ChangeRenewalSettings.
type ChangeRenewalSettingsOperation struct {
	lro *longrunning.Operation
}

// ChangeRenewalSettingsOperation returns a new ChangeRenewalSettingsOperation from a given name.
// The name must be that of a previously created ChangeRenewalSettingsOperation, possibly from a different process.
func (c *CloudChannelClient) ChangeRenewalSettingsOperation(name string) *ChangeRenewalSettingsOperation {
	return &ChangeRenewalSettingsOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ChangeRenewalSettingsOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ChangeRenewalSettingsOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ChangeRenewalSettingsOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ChangeRenewalSettingsOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ChangeRenewalSettingsOperation) Name() string {
	return op.lro.Name()
}

// CreateEntitlementOperation manages a long-running operation from CreateEntitlement.
type CreateEntitlementOperation struct {
	lro *longrunning.Operation
}

// CreateEntitlementOperation returns a new CreateEntitlementOperation from a given name.
// The name must be that of a previously created CreateEntitlementOperation, possibly from a different process.
func (c *CloudChannelClient) CreateEntitlementOperation(name string) *CreateEntitlementOperation {
	return &CreateEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateEntitlementOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateEntitlementOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateEntitlementOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateEntitlementOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateEntitlementOperation) Name() string {
	return op.lro.Name()
}

// ProvisionCloudIdentityOperation manages a long-running operation from ProvisionCloudIdentity.
type ProvisionCloudIdentityOperation struct {
	lro *longrunning.Operation
}

// ProvisionCloudIdentityOperation returns a new ProvisionCloudIdentityOperation from a given name.
// The name must be that of a previously created ProvisionCloudIdentityOperation, possibly from a different process.
func (c *CloudChannelClient) ProvisionCloudIdentityOperation(name string) *ProvisionCloudIdentityOperation {
	return &ProvisionCloudIdentityOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ProvisionCloudIdentityOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Customer, error) {
	var resp channelpb.Customer
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ProvisionCloudIdentityOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Customer, error) {
	var resp channelpb.Customer
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ProvisionCloudIdentityOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ProvisionCloudIdentityOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ProvisionCloudIdentityOperation) Name() string {
	return op.lro.Name()
}

// StartPaidServiceOperation manages a long-running operation from StartPaidService.
type StartPaidServiceOperation struct {
	lro *longrunning.Operation
}

// StartPaidServiceOperation returns a new StartPaidServiceOperation from a given name.
// The name must be that of a previously created StartPaidServiceOperation, possibly from a different process.
func (c *CloudChannelClient) StartPaidServiceOperation(name string) *StartPaidServiceOperation {
	return &StartPaidServiceOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *StartPaidServiceOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *StartPaidServiceOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *StartPaidServiceOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *StartPaidServiceOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *StartPaidServiceOperation) Name() string {
	return op.lro.Name()
}

// SuspendEntitlementOperation manages a long-running operation from SuspendEntitlement.
type SuspendEntitlementOperation struct {
	lro *longrunning.Operation
}

// SuspendEntitlementOperation returns a new SuspendEntitlementOperation from a given name.
// The name must be that of a previously created SuspendEntitlementOperation, possibly from a different process.
func (c *CloudChannelClient) SuspendEntitlementOperation(name string) *SuspendEntitlementOperation {
	return &SuspendEntitlementOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *SuspendEntitlementOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *SuspendEntitlementOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.Entitlement, error) {
	var resp channelpb.Entitlement
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *SuspendEntitlementOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *SuspendEntitlementOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *SuspendEntitlementOperation) Name() string {
	return op.lro.Name()
}

// TransferEntitlementsOperation manages a long-running operation from TransferEntitlements.
type TransferEntitlementsOperation struct {
	lro *longrunning.Operation
}

// TransferEntitlementsOperation returns a new TransferEntitlementsOperation from a given name.
// The name must be that of a previously created TransferEntitlementsOperation, possibly from a different process.
func (c *CloudChannelClient) TransferEntitlementsOperation(name string) *TransferEntitlementsOperation {
	return &TransferEntitlementsOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *TransferEntitlementsOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*channelpb.TransferEntitlementsResponse, error) {
	var resp channelpb.TransferEntitlementsResponse
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *TransferEntitlementsOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*channelpb.TransferEntitlementsResponse, error) {
	var resp channelpb.TransferEntitlementsResponse
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *TransferEntitlementsOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *TransferEntitlementsOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *TransferEntitlementsOperation) Name() string {
	return op.lro.Name()
}

// TransferEntitlementsToGoogleOperation manages a long-running operation from TransferEntitlementsToGoogle.
type TransferEntitlementsToGoogleOperation struct {
	lro *longrunning.Operation
}

// TransferEntitlementsToGoogleOperation returns a new TransferEntitlementsToGoogleOperation from a given name.
// The name must be that of a previously created TransferEntitlementsToGoogleOperation, possibly from a different process.
func (c *CloudChannelClient) TransferEntitlementsToGoogleOperation(name string) *TransferEntitlementsToGoogleOperation {
	return &TransferEntitlementsToGoogleOperation{
		lro: longrunning.InternalNewOperation(c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *TransferEntitlementsToGoogleOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *TransferEntitlementsToGoogleOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *TransferEntitlementsToGoogleOperation) Metadata() (*channelpb.OperationMetadata, error) {
	var meta channelpb.OperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *TransferEntitlementsToGoogleOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *TransferEntitlementsToGoogleOperation) Name() string {
	return op.lro.Name()
}

// ChannelPartnerLinkIterator manages a stream of *channelpb.ChannelPartnerLink.
type ChannelPartnerLinkIterator struct {
	items    []*channelpb.ChannelPartnerLink
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.ChannelPartnerLink, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ChannelPartnerLinkIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ChannelPartnerLinkIterator) Next() (*channelpb.ChannelPartnerLink, error) {
	var item *channelpb.ChannelPartnerLink
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ChannelPartnerLinkIterator) bufLen() int {
	return len(it.items)
}

func (it *ChannelPartnerLinkIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// CustomerIterator manages a stream of *channelpb.Customer.
type CustomerIterator struct {
	items    []*channelpb.Customer
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.Customer, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *CustomerIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *CustomerIterator) Next() (*channelpb.Customer, error) {
	var item *channelpb.Customer
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *CustomerIterator) bufLen() int {
	return len(it.items)
}

func (it *CustomerIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// EntitlementIterator manages a stream of *channelpb.Entitlement.
type EntitlementIterator struct {
	items    []*channelpb.Entitlement
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.Entitlement, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *EntitlementIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *EntitlementIterator) Next() (*channelpb.Entitlement, error) {
	var item *channelpb.Entitlement
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *EntitlementIterator) bufLen() int {
	return len(it.items)
}

func (it *EntitlementIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// OfferIterator manages a stream of *channelpb.Offer.
type OfferIterator struct {
	items    []*channelpb.Offer
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.Offer, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *OfferIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *OfferIterator) Next() (*channelpb.Offer, error) {
	var item *channelpb.Offer
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *OfferIterator) bufLen() int {
	return len(it.items)
}

func (it *OfferIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ProductIterator manages a stream of *channelpb.Product.
type ProductIterator struct {
	items    []*channelpb.Product
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.Product, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ProductIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ProductIterator) Next() (*channelpb.Product, error) {
	var item *channelpb.Product
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ProductIterator) bufLen() int {
	return len(it.items)
}

func (it *ProductIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PurchasableOfferIterator manages a stream of *channelpb.PurchasableOffer.
type PurchasableOfferIterator struct {
	items    []*channelpb.PurchasableOffer
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.PurchasableOffer, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *PurchasableOfferIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PurchasableOfferIterator) Next() (*channelpb.PurchasableOffer, error) {
	var item *channelpb.PurchasableOffer
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PurchasableOfferIterator) bufLen() int {
	return len(it.items)
}

func (it *PurchasableOfferIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// PurchasableSkuIterator manages a stream of *channelpb.PurchasableSku.
type PurchasableSkuIterator struct {
	items    []*channelpb.PurchasableSku
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.PurchasableSku, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *PurchasableSkuIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *PurchasableSkuIterator) Next() (*channelpb.PurchasableSku, error) {
	var item *channelpb.PurchasableSku
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *PurchasableSkuIterator) bufLen() int {
	return len(it.items)
}

func (it *PurchasableSkuIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// SkuIterator manages a stream of *channelpb.Sku.
type SkuIterator struct {
	items    []*channelpb.Sku
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.Sku, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *SkuIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *SkuIterator) Next() (*channelpb.Sku, error) {
	var item *channelpb.Sku
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *SkuIterator) bufLen() int {
	return len(it.items)
}

func (it *SkuIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// StringIterator manages a stream of string.
type StringIterator struct {
	items    []string
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []string, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *StringIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *StringIterator) Next() (string, error) {
	var item string
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *StringIterator) bufLen() int {
	return len(it.items)
}

func (it *StringIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TransferableOfferIterator manages a stream of *channelpb.TransferableOffer.
type TransferableOfferIterator struct {
	items    []*channelpb.TransferableOffer
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.TransferableOffer, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TransferableOfferIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TransferableOfferIterator) Next() (*channelpb.TransferableOffer, error) {
	var item *channelpb.TransferableOffer
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TransferableOfferIterator) bufLen() int {
	return len(it.items)
}

func (it *TransferableOfferIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// TransferableSkuIterator manages a stream of *channelpb.TransferableSku.
type TransferableSkuIterator struct {
	items    []*channelpb.TransferableSku
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*channelpb.TransferableSku, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *TransferableSkuIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *TransferableSkuIterator) Next() (*channelpb.TransferableSku, error) {
	var item *channelpb.TransferableSku
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *TransferableSkuIterator) bufLen() int {
	return len(it.items)
}

func (it *TransferableSkuIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
